// ***********************************************************************************************

// 			Worm Project:  Data structures and associated functions of images

//			UCSD Biology, Schafer Lab

// 			Written by John Wittig Jr. and John Feng

//			wormDataStruct.h

// ***********************************************************************************************


// calculation shows 20 minutes of data would maximally equal 384 MBytes. (in reality it is more like 7MB)
// define NODES_PER_SET to not exceed the physical memory of the computer
#define FULL_SET_ERROR -1
#define MEM_ERROR 0
#define MAX_NAME_LEN 500

#define null 0


// **************************************************************************************
//				ImageNode Definition
// **************************************************************************************
typedef struct ImageNodes
{

	// these values code the absolute coordinates of the upper left pixel containing the worm image
	int absX, absY ;
	int height, width ;
	
	double time;
	
	unsigned char * image ;

	// file pointer to the image
	long imageFilePtr ; 

	int fromFile ;		// 0 = newNode or 1 = readNode 
	
} ImageNode ;

typedef long ImageNodePtr ;


// **************************************************************************************
//				ImageSet Definition
// **************************************************************************************
// the ImageSet will be a pointer to an object. Memory is allocated automatically upon
// declaration of the variable
typedef struct ImageSets
{
	
	// setName is a string containing the full path to the file
	// setNum is the suffix to the setName specifying which number of a set
	char * setName ;   
	int setNum ;
	
	// arrays with extra space for null character at the end
	char startDate[11] ;
	char startTime[9] ;
	
	// used during imageSet construction to set limit on max imageCount:: not saved to imageSet file
	int MaxCount ;
	// counts the nodes as they are written, saved and read from imageSet file    
	int imageCount ;	
	
	// counts the bytes as they are read, used to position the file pointers in imageNode
	long byteCount ;

//background
	double imageBackground;
	
	// array of long values which are pointers to imageNodes in memory
	ImageNode ** imageNodePtr ;
	
	int filePtr ;
	
	// used in analysis: this defines the nuber of high dimensional points contained within this set
	int * highDList ;
	
} ImageSet ;



// **************************************************************************************
//				Fucnction prototypes
// **************************************************************************************
ImageNode * newImageNode(int newAbsX, int newAbsY, int newHeight, int newWidth, char * newImage, long newImageFilePtr, int fromFile, double newTime) ;
ImageNode * readImageNode(int filePtr, long * byteCount, int iVersion) ;
unsigned char * makeImageChar(ImageSet * thisSet, int thisNode) ;
int writeImageNode(ImageNode * thisNode, int filePtr, ImageSet * thisImageSet, int thisNodeIndex) ;
int destroyImageNode(ImageNode * thisNode) ;

//ImageSet * newImageSet(char * newImageSetName, int newImageSetNum, int MaxNumImages) ;
ImageSet * newImageSet(char * newImageSetName, int newImageSetNum, int MaxNumImages, double newBackground);
ImageSet * readImageSet(char * newImageSetName, int newImageSetNum) ;
int writeImageSet(ImageSet * thisImageSet) ;
int destroyImageSet(ImageSet ** imageSetPtrPtr) ;  
int addImage(ImageSet * thisImageSet, int newAbsX, int newAbsY, int newHeight, int newWidth, char * newImage, double newTime) ;

int GetVersionOfImageData (ImageSet * thisImageSet, int *iVersion);

int writeImageSetToAVI(ImageSet * thisImageSet) ;
