/**************************************************************************/
/* LabWindows/CVI User Interface Resource (UIR) Include File              */
/* Copyright (c) National Instruments 2004. All Rights Reserved.          */
/*                                                                        */
/* WARNING: Do not add to, delete from, or otherwise modify the contents  */
/*          of this include file.                                         */
/**************************************************************************/

#include <userint.h>

#ifdef __cplusplus
    extern "C" {
#endif

     /* Panels and Controls: */

#define  PANEL_COLL                      1
#define  PANEL_COLL_CANVAS_LIVE          2
#define  PANEL_COLL_TRACK_ON             3       /* callback function: DoTrackOn */
#define  PANEL_COLL_WRITE_BIN            4       /* callback function: DoWriteFileTrack */
#define  PANEL_COLL_STAGE_Y              5       /* callback function: DoSetStage */
#define  PANEL_COLL_STAGE_X              6       /* callback function: DoSetStage */
#define  PANEL_COLL_ImageRate            7       /* callback function: setImageFrameRate */
#define  PANEL_COLL_MIN_LENGTH           8
#define  PANEL_COLL_MIN_AREA             9
#define  PANEL_COLL_CAPTURE_RATE         10
#define  PANEL_COLL_MAX_LENGTH           11
#define  PANEL_COLL_WORM_CENT_Y          12
#define  PANEL_COLL_MAX_AREA             13
#define  PANEL_COLL_WORM_HEIGHT          14
#define  PANEL_COLL_WORM_CENT_X          15
#define  PANEL_COLL_WORM_AREA            16
#define  PANEL_COLL_WORM_WIDTH           17
#define  PANEL_COLL_STAGE_DOWN           18      /* callback function: DoMoveStage */
#define  PANEL_COLL_STAGE_RIGHT          19      /* callback function: DoMoveStage */
#define  PANEL_COLL_STAGE_UP             20      /* callback function: DoMoveStage */
#define  PANEL_COLL_STAGE_LEFT           21      /* callback function: DoMoveStage */
#define  PANEL_COLL_CALIBRATE_OK         22      /* callback function: DoCalibrateTracker */
#define  PANEL_COLL_TIMER_ON             23      /* callback function: DoTimerON */
#define  PANEL_COLL_TIMER_VAL            24      /* callback function: setTimer */
#define  PANEL_COLL_CALIBRATE_START      25      /* callback function: DoCalibrateTracker */
#define  PANEL_COLL_CURRENT_IMAGESET     26
#define  PANEL_COLL_Min                  27
#define  PANEL_COLL_Sec                  28
#define  PANEL_COLL_ResetTimer           29      /* callback function: ResetTimerJohn */
#define  PANEL_COLL_cmdCalibrateOptical  30      /* callback function: calibrateOptical */
#define  PANEL_COLL_numBackground        31
#define  PANEL_COLL_cmdOpticalCalibrate  32      /* callback function: opticalCalibration */
#define  PANEL_COLL_fuck                 33
#define  PANEL_COLL_bWriteCentroid       34
#define  PANEL_COLL_cmdIniCam            35      /* callback function: iniCam */
#define  PANEL_COLL_DECORATION_4         36
#define  PANEL_COLL_TEXTMSG_2            37
#define  PANEL_COLL_TEXTMSG_4            38
#define  PANEL_COLL_TEXTMSG_3            39
#define  PANEL_COLL_txtMsgOptical        40
#define  PANEL_COLL_DECORATION_2         41
#define  PANEL_COLL_trackerTimer         42      /* callback function: startTracking */


     /* Menu Bars, Menus, and Menu Items: */

#define  WORM                            1
#define  WORM_COLLECT                    2       /* callback function: PanelCollect */
#define  WORM_QUIT                       3       /* callback function: DoQuitMenu */


     /* Callback Prototypes: */ 

int  CVICALLBACK calibrateOptical(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK DoCalibrateTracker(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK DoMoveStage(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
void CVICALLBACK DoQuitMenu(int menubar, int menuItem, void *callbackData, int panel);
int  CVICALLBACK DoSetStage(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK DoTimerON(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK DoTrackOn(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK DoWriteFileTrack(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK iniCam(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK opticalCalibration(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
void CVICALLBACK PanelCollect(int menubar, int menuItem, void *callbackData, int panel);
int  CVICALLBACK ResetTimerJohn(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK setImageFrameRate(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK setTimer(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK startTracking(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);


#ifdef __cplusplus
    }
#endif
