

/*********************************************************************************************/
/*																							 */
/*		Worm Project:  Data collection and saving											 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*																							 */
/*		Written by John Feng and John Wittig	 											 */
/*        																					 */
/*      John Wittig left the project 8/29/2001, JF continues after 8/30/2001				 */
/*																							 */
/*		JW's codes was leaned up starting 8/30/2001, Codes from JW is mention 	             */																					 
/*				in the header of the function. Otherwise, it either JF's new or 			 */
/*					modified codes.  														 */
/*																							 */
/*		The general design of this program is totally changed   							 */
/*********************************************************************************************/

//********************************************************************************************************************

//*		Inlcluding header files																						 *

//********************************************************************************************************************


#include "Flexmotn.h"
#include "niimaq.h"
#include "nivision.h"

#include <formatio.h>
#include <analysis.h>
#include <utility.h>
#include <ansi_c.h>
#include <cvirte.h>		/* Needed if linking in external compiler; harmless otherwise */
#include <userint.h>

#include "wormClassify.h"
#include "wormDataStruct.h"
#include "ImageProcessing.h"

//AVI
#include "extcode.h"      


//********************************************************************************************************************
//*		JF Inlcluding header files																						
//********************************************************************************************************************

//* Constant used in this files
#define CALIBRATE_X 620
#define IMAGE_X 640
#define IMAGE_Y 480
#define NUM_NODES_IMAGESET 2400
//#define NUM_NODES_IMAGESET 4000
#define STAGE_TO_PIX 40		// conversion factor from stage coordinates to pixel coordinates



//********************************************************************************************************************/
//***********      GLOBAL VARIABLE DECLARATION   *********************************************************************/
//********************************************************************************************************************/
static int acquistionState;
static INTERFACE_ID iid;
static SESSION_ID sid;
static Image* myImage = NULL;

//UIR Panel ID
static int panelCollect;

//*********************************************************************************************//
//  Image objective and related definitions by JW
//*********************************************************************************************//
Image * BinImage ;	
Image * SourceImage ;

//*********************************************************************************************//
//  Global varaible definition by JW
//*********************************************************************************************//
// Color palette 
int	paletteGrey[256] ;   
int	paletteBin[256] ;   
static RGBValue paletteBinOut[256];
static RGBValue paletteGreyOut[256];
ColorMapEntry doubleColorMap[256] ;
PixelValue 	pixZero, whitePix ; 		// initalized to value zero in "initVar()"
//CalilbrationShit
// ***********      COLLECT globals: calibration of image collection, tracker variables		************************** / 
char calibrateLine[CALIBRATE_X] ;	 // initalized to value in "initVar()"     
// used in adjusting the tracker calibration variables and displaying line across the screen      
int calibrate_tracker ;		
int calibrate_X1, calibrate_Y1 ;
int calibrate_X2, calibrate_Y2 ;

// global variables used to communicate the file name of the imageSet and the centriod file to the seperate thread
char gImageSetPath[MAX_PATHNAME_LEN] ;
int gCentroidFile = null ;

//More claibration desinged by JF
double dOriginX = 0, dOriginY = 0;
int iCalibration = 0;
double dBackground = 197.5;
//the drop
float fCentXP, fCentYP; 

//the time
double dMS = 0.0;
double dMSFirst=0.0;
double gTimerVal = 60;
float gImageRate = 2;

//flags
int gWriteBinary = 0;
int gWriteCen;
int gTrackOnly = 1;
ImageSet * thisImageSet = null ;  
 

//********************************************************************************************************************/
//*	      LOCAL FUNCTION DECLARATION. 																				 */
//********************************************************************************************************************/

//Calibrationshit
void InitVariables (void) ;
int CVICALLBACK DoShowLive (void *functionData) ;   //calimbartion

//binaryOut
void OutputBinaryImages(Image * liveImage) ;//

int CVICALLBACK OutputBinFile(void * functionData) ;
//****timers
// the time control seems a little bit stupid.  Before the general structure is totally altered, this is a temparary solution
int TimerJohn(void *functionalData) ;  

/*********************************************************************************************/
/*																							 */
/*		The codes start here																 */
/*																							 */
/*********************************************************************************************/

/*********************************************************************************************/
/*		The main funciton. part is written by comiler										 */
/*********************************************************************************************/

int main (int argc, char *argv[])
{
	//* written by compiler
	if (InitCVIRTE (0, argv, 0) == 0)	/* Needed if linking in external compiler; harmless otherwise */
		return -1;	/* out of memory */
	if ((panelCollect = LoadPanel (0, "wormClassify.uir", PANEL_COLL)) < 0)
		return -1;	
		
   	//* Initialize Interface and Session with NI-IMAQ functions */
	imgInterfaceOpen ("img0", &iid);
	imgSessionOpen (iid, &sid);
	
	/* Setup the acquisition /have to do with a initiate button/
	//AVI
	// Define the area //
	imaqSetupGrab (sid, MakeRect (0, 0, 480, 640));
	
	// Create an image in which to store the acquired image /
	// if camera is 16 bit, use 16bit source, and lower bit depth processing images 8 or 2
	SourceImage = imaqCreateImage (IMAQ_IMAGE_I16, 2);
	BinImage = imaqCreateImage (IMAQ_IMAGE_U8, 4);
	//*/
	//* innitialize the global variables
	InitVariables() ;
		  
	//* written by compiler	  
	SetPanelPos (panelCollect, 40, 25);
	DisplayPanel (panelCollect);
	RunUserInterface ();

	/* run after uir is quit
	/* dispose of the character image of a red X representing a null image node */	
	imaqDispose (SourceImage);
	imaqDispose (BinImage);
	
	/* Release all used system resources */
	imgClose (sid, TRUE);
	imgClose (iid, TRUE);
	imaqDispose (myImage);
	
	return 0;
}


/*********************************************************************************************/
/*		Written by JW to initiate the globle variable										 */
/*********************************************************************************************/

void InitVariables(void)
{

int count,index ;
i32 xPos, yPos;

	// initialize the global gImageSetPath for data collection purposes
	for (index = 0; index < MAX_PATHNAME_LEN; index++) gImageSetPath[index] = null ;
	gCentroidFile = null ;			 //a global variable used to communicate the file name of the imageSet and the centriod file to the seperate thread, integer    

	// panelCollect number showing imageSet is not being currently collected
	SetCtrlVal(panelCollect, PANEL_COLL_CURRENT_IMAGESET, -1) ;

//binary Talbe
  	// color palletes used in image display functions
	for(count=0; count<256; count++)
	{					  
		paletteGrey[count] = MakeColor(count, count, count);
		paletteBin[count] = MakeColor(255,255,255);


		paletteGreyOut[count].B = count ;
		paletteGreyOut[count].R = count ;
		paletteGreyOut[count].G = count ;
		paletteGreyOut[count].alpha = 0 ;

		paletteBinOut[count].B = 0 ;
		paletteBinOut[count].R = 0 ;
		paletteBinOut[count].G = 0 ;
		paletteBinOut[count].alpha = 0 ;
	}

//color of binary
	doubleColorMap[0].dataValue.valDouble = 0 ;  
	doubleColorMap[0].color = MakeColor(255, 255,255);
	
	doubleColorMap[1].dataValue.valDouble = 1.0 ;  
	doubleColorMap[1].color = MakeColor(255, 255,1);
	
	paletteBin[0] = MakeColor(0,0,0);  
	paletteBin[2] = MakeColor(255,0,0);
	paletteBin[3] = MakeColor(0,255,0);
	paletteBin[4] = MakeColor(0,0,255);
	
	paletteBinOut[0].B = 0 ;
	paletteBinOut[0].R = 0 ;
	paletteBinOut[0].G = 0 ;
	paletteBinOut[0].alpha = 1 ;

	paletteBinOut[1].B = 255 ;
	paletteBinOut[1].R = 255 ;
	paletteBinOut[1].G = 255 ;
	paletteBinOut[1].alpha = 1 ;
	
	paletteBinOut[2].B = 0 ;
	paletteBinOut[2].R = 0 ;
	paletteBinOut[2].G = 100 ;
	paletteBinOut[2].alpha = 1 ;
	
  // create a pixel value of zero for display clearing and rotation in ViewImageBig and BigLoop
	pixZero.grayscale = 0.0 ;	
	whitePix.grayscale = 255 ;

  // calibration of the stage information
  // break line into 10 equal distant parts and color black and white
	for (count = 0; count < CALIBRATE_X; count++) calibrateLine[count] = 255 ;
	for (count = 0; count < 21; count++) 
	{
		if (count%2 == 0) for (index = 0; index < CALIBRATE_X/21; index++) calibrateLine[count*CALIBRATE_X/21 + index] = 255 ;
		else for (index = 0; index < CALIBRATE_X/21; index++) calibrateLine[count*CALIBRATE_X/21 + index] = 0 ; 
	}
	
	// init flex motion axis	
	flex_enable_axes (1, 0, 7, 0x06);     

	// move to initial center position slowly
	flex_load_rpm (1, 1, 100, 0xFF);
	flex_load_rpsps (1, 1, NIMC_BOTH, 20, 0xFF);
	flex_load_target_pos (1, 1, 300000, 0xFF);
//	flex_start (1, 1, 0);	

	flex_load_rpm (1, 2, 100, 0xFF);
	flex_load_rpsps (1, 2, NIMC_BOTH, 20, 0xFF);
	flex_load_target_pos (1, 2, 300000, 0xFF);
//	flex_start (1, 2, 0);	
	
	// set velocity and acceloration high form tracking, 1000, 500 was initial setting
	flex_load_rpm (1, 1, 100, 0xFF);
	flex_load_rpsps (1, 1, NIMC_BOTH, 50, 0xFF);

	flex_load_rpm (1, 2, 100, 0xFF);
	flex_load_rpsps (1, 2, NIMC_BOTH, 50, 0xFF);	

	// init the position coordinates on the user interface
	flex_read_pos_rtn (1, NIMC_AXIS1, &xPos);
	flex_read_pos_rtn (1, NIMC_AXIS2, &yPos);
	
	
	dMSFirst = 0;
	gTrackOnly = 1;
	
	SetCtrlVal (panelCollect, PANEL_COLL_STAGE_X, xPos);
	SetCtrlVal (panelCollect, PANEL_COLL_STAGE_Y, yPos);

	
}


//********************************************************************************************/
//*																							 */
//*		Written by JF and JW to calibrate the tracker										 */
//*																							 */
//*		JF: The basic idea is: when the stage is moving horizonally or vertically, the 		 */
//*			chacker should be move exactly horizonally or vertically.						 */
//*																							 */
//*																							 */
//********************************************************************************************/


/********DoCalibrateTracker*******************************************************************/
//		This function guides the user to calibrate the stage step by step
//********************************************************************************************/

int CVICALLBACK DoCalibrateTracker (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
char temp[1000] ;
float step ;

i32 i32X = 0, i32Y = 0;

int startCalibrate ;
int iChoice = 0;

  
  switch (event)
	{
	case EVENT_COMMIT:
	
			iCalibration = 0;

			// if "Calibrate Tracker is pressed, start at the beginning
			if (control == PANEL_COLL_CALIBRATE_START) 
			{
				calibrate_tracker = 0 ;									  //declared in the global variable section.  Used in another function below
			
				GetCtrlVal(panelCollect, PANEL_COLL_CALIBRATE_START, &startCalibrate) ;
			
				// turn on image if this is starting
				if (startCalibrate)	CmtScheduleThreadPoolFunction (DEFAULT_THREAD_POOL_HANDLE, DoShowLive,NULL, NULL); 
				
				// calibrate tracker is being turned off
				else return (0) ;
			}
			
			switch (calibrate_tracker)
			{

				case (0):
				
					SetCtrlAttribute (panelCollect, PANEL_COLL_CALIBRATE_OK, ATTR_DIMMED, 0);
				
					// ungrey Y coordinate and up/down
					MessagePopup ("Tracker Calibrate Step #1 of 5", 
							"Move a reference object to the left side of the screen on the horizontal line so that the object's left most pixel is on the left cross hair and press 'Next'");
					calibrate_tracker = 1 ;
				
				break ;
				
				case (1):
				
					// save X and Y coordinates 
					// grey out Y coordinate and up/down
					flex_read_pos_rtn (1, NIMC_AXIS1, &calibrate_X1);
					flex_read_pos_rtn (1, NIMC_AXIS2, &calibrate_Y1);
			
					MessagePopup ("Tracker Calibrate Step #2 of 5", 
						"Use 'RIGHT' and 'Stage X Coorinate' buttons to move object to the right side of the screen so the object's left most pixel is on the right cross hair and press 'Next'") ;
					calibrate_tracker = 2 ;

				break ;

				case (2):
				
					// ungrey Y coordinate and up/down
					// grab X and Y coordinates, 
					// set the stage-to-pixel converter
					flex_read_pos_rtn (1, NIMC_AXIS1, &calibrate_X2);
					flex_read_pos_rtn (1, NIMC_AXIS2, &calibrate_Y2);
					
					step = (calibrate_X2 - calibrate_X1) / 620.0 ;
					
					sprintf(temp, "x step =%f", step) ;
					MessagePopup ("Tracker Calibrate Step #3 of 5", temp) ; 
					
					calibrate_tracker = 3 ;

					
				break ;
				
				case (3):
				
redo:				iChoice = ConfirmPopup ("Home orgin", "Do you need to home origin ?");
					
					if (iChoice == 1)
					{
							MessagePopup ("Tracker Calibrate Step #4 of 5", 
								"Using the calibration plate, use curssor or 'Coorinate' buttons to move origin of plate superimpose with the cross hair. Press 'Next'") ;

					}
					else
					{
						calibrate_tracker = 0 ;
						dOriginX = 467281;
						dOriginY = 4294710;
						iCalibration ++;  						
						SetCtrlVal(panelCollect, PANEL_COLL_CALIBRATE_START, 0);
						SetCtrlAttribute (panelCollect, PANEL_COLL_cmdCalibrateOptical, ATTR_DIMMED, 0);
						MessagePopup ("End of calibration",
						"If you need to recalibrate tracker again. Otherwise thank you for calibrating! You may now save images to disk!");
						SetCtrlAttribute (panelCollect, PANEL_COLL_CALIBRATE_OK, ATTR_DIMMED, 1);
						SetCtrlAttribute (panelCollect, PANEL_COLL_cmdCalibrateOptical, ATTR_DIMMED, 0);
					
						sprintf(temp, "x(0) = %f; y(0) = %f", dOriginX, dOriginY);
					
						MessagePopup ("test", temp);
					}
					
					// turn off image by turning off button
					calibrate_tracker = 4 ;

				break;
				

				case (4):
						
					flex_read_pos_rtn (1, NIMC_AXIS1, &i32X);
					
					flex_read_pos_rtn (1, NIMC_AXIS2, &i32Y);			

					sprintf(temp, "x(0) = %d; y(0) = %d", i32X, i32Y);
					
					MessagePopup ("Origni point calibrated", temp);
					
					dOriginX = i32X * 1.0;
					dOriginY = i32Y * 1.0;

					iCalibration ++;
//Make it invisible
					calibrate_tracker = 0 ;
					SetCtrlVal(panelCollect, PANEL_COLL_CALIBRATE_START, 0);
					SetCtrlAttribute (panelCollect, PANEL_COLL_cmdCalibrateOptical, ATTR_DIMMED, 0);
					MessagePopup ("End of calibration",
						"If you need to recalibrate tracker again. Otherwise thank you for calibrating! You may now save images to disk!");
					SetCtrlAttribute (panelCollect, PANEL_COLL_CALIBRATE_OK, ATTR_DIMMED, 1);
					SetCtrlAttribute (panelCollect, PANEL_COLL_cmdCalibrateOptical, ATTR_DIMMED, 0);
					
				break;
		   }
		   
		   
	break;
  }
  return 0;
}


// ******************DoSetStage**********************************************************************************/
//  	Moving the stage by setting XY coordinates directly (JW)													
// **************************************************************************************************************/

int CVICALLBACK DoSetStage (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

i32 xPos, yPos;

	switch (event)
		{
		case EVENT_COMMIT:

			GetCtrlVal (panelCollect, PANEL_COLL_STAGE_X, &xPos);
			GetCtrlVal (panelCollect, PANEL_COLL_STAGE_Y, &yPos);

			flex_load_target_pos (1, 1, xPos, 0xFF); 
			flex_load_target_pos (1, 2, yPos, 0xFF); 
			flex_start (1, 1, 0); 
			flex_start (1, 2, 0); 
			
			break;
		}
	return 0;
}


// *****************DoMoveStage**********************************************************************************/
// 		Moving the stage by push the buttons (JW)				 													
// **************************************************************************************************************/

int CVICALLBACK DoMoveStage (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

i32 xPos, yPos;

	switch (event)
		{
		case EVENT_COMMIT:

			flex_read_pos_rtn (1, NIMC_AXIS1, &xPos);
			flex_read_pos_rtn (1, NIMC_AXIS2, &yPos);
			
	
			switch (control)
			{
			case PANEL_COLL_STAGE_UP:
				yPos = yPos + 4000 ;
				
			case PANEL_COLL_STAGE_DOWN:
				yPos = yPos - 2000 ;
				
				flex_load_target_pos (1, 2, yPos, 0xFF);
				flex_start (1, 2, 0);
			break;

			case PANEL_COLL_STAGE_LEFT:
				xPos = xPos + 4000 ; 
			
			case PANEL_COLL_STAGE_RIGHT:
				xPos = xPos - 2000 ; 
			
				flex_load_target_pos (1, 1, xPos, 0xFF);
				flex_start (1, 1, 0);
			break;
			}	


			SetCtrlVal (panelCollect, PANEL_COLL_STAGE_X, xPos);
			SetCtrlVal (panelCollect, PANEL_COLL_STAGE_Y, yPos);
			
		break;
		}
	return 0;
}


// ****************DoShowLive*************************************************************************************************/
//		JW:DoShowLive: called and runs in seperate thread (not main) by DoCalibrateTracker()						
//		Captures the live image and calls the outputbinaryImage to display it displays to screen during calibration														
// ***************************************************************************************************************************/

int CVICALLBACK DoShowLive (void *functionData)
{				

  int calibrateOn ;

		GetCtrlVal (panelCollect, PANEL_COLL_CALIBRATE_START, &calibrateOn) ;
				
		while (calibrateOn)
		{
			SourceImage = imaqSnap (sid, SourceImage, IMAQ_NO_RECT);
		 	
			imaqCast (SourceImage, SourceImage, IMAQ_IMAGE_U8, NULL, 2);
			OutputBinaryImages(SourceImage) ; 			
			
			ProcessSystemEvents ();
			
			GetCtrlVal (panelCollect, PANEL_COLL_CALIBRATE_START, &calibrateOn) ;
		}				   
		
	return 0;
}



// *******************OutputBinaryImages*************************************************************************/
//		DoShowLive: called and runs in seperate thread (not main) by DoCalibrateTracker()						
//		Captures the live image and displays to screen. NOT really take the live image and translate to binary
//             image.  Just display it.  The name of this function is confusing.
// **************************************************************************************************************/
void OutputBinaryImages(Image * liveImage)
{
int liveBit ;
unsigned char * liveChar ;

	
  // grey-scale pallete used for these two	
	if (liveImage != NULL)
	{

		// if in calibration mode, draw line across screen
		if (calibrate_tracker != 0) 
		{
			 if (calibrate_tracker == 1) imaqSetLine (liveImage, calibrateLine, 620, MakePoint(15,235), MakePoint(15,245));
			 if (calibrate_tracker == 2) imaqSetLine (liveImage, calibrateLine, 620, MakePoint(625,235), MakePoint(625,245));
			 if (calibrate_tracker == 3) imaqSetLine (liveImage, calibrateLine, 620, MakePoint(320,235), MakePoint(320,245));
			 if (calibrate_tracker == 4) imaqSetLine (liveImage, calibrateLine, 620, MakePoint(320,235), MakePoint(320,245));
			 imaqSetLine (liveImage, calibrateLine, 620, MakePoint(10,240), MakePoint(630,240));
		}

		liveChar = imaqImageToArray (liveImage, IMAQ_NO_RECT, NULL, NULL);
		NewBitmap (IMAGE_X, 8, IMAGE_X, IMAGE_Y, paletteGrey, liveChar, 0, &liveBit);
		CanvasDrawBitmap (panelCollect, PANEL_COLL_CANVAS_LIVE, liveBit, VAL_ENTIRE_OBJECT, MakeRect(0,0,VAL_KEEP_SAME_SIZE,VAL_KEEP_SAME_SIZE));		
		imaqDispose(liveChar);					
		DiscardBitmap (liveBit);
	}

}

/*********************************************************************************************/
/*		Written by JF to track the worm														 */
/*																							 */
/*		JF: The basic idea is: find the largest particle in the image.  Assume that is the 	 */
/*			worm. Get its central mass point and keep tracking it.  .						 */
/*																							 */
/*		The central function is DoTrackOne													 */
/*********************************************************************************************/



//**********OutputBinFile*****************************************************************************************/
//		After DoTrackOn turns on the image processing function, which runs continuously in another thread
//			Tbis function is translate the data to imageset
//****************************************************************************************************************/

//JF corrected 08/30/01
int CVICALLBACK OutputBinFile(void * functionData)
//int OutputBinFile(void * functionData)
{

  ImageSet * thisLocalImageSet = (ImageSet *)functionData ;

//AVI change
//	writeImageSet(thisLocalImageSet) ;
	writeImageSetToAVI(thisLocalImageSet) ;

	destroyImageSet(&thisLocalImageSet) ;
		
	return (0) ;
}

//*****************************DoWriteFile************************************************************************/
//		DoTrackOn: Called by turning on the file writing program to write a file.  It is pop out an UIR for user 
//      to imput the directory and other stuff
//****************************************************************************************************************/




//********************************************************************************************************************//
//*																													 *//
//*		Menu Item Functions: switch between different programs and quit												 *//
//*																													 *//
//********************************************************************************************************************//
void CVICALLBACK PanelCollect (int menuBar, int menuItem, void *callbackData, int panel)
{
int top, left ;

		HidePanel (panel); 
		GetPanelAttribute (panel, ATTR_LEFT, &left);
		GetPanelAttribute (panel, ATTR_TOP, &top);
		SetPanelPos (panelCollect, top, left);
		DisplayPanel (panelCollect);
}



void CVICALLBACK DoQuitMenu (int menuBar, int menuItem, void *callbackData, int panel)
{
  int trackOn ;
		
		// turn off tracker, the delay allows the separate tracker thread to end before the program closes
		GetCtrlVal(panelCollect, PANEL_COLL_TRACK_ON, &trackOn) ;
		if (trackOn == 1)
		{
			SetCtrlVal(panelCollect, PANEL_COLL_TRACK_ON, 0) ;
			ProcessSystemEvents() ;
			Delay(1) ;
		}
		
		QuitUserInterface (0);
}



//************************DoTimerON**********************************************************************************************//
// 																																 //
// 		JW has the prototype of this function, but this function is empty.  I use this function to set a timer for user          //
//            to monitor the time for record the data.  																	     //
// 																																 //
//*******************************************************************************************************************************//
int CVICALLBACK DoTimerON (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

int iTimerOn;

	switch (event)
		{
		case EVENT_COMMIT:
		
			GetCtrlVal (panelCollect, PANEL_COLL_TIMER_ON, &iTimerOn) ; 
			
			// create a high priority thread to run the image acquizition and processing on
			if (iTimerOn == 1)
			{
				CmtScheduleThreadPoolFunctionAdv (DEFAULT_THREAD_POOL_HANDLE,TimerJohn, NULL, THREAD_PRIORITY_ABOVE_NORMAL, 
													NULL, EVENT_TP_THREAD_FUNCTION_END, NULL, CmtGetCurrentThreadID(), NULL);
			}else
			{
				SetCtrlVal(panelCollect, PANEL_COLL_Min, 0);
				SetCtrlVal(panelCollect, PANEL_COLL_Sec, 0);
		    	//SetCtrlAttribute (panelCollect, PANEL_COLL_trackerTimer, ATTR_ENABLED, 0);
			}

			break;
		}
	return 0;
}

//************************TimerJohn**********************************************************************************************//
// 																																 //
// 		This function is to monitor the time scince the user starts record the data, and display it to the user.                 //
// 																																 //
//*******************************************************************************************************************************//
//int TimerJohn(void * functionalData)
int TimerJohn(void * functionalData)
{
int iMin, iSecond;
int iIsTimerOn;
double dTempTime = 0;
	
	GetCtrlVal(panelCollect, PANEL_COLL_TIMER_ON, &iIsTimerOn) ;
	
	while (iIsTimerOn == 1)
	{
		dTempTime = dMS - dMSFirst;
		iMin = (int) floor(dTempTime / 60);
		iSecond = floor ( (int) floor (dTempTime) % 60  );
		
		SetCtrlVal(panelCollect, PANEL_COLL_Min, iMin);
		SetCtrlVal(panelCollect, PANEL_COLL_Sec, iSecond);
		SetCtrlVal(panelCollect, PANEL_COLL_fuck, dTempTime);
		
		if (gTimerVal * 60  < dTempTime )
		{
		  SetCtrlAttribute (panelCollect, PANEL_COLL_trackerTimer, ATTR_ENABLED, 0);  
		  SetCtrlVal (panelCollect, PANEL_COLL_WRITE_BIN , 0) ;
		  SetCtrlVal (panelCollect, PANEL_COLL_TRACK_ON , 0) ;
		  SetCtrlVal (panelCollect, PANEL_COLL_TIMER_ON, 0) ;
		}
		
		Delay (0.5);
	}
	return 0; 	
}


//************************TimerJohn**********************************************************************************************//
// 																																 //
// 		This function is to reset the timer.    																	             //
// 																																 //
//*******************************************************************************************************************************//
int CVICALLBACK ResetTimerJohn (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
				SetCtrlVal(panelCollect, PANEL_COLL_Min, 0);
				SetCtrlVal(panelCollect, PANEL_COLL_Sec, 0);
				SetCtrlVal(panelCollect, PANEL_COLL_TIMER_VAL, 60.0);
				SetCtrlVal(panelCollect, PANEL_COLL_fuck, 0.0);
				//dMS = 0.0;
		break;
		}
	return 0;
}


int CVICALLBACK calibrateOptical (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
				MessagePopup ("Optical System Calibration 1", "1. Adjut the mirror to a confortable angle. \n2. Put a plate with media but not worm on holder. \n3. If it is done click NEXT STEP button.") ;
				SetCtrlAttribute (panelCollect, PANEL_COLL_cmdOpticalCalibrate, ATTR_DIMMED, 0) ;

			break;
		}
	return 0;
}



int CVICALLBACK opticalCalibration (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

Image * tempImage ; 
unsigned char* tempImageArray;
int iWidth, iHeight;
int indexRow, indexCol;
int iBitmap;
unsigned char ** tempImageMatrix;

	switch (event)
		{
		case EVENT_COMMIT:
		
			tempImage = imaqSnap (sid, NULL, IMAQ_NO_RECT);
			imaqCast (tempImage, tempImage, IMAQ_IMAGE_U8, NULL, 2);

			tempImageArray = imaqImageToArray (tempImage, IMAQ_NO_RECT, &iWidth, &iHeight);
			
			if (tempImageArray == NULL) return 0;

			tempImageMatrix = (unsigned char **) malloc ((iHeight * iWidth) * sizeof (unsigned char**));
	
			for (indexRow = 0; indexRow < iHeight; indexRow ++)
			{
				tempImageMatrix[indexRow]  = (unsigned char *) calloc (iWidth, sizeof (unsigned char*));
			}
			

			//CanvasClear (panelCollect, PANEL_COLL_CANVAS_SMALL, VAL_ENTIRE_OBJECT);

			NewBitmap (iWidth, 8, iWidth, iHeight, paletteGrey, tempImageArray, 0, &iBitmap);
			CanvasDrawBitmap (panelCollect, PANEL_COLL_CANVAS_LIVE, iBitmap, VAL_ENTIRE_OBJECT, MakeRect(0,0,VAL_KEEP_SAME_SIZE,VAL_KEEP_SAME_SIZE));		
			DiscardBitmap (iBitmap);

			BreakImage1DArrayTo2DArray (tempImageArray, iHeight, iWidth, tempImageMatrix) ; 
			
			for (indexRow = 0; indexRow < iHeight; indexRow ++)
			{
				for (indexCol = 0; indexCol < iWidth; indexCol++)
				{
		      		dBackground = dBackground + tempImageMatrix[indexRow][indexCol] ;
				}
			}
			
			dBackground = dBackground / (iHeight * iWidth);

			SetCtrlVal (panelCollect, PANEL_COLL_numBackground, dBackground);
			iCalibration ++;
			
			if (!tempImageArray) free (tempImageArray);
			imaqDispose (tempImage);

			for (indexRow = 0; indexRow < iHeight; indexRow ++)
			{
				free (tempImageMatrix[indexRow]);
			}

			free (tempImageMatrix);

			SetCtrlAttribute (panelCollect, PANEL_COLL_cmdOpticalCalibrate, ATTR_DIMMED, 1) ;
			
			break;
		}
	return 0;
}

int CVICALLBACK setTimer (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			GetCtrlVal (panelCollect, PANEL_COLL_TIMER_VAL, &gTimerVal) ;
			
			break;
		}
	return 0;
}

int CVICALLBACK startTracking (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

  // general purpose counter
  int index ;
  static int nbFrame = 0;  

  // variables obtained from the user interface "GetCtrlVal()"
  int writeCentroid;
  int writeBinary ;
  int MaxLength, MinLength;
  int MaxArea, MinArea ;

  // used to find the worm particle and store its properties
  int wormIndex ;
  float newArea, bigArea ;
  float wormTop, wormLeft, wormHeight, wormWidth ;
  float wormCentX, wormCentY ;
  // used in the absolute center of mass calculation
  float absWormCentX, absWormCentY ;
  float absWormX, absWormY ;
  
  // image processing variables: 
  ParticleReport*partReport;
  int numPart;

  // the bitmap of the bounding rectangle containing the worm used for display
  char * saveImage ;

  // for centroid file output 
  int bytesWritten = 0 ;
  char string[1000] ;

  // the imageSet datastructure pointer used to save images to file
//  ImageSet * thisImageSet = null ;  
  int thisSetNum, resultAdd;

  // tracker variables, the position of the tracker, and the amount the stage need to move to center the worm box
  i32 xPos, yPos ;
  int stageMoveX, stageMoveY ;
  float fCentX0 = 0, fCentY0 = 0, fCentX1 = 0, fCentY1 = 0;
  float fNewX, fNewY;
  float fDis1, fDis0;
  double dMS0;
  double dTempTime = 0;
  
  int iIsBin, iIsTrackOnly;

	switch (event)
		{
		case EVENT_TIMER_TICK:

//I have to find a place to put this		
 			//GetCtrlVal (panelCollect, PANEL_COLL_WRITE_BIN, &writeBinary) ;
			// deal with the timer
			//GetCtrlVal (panelCollect, PANEL_COLL_TIMER_ON, &timerOn) ;

			//* grab the image processing parameters
			//GetCtrlVal (panelCollect, PANEL_COLL_ImageRate, &fRate) ;
			GetCtrlVal (panelCollect, PANEL_COLL_MAX_AREA, &MaxArea) ;
			GetCtrlVal (panelCollect, PANEL_COLL_MIN_AREA, &MinArea) ;
			GetCtrlVal (panelCollect, PANEL_COLL_MAX_LENGTH, &MaxLength) ;
			GetCtrlVal (panelCollect, PANEL_COLL_MIN_LENGTH, &MinLength) ;

			//*/
			dMS = Timer();
			dTempTime = dMS-dMSFirst;
			nbFrame++;
			if (nbFrame>10)
			{
				SetCtrlVal (panelCollect, PANEL_COLL_CAPTURE_RATE, nbFrame/(dMS-dMS0));
				dMS0 = dMS;
				nbFrame=0;
			}

			
			// reset timer for new iteration   
		 	//myImage = imaqGrab (sid, myImage, FALSE);
		 	myImage = imaqGrab (sid, myImage, FALSE);

			imaqCast (myImage, myImage, IMAQ_IMAGE_U8, NULL, 2);
			if (myImage == NULL) goto bad;

			imaqThreshold (BinImage, myImage, 0.0, dBackground - 50, TRUE, 1);
			partReport = imaqGetParticleInfo (BinImage, TRUE, IMAQ_ALL_INFO, &numPart);

			newArea = 0;
			bigArea = MinArea ;
			wormIndex = -1 ;
			
			fDis0 = 1000000;
			
			// determine which particle has the biggest area, but is within the width and height of the biggest worm
			// eventually this will be implemented with a MAX AREA parameter to screen out the side of the dish
			flex_read_pos_rtn (1, NIMC_AXIS1, &xPos);
			flex_read_pos_rtn (1, NIMC_AXIS2, &yPos);

//Crush Problem
			if (numPart <= 0)
			{
				goto bad;
			}


			for (index = 0; index < numPart; index++)
			{
				imaqCalcCoeff (BinImage, &(partReport[index]), IMAQ_AREA, &newArea);
				if (newArea > MinArea && newArea < MaxArea) 
				{
					imaqCalcCoeff (BinImage, &(partReport[index]), IMAQ_HEIGHT, &wormHeight);
					imaqCalcCoeff (BinImage, &(partReport[index]), IMAQ_WIDTH, &wormWidth);
					
					if (wormHeight <= MaxLength & wormWidth <= MaxLength)
					{
						imaqCalcCoeff (BinImage, &(partReport[index]), IMAQ_CENTER_MASS_X, &fNewX);
						imaqCalcCoeff (BinImage, &(partReport[index]), IMAQ_CENTER_MASS_Y, &fNewY);
						
						fCentX1 =  (-xPos/STAGE_TO_PIX + fNewX);
						fCentY1 =  (-yPos/STAGE_TO_PIX + fNewY);

						fDis1 = sqrt ( (fCentX1 -fCentXP) * (fCentX1 - fCentXP) + (fCentY1 - fCentYP) * (fCentY1 - fCentYP) ) ;
						if (fDis1 < fDis0)
						{
							bigArea = newArea ;
							wormIndex = index ;
							fCentX0 = fCentX1;
							fCentY0 = fCentY1;
							fDis0 = fDis1;
						}
						
					}
				}
			}
			
			fCentXP = fCentX0;
			fCentYP = fCentY0;
			
bad:		if (wormIndex != -1)
			{
				imaqCalcCoeff (BinImage, &(partReport[wormIndex]), IMAQ_TOP_ROW, &wormTop);
				imaqCalcCoeff (BinImage, &(partReport[wormIndex]), IMAQ_LEFT_COLUMN, &wormLeft);
				imaqCalcCoeff (BinImage, &(partReport[wormIndex]), IMAQ_HEIGHT, &wormHeight);
				imaqCalcCoeff (BinImage, &(partReport[wormIndex]), IMAQ_WIDTH, &wormWidth);

				imaqCalcCoeff (BinImage, &(partReport[wormIndex]), IMAQ_CENTER_MASS_X, &wormCentX);
				imaqCalcCoeff (BinImage, &(partReport[wormIndex]), IMAQ_CENTER_MASS_Y, &wormCentY);
			
				//*calibrated by orgin
				// stage is has opposite direction of increase, make abs match cartesian plane, up and right are positive directions
				absWormCentX = (-xPos/STAGE_TO_PIX + wormLeft + wormCentX)  - dOriginX;
				absWormCentY = (-yPos/STAGE_TO_PIX + wormTop + wormCentY) - dOriginY;
				//*/

				//* Calibrated by origin
				//AVI change
				//When reading back later just + wormLeft and top and so on
				//absWormX = (-xPos/STAGE_TO_PIX + wormLeft) - dOriginX;  
				//absWormY = (-yPos/STAGE_TO_PIX + wormTop) - dOriginY;    
				absWormX = (-xPos/STAGE_TO_PIX) - dOriginX;  
				absWormY = (-yPos/STAGE_TO_PIX) - dOriginY;    

				//*/
				// load the coordinates that would shift the worm median to the center of the screen
				// *******************  40(39.7) units in flex equals 1 pixel  ***************************
				// how to move the current stage coordinates to center on the worms bounding box
				if (wormTop < 20 || wormLeft < 20 || wormLeft + wormWidth > 620 || wormTop + wormHeight > 460)
				{
					stageMoveX = IMAGE_X/2 - wormCentX ;
					stageMoveY = IMAGE_Y/2 - wormCentY ;
				
					flex_load_target_pos (1, 1, xPos + stageMoveX*STAGE_TO_PIX, 0xFF); 
					flex_load_target_pos (1, 2, yPos + stageMoveY*STAGE_TO_PIX, 0xFF); 
					flex_start (1, 1, 0); 
					flex_start (1, 2, 0); 
			
					SetCtrlVal (panelCollect, PANEL_COLL_STAGE_X, xPos + stageMoveX);
					SetCtrlVal (panelCollect, PANEL_COLL_STAGE_Y, yPos + stageMoveY);
					
  				}
				
//************* //AVI change
				//saveImage = imaqImageToArray (myImage,MakeRect (wormTop, wormLeft, wormHeight, wormWidth), NULL, NULL);
				saveImage = imaqImageToArray (myImage,IMAQ_NO_RECT, NULL, NULL);
				//imaqArrayToImage (BinImage, saveImage, wormWidth, wormHeight);
				//imaqDisplayImage (BinImage, 0, FALSE);
				imaqDrawShapeOnImage (myImage, myImage, MakeRect (wormTop, wormLeft, wormHeight, wormWidth), IMAQ_DRAW_VALUE,
									  IMAQ_SHAPE_RECT, 0);
				OutputBinaryImages(myImage) ; 	
				
			}
			else  // no worm was found: dont track, set all parameters to zero, and empty clean image, save null images to imageSet
			{
				wormTop = 0.0 ;
				wormLeft = 0.0 ;
				wormWidth = 0.0 ;
				wormHeight = 0.0 ;
				bigArea = 0.0 ;
				//imaqDispose(saveImage);
				saveImage = NULL ;
			}
	
			// output image statistics
			if (gImageRate <= 8)
			{
				SetCtrlVal (panelCollect, PANEL_COLL_WORM_AREA, bigArea) ;	
				SetCtrlVal (panelCollect, PANEL_COLL_WORM_WIDTH, wormWidth) ;
				SetCtrlVal (panelCollect, PANEL_COLL_WORM_HEIGHT, wormHeight) ;
				SetCtrlVal (panelCollect, PANEL_COLL_WORM_CENT_X, absWormCentX) ;
				SetCtrlVal (panelCollect, PANEL_COLL_WORM_CENT_Y, absWormCentY) ;
			}	
			// clean up memory of particle report	
			imaqDispose(partReport) ;
			
//User decide to write the binary file
			if (gWriteBinary == 1 && gImageSetPath[0] != null)
			//if (writeBinary == 1 && gImageSetPath[0] != null)
			{
//Do I need work here
//if write fiel and there is a image path, I just put it into memory here.  When it is click off write the data.

				if (thisImageSet == null) //if it is the first onedurin
				{
					thisSetNum = 0 ;
					SetCtrlVal(panelCollect, PANEL_COLL_CURRENT_IMAGESET, thisSetNum) ;
					//take careof the buffer
					
					//AVI change
					//thisImageSet = newImageSet(gImageSetPath, thisSetNum, NUM_NODES_IMAGESET, dBackground) ; 
					thisImageSet = newImageSet(gImageSetPath, thisSetNum, NUM_NODES_IMAGESET, gImageRate) ; 
				}
				
				//AVI change
				//resultAdd = addImage(thisImageSet, absWormX, absWormY, wormHeight, wormWidth, saveImage, dTempTime) ;
				resultAdd = addImage(thisImageSet, absWormX, absWormY, 480, 640, saveImage, dTempTime) ;
				
				if (resultAdd == FULL_SET_ERROR) //if need to start a new set. 
				{
					//If the maxNum in current set is reached.  Start writing to it.  And start a newone
					CmtScheduleThreadPoolFunction (DEFAULT_THREAD_POOL_HANDLE, OutputBinFile, (void*)thisImageSet, NULL);
					thisSetNum++;
					SetCtrlVal(panelCollect, PANEL_COLL_CURRENT_IMAGESET, thisSetNum) ; 
					thisImageSet = newImageSet(gImageSetPath, thisSetNum, NUM_NODES_IMAGESET, dBackground) ; 
				}	 
			}
//I write the final
//*
			else if (gWriteBinary == 0)  // switch turned off, or just plain is off. Have to write the last one.
			{
//Need therh
				if (gTrackOnly == 1) goto donotWrite;
				// write the last imageSet worked on
				/*
				if (thisImageSet != null) CmtScheduleThreadPoolFunction (DEFAULT_THREAD_POOL_HANDLE, OutputBinFile, thisImageSet, NULL);  
				
				// init the local imageSet Pointer to null
				thisSetNum = -1 ;
				SetCtrlVal(panelCollect, PANEL_COLL_CURRENT_IMAGESET, thisSetNum) ;
				thisImageSet = null ;
				// init the global pathname
				if (gImageSetPath[0] != null)
					for (index = 0; index < MAX_PATHNAME_LEN; index++) gImageSetPath[index] = null ;
				//*/
			}
			if (gWriteCen == 1 && wormIndex != -1) 
			{
			    bytesWritten = sprintf(string,"%f %f %f",dTempTime, absWormCentX, absWormCentY);
				WriteLine (gCentroidFile, string, bytesWritten);	
			}
			
donotWrite:			break;
		}

	return 0;
}

//****************************DoTrackOn***************************************************************************/
//		DoTrackOn: Turns on the image processing function, which runs continuously in another thread
//      		to track the worm
//****************************************************************************************************************/

int CVICALLBACK DoTrackOn (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

int iTrack;
	
	switch (event)
		{
		case EVENT_COMMIT:

			GetCtrlVal (panelCollect,PANEL_COLL_TRACK_ON, &iTrack);
			GetCtrlVal (panelCollect,PANEL_COLL_WRITE_BIN, &acquistionState);
			
			if (iTrack == 0 && acquistionState == 0)
			{
				gWriteBinary = 0;
 		    	SetCtrlAttribute (panelCollect, PANEL_COLL_trackerTimer, ATTR_ENABLED, 0);
 		    	SetCtrlVal (panelCollect,PANEL_COLL_WRITE_BIN,0);
 		    	SetCtrlVal (panelCollect,PANEL_COLL_TIMER_ON,0);   
 		    	//dMS = 0;

			}
			else
			{
				if (acquistionState ==0) 
				{
					gWriteBinary = 0;
 		    		SetCtrlAttribute (panelCollect, PANEL_COLL_trackerTimer, ATTR_ENABLED, 1);
 		    		dMSFirst = Timer();
					gTrackOnly = 1;
				}  
				else gTrackOnly = 0;
			}
			
			break;
			
		}
	return 0;
}

int CVICALLBACK DoWriteFileTrack (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

char centFileName[MAX_PATHNAME_LEN];
int errorFile ;
int writeBinary, trackOn, index ; 
int iTimerOn;
int iChoice;

	switch (event)
		{
		case EVENT_COMMIT:
		
		
			GetCtrlVal (panelCollect,PANEL_COLL_WRITE_BIN, &acquistionState);
		    
		    if (acquistionState == 0)
		    {
		    	SetCtrlAttribute (panelCollect, PANEL_COLL_trackerTimer, ATTR_ENABLED, acquistionState);

				if (gImageSetPath[0] != null)
				for (index = 0; index < MAX_PATHNAME_LEN; index++) gImageSetPath[index] = null ;

				SetCtrlVal(panelCollect, PANEL_COLL_TRACK_ON, 0) ;

				SetCtrlVal (panelCollect, PANEL_COLL_TIMER_ON, 0);
				SetCtrlAttribute (panelCollect, PANEL_COLL_TIMER_ON, ATTR_DIMMED, 1);
					SetCtrlAttribute (panelCollect, PANEL_COLL_ImageRate, ATTR_VISIBLE, 0);     

				if (gWriteCen == 1) 
				{	
					CloseFile(gCentroidFile) ;
					gWriteCen = 0;
				}

				gCentroidFile = null ;

//Taking care of binaryImage
			    gWriteBinary = 0; 
			    gTrackOnly = 1;
			    //write this image set
				if (thisImageSet != null) CmtScheduleThreadPoolFunction (DEFAULT_THREAD_POOL_HANDLE, OutputBinFile, thisImageSet, NULL);  

				SetCtrlVal(panelCollect, PANEL_COLL_CURRENT_IMAGESET, -1) ;
				MessagePopup ("Tracking Complete", "Tracking Complete!");
				thisImageSet = null ;
				if (gImageSetPath[0] != null)
					for (index = 0; index < MAX_PATHNAME_LEN; index++) gImageSetPath[index] = null ;
			    
			    return(0);
			    }
			    
			    
			if (acquistionState == 1 && iCalibration <= 1)
			{
				iChoice = ConfirmPopup ("Warning", "Are you sure go without calibration?"); 
			}
			
			if (iChoice == 0)
			{
				SetCtrlVal (panelCollect, PANEL_COLL_TRACK_ON, 0);
				SetCtrlVal (panelCollect, PANEL_COLL_WRITE_BIN, 0);
				MessagePopup ("Error", "Please calibrate coordinate first then optical field!");
			   	gWriteBinary = 0;
			   	gTrackOnly = 1;
			}
			else
			{
			   	iCalibration = 2;
			   	dOriginX = 0;
			   	dOriginY = 0;
			}

			GetCtrlVal(panelCollect, PANEL_COLL_TIMER_ON, &iTimerOn) ;
			if (iTimerOn == 0)
			{
				SetCtrlAttribute (panelCollect, PANEL_COLL_TIMER_ON, ATTR_DIMMED, 0);
				SetCtrlVal (panelCollect, PANEL_COLL_TIMER_ON, 1);
				DoTimerON ( panelCollect, null, EVENT_COMMIT, NULL, null, null) ;
			}

			errorFile = FileSelectPopup ("c:\\ImageData", "NewData", "*.avi",
											 "Save Image Set File", VAL_SAVE_BUTTON,
											 0, 1, 1, 1, gImageSetPath);
			if (errorFile <= 0)
			{
				SetCtrlVal(panelCollect, PANEL_COLL_WRITE_BIN, 0) ;
//JF add these two lines
				SetCtrlVal (panelCollect, PANEL_COLL_TIMER_ON, 0);
				SetCtrlVal(panelCollect, PANEL_COLL_TRACK_ON,0) ;

				SetCtrlAttribute (panelCollect, PANEL_COLL_TIMER_ON, ATTR_DIMMED, 1);
				
			   	gWriteBinary = 0;
			   	gTrackOnly = 1;
			}

			GetCtrlVal(panelCollect, PANEL_COLL_bWriteCentroid, &gWriteCen) ;
			if (gWriteCen == 1)
			{
					sprintf(centFileName, "%s.txt.", gImageSetPath) ;
					gCentroidFile = OpenFile (centFileName, VAL_WRITE_ONLY, VAL_TRUNCATE ,VAL_ASCII);
			}

			// initalize anything in the file that goes on the first few lines		
			SetCtrlVal(panelCollect, PANEL_COLL_TRACK_ON, 1) ;
			gWriteBinary = 1;
			gTrackOnly = 0;
 		    SetCtrlAttribute (panelCollect, PANEL_COLL_trackerTimer, ATTR_ENABLED, acquistionState);
 			
 			//AVI change
 			GetCtrlVal (panelCollect, PANEL_COLL_ImageRate, &gImageRate) ;
			SetCtrlAttribute (panelCollect, PANEL_COLL_ImageRate, ATTR_VISIBLE, 0);
 			
			dMSFirst = Timer();
			    
			break;
		}
	return 0;
}

 //*/
int CVICALLBACK setImageFrameRate (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
	
			GetCtrlVal (panelCollect,PANEL_COLL_ImageRate, &gImageRate);
			SetCtrlAttribute (panelCollect, PANEL_COLL_trackerTimer,ATTR_INTERVAL, 1/gImageRate);
			break;
		}
	return 0;
}

int CVICALLBACK iniCam(int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
	//AVI
	imaqSetupGrab (sid, MakeRect (0, 0, 480, 640));
	
	// Create an image in which to store the acquired image /
	// if camera is 16 bit, use 16bit source, and lower bit depth processing images 8 or 2
	SourceImage = imaqCreateImage (IMAQ_IMAGE_I16, 2);
	BinImage = imaqCreateImage (IMAQ_IMAGE_U8, 4);		

			break;
		}
	return 0;
}
