/*******Project Infromation*******************************************************************/
/*																							 */
/*		Worm Project:  Data miner															 */
/*		This is one of the four parts of quantitative behavrior project (4/4)   			 */
/*																							 */
/*																							 */
/*		Zhaoyang Feng   																	 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*																							 */
/*********************************************************************************************/

//********************************************************************************************/
//**																						 */
//**  File name: 				miner.h             										 */
//**  File function:			delaration of all data and the plots handlers    			 */
//**																						 */
//**																						 */
//**																						 */
//**  Author:					Zhaoyang (John) Feng										 */
//**  Last time modification:   March. 25, 2001.											 */
//**																						 */
//**																						 */
//********************************************************************************************/
#include <backboneDataStruct.h>
 
//
//**************************************
//**************************************JF define global variables: considering change them into a data structure
//int excelLaunched;

//those plot handlers
int iPlotCenTrack;
int iPlotGlb;
int iPlotGrey;
int iPlotMorph;
int iPlotIMAQ;
int iPlotLcl;
int iPlotVct;

int iPlotTwoImage1, iPlotTwoImage2;
int iPlotTwoImageFitting1, iPlotTwoImageFitting2;

int iPlotBkbRotated; 
int iPlotBkbRotatedFitting;  
int iPlotBkbRotated2; 
int iPlotBkbRotatedFitting2;

int iPlotBkbvv; 
int iPlotWave;

int iPlotIMAQBkb;
int iPlotMvPtn;

int iPlotAngle;
//below

//**************************************

//the X and Y coordinates
double ** dX, ** dY;					//hold all the cordinates (node #: total of gTotalValidNodes)(backbone points #)
double **dXRotated, **dYRotated;

double *dTime;							//hold the node index of valid nodes in the array 
double *dCenX, *dCenY;					//hold the centroid cordinate [node #)

//loop type
int *iIsBkbp;

//worm shape analysis based on binary and backbone image
double *dArea;
double *dWormLength;
double *dTransparency;
double *dThickness;
double *dFatness;

//worm shape analysis based on binary and backbone image			
double *dLengthToPixelNumber;

//worm shape analysis based on grey image
//Details see the quantitative analysis of iMAQ
double *dMaxIntercept;
double *dMeanInterceptPerpendicular;
double *dEquivalenceEllipsRatio;
double *dEllipsMajorAxis;
double *dEllipsRatio;
double *dRectBigSide;
double *dRectRatio;
			
double *dElongationFactor;
double *dCompactnessFactor;
double *dHeywoodCicularityFactor;
double *dTypeFactor;
double *dHydraulicRadius;
double *dWaddelDiskDiameter;
double *dIXX;
double *dIYY;
double *dIXY;

//global movement analysis
double * gMovingDistances;						//hold the centroid moving distances [nodes] 
double * gMovingAngles;							//hold the centroid angles [nodes]
double * gSpeed;	   							//hold the centroid speed [nodes]
double * gAngleToFirstPoint;					//hold the centroid angles to first point
double * gDistanceToFirstPoint;					//hold the centroid distances to first point
double * gAngleWholeBody;						//hold the line between two frames if there is any

double gScope;
double gTotalDistance;

//Local movement analysis
double **lclSpeed;								//hold the speed of bkppoint (iNumXY)
double *lclSpeedAverage;						//hold the average of all bkbp
double *lclHeadToTailRatio;						//hold the ratio of head to tail
double *dPushing;								//hold the pushing ratio of global to local

//How do worms post their bodies 
//Backbone Posture
//angle between vectors 
double **dBkbvvAngle;							//hold the angles between two backbone vector
double *dBkbvvAngleAverage;						//hold the angle vareage
double *dBkbvvAngleMaxium;						//hold the angele maximum

//******************How this worm wiggle it body
//backbone vector analysis
//BackboneVector angle during moving analysis
double *dBkbvAngleAverage;				//hold all the average of backbone vector
double ** dBkbvAngles;		 			//hold all the angles of backbone vector
double ** dBkbvDistance;				//hold the distance of backbone vectors
double * dBkbvDistMinToBackboneLength;  //hold the minimum of bkbv distance to length
double * dBkbvDistMaxToBackboneLength;  //hold the maximum of bkbv distance to length
double * dBkbvDistAveToBackboneLength;  //hold the Average of bkbv distance to length

double *dDistanceHeadTail;

//backbone point analysis
//bkp local movement analysis
double **dAngleToCentroid;						//hold all the angles to centroid after rotated  							(node #)(backbone point #)
double **dBkbpSpeed;							//hold all the moving speed 
double *dBkbpSpeedAverage;					//hold the bkbp speed average
double *dBkbpHeadToTail;

//intert (quantitative image analysis)
double *dBkpDXX, *dBkpDYY, *dBkpDXY;				//inert analysis based on bkbp
double *dBkpElgFactor, *dCmpctFactor;
double *dBkpHight;
double *dXSym, *dYSym, *dXYSym;

//Behaviror pattern
int *iRevese;									//reverse pattern
int *iForging;									//forging pattern
int *iLoop;										//loop pattern
int *iTurn;										//turn pattern


//
int *iOmega;
//
double *dForagingAlg, *dForagingDis;

//CalTech Data
double *dWavlength, *dAmpt;
double **dFRE;
double **dFlex;

double *dBkpWidth;

//CalTech Flag
//int iCalTech = 0;

//
int iOmegaCount; 
