
//*******Project Infromation******************************************************************/
//**																						 */
//**		Worm Project:  Tracker system 													 */
//**		This is one of the four parts of quantitative behavrior project (4/4)   		 */
//**																						 */
//**																						 */
//**		Zhaoyang (John) Feng   															 */
//**																						 */
//**		UCSD Biology, Schafer Lab														 */
//**																						 */
//**		Tracker group  (Zhaoyang Feng, Christopher Cronin, Paul Sternberg, William Schafer)*/
//**																						 */
//********************************************************************************************/
//********************************************************************************************/
//**																						 */
//**  File name: 				miner.c             										 */
//**  File function:			all the functions related to get the data and UIR			 */
//**																						 */
//**  Author:					Zhaoyang (John) Feng										 */
//**  2nd Last modification:    Augest 19, 2003.											 */
//**  Last modification:		April 12, 2004  											 */
//**																						 */
//********************************************************************************************/

//library headers
#include "cvi_db.h"
#include "excel2000.h" 
#include <userint.h>
#include <analysis.h>
#include <utility.h>
#include <ansi_c.h>

//Self-defined headers
#include <wormMiner.h>
#include <miner.h>
#include <WormDataManipulation.h>
#include <talkWithDatabase.h>


//********************************************************************//
//*  Global variables
//*  The variables here are either used for programming control or 
//*      for data that can be seen by all functions here
//********************************************************************//

//variable declare 
BackboneSet ** gBksForAnalysis = null ; 

//int gTotalValidNodes;
//move to hfile and make other files see this variable
int gAnalBkbFileLoaded = 0;	   //Flaging whether there is any file loaded
int gFileNumber = 0;		   //Indicating how many files currently loaded
int gCurrentNodeNumber = 0;	   //For current work BackboneSet, the total node number 

int gValidNode = 0;			   //For current work BackboneSet, the number of valid nodes (no missing image).
int gIsBkpCount = 0;		   //For current work BackboneSet, the number of nodes that has skeleton points
int gIStartingNode;			   //For current work BackboneSet, the node index that currently working on either for display or calculation purposes.


//Local program control to hold the index of imageNode that displayed in the graph controls (crosshair)
//It is work like that, say a graph displayng data produced from node i to j
// the iCentIndex[0] = i, iCentIndex[1] = i + 1
int *iCentIndex, *iPtnIndex;
int *iGlbIndex, *iLclIndex;
int *iGrey, *iMorph;
int *iIMAQ, *iVct;
int *iBkbvv, *iWave;
int *iIMAQBkb;

//Local Function

//Memeory
//******************************************************************************************//
//  unloadAll
//  Pass the node number of the current working backboneSet.  This function will clear all
//    the memory for displaying, and calculation of behavioral data.
//******************************************************************************************//
int unloadAll(int Number);

//******************************************************************************************//
//  initiate
//  Pass the number points in a skeleton point sets, and the node number of the current working 
//    backboneSet.  This function will claim the memory for displaying, and caculation of behavioral data.
//******************************************************************************************//
int initiate (int iNumXY, int iNumImage);  

//******************************************************************************************//
//  splitBackbone
//  Pass the name of a lined backboneSet, this function
//
//      1. Get data do not need to be further calculate (dX, dY, the x-y coordinate data).  
//      
//      It also do following things:
//		2. For current backboneSet, store the number of valid nodes in iValidNode;
//      3. For current backboneSet, store the number of nodes that have a valid skeleton point set in iIsBkpCount
//				The difference between these two number is, iValidNode is count when a image is missing
//						while iIsBkpCount is only count when a reliable skeleton point set can be produced from the image;
//      4. For current working backboneSet, a flag for each nodes wheth has skeleton point is set and store in 
//           iIsBkp array for display and calculation purpose
//      5. For each current working backboneSet, the iLoopType[] value is set to -10 if an image is gone, indicating there is no information of loop type
//
//      
//******************************************************************************************//
int splitBackbone (BackboneSet * bbs, int *iValidNode, int *iIsBkpCount); 

//******************************************************************************************//
//  RotateBackbone
//  Pass the name of a lined backboneSet, this function will and rotated backbone according to skewer fitting
//    following data will be modified
//		1. dXRotated, dYRotated (the rotated x-y coordinates used to produce behavioral data based on rotated skeleton analysis;
//           detailed list of the data should be listed when this one becomes final
//      2. Behavioral data based on rotated skeleton behavioral analysis
//
//      
//******************************************************************************************//
int RotateBackbone (BackboneSet * bbs);

//******************************************************************************************//
//  GetGlbMvData
//  Pass the backbone set (by pointer), this function calculate the catalogued behavioral
//  Detail will be listed later.
//
//      
//******************************************************************************************//
int GetGlbMvData (BackboneSet *bbs);

//******************************************************************************************//
//  GetLclMvData
//  Pass the backbone set (by pointer), this function calculate the cataloged behavioral
//  Detail will be listed later.
//
//      
//******************************************************************************************//
int GetLclMvData (BackboneSet *bbs); 

//******************************************************************************************//
//  GetBkbvvData
//  Pass the backbone set (by pointer), this function calculate the cataloged behavioral
//  Detail will be listed later.
//
//      
//******************************************************************************************//
int GetBkbvvData (BackboneSet *bbs);

//******************************************************************************************//
//  GetBkbAnalysisData
//  Pass the backbone set (by pointer), this function calculate the cataloged behavioral
//  Detail will be listed later.
//
//      
//******************************************************************************************//
int GetBkbAnalysisData (BackboneSet *bbs); 

//******************************************************************************************//
//  GetStatistic
//	  data passed: 
//			1. dArray: data array;  2. iTotal: total number in the array; 
//			3. checkBkp: value = 1 need to check iIsBkp[index] == 1 indicating a valid skeleton set
//							   = 0 no check needed	   (error control)
//			4. checkNull: value = 1 need to check currentNode has valid image;   (error control)
//			5. isLowLimit: whether it should has an low error control value, any value small than this should not be counted;
//          6. isHighLimit: whether it should has an up error control value, any value larger than this should not be counted. 
//			7. dLowLimit: the value of low limit
//          8. dHighLimit: the value of high limit
//    data modified (by reference):
//			1. dAve: the mean
//			2. Max:  up 5% 
//			3. Min: lower 5%
//******************************************************************************************//
int getStatistic (double * dArray, int iTotal, double *Ave, double *Max, double *Min, int checkBkp, int checkNull, int isLowLimit, double dLowLimit, int isHighLimit, double dHighLimit) ;


//******************************************************************************************//
//  getMvPtnStatistic
//	  data passed: 
//          1. iTotal: total number in the backboneSet; 
//    data modified (by reference) or returned:
//			1. All other data (by reference) is the count of data validations, for example doing reversal or loop1
//
//******************************************************************************************//
int getMvPtnStatistic (int iTotal, int *loop1f, int *loop2f, int *loop3f, int *reversalf, int *forgingf, int *turnf);



int GetCalTechData (BackboneSet *bbs);      

int GetAdditionalData1 (BackboneSet *bbs);      



//******************************************************************************************//
//  Display the data in the respective graphic control in function panel
//  Data needed to be passed here, 	iStartingNode: the first node index will be displayed
//								   	iEndnode, the last node index will be displayed
//									the bacboneSet to be displayed (passed by pointer)
//  All functions are similar, can be combined together, but at this time do not because there
//    is different error and program control.
//******************************************************************************************//

int disPlayTrack (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disGlb (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disGrey (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disMorph (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs); 
int disIMAQ (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disLcl (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disVct (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disBkbvv (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disWave (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disIMAQBkb (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disMvPtn (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs);
int disAngle (int panel, int whichNode, BackboneSet *bbs);

int disPlayTwoImages (int panel, int whichNode, BackboneSet *bbs);
int disRotatedBkb (int panel, int whichNode, BackboneSet *bbs);


//******************************************************************************************//
//  writeToAcces, prepare/ write data to acess.
//		will call writeAccessData to write 3 specific feature/attribute in Access
//
//	  data passed: 
//          1. panel: panel handler, used to write the imformation to user interface
//    		2. bbs:  backboneSet whose data currently been written to acess, used to get the expID
//			3. int hdbc: database connection handler
//	  data modified
//			4. resCode (by reference): recordSet handler, programming control
//
//******************************************************************************************//
int writeToAccess (int panel, BackboneSet * bbs, int hdbc, int *resCode)  ;
//********************************************


//******************************************************************************************//
//  writeToAccesData, write three data to access, will be called by writeToAcess 
//	  data passed: 
//          1. Ave, Max, Min: three string holds the name in the database that need to be written.  
//				not neccessary to be exactly ave, max, min
//    		2. val1:  the data written to ave
//			3. val2:  the data written to max
//			4. val3   the data written to min
//			5. hdbc:  database connection handler
//	  data modified
//			4. resCode (by reference): recordSet handler, programming control
//
//******************************************************************************************//
int writeAccessData (char *Ave, char *Max, char *Min, double val1, double val2, double val3, int hdbc, int *resCode, char *ExpID);  

//******************************************************************************************//
//  writeExcelData, write data to excell
//	  data passed: 
//          1. panel: penal handler to write informtion to user interface
//    		2. bbs:  the name of the excel file will get from here.
//
//******************************************************************************************//
int writeExcelData (int panel, BackboneSet * bbs);



//Functions

//******************************************************************************************//
//  DoSelectFileAnal
//			Partialy written by compiler
//     When the button is clicked.  This function will be called.
//
//******************************************************************************************//
int CVICALLBACK DoSelectFilesAnal (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int iFileLoaded;
int iFileReadingError;
char fileName[MAX_FILENAME_LEN] ;
char cFileName[MAX_PATHNAME_LEN];
char sMessage[MAX_FILENAME_LEN + 200];
int iNumXY;
int iNumImage;
int iMemorySuccess;
char **fileList = null;
int index;


	switch (event)
		{
		case EVENT_COMMIT:

//******************************** dealing with uir

//***********get what user wants
			GetCtrlVal(panel, PANEL_ANAL_SELECT_FILES, &iFileLoaded) ;

//***********If user wants is unloading
			if (iFileLoaded == 0)
			{

//******************uir			
				ResetTextBox (panel, PANEL_ANAL_STATUS, "Ready to load backbone image sets");  
				SetCtrlVal (panel, PANEL_ANAL_STATUS, ""); 

				ResetTextBox (panel, PANEL_ANAL_SET_NAMES, "Analysis list is empty");
				
				if (gAnalBkbFileLoaded == 1) 
				{
					//unloadAll(gBksForAnalysis->NumXYpairs, gBksForAnalysis->NodeCount);
					unloadAll(gCurrentNodeNumber);

					//******************************free the memory

    				for (index = 0; index < gFileNumber; index++)
    				{
						destroyBackboneSet(&gBksForAnalysis[index]);
						free(gBksForAnalysis[index]);
					}
	
					free (gBksForAnalysis);					
				}
				 
				gAnalBkbFileLoaded = 0;
				
				SetCtrlAttribute (panel, PANEL_ANAL_StartingNode, ATTR_DIMMED, 1);
				SetCtrlAttribute (panel, PANEL_ANAL_nEndNode, ATTR_DIMMED, 1);
				SetCtrlAttribute (panel, PANEL_ANAL_numCursorIndex, ATTR_DIMMED, 1);
				SetCtrlAttribute (panel, PANEL_ANAL_WhichBackbonePoint, ATTR_DIMMED, 1);

				return 0 ;
			}

//************loading the analysis set

//*************************************Read the file
//			iFileReadingError = FileSelectPopup ("c:\\ImageData", "*.bbs", ".bbs", "Select backbone set for analysis.", VAL_SELECT_BUTTON, 0, 1, 1, 0, cFileName);
			iFileReadingError = MultiFileSelectPopup ("c:\\BackboneSet", "*.bbs",
													  ".bbs",
													  "Select backbone set for analysis.",
													  0, 1, 1, &gFileNumber,
													  &fileList);
			
			if (iFileReadingError < 1)
			{
			 	SetCtrlVal(panel, PANEL_ANAL_SELECT_FILES, 0) ;
			 	gFileNumber = 0;
				return (0) ;
			}
//allocate memory
			gBksForAnalysis = (BackboneSet**) malloc(gFileNumber * sizeof(BackboneSet*) );


//********************** read the current file containing backbone sets.  for the firt one, just read it, for all other's to see, if*********
//********************** it has the same number of backbone points as the first one.  Dump it if not, otherwise save it**********************
			for (index = 0; index < gFileNumber; index++)
			{
				ResetTextBox (panel, PANEL_ANAL_STATUS, "") ;
				SplitPath (fileList[index], NULL, NULL, fileName) ;    

//*********load the backbone set
				gBksForAnalysis[index] = readBackboneSet(fileList[index]) ; 
			
				if (gBksForAnalysis[index] == null)
				{
					sprintf( sMessage, "\nLoading failed: %s", fileName ) ;
					MessagePopup ("Error", sMessage);
					//gBksForAnalysis[index] = null;
					
				}  else 
				{
					sprintf(sMessage, "\nBackbone set %s: loaded", fileName) ;
				}
				
				InsertTextBoxLine (panel, PANEL_ANAL_STATUS, -1, sMessage); 
			}

//**********************************get some paramenter
			iNumXY =  gBksForAnalysis[0]->NumXYpairs ; 
			iNumImage = gBksForAnalysis[0]-> NodeCount;
//Debug
			//gTotalValidNodes = iNumImage;
			iMemorySuccess = initiate (iNumXY, iNumImage) ;
			gCurrentNodeNumber = iNumImage;
			
			if (iMemorySuccess == 1)
			{
				MessagePopup ("Error!", "Memory Error! Program will quit." );
				QuitUserInterface (0);       
			
			}

//********
//**************************get xy coordinate
			splitBackbone (gBksForAnalysis[0], &gValidNode, &gIsBkpCount); 
			//get rotated backbone coordinates and some data are suitable to be processed here.
			RotateBackbone (gBksForAnalysis[0]);
			
//***********
//**********GetData
			GetGlbMvData (gBksForAnalysis[0]);
			GetLclMvData (gBksForAnalysis[0]); 
			GetBkbvvData (gBksForAnalysis[0]);
			GetBkbAnalysisData (gBksForAnalysis[0]); 
			
//should remove
			//if (iNumXY == 25) 
			GetCalTechData (gBksForAnalysis[0]); 
			GetAdditionalData1 (gBksForAnalysis[0]);
//SetFlag
			gAnalBkbFileLoaded = 1;
//Display Track
			disPlayTrack (panel, 0, iNumImage - 1, gBksForAnalysis[0]);   
			disPlayTwoImages (panel, 0, gBksForAnalysis[0]); 			
			disAngle (panel, 0, gBksForAnalysis[0]);
			disRotatedBkb (panel, 0,  gBksForAnalysis[0]); 
			
			disGlb (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disGrey (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disMorph (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disIMAQ (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disLcl (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disVct (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disBkbvv (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disWave (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disIMAQBkb (panel, 0, iNumImage - 1, gBksForAnalysis[0]);
			disMvPtn (panel, 0, iNumImage - 1, gBksForAnalysis[0]);

//***************************tell the user
			//sprintf(sMessage, "Backbone set is loaded: %s \n  with %d points per backbone \n  and totoal %d image nodes \n\n", fileName, iNumXY, iNumImage) ;
			ResetTextBox (panel, PANEL_ANAL_SET_NAMES, "Data Ready");  

			SetCtrlAttribute (panel, PANEL_ANAL_StartingNode, ATTR_DIMMED, 0);
			SetCtrlAttribute (panel, PANEL_ANAL_nEndNode, ATTR_DIMMED, 0);
			SetCtrlAttribute (panel, PANEL_ANAL_numCursorIndex, ATTR_DIMMED, 0);
			SetCtrlAttribute (panel, PANEL_ANAL_WhichBackbonePoint, ATTR_DIMMED, 0);

			//The default number/index of images for analysis is set
			SetCtrlVal (panel, PANEL_ANAL_nEndNode, iNumImage - 1);
			SetCtrlVal (panel, PANEL_ANAL_StartingNode, 0);

			SetCtrlVal (panel, PANEL_ANAL_numCursorIndex, 0);
			SetCtrlAttribute (panel, PANEL_ANAL_StartingNode, ATTR_MAX_VALUE, iNumImage - 2);
			SetCtrlAttribute (panel, PANEL_ANAL_nEndNode, ATTR_MAX_VALUE, iNumImage - 1);
			SetCtrlAttribute (panel, PANEL_ANAL_numCursorIndex, ATTR_MAX_VALUE, iNumImage - 1);
			SetCtrlAttribute (panel, PANEL_ANAL_WhichBackbonePoint, ATTR_MAX_VALUE, iNumXY - 1);
			SetCtrlAttribute (panel, PANEL_ANAL_nSet, ATTR_MAX_VALUE, gFileNumber - 1);
			

			sprintf(sMessage, "\n Total of %d Backbone sets loaded", gFileNumber) ;
			InsertTextBoxLine (panel,  PANEL_ANAL_STATUS, - 1, sMessage);  
			
			break;
		}
	return 0;
}

//******************************************************************************************//
//  unloadAll
//    when user unload data or quit the program,unload will clean up the user interface and clear memeory
//
//******************************************************************************************//

int unloadAll(int Number)
{

int index;

//*******************************delete the plots
	if (iPlotCenTrack > 0) iPlotCenTrack = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphCenTrack, iPlotCenTrack, VAL_IMMEDIATE_DRAW);
	if (iPlotGlb > 0) iPlotGlb = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphGlb, iPlotGlb, VAL_IMMEDIATE_DRAW);

	if (iPlotGrey > 0) iPlotGrey = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphGrey, iPlotGrey, VAL_IMMEDIATE_DRAW);
	if (iPlotMorph > 0) iPlotMorph = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphMorph, iPlotMorph, VAL_IMMEDIATE_DRAW);
	if (iPlotIMAQ > 0) iPlotIMAQ = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphIMAQ, iPlotIMAQ, VAL_IMMEDIATE_DRAW);

	if (iPlotLcl > 0) iPlotLcl = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphLcl, iPlotLcl, VAL_IMMEDIATE_DRAW);

	if (iPlotVct > 0) iPlotVct = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphVct, iPlotVct, VAL_IMMEDIATE_DRAW);

	if (iPlotBkbRotated > 0) iPlotBkbRotated = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphBkbRotated, iPlotBkbRotated, VAL_IMMEDIATE_DRAW);
	if (iPlotBkbRotatedFitting > 0) iPlotBkbRotatedFitting = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphBkbRotated, iPlotBkbRotatedFitting, VAL_IMMEDIATE_DRAW);
	if (iPlotBkbRotated2 > 0) iPlotBkbRotated2 = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphBkbRotated, iPlotBkbRotated2, VAL_IMMEDIATE_DRAW);
	if (iPlotBkbRotatedFitting2 > 0) iPlotBkbRotatedFitting2 = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphBkbRotated, iPlotBkbRotatedFitting2, VAL_IMMEDIATE_DRAW);


	if (iPlotAngle> 0) iPlotAngle = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphAngle, iPlotAngle, VAL_IMMEDIATE_DRAW);

	if (iPlotBkbvv > 0) iPlotBkbvv = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphBkbvv, iPlotBkbvv, VAL_IMMEDIATE_DRAW);

	if (iPlotWave > 0) iPlotWave= DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphWave, iPlotWave, VAL_IMMEDIATE_DRAW);

	if (iPlotIMAQBkb > 0) iPlotIMAQBkb = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphIMAQBkb, iPlotIMAQBkb, VAL_IMMEDIATE_DRAW);
	if (iPlotMvPtn > 0) iPlotMvPtn = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphMvPtn, iPlotMvPtn, VAL_IMMEDIATE_DRAW);
	if (iPlotAngle > 0) iPlotAngle = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphAngle, iPlotAngle, VAL_IMMEDIATE_DRAW);

	if (iPlotTwoImageFitting1 > 0) iPlotTwoImageFitting1 = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphTwoImage, iPlotTwoImageFitting1, VAL_IMMEDIATE_DRAW);
	if (iPlotTwoImageFitting2 > 0) iPlotTwoImageFitting2 = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphTwoImage, iPlotTwoImageFitting2, VAL_IMMEDIATE_DRAW);

	if (iPlotTwoImage1 > 0) iPlotTwoImage1 = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphTwoImage, iPlotTwoImage1, VAL_IMMEDIATE_DRAW);
	if (iPlotTwoImage2 > 0) iPlotTwoImage2 = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphTwoImage, iPlotTwoImage2, VAL_IMMEDIATE_DRAW);

//below
//int *iCentIndex, *iPtnIndex;
//Locl Index Control
//int *iGlbIndex, *iLclIndex;
//int *iGrey, *iMorph;
//int *iIMAQ, *iVct;
//int *iBkbvv, *iWave;
//int *iIMAQBkb;

//locl program control
	free (iCentIndex);
	free (iPtnIndex);
    free (iGlbIndex);
    free (iLclIndex);
 	free (iGrey);
 	free (iMorph);
	free (iIMAQ);
	free (iVct);
	free (iBkbvv);
	free (iWave);
	free (iIMAQBkb);

//	iCalTech = 0;
//***********************Free the memory 

	for (index = 0; index < Number; index ++)
	{
		free (dX[index]) ;
		free (dY[index]) ;

		free (dXRotated[index]) ;
		free (dYRotated[index]) ;

		free (lclSpeed[index]) ;
		free (dBkbvvAngle[index]) ;

		free (dBkbvAngles[index]) ;
		free (dBkbvDistance[index]) ;
//		free (dBkbvDistMinToBackboneLength[index]);

		free (dAngleToCentroid[index]);
		free (dBkbpSpeed[index]);
//		free (dBkbpSpeedNormalized[index]);

//CalTech
		free (dFRE[index]);
		free (dFlex[index]);
	}
			
//Bkb coordinates
	free (dX);
	free (dY);
	free (dXRotated);
	free (dYRotated);

//other matrix
	free (lclSpeed);
	free (dBkbvvAngle);

	free (dBkbvAngles);
	free (dBkbvDistance);

	free (dBkbvDistMinToBackboneLength);
	free (dDistanceHeadTail);
	free (dBkbvDistMaxToBackboneLength);
	free (dBkbvDistAveToBackboneLength);
	

	free (dAngleToCentroid);
	free (dBkbpSpeed);
	free (dBkbpSpeedAverage);
	free (dBkbpHeadToTail);

//Biggest time array
	free (dTime);

//Centroid coordinates
	free (dCenX);
	free (dCenY);

//Biggest control
	free (iIsBkbp);

//loop type
//see blow			

//worm shape analysis based on binary and backbone image
	free (dArea);
	free (dWormLength);
	free (dTransparency);
	free (dThickness);
	free (dFatness);

//worm shape analysis based on binary and backbone image			
	free (dLengthToPixelNumber);

//worm shape analysis based on grey image
//Details see the quantitative analysis of iMAQ
	free (dMaxIntercept);
	free (dMeanInterceptPerpendicular);
	free (dEquivalenceEllipsRatio);
	free (dEllipsMajorAxis);
	free (dEllipsRatio);
	free (dRectBigSide);
	free (dRectRatio);

	free (dElongationFactor);
	free (dCompactnessFactor);
	free (dHeywoodCicularityFactor);
	free (dTypeFactor);
	free (dHydraulicRadius);
	free (dWaddelDiskDiameter);
	free (dIXX);
	free (dIYY);
	free (dIXY);

//global movement analysis
	free (gMovingDistances);
	free (gMovingAngles);
	free (gSpeed);
	free (gAngleToFirstPoint);
	free (gDistanceToFirstPoint);
	free (gAngleWholeBody);

//Local movement analysis
//double **lclSpeed;								//hold the speed of bkppoint (iNumXY)
//see above			
	free (lclSpeedAverage);
	free (lclHeadToTailRatio);
	free (dPushing);

//How do worms post their bodies 
//Backbone Posture
//angle between vectors 
//double **dBkbvvAngle;							//hold the angles between two backbone vector
//see above
	free (dBkbvvAngleAverage);
	free (dBkbvvAngleMaxium);

//******************How this worm wiggle it body
//backbone vector analysis
//BackboneVector angle during moving analysis
	free (dBkbvAngleAverage);
	
	free (dBkpDXX);
	free (dBkpDYY);
	free (dBkpDXY);

	free (dBkpElgFactor);
	free (dCmpctFactor);
	free (dBkpHight);
	free (dXSym);
	free (dYSym);
	free (dXYSym);

//Behaviror pattern
	free (iRevese);
	free (iForging);
	free (iLoop);
	free (iTurn);

//CalTech
	free (dAmpt);
	free (dWavlength);
	free (dFRE);
	free (dFlex);

//new features
	free (iOmega);
	free (dForagingAlg);
	free (dForagingDis);

//new feature
	free (dBkpWidth);

	if (iTurn != null) return 0;
	else return 1;
	
}


//******************************************************************************************//
//  initiate
//		prepare user interface and claim memory
//	  data passed: 
//          1. iNumXY:  the number of skeleton points in a skeleton set
//    		2. iNumImage: the number of total image frame
//				 These data is saved in skeleton data structure
//******************************************************************************************//
int initiate (int iNumXY, int iNumImage)
{
int index;

//***********************Assign the memory 
//int *iCentIndex, *iPtnIndex;
//Locl Index Control
//int *iGlbIndex, *iLclIndex;
//int *iGrey, *iMorph;
//int *iIMAQ, *iVct;
//int *iBkbvv, *iWave;
//int *iIMAQBkb;

		iCentIndex = (int *)malloc (iNumImage * sizeof(int) );
		iPtnIndex = (int *)malloc (iNumImage * sizeof(int) );
		iGlbIndex = (int *)malloc (iNumImage * sizeof(int) );
		iLclIndex = (int *)malloc (iNumImage * sizeof(int) );
		iGrey = (int *)malloc (iNumImage * sizeof(int) );
		iMorph = (int *)malloc (iNumImage * sizeof(int) );
		iIMAQ = (int *)malloc (iNumImage * sizeof(int) );
		iVct = (int *)malloc (iNumImage * sizeof(int) );
		iBkbvv = (int *)malloc (iNumImage * sizeof(int) );
		iWave = (int *)malloc (iNumImage * sizeof(int) );
		iIMAQBkb = (int *)malloc (iNumImage * sizeof(int) );

//Bkb coordinates
		dX = (double **) malloc ( iNumImage * sizeof(double *) );
		dY = (double **) malloc ( iNumImage * sizeof(double *) ) ; 
		dXRotated = (double **)malloc (iNumImage * sizeof(double *) );
		dYRotated = (double **)malloc (iNumImage * sizeof(double *) );
//other matrix
		lclSpeed = (double **) malloc ( iNumImage * sizeof(double *) );
		dBkbvvAngle = (double **) malloc ( iNumImage * sizeof(double *) ) ; 

		dBkbvAngles = (double **)malloc (iNumImage * sizeof(double *) );
		dBkbvDistance = (double **)malloc (iNumImage * sizeof(double *) );

		dAngleToCentroid = (double **)malloc (iNumImage * sizeof(double *) );
		dBkbpSpeed = (double **)malloc (iNumImage * sizeof(double *) );
//		dBkbpSpeedNormalized = (double **)malloc (iNumImage * sizeof(double *) );

		dFRE = (double **)malloc (iNumImage * sizeof(double *) );
		dFlex = (double **)malloc (iNumImage * sizeof(double *) );

		for (index = 0; index < iNumImage; index ++)
		{
			dX[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
			dY[index] = (double *)malloc(iNumXY * sizeof(double)) ; 

			dXRotated[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
			dYRotated[index] = (double *)malloc(iNumXY * sizeof(double)) ; 

			lclSpeed[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
			dBkbvvAngle[index] = (double *)malloc(iNumXY * sizeof(double)) ; 

			dBkbvAngles[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
			dBkbvDistance[index] = (double *)malloc(iNumXY * sizeof(double)) ; 

			dAngleToCentroid[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
			dBkbpSpeed[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
			
			//Caltech
			//
			dFRE[index] =  (double *)malloc(iNumXY * sizeof(double)) ;
			dFlex[index] =  (double *)malloc(iNumXY * sizeof(double)) ;
		}

			
//Biggest time array
		dTime = (double *)malloc (iNumImage * sizeof(double) );

//Centroid coordinates
		dCenX = (double *)malloc (iNumImage * sizeof(double) );
		dCenY = (double *)malloc (iNumImage * sizeof(double) );

//Biggest error control
		iIsBkbp = (int *)malloc (iNumImage * sizeof (int) );

//loop type
//see blow			

//worm shape analysis based on binary and backbone image
		dArea = (double *)malloc (iNumImage * sizeof(double) );
		dWormLength = (double *)malloc (iNumImage * sizeof(double) );
		dTransparency = (double *)malloc (iNumImage * sizeof(double) );
		dThickness = (double *)malloc (iNumImage * sizeof(double) );
		dFatness = (double *)malloc (iNumImage * sizeof(double) );

//worm shape analysis based on binary and backbone image			
		dLengthToPixelNumber = (double *)malloc (iNumImage * sizeof(double) );

//worm shape analysis based on grey image
//Details see the quantitative analysis of iMAQ
		dMaxIntercept = (double *)malloc (iNumImage * sizeof(double) );
		dMeanInterceptPerpendicular = (double *)malloc (iNumImage * sizeof(double) );
		dEquivalenceEllipsRatio = (double *)malloc (iNumImage * sizeof(double) );
		dEllipsMajorAxis = (double *)malloc (iNumImage * sizeof(double) );
		dEllipsRatio = (double *)malloc (iNumImage * sizeof(double) );
		dRectBigSide = (double *)malloc (iNumImage * sizeof(double) );
		dRectRatio = (double *)malloc (iNumImage * sizeof(double) );

		dElongationFactor = (double *)malloc (iNumImage * sizeof(double) );
		dCompactnessFactor = (double *)malloc (iNumImage * sizeof(double) );
		dHeywoodCicularityFactor = (double *)malloc (iNumImage * sizeof(double) );
		dTypeFactor = (double *)malloc (iNumImage * sizeof(double) );
		dHydraulicRadius = (double *)malloc (iNumImage * sizeof(double) );
		dWaddelDiskDiameter = (double *)malloc (iNumImage * sizeof(double) );
		dIXX = (double *)malloc (iNumImage * sizeof(double) );
		dIYY = (double *)malloc (iNumImage * sizeof(double) );
		dIXY = (double *)malloc (iNumImage * sizeof(double) );
			

//global movement analysis
		gMovingDistances = (double *)malloc (iNumImage * sizeof(double) );
		gMovingAngles = (double *)malloc (iNumImage * sizeof(double) );
		gSpeed = (double *)malloc (iNumImage * sizeof(double) );
		gAngleToFirstPoint = (double *)malloc (iNumImage * sizeof(double) );
		gDistanceToFirstPoint = (double *)malloc (iNumImage * sizeof(double) );
		gAngleWholeBody = (double *)malloc (iNumImage * sizeof(double) );

//Local movement analysis
//double **lclSpeed;								//hold the speed of bkppoint (iNumXY)
//see above			
		lclSpeedAverage = (double *)malloc (iNumImage * sizeof(double) );
		lclHeadToTailRatio = (double *)malloc (iNumImage * sizeof(double) );
		dPushing = (double *)malloc (iNumImage * sizeof(double) );

//How do worms post their bodies 
//Backbone Posture
//angle between vectors 
//double **dBkbvvAngle;							//hold the angles between two backbone vector
//see above
		dBkbvvAngleAverage = (double *)malloc (iNumImage * sizeof(double) );
		dBkbvvAngleMaxium = (double *)malloc (iNumImage * sizeof(double) );

//******************How this worm wiggle it body
//backbone vector analysis
//BackboneVector angle during moving analysis
		dBkbvAngleAverage = (double *)malloc (iNumImage * sizeof(double) );
		dBkbvDistMinToBackboneLength = (double *)malloc (iNumImage * sizeof(double) ); 
		dDistanceHeadTail = (double *)malloc (iNumImage * sizeof(double) ); 
//double ** dBkbvAngles;		 			//hold all the angles of backbone vector
//double ** dBkbvDistance;				//hold the distance of backbone vectors
//double ** dBkbvDistMinToBackboneLength  //hold the minimum of bkbv distance to length
//all see above
		dBkbvDistAveToBackboneLength = (double *)malloc (iNumImage * sizeof(double) ); 
		dBkbvDistMaxToBackboneLength = (double *)malloc (iNumImage * sizeof(double) ); 
		

//backbone point analysis
//bkp local movement analysis
//double **dAngleToCentroid;						//hold all the angles to centroid after rotated  							(node #)(backbone point #)
//double **dBkbpSpeed;							//hold all the moving speed 
//double **dBkbpSpeedNormalized;					//hold the bkbp speed with normalized
//all see above
		dBkbpSpeedAverage = (double *)malloc (iNumImage * sizeof(double) );
		dBkbpHeadToTail = (double *)malloc (iNumImage * sizeof(double) );


//bkbintert (quantitative image analysis)
		dBkpDXX = (double *)malloc (iNumImage * sizeof(double) );
		dBkpDYY = (double *)malloc (iNumImage * sizeof(double) );
		dBkpDXY = (double *)malloc (iNumImage * sizeof(double) );

		dBkpElgFactor = (double *)malloc (iNumImage * sizeof(double) );
		dCmpctFactor = (double *)malloc (iNumImage * sizeof(double) );
		dBkpHight = (double *)malloc (iNumImage * sizeof(double) );
		dXSym = (double *)malloc (iNumImage * sizeof(double) );
		dYSym = (double *)malloc (iNumImage * sizeof(double) );
		dXYSym = (double *)malloc (iNumImage * sizeof(double) );

//Behaviror pattern
		iRevese = (int *)malloc (iNumImage * sizeof (int) );
		iForging = (int *)malloc (iNumImage * sizeof (int) );
		iLoop = (int *)malloc (iNumImage * sizeof (int) );
		iTurn = (int *)malloc (iNumImage * sizeof (int) );	  
		
//CalTech
		dAmpt = (double *)malloc (iNumImage * sizeof(double) );
		dWavlength = (double *)malloc (iNumImage * sizeof(double) );

//new features
		iOmega = (int *)malloc (iNumImage * sizeof (int) );   
		dForagingAlg = (double *)malloc (iNumImage * sizeof(double) );    
		dForagingDis = (double *)malloc (iNumImage * sizeof(double) );    	

		dBkpWidth = (double *)malloc (iNumImage * sizeof(double) );

//should be removed
/*
		if (iNumImage == 25)
		{
			iCalTech = 1 ;
		
		} else iCalTech = 0;
//Chris believes that for his features, it is better idea to reprecess the data instead of fix it to 13 points.
//He does not know how many is better either. Therefore, remove this at this time to allow users to test it.
//*/
  
  		iOmegaCount = 0;
  		
		if (iTurn == null) return 1;
		else return 0;
}

//******************************************************************************************//
//  splitBackbone
//  Pass the name of a lined backboneSet, this function
//
//      1. Get data do not need to be further calculate (dX, dY, the x-y coordinate data).  
//      
//      It also do following things:
//		2. For current backboneSet, store the number of valid nodes in iValidNode;
//      3. For current backboneSet, store the number of nodes that have a valid skeleton point set in iIsBkpCount
//				The difference between these two number is, iValidNode is count when a image is missing
//						while iIsBkpCount is only count when a reliable skeleton point set can be produced from the image;
//      4. For current working backboneSet, a flag for each nodes wheth has skeleton point is set and store in 
//           iIsBkp array for display and calculation purpose
//      5. For each current working backboneSet, the iLoopType[] value is set to -10 if an image is gone, indicating there is no information of loop type
//
//      
//******************************************************************************************//
int splitBackbone (BackboneSet * bbs, int *iValidNode, int *iIsBkpCount)
{

int indexNode;
int indexBkp;

int iIsBkp;
int iNumXY, iNodeCount;

double dTempTime;
int iNode, iBkp;
double dDebug;
int iVersion;
	
	iNumXY = bbs->NumXYpairs;
	iNodeCount = bbs->NodeCount;
	
	getBackboneVersion (bbs, &iVersion); 	
	
	iBkp = 0;
	iNode = 0;

//***************************************************
//Read the time data first
//***************************************************
	//For each node
	for (indexNode = 0; indexNode < iNodeCount; indexNode ++)
	{
		if (bbs->backboneNodePtr[indexNode] != null )  //current node is not NULL
		{
			iNode ++;

//***********************
//Tracker which is initially written by John Wittig, is not designed to have time stamp.
//John Feng introdued time stamp here.  Intially, he thought the time intervals are 0.5s constantly, but
//they actually vary largest though the mean is 0.509.
//John then complete change the timer control it record the real time.
//Please keep the codes here though they are marked off.
			/*
			if (bbs->backboneNodePtr[indexNode]->Time > 0)  //get them
			{
					dTempTime = dTempTime + 0.509; 
					dTime[indexNode] = dTempTime ; 
			
			}else 
			{
					bbs-> backboneNodePtr[indexNode]->Time;
			}
			//*/
			if (bbs->backboneNodePtr[indexNode]->Time > 0)  //get them
			{
					dTime[indexNode] = bbs->backboneNodePtr[indexNode]->Time ;
			}
				
		} 
		/*  some fix after 11012002. They are not neccessary now.
		else //if curent image is null just put get the time as 0.5
		{   
			dTempTime = dTempTime + 0.50;
			dTime[indexNode] = dTempTime ; 
			iIsBkbp[indexNode] = 0; 			
		}
		//*/
		//*  some fix after 11012002
		else //if curent image is null just put get the time as 0.5
		{
			//dTempTime = dTempTime + 0.50;
			//dTime[indexNode] = dTempTime ; 
			iIsBkbp[indexNode] = 0; 	//Not necessary but make sure flag is set.		
		}
		//*/
		
		//flag whether there is a backbonepiont
		if (bbs->backboneNodePtr[indexNode] != null)
		{
			iIsBkp = bbs->backboneNodePtr[indexNode]->iIsBkbp;
		}else iIsBkp = 0;
		
		//if there is a bkbpoint
		if (iIsBkp == 1)
		{
			//Set control
			iBkp ++;
			iIsBkbp[indexNode] = 1; //set flat that there is a bkbpoint in a global data
		
			//Get all coordinate value. Grap the data.
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
			{
				dX[indexNode][indexBkp] = bbs->backboneNodePtr[indexNode]->xPoints[indexBkp];
				dY[indexNode][indexBkp] = bbs->backboneNodePtr[indexNode]->yPoints[indexBkp];
			}
		}
		else
		{
			//set flag
			iIsBkbp[indexNode] = 0;
		
			// set the pointer to null.  
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
			{
				dX[indexNode] = null;
				dY[indexNode] = null;
			}
		
		}

//***********************This should be combined with previous if.  I do not know why I did this: stupid. 
		//if current image is valid
		if (bbs->backboneNodePtr[indexNode] != null )  //current node is not NULL
		{
//Centroid coordinate
			dCenX[indexNode] = bbs->backboneNodePtr[indexNode]->absCentX;
			dCenY[indexNode] = bbs->backboneNodePtr[indexNode]->absCentY;
			//dDebug = dCenX[indexNode];

//worm shape analysis based on binary and backbone image
			
			dArea[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dArea;
			//dDebug = dArea[indexNode];
			//if (dDebug > 10000)dArea[indexNode] = -1.0;
			dWormLength[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dWormLength;
			dTransparency[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dTransparency;
			dThickness[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dThickness;
			dFatness[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dFatness;

//worm shape analysis based on binary and backbone image
			dLengthToPixelNumber[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dLengthToPixelNumber;

//worm shape analysis based on grey image
//Details see the quantitative analysis of iMAQ
			dMaxIntercept[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dMaxIntercept;
			dMeanInterceptPerpendicular[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dMeanInterceptPerpendicular;
			dEquivalenceEllipsRatio[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dEquivalenceEllipsRatio;
			dEllipsMajorAxis[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dEllipsMajorAxis;
			dEllipsRatio[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dEllipsRatio;
			dRectBigSide[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dRectBigSide;
			dRectRatio[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dRectRatio;

			dElongationFactor[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dElongationFactor;
			dCompactnessFactor[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dCompactnessFactor;
			dHeywoodCicularityFactor[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dHeywoodCicularityFactor;
			dTypeFactor[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dTypeFactor;
			dHydraulicRadius[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dHydraulicRadius;
			dWaddelDiskDiameter[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dWaddelDiskDiameter;
			dIXX[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dIXX;
			dIYY[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dIYY;
			dIXY[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.dIXY;

			iLoop[indexNode] = bbs->backboneNodePtr[indexNode]->imageInfor.iLoopType;
		}else
		{
			iLoop[indexNode] = -10;   //there fore loop nubmer is 1: type 1, loop 2, type 2, no valid image
			iIsBkbp[indexNode] = 0;    			
		}
	}
	
	*iIsBkpCount = iBkp;  //the number of node that has skeleton point
	*iValidNode = iNode;  // the valid node number
	
	//YGraphPopup ("Debug1", dTime, iNodeCount, VAL_DOUBLE);

	return 1;
}

//******************************************************************************************//
//  RotateBackbone
//  Pass the name of a lined backboneSet, this function will and rotated backbone according to skewer fitting
//    following data will be modified
//		1. dXRotated, dYRotated (the rotated x-y coordinates used to produce behavioral data based on rotated skeleton analysis;
//           detailed list of the data should be listed when this one becomes final
//      2. Behavioral data based on rotated skeleton behavioral analysis
//
//      
//******************************************************************************************//
int RotateBackbone (BackboneSet * bbs)
{

int indexNode, indexBkp;

double dHeadX, dHeadY, dTailX, dTailY;

double *dCurrentX, *dCurrentY;
double dAngleRotated;
//double dDistance;

double dXTemp, dYTemp;
double dXMean, dYMean;

double dXCurrentRotated, dYCurrentRotated;
double dAngleC;

double dTempSin, dTempCos;

int iIsBkp;
int iNumXY, iNodeCount;
double BkbvDistMin;
double dTemp;
int iTemp;
double dAveLength;
double dMin = 1000;
double dMax = -1;
double dAve = 0;

	iNumXY = bbs->NumXYpairs;
	iNodeCount = bbs->NodeCount;

	//hold the backbone points of current nodes
	dCurrentX = (double *) malloc (iNumXY * sizeof(double));
	dCurrentY = (double *) malloc (iNumXY * sizeof(double));

//initial
	//intial all angle to -1000 for error control
	Set1D (gAngleWholeBody, iNodeCount, -1000.0) ;

//for each node
	for (indexNode = 0; indexNode < iNodeCount; indexNode ++)
	{
//Check if current one has coordinates
		iIsBkp = iIsBkbp[indexNode]; //This is the flag to indicate whether this node does have a 
									//valid bkb.  This flag is set in the function splitBkb

		//If there is no backbone, just set some error control
		if (iIsBkp == 0)
		{
			//Set angle to - 1000 and distance = -1 for error control	
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp ++)
			{
				dAngleToCentroid[indexNode][indexBkp] = - 1000;
				dBkbvDistance[indexNode][indexBkp] = -1;
				dBkbvAngles[indexNode][indexBkp] = - 1000;				
			}
			
			dBkbvDistMinToBackboneLength[indexNode]	= - 1;	  
			dBkbvDistMaxToBackboneLength[indexNode]	= - 1;	
			dBkbvDistAveToBackboneLength[indexNode]	= - 1;	
			dBkbvAngleAverage[indexNode] = - 1000; 
			
			exit;
		}
		//if there is a valid skeleton point set
		else
		{
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp ++)
			{
				dCurrentX[indexBkp] = dX[indexNode][indexBkp];
				dCurrentY[indexBkp] = dY[indexNode][indexBkp];
			}
		
			//Get the head
			dHeadX = dCurrentX[0];
			dHeadY = dCurrentY[0];
		
			//Get the tail
			dTailX = dCurrentX[iNumXY - 1];
			dTailY = dCurrentY[iNumXY - 1];

			//Get the Mean cooridinate of all skpt
			Mean (dCurrentX, iNumXY, &dXMean);
			Mean (dCurrentY, iNumXY, &dYMean);

			//Get the angle of the line that links head and tail
			DisAngleBetweenTwoPoints (dTailX, dTailY, dHeadX, dHeadY, &dAngleRotated, &dDistanceHeadTail[indexNode]);

//Output
//gAngleWholeBody
			//put the angle to data
			gAngleWholeBody[indexNode] = dAngleRotated;

//Get the rotated one
			for(indexBkp = 0; indexBkp < iNumXY; indexBkp ++)
			{
				dXTemp = dCurrentX[indexBkp] - dXMean;
				dYTemp = dCurrentY[indexBkp] - dYMean;
		
				dXCurrentRotated = dXTemp * cos (dAngleRotated) + dYTemp * sin (dAngleRotated);
				dYCurrentRotated = - dXTemp * sin (dAngleRotated) + dYTemp * cos (dAngleRotated);
//output parameter
//dAngleWholeBody
				gAngleWholeBody[indexNode] = dAngleRotated;
//angle for centroid and distanceHeadTail
			//DisAngleBetweenTwoPoints (dCenX[indexWhichNode], dCenY[indexWhichNode], dXCurrent, dYCurrent, &dAngleToCentroid[indexWhichNode][index], &dDistanceTemp) ;
				//Get the angle to the first points that worms were transfered to 
				DisAngleBetweenTwoPoints (0, 0, dXCurrentRotated, dYCurrentRotated, &dAngleC, &dTemp) ;
		
				if (dAngleC > PI/2) dAngleC = PI - dAngleC;
				if (dAngleC < - PI/2) dAngleC = - PI - dAngleC;
//output
//rotated porameter
				dXRotated[indexNode][indexBkp] = dXCurrentRotated;
				dYRotated[indexNode][indexBkp] = dYCurrentRotated;
//for later use
				dCurrentX[indexBkp] = dXCurrentRotated;
				dCurrentY[indexBkp] = dYCurrentRotated;
//output			
//angles to centroid
				dAngleToCentroid[indexNode][indexBkp] = dAngleC;
			}

//This is usefull Save it
			//This is the similar apporoach as Chris's section.  The first on is zero
			SplitBackboneToDistanceAndAngles (dCurrentX, dCurrentY, iNumXY, dBkbvDistance[indexNode], dBkbvAngles[indexNode]);
		
			dTempSin = 0;
			dTempCos = 0;
			dAve = 0;
			dMax = -1;
			dMin = 1000;

			//We do not need the first one, so start with 1
			for (indexBkp = 1; indexBkp < iNumXY; indexBkp ++)
			{
				dTempSin = dTempSin + sin(dBkbvAngles[indexNode][indexBkp]);
				dTempCos = dTempCos + cos(dBkbvAngles[indexNode][indexBkp]);
				if (dMin > dBkbvDistance[indexNode][indexBkp]) dMin = dBkbvDistance[indexNode][indexBkp];
				if (dMax < dBkbvDistance[indexNode][indexBkp]) dMax = dBkbvDistance[indexNode][indexBkp];
				dAve = dAve + dBkbvDistance[indexNode][indexBkp];
			}
			
			dAve = dAve / (iNumXY - 1);
			
			dTempSin = dTempSin / (iNumXY - 1);
			dTempCos = dTempCos / (iNumXY - 1);
//output
//dBkbvAngleAverage; 
//This gave me pi or -pi or zero result. try to fix it.
			//Get the every
			dBkbvAngleAverage[indexNode] = atan2(dTempSin, dTempCos);
//by making to in the range of - PI/2 to PI/2, 
/*Keep value between Pi and -Pi
			if (dBkbvAngleAverage[indexNode] > PI/2)
			{
				dBkbvAngleAverage[indexNode] = dBkbvAngleAverage[indexNode] - PI/2;
			}
			if (dBkbvAngleAverage[indexNode] < - PI/2)
			{
				dBkbvAngleAverage[indexNode] = dBkbvAngleAverage[indexNode] + PI/2;
			}
/*/
			dAveLength = ( bbs->backboneNodePtr[indexNode]->imageInfor.dWormLength ) / (iNumXY - 1); 
//output
//dBkbv distance to length min
			dBkbvDistMinToBackboneLength[indexNode] = dMin / dAveLength;
			dBkbvDistMaxToBackboneLength[indexNode]	= dMax / dAveLength;
			dBkbvDistAveToBackboneLength[indexNode]	= dAve / dAveLength;	
			
   		}//else
   		
   	} //for indexNode loop
   
   	free (dCurrentX);
   	free (dCurrentY);
   
   	return 1;
}


//******************************************************************************************//
//  GetGlbMvData
//  Pass the backbone set (by pointer), this function calculate the catalogued behavioral
//  
//   This include global speed and totoalTraveled Distances.
//      
//******************************************************************************************//
int GetGlbMvData (BackboneSet *bbs)
{
int indexNode;
int iNodeCount;

int iCurrentNode;
int iNextNode ;

double dCentX1, dCentX2, dCentY1, dCentY2;
double dCentX0, dCentY0;
double dTime1, dTime2;
double dTemp;
int iTemp;

	iNodeCount = bbs->NodeCount;

	//Get the centroid coordinates of the first frame to calculate gScope
	dCentX0 = dCenX[0];
	dCentY0 = dCenY[0];

//Set error control value
	Set1D (gMovingAngles, iNodeCount, -1000.0) ;
	Set1D (gMovingDistances, iNodeCount, -1.0) ;
	Set1D (gSpeed, iNodeCount, -1.0) ;
	Set1D (gAngleToFirstPoint, iNodeCount, -1000.0) ;
	Set1D (gDistanceToFirstPoint, iNodeCount, -1.0) ;
	gScope = 0;
	gTotalDistance = 0;

	for (indexNode = 0; indexNode < iNodeCount - 1; indexNode ++)
	{
		iCurrentNode = indexNode;
		iNextNode = indexNode + 1;
		
		//if current node has invalid image, quit
		if (iLoop[iCurrentNode] == -10) 		//This flag is different with isBkb[], which indicates a valid skeleton
		//The logic here is simple.  If there is a valid image, the centroid is calculatable no matter whether a good
		//skeleton set can be extrapulated. 
		{
			goto exit; //go to next loop
		}
		else //if current node has valid image
		{
			dTime1 = dTime[iCurrentNode];
			dCentX1 = dCenX[iCurrentNode];
			dCentY1 = dCenY[iCurrentNode];
			
			DisAngleBetweenTwoPoints (dCentX0, dCentY0, dCentX1, dCentY1, &gAngleToFirstPoint[iCurrentNode], &gDistanceToFirstPoint[iCurrentNode]);
			if (gScope < gDistanceToFirstPoint[iCurrentNode]) gScope = gDistanceToFirstPoint[iCurrentNode]; 
		}
loop1:
		//if next node has valid image
		if (iLoop[iNextNode] == - 10)
		{
error1:		iNextNode ++;	 //if this is the end of the image
			if (iNextNode >= iNodeCount)	 //if this is the end of the image
			{
				goto end;	 //it is done here
			}
			
			//gMovingAngles[iNextNode] = - 5;
			//gMovingDistances[iNextNode] = - 1;			
			goto loop1; //repeat until find next node having valid image
		
		}
		
		//if current and next (may not be exactly next frame) have valid nodes
		if ( (iLoop [iCurrentNode] != -10) &&  (iLoop [iNextNode] != -10) ) 
		{
		
			//get the coordinates and time stamp of next frame
			dCentX2 = dCenX[iNextNode];
			dCentY2 = dCenY[iNextNode];
			dTime2 = dTime[iNextNode];
			
			//Comput it
			DisAngleBetweenTwoPoints (dCentX1, dCentY1, dCentX2, dCentY2, &gMovingAngles[iCurrentNode], &gMovingDistances[iCurrentNode]);
			gSpeed[iCurrentNode] = gMovingDistances[iCurrentNode] / fabs(dTime2 - dTime1);
			gTotalDistance = gTotalDistance + gMovingDistances[iCurrentNode];
			
			//if (gSpeed[iCurrentNode]> 200) gSpeed[iCurrentNode] = -1.0;
			//iLoop[iNextNode] = -10;
//add totalDistance here;

		}
		
exit:		
		exit;
		
	}  //for loop

end:
	
	return 1;

}


//******************************************************************************************//
//  GetLclMvData
//  Pass the backbone set (by pointer), this function calculate the catalogued behavioral
//  
//   This includes behaviraol calculated based on sktp 
//      
//******************************************************************************************//
int GetLclMvData (BackboneSet *bbs)
{
int indexNode;
int indexBkp;

int iNumXY;
int iNodeCount;

int iCurrentNode;
int iNextNode ;

//double *dRotatedX1, *dRotatedX2, *dRotatedY1, *dRotatedY2;
double *dX1, *dX2, *dY1, *dY2;

double dCentX1, dCentY1, dCentX2, dCentY2;
double dTime1, dTime2;
double dTemp;

double dLowLimit = 30;
double dAngleDifference;

	iNumXY = bbs->NumXYpairs;
	iNodeCount = bbs->NodeCount;

//initiate all data here as error control
	for (indexNode = 0; indexNode < iNodeCount - 1; indexNode ++)
	{
		Set1D (dBkbpSpeed[indexNode], iNumXY, -1.0) ;
		Set1D (lclSpeed[indexNode], iNumXY, -1.0) ;
		iTurn[indexNode] = - 1;
		iForging[indexNode] = - 1;
		iRevese[indexNode] = - 1;
	}		   

	//set error control
	Set1D (dBkbpHeadToTail, iNodeCount, -1.0) ;
	Set1D (dBkbpSpeedAverage, iNodeCount, -1.0) ;   	
	Set1D (lclSpeedAverage, iNodeCount, -1.0) ;   	
	Set1D (lclHeadToTailRatio, iNodeCount, -1.0) ;   	
	Set1D (dPushing, iNodeCount, -1.0) ;   	

	//The sktp coordinates of current node and next node
	dX1 = (double *) calloc (iNumXY, sizeof(double));
	dY1 = (double *) calloc (iNumXY, sizeof(double));
	dX2 = (double *) calloc (iNumXY, sizeof(double));
	dY2 = (double *) calloc (iNumXY, sizeof(double));
	
	
	for (indexNode = 0; indexNode < iNodeCount - 1; indexNode ++)
	{
		iCurrentNode = indexNode;
		iNextNode = indexNode + 1;
		
		if (iIsBkbp[indexNode] == 0)  //if current node has no invalid skeleton 
		{
			goto exit;	   //go to next frame
		}
		else
		{
			dTime1 = dTime[iCurrentNode];
			
			Copy1D (dX[iCurrentNode], iNumXY, dX1);
			Copy1D (dY[iCurrentNode], iNumXY, dY1);
			
			dCentX1 = dCenX[iCurrentNode];
			dCentY1 = dCenY[iCurrentNode];
			//Mean (dX1, iNumXY, &dCentX1);
			//Mean (dY1, iNumXY, &dCentY1);
			
		}
loop1:
		if (iIsBkbp[iNextNode] == 0)   //if threre is no valid node
		{
			iNextNode ++;
			if (iNextNode >= iNodeCount)	   //if this is the last one
			{
				goto end;
			}
			goto loop1;			//repeat until find a valid one.
		}

		//if current and next (may not be exactly the next frame) nodes having valid skeleton 
		if ( (iIsBkbp [iCurrentNode] == 1) &&  (iIsBkbp [iCurrentNode] == 1) )
		{
			//Get coordinates and time stamp
			dTime2 = dTime[iNextNode];
			Copy1D (dX[iNextNode], iNumXY, dX2);
			Copy1D (dY[iNextNode], iNumXY, dY2);

			dCentX2 = dCenX[iNextNode];
			dCentY2 = dCenY[iNextNode];
			//Mean (dX2, iNumXY, &dCentX1);
			//Mean (dY2, iNumXY, &dCentY2);
			
//out put
//get dBkbpSpeed (without normalized)
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
			{
				DisAngleBetweenTwoPoints (dX1[indexBkp], dY1[indexBkp], dX2[indexBkp], dY2[indexBkp], &dTemp, &dBkbpSpeed[iCurrentNode][indexBkp]);
				dBkbpSpeed[iCurrentNode][indexBkp] = dBkbpSpeed[iCurrentNode][indexBkp] / fabs (dTime2 - dTime1);
			}
			
			//LinEv1D (dBkbpSpeed[iCurrentNode], iNumXY, ( 1 / fabs (dTime2 - dTime1) ), 0.0, dBkbpSpeed[iCurrentNode]);
			
			Mean (dBkbpSpeed[iCurrentNode], iNumXY, &dBkbpSpeedAverage [iCurrentNode]);
			dBkbpHeadToTail[iCurrentNode] = dBkbpSpeed[iCurrentNode][0] / dBkbpSpeed[iCurrentNode][iNumXY -1];

			
//**********Calculate the normalized speed
// first I need to normalized the iNextNode to superImpose the centroid
			LinEv1D (dX2, iNumXY, 1, (dCentX1 - dCentX2), dX2 );
			LinEv1D (dY2, iNumXY, 1, (dCentY1 - dCentY2), dY2 );

//get dBkbpSpeed (without normalized)
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
			{
				DisAngleBetweenTwoPoints (dX1[indexBkp], dY1[indexBkp], dX2[indexBkp], dY2[indexBkp], &dTemp, &lclSpeed[iCurrentNode][indexBkp]);
				lclSpeed[iCurrentNode][indexBkp] = lclSpeed[iCurrentNode][indexBkp] / fabs (dTime2 - dTime1);
			}

			//LinEv1D (lclSpeed[iCurrentNode], iNumXY, ( 1 / fabs (dTime2 - dTime1) ), 0.0, lclSpeed[iCurrentNode]);
			
			Mean (lclSpeed[iCurrentNode], iNumXY, &lclSpeedAverage [iCurrentNode]);
			lclHeadToTailRatio[iCurrentNode] = lclSpeed[iCurrentNode][0] / lclSpeed[iCurrentNode][iNumXY -1];

			dPushing[iCurrentNode] = gSpeed[iCurrentNode] / lclSpeedAverage[iCurrentNode];
			
			if ( (iNextNode - iCurrentNode) == 1 ) 
			{
				//MessagePopup ("Hi", "Available soon.");
//sharp turn	
				dAngleDifference = fabs (gAngleWholeBody[iNextNode] - gAngleWholeBody[iCurrentNode]);
				
				if (dAngleDifference >= (dLowLimit/180 * PI))
				{
					iTurn[iCurrentNode] = 1;
				}else iTurn[iCurrentNode] = 0;
				
//if forging
				iForging[iCurrentNode] = IsForging (dBkbpSpeed, iCurrentNode, iNextNode, iNumXY, gSpeed, dTime, dWormLength);
//if reversal
				//Get the dX2, dY2 because it is modified
				Copy1D (dX[iNextNode], iNumXY, dX2);
				Copy1D (dY[iNextNode], iNumXY, dY2);

				iRevese[iCurrentNode] = IsReversal (dX1, dY1, dX2, dY2, iNumXY);
				
			} 
		}
		
exit:		
		exit;
		
	}  //for loop

end:
	free (dX1);
	free (dX2);
	free (dY1);
	free (dY2);
	
	return 1;

}

//******************************************************************************************//
//  GetBkbvvData
//  Pass the backbone set (by pointer), this function calculate the catalogued behavioral
//  
//   This will calculate a lot of feature based "section" of bkb which the name is defined by 
//			Chris.  Some feature is similar to Chris's. 
//      
//******************************************************************************************//
int GetBkbvvData (BackboneSet *bbs) 
{
int indexNode;
int iNumXY;
int iNodeCount;

double *dRotatedX1, *dRotatedY1;
double dTemp;
int iTemp;
double *dTempAngle;

//need to initial the data
	iNodeCount = bbs->NodeCount;
	iNumXY = bbs->NumXYpairs;
	
	for (indexNode = 0; indexNode < iNodeCount - 1; indexNode ++)
	{
		Set1D (dBkbvvAngle[indexNode], iNumXY, -1000.0) ;
	}		   

	Set1D (dBkbvvAngleMaxium, iNodeCount, -1000.0) ;
	Set1D (dBkbvvAngleAverage, iNodeCount, -1000.0) ;   	

	dRotatedX1 = (double *) calloc (iNumXY, sizeof(double));
	dRotatedY1 = (double *) calloc (iNumXY, sizeof(double));

	dTempAngle = (double *) calloc (iNumXY, sizeof(double));

	for (indexNode = 0; indexNode < iNodeCount; indexNode ++)
	{
	
		if (iIsBkbp[indexNode] == 1)
		{
		
			Copy1D (dXRotated[indexNode], iNumXY, dRotatedX1) ;
			Copy1D (dYRotated[indexNode], iNumXY, dRotatedY1) ;
			
			AngleBtwBkbv (dRotatedX1, dRotatedY1, dBkbvvAngle[indexNode], iNumXY) ; 
//average
//first get the abs value
			Abs1D (dBkbvvAngle[indexNode], iNumXY - 2, dTempAngle);
			Mean (dTempAngle, iNumXY - 2, &dBkbvvAngleAverage[indexNode]); 
			//angleAverage (dBkbvvAngle[indexNode], iNumXY - 2, &dBkbvvAngleAverage[indexNode]); 

			MaxMin1D (dTempAngle, iNumXY - 2, &dBkbvvAngleMaxium[indexNode], &iTemp, &dTemp, &iTemp);
		}
		
	}
	
	free (dRotatedX1);
	free (dRotatedY1);
	free (dTempAngle);
	
	return 1;
}

//******************************************************************************************//
//  GetBkbAnalysisData
//  Pass the backbone set (by pointer), this function calculate the catalogued behavioral
//  
//   This will calculate a lot of feature based bkb or skeleton of a worm.
//      
//******************************************************************************************//
int GetBkbAnalysisData (BackboneSet *bbs)
{
int indexNode;
int iNumXY;
int iNodeCount;
int indexBkp;

double *dRotatedX1, *dRotatedY1;
double *dTempArray;

double dTemp;
int iTemp;
double dMax, dMin;
double dLong, dWidth;

//project1
double dXMax, dXMin, dYHead, dYTail;


	iNodeCount = bbs->NodeCount;
	iNumXY = bbs->NumXYpairs;

	dRotatedX1 = (double *) calloc (iNumXY, sizeof(double));
	dRotatedY1 = (double *) calloc (iNumXY, sizeof(double));
	dTempArray = (double *) calloc (iNumXY, sizeof(double));
	
	for (indexNode = 0; indexNode < iNodeCount; indexNode ++)
	{
	
		if (iIsBkbp[indexNode] == 1)
		{
			Copy1D (dXRotated[indexNode], iNumXY, dRotatedX1) ;
			Copy1D (dYRotated[indexNode], iNumXY, dRotatedY1) ;

			MaxMin1D (dRotatedX1, iNumXY, &dXMax, &iTemp, &dXMin, &iTemp);
			dXMax = (dXMax + dXMin) / 2;
			
			dYHead = dRotatedY1[0];
			dYTail = dRotatedY1[iNumXY-1];
			dYTail = (dYHead + dYTail) / 2;
			
			LinEv1D (dRotatedX1, iNumXY, 1.0, - dXMax, dRotatedX1);
			LinEv1D (dRotatedY1, iNumXY, 1.0, - dYTail, dRotatedY1);
			
			Sum1D (dRotatedX1, iNumXY, &dXSym[indexNode]);
			Sum1D (dRotatedY1, iNumXY, &dYSym[indexNode]);
			
			Mul1D (dRotatedX1, dRotatedX1, iNumXY, dTempArray);
			Sum1D (dTempArray, iNumXY, &dBkpDXX[indexNode]);


			Mul1D (dRotatedY1, dRotatedY1, iNumXY, dTempArray);
			Sum1D (dTempArray, iNumXY, &dBkpDYY[indexNode]);

			Mul1D (dRotatedX1, dRotatedY1, iNumXY, dTempArray);
			Sum1D (dTempArray, iNumXY, &dXYSym[indexNode]);
			Abs1D (dTempArray, iNumXY, dTempArray);
			Sum1D (dTempArray, iNumXY, &dBkpDXY[indexNode]);

			MaxMin1D (dRotatedX1, iNumXY, &dMax, &iTemp, &dMin, &iTemp);
			dLong = dMax - dMin;
			
			MaxMin1D (dRotatedY1, iNumXY, &dMax, &iTemp, &dMin, &iTemp);
			dWidth = dMax - dMin;
			
			dBkpElgFactor[indexNode] = dLong / dWidth;
			dCmpctFactor[indexNode] = dWormLength[indexNode] / (dLong * dWidth);

//Change this
			//dBkpHight[indexNode] = dWormLength[indexNode] / dLong;
//Get it here
			dBkpHight[indexNode] = dLong;
			dBkpWidth[indexNode] = dWidth;			
		}
		
	}	
	
	free (dRotatedX1);
	free (dRotatedY1);
	free (dTempArray);

	return 1;
}

//******************************************************************************************//
//  disPlayTrack
// 	   This function will display the track, 
//  
//   This will calculate a lot of feature based "section" of bkb which the name is defined by 
//			Chris.  Some feature is similar to Chris's. 
//      
//******************************************************************************************//
int disPlayTrack (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;
double *dDisplayCenX, *dDisplayCenY;

int iNodeCount;
int iDisplayCount = 0;

	if (gAnalBkbFileLoaded == 0 || gBksForAnalysis == null)
	{
		MessagePopup ("Error", "No backbone set available yet!");
		return 0;
	}

	iNodeCount = bbs->NodeCount;
	if (iStartingNode < 0 || iEndNode >= iNodeCount)
	{
		MessagePopup ("Error", "Out of range.");
		return 0;
	}
	
	dDisplayCenX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayCenY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iLoop[indexNode]  != - 10)
		{
			dDisplayCenX[iDisplayCount] = dCenX[indexNode];
			dDisplayCenY[iDisplayCount] = dCenY[indexNode];
//			dDisplayCenX[iDisplayCount] = bbs->backboneNodePtr[indexNode]->absCentX;
//			dDisplayCenY[iDisplayCount] = bbs->backboneNodePtr[indexNode]->absCentY;
			iCentIndex[indexNode] = iDisplayCount; 

			iDisplayCount ++;
		}  else iCentIndex[indexNode] = -1;
	}
	
	if (iPlotCenTrack > 0) iPlotCenTrack = DeleteGraphPlot (panel, PANEL_ANAL_grphCenTrack, iPlotCenTrack, VAL_IMMEDIATE_DRAW);
	iPlotCenTrack = PlotXY (panel, PANEL_ANAL_grphCenTrack, dDisplayCenX, dDisplayCenY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);

	free (dDisplayCenX);
	free (dDisplayCenY);
	
//set the starting of the plot
	gIStartingNode = iStartingNode;
	
	return 1;

}

int CVICALLBACK SetCurrentStartNode (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int iStartingNode;
int iEndNode;
int iSet; 

	switch (event)
		{
		case EVENT_COMMIT:

			GetCtrlVal (panel, PANEL_ANAL_StartingNode, &iStartingNode);
			GetCtrlVal (panel, PANEL_ANAL_nEndNode, &iEndNode);
			GetCtrlVal (panel, PANEL_ANAL_nSet, &iSet);
			
			if (iEndNode <= iStartingNode)
			{
				MessagePopup ("Error", "End Node has to be larger than starting node!") ;
				//return 1;
			}

			if (control == PANEL_ANAL_StartingNode)
			{
				if (iEndNode <= iStartingNode) iStartingNode = iEndNode - 1;
				SetCtrlVal (panel, PANEL_ANAL_StartingNode, iStartingNode);
				SetCtrlVal (panel, PANEL_ANAL_numCursorIndex, iStartingNode);	

				SetCtrlAttribute (panel, PANEL_ANAL_numCursorIndex, ATTR_MIN_VALUE, iStartingNode);
				SetCtrlAttribute (panel, PANEL_ANAL_nEndNode, ATTR_MIN_VALUE, iStartingNode + 1);

			}else
			{
			
				if (iEndNode <= iStartingNode) iEndNode = iStartingNode + 1;
				SetCtrlVal (panel, PANEL_ANAL_nEndNode, iEndNode);
				SetCtrlAttribute (panel, PANEL_ANAL_numCursorIndex, ATTR_MAX_VALUE, iEndNode);
				SetCtrlAttribute (panel, PANEL_ANAL_StartingNode, ATTR_MAX_VALUE, iEndNode - 1);
			}
			
			disPlayTrack (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);    
			
			break;
		}
	return 0;
}

int CVICALLBACK plotData (int panel, int control, int event,				 
		void *callbackData, int eventData1, int eventData2)
{

int iNodeCount;

int iStartingNode;
int iEndNode;
int iSet;


	switch (event)
		{
		case EVENT_COMMIT:
		
				GetCtrlVal (panel, PANEL_ANAL_StartingNode, &iStartingNode);
				GetCtrlVal (panel, PANEL_ANAL_nEndNode, &iEndNode);
				GetCtrlVal (panel, PANEL_ANAL_nSet, &iSet);

				if (gAnalBkbFileLoaded == 0 || gBksForAnalysis == null)
				{
					MessagePopup ("Error", "No backbone set available yet!");
					return 1;
				}		

				iNodeCount = gBksForAnalysis[iSet]->NodeCount;

				if (iStartingNode < 0 || iEndNode >= iNodeCount)
				{
					MessagePopup ("Error", "Out of range.");
					return 1;
				}
				
								
				
				switch (control)
				{
			
					case PANEL_ANAL_lstGlb:
						disGlb (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);      
					break;
				
					case PANEL_ANAL_lstGrey:
						disGrey (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);  
					break;

					case PANEL_ANAL_lstMorph:
						disMorph (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);		
					break;

					case PANEL_ANAL_lstIMAQ:
						disIMAQ (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);		
					break;

					case PANEL_ANAL_lstLcl:
						disLcl (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);		
					break;

					case PANEL_ANAL_lstVct:
						disVct (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);		
					break;  
					
					case PANEL_ANAL_lstBkbvv:
						disBkbvv (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
					break;

					case PANEL_ANAL_lstWave:
						disWave (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
					break;

					case PANEL_ANAL_lstIMAQBkb:
						disIMAQBkb (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);  
					break;

					case PANEL_ANAL_lstMvPtn:
						disMvPtn (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);  
					break;

					case PANEL_ANAL_lstAngle:
						disAngle (panel, iStartingNode, gBksForAnalysis[iSet]);  
					break;

/*
					case PANEL_ANAL_lstMorph:
						disIMAQBkb (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);  
					break;
//*/
				}

			break;
		}
	return 0;
}


int disGlb (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;
double *dDisplayX, *dDisplayY;

//int iNodeCount;
int iDisplayCount = 0;

int iWhichAttribute;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;


	GetCtrlVal (panel, PANEL_ANAL_lstGlb, &iWhichAttribute);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	//Copy1D (dTime, iNumImage, dTime);     	
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iLoop[indexNode]  != - 10)
		{
		
			switch (iWhichAttribute)
			{
				case 1:
					sprintf (sTitle, "Globle Speed");
					if (gSpeed[indexNode] > -1)
					{
						dDisplayY[iDisplayCount] = gSpeed[indexNode];
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						iGlbIndex[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else 	iGlbIndex[indexNode] = - 1; 
				break;
				
				case 2:
					sprintf (sTitle, "Global Moving Angle");
					if (gMovingAngles[indexNode]  > - 3.15)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = gMovingAngles[indexNode];
						iGlbIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iGlbIndex[indexNode] = - 1; 
				break;

				case 3:
					sprintf (sTitle, "Distance to 1st Centroid");
					if (gDistanceToFirstPoint[indexNode] > -1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = gDistanceToFirstPoint[indexNode];
						iGlbIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iGlbIndex[indexNode] = - 1; 
				break;
					
				case 4:
					sprintf (sTitle, "Angle To 1st Cen");
					if (gAngleToFirstPoint[indexNode] > -3.15)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = gAngleToFirstPoint[indexNode];
						iGlbIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iGlbIndex[indexNode] = - 1; 
				break;

				case 5:
					sprintf (sTitle, "Angles of Body Fit");
					if (gAngleWholeBody[indexNode] > -3.15)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = gAngleWholeBody[indexNode];
						iGlbIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iGlbIndex[indexNode] = - 1;

				break;
			}

		} else 	iGlbIndex[indexNode] = - 1;      
	}
	
	
	
	if (iPlotGlb > 0) iPlotGlb = DeleteGraphPlot (panel, PANEL_ANAL_grphGlb, iPlotGlb, VAL_IMMEDIATE_DRAW);
//compiler
	iPlotGlb = PlotXY (panel, PANEL_ANAL_grphGlb, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphGlb, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 1, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);
	
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 1), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 1), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 1), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 1), dSD);
	
	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disGrey (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;
double *dDisplayX, *dDisplayY;

//int iNodeCount;
int iDisplayCount = 0;

int iWhichAttribute;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;


	GetCtrlVal (panel, PANEL_ANAL_lstGrey, &iWhichAttribute);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iLoop[indexNode]  !=  - 10)
		{
		
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf(sTitle, "Area");
					if (dArea[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = dArea[indexNode];
						iGrey[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else iGrey[indexNode] = - 1; 
				break;
				
				case 2:
					sprintf(sTitle, "Length");
					if (dWormLength[indexNode]  > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dWormLength[indexNode];
						iGrey[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iGrey[indexNode] = - 1; 
				break;

				case 3:
					sprintf(sTitle, "Transparency");
					if (dTransparency[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dTransparency[indexNode];
						iGrey[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iGrey[indexNode] = - 1; 
				break;
					
				case 4:
					sprintf(sTitle, "Thickness");
					if (dThickness[indexNode] > 16)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dThickness[indexNode];
						iGrey[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iGrey[indexNode] = - 1; 
				break;

				case 5:
					sprintf(sTitle, "Fatness");
					if (dFatness[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dFatness[indexNode];
						iGrey[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iGrey[indexNode] = - 1; 
				break;

				case 6:
					sprintf(sTitle, "Length/No. Pixel");
					if (dLengthToPixelNumber[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dLengthToPixelNumber[indexNode];
						iGrey[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iGrey[indexNode] = - 1;
				break;
					
			}
	
		} else iGrey[indexNode] = - 1; 
	}

	if (iDisplayCount > 0)
	 {
		if (iPlotGrey > 0) iPlotGrey = DeleteGraphPlot (panel, PANEL_ANAL_grphGrey, iPlotGrey, VAL_IMMEDIATE_DRAW);
		iPlotGrey = PlotXY (panel, PANEL_ANAL_grphGrey, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
		SetCtrlAttribute (panel, PANEL_ANAL_grphGrey, ATTR_YNAME, sTitle);
		SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 2, ATTR_LABEL_TEXT, sTitle);

		MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
		StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

		SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 2), dMean);
		SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 2), dMin);
		SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 2), dMax);
		SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 2), dSD);
	}
	
	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disMorph (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;
double *dDisplayX, *dDisplayY;

//int iNodeCount;
int iDisplayCount = 0;

int iWhichAttribute;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;


	GetCtrlVal (panel, PANEL_ANAL_lstMorph, &iWhichAttribute);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iLoop[indexNode]  != - 10)
		{
		
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "Max Intercept");
					if (dMaxIntercept[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = dMaxIntercept[indexNode];
						iMorph[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else 	iMorph[indexNode] = - 1; 
				break;
				
				case 2:
					sprintf (sTitle, "Mean Ppdcl Intcpt");
					if (dMeanInterceptPerpendicular[indexNode]  > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dMeanInterceptPerpendicular[indexNode];
						iMorph[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iMorph[indexNode] = - 1; 
				break;

				case 3:
					sprintf (sTitle, "Equ. Ell. Ratio");
					if (dEquivalenceEllipsRatio[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dEquivalenceEllipsRatio[indexNode];
						iMorph[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iMorph[indexNode] = - 1; 
				break;
					
				case 4:
					sprintf (sTitle, "Ell M. Axis");
					if (dEllipsMajorAxis[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dEllipsMajorAxis[indexNode];
						iMorph[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iMorph[indexNode] = - 1; 
				break;

				case 5:
					sprintf (sTitle, "Ell Ratio");
					if (dEllipsRatio[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dEllipsRatio[indexNode];
						iMorph[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iMorph[indexNode] = - 1; 
				break;

				case 6:
					sprintf (sTitle, "Rect Big Side");
					if (dRectBigSide[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dRectBigSide[indexNode];
						iMorph[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iMorph[indexNode] = - 1; 
				break;

				case 7:
					sprintf (sTitle, "Rect Rati");
					if (dRectRatio[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dRectRatio[indexNode];
						iMorph[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iMorph[indexNode] = - 1;

				break;
					
			}
	
		}  else 	iMorph[indexNode] = - 1; 
	}
	
	if (iPlotMorph > 0) iPlotMorph = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphMorph, iPlotMorph, VAL_IMMEDIATE_DRAW);
	iPlotMorph = PlotXY (panel, PANEL_ANAL_grphMorph, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphMorph, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 5, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 5), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 5), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 5), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 5), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disIMAQ (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;
double *dDisplayX, *dDisplayY;

//int iNodeCount;
int iDisplayCount = 0;

int iWhichAttribute;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;


	GetCtrlVal (panel, PANEL_ANAL_lstIMAQ, &iWhichAttribute);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iLoop[indexNode]  != - 10)
		{
		
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "IMAQ Elongation");
					if (dElongationFactor[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = dElongationFactor[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else 	iIMAQ[indexNode] = iDisplayCount; 
				break;
				
				case 2:
					sprintf (sTitle, "IMAQ Compact");
					if (dCompactnessFactor[indexNode]  > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dCompactnessFactor[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iIMAQ[indexNode] = iDisplayCount; 
				break;

				case 3:
					sprintf (sTitle, "IMAQ Heywood");
					if (dHeywoodCicularityFactor[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dHeywoodCicularityFactor[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					}  else 	iIMAQ[indexNode] = iDisplayCount; 
				break;
					
				case 4:
					sprintf (sTitle, "IMAQ Type Factor");
					if (dTypeFactor[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dTypeFactor[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iIMAQ[indexNode] = iDisplayCount; 
				break;

				case 5:
					sprintf (sTitle, "IMAQ Hydraulic");
					if (dHydraulicRadius[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dHydraulicRadius[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					}  else 	iIMAQ[indexNode] = iDisplayCount; 
				break;

				case 6:
					sprintf (sTitle, "IMAQ Waddel Disk");
					if (dWaddelDiskDiameter[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dWaddelDiskDiameter[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					}  else 	iIMAQ[indexNode] = iDisplayCount; 
				break;

				case 7:
					sprintf (sTitle, "IMAQ Inert XX");
					if (dIXX[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dIXX[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iIMAQ[indexNode] = iDisplayCount; 
				break;

				case 8:
					sprintf (sTitle, "IMAQ Inert YY");
					if (dIYY[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dIYY[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iIMAQ[indexNode] = iDisplayCount; 
				break;

				case 9:
					sprintf (sTitle, "IMAQ Inert XY");
					if (dIXY[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dIXY[indexNode];
						iIMAQ[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iIMAQ[indexNode] = iDisplayCount;

				break;
					
			}
	
		} else 	iIMAQ[indexNode] = iDisplayCount; 
	}
	
	if (iPlotIMAQ > 0) iPlotIMAQ = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphIMAQ, iPlotIMAQ, VAL_IMMEDIATE_DRAW);
	iPlotIMAQ = PlotXY (panel, PANEL_ANAL_grphIMAQ, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphIMAQ, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 4, ATTR_LABEL_TEXT, sTitle);
	
	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);
	
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 4), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 4), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 4), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 4), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disLcl (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;

double *dDisplayX, *dDisplayY;

int iDisplayCount = 0;

int iWhichAttribute;
int iWhichBkbp;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;

	
	GetCtrlVal (panel, PANEL_ANAL_lstLcl, &iWhichAttribute);
	GetCtrlVal (panel, PANEL_ANAL_WhichBackbonePoint, &iWhichBkbp);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iIsBkbp[indexNode]  > 0)
		{
		
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "Lcl Speed Ave");
					if (lclSpeedAverage[indexNode] > -1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = lclSpeedAverage[indexNode];
						iLclIndex[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else iLclIndex[indexNode] = - 1;
				break;
				
				case 2:
					sprintf (sTitle, "Lcl Speed Head/Tail");
					if (lclHeadToTailRatio[indexNode]  < 10 && lclHeadToTailRatio[indexNode]  > -1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = lclHeadToTailRatio[indexNode];
						iLclIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iLclIndex[indexNode] = - 1;
				break;

				case 3:
					sprintf (sTitle, "Pusing Effect");
					if (dPushing[indexNode] < 3 && dPushing[indexNode] > -1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dPushing[indexNode];
						iLclIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iLclIndex[indexNode] = - 1;
				break;
					
				case 4:
					sprintf (sTitle, "Lcl Speed bkbp[%d]", iWhichBkbp);
					if (lclSpeed[indexNode][iWhichBkbp] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = lclSpeed[indexNode][iWhichBkbp];
						iLclIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iLclIndex[indexNode] = - 1;
				break;

				case 5:
					sprintf (sTitle, "Dist. Head/Tail");
					if (dDistanceHeadTail[indexNode] > - 1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dDistanceHeadTail[indexNode];
						iLclIndex[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iLclIndex[indexNode] = - 1;
				break;
			}
	
		} else iLclIndex[indexNode] = - 1;  
	}
	
	if (iPlotLcl > 0) iPlotLcl = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphLcl, iPlotLcl, VAL_IMMEDIATE_DRAW);
	iPlotLcl = PlotXY (panel, PANEL_ANAL_grphLcl, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphLcl, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 10, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 10), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 10), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 10), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 10), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}


int disVct (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;

double *dDisplayX, *dDisplayY;

int iDisplayCount = 0;

int iWhichAttribute;
int iWhichBkbp;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;

	
	GetCtrlVal (panel, PANEL_ANAL_lstVct, &iWhichAttribute);
	GetCtrlVal (panel, PANEL_ANAL_WhichBackbonePoint, &iWhichBkbp);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iIsBkbp[indexNode]  > 0)
		{
		
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "Bkbv Agl[%d]", iWhichBkbp);
					if (dBkbvAngles[indexNode][iWhichBkbp]  > - 3.15)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbvAngles[indexNode][iWhichBkbp];
						iVct[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iVct[indexNode] = iDisplayCount;   
				break;
				
				case 2:
					sprintf (sTitle, "Bkbv Agl Ave");
					if (dBkbvAngleAverage[indexNode] > - 3.15)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = dBkbvAngleAverage[indexNode];
						iDisplayCount ++; 
					} else 	iVct[indexNode] = iDisplayCount;   
				break;
				
				case 3:
					sprintf (sTitle, "Min Bkbv/length");
					if (dBkbvDistMinToBackboneLength[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbvDistMinToBackboneLength[indexNode];
						iVct[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iVct[indexNode] = iDisplayCount;

				break;
				
				case 4:
					sprintf (sTitle, "Max Bkbv/length");
					if (dBkbvDistMaxToBackboneLength[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbvDistMaxToBackboneLength[indexNode];
						iVct[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iVct[indexNode] = iDisplayCount;

				break;

				case 5:
					sprintf (sTitle, "Ave Bkbv/length");
					if (dBkbvDistAveToBackboneLength[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbvDistAveToBackboneLength[indexNode];
						iVct[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else 	iVct[indexNode] = iDisplayCount;

				break;
				

			}
	
		}  else 	iVct[indexNode] = iDisplayCount;   
	}
	
	if (iPlotVct > 0) iPlotVct = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphVct, iPlotVct, VAL_IMMEDIATE_DRAW);
	iPlotVct = PlotXY (panel, PANEL_ANAL_grphVct, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphVct, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 6, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 6), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 6), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 6), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 6), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disPlayTwoImages (int panel, int whichNode, BackboneSet *bbs)  
{

int indexWhichBackbonePoint, index;

double *dBackbone1X, *dBackbone2X, *dBackbone1Y, *dBackbone2Y;

double dMax1, dMin1;
double dMax2, dMin2;
double dMaxX, dMaxY, dMinX, dMinY;
int iTemp;

double dXTemp, dYTemp;
double dDiff;

double *dFitting1X, *dFitting1Y, *dFitting2X, *dFitting2Y;
double dCent1X, dCent1Y, dCent2X, dCent2Y;

double dSlope1, dIntercept1;
double dSlope2, dIntercept2;

double dXTemp1, dYTemp1; 
double dAngle, dDistance;

int numXY, iNodeCount;

int iNextNode, iNextAvailable = -1 ;


			if (iIsBkbp[whichNode] != 1)
			{
				if (iPlotTwoImage1 > 0) iPlotTwoImage1 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImage1, VAL_IMMEDIATE_DRAW);
				if (iPlotTwoImage2 > 0) iPlotTwoImage2 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImage2, VAL_IMMEDIATE_DRAW);

				if (iPlotTwoImageFitting1 > 0) iPlotTwoImageFitting1 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImageFitting1, VAL_IMMEDIATE_DRAW);
				if (iPlotTwoImageFitting2 > 0) iPlotTwoImageFitting2 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImageFitting2, VAL_IMMEDIATE_DRAW);
			
				return 0;
			}
			
			iNodeCount = bbs->NodeCount;  
			numXY = bbs->NumXYpairs;
			
			iNextNode = whichNode + 1;
				
			if (iNextNode >= iNodeCount) 
			{	
				iNextAvailable = 0;
				goto skip;
			}			

repeat:			
			if (iIsBkbp[iNextNode] != 1)
			{
				iNextNode ++ ;
				if (iNextNode >= iNodeCount) 
				{	
					iNextAvailable = 0;
					goto skip;
				}
				
				goto repeat;
			}
			
			iNextAvailable = 1;
			
skip:
			
			dBackbone1X =  (double *)malloc (numXY * (sizeof(double)));
			dBackbone2X =  (double *)malloc (numXY * (sizeof(double)));
			dBackbone1Y =  (double *)malloc (numXY * (sizeof(double)));
			dBackbone2Y =  (double *)malloc (numXY * (sizeof(double)));

			dFitting1X =  (double *)malloc (2 * (sizeof(double)));
			dFitting1Y =  (double *)malloc (2 * (sizeof(double)));

			dFitting2X =  (double *)malloc (2 * (sizeof(double)));
			dFitting2Y =  (double *)malloc (2 * (sizeof(double)));

//Get the data
			for (indexWhichBackbonePoint = 0; indexWhichBackbonePoint < numXY; indexWhichBackbonePoint ++)
			{
				dBackbone1X[indexWhichBackbonePoint] = dX[whichNode][indexWhichBackbonePoint];
				dBackbone1Y[indexWhichBackbonePoint] = dY[whichNode][indexWhichBackbonePoint];

				if (iNextAvailable == 1)
				{
					dBackbone2X[indexWhichBackbonePoint] = dX[iNextNode][indexWhichBackbonePoint];
					dBackbone2Y[indexWhichBackbonePoint] = dY[iNextNode][indexWhichBackbonePoint];
				}
			}

//Get the max and min
			MaxMin1D (dBackbone1X, numXY, &dMax1, &iTemp, &dMin1, &iTemp);
			MaxMin1D (dBackbone2X, numXY, &dMax2, &iTemp, &dMin2, &iTemp);

			if (dMax1 > dMax2)
			{
				dMaxX = dMax1;
			}else dMaxX = dMax2;

			if (dMin1 < dMin2)
			{
				dMinX = dMin1;
			}else dMinX = dMin2;
			
			MaxMin1D (dBackbone1Y, numXY, &dMax1, &iTemp, &dMin1, &iTemp);
			MaxMin1D (dBackbone2Y, numXY, &dMax2, &iTemp, &dMin2, &iTemp);

			if (dMax1 > dMax2)
			{
				dMaxY = dMax1;
			}else dMaxY = dMax2;

			if (dMin1 < dMin2)
			{
				dMinY = dMin1;
			}else dMinY = dMin2;

//Get the fitting
			//Central mass
			Mean (dBackbone1X, numXY, &dCent1X);
			Mean (dBackbone2X, numXY, &dCent2X);
			
			Mean (dBackbone1Y, numXY, &dCent1Y);
			Mean (dBackbone2Y, numXY, &dCent2Y);

			//First One
			dXTemp = dBackbone1X[0];
			dYTemp = dBackbone1Y[0];

			dXTemp1 = dBackbone1X[numXY - 1];
			dYTemp1 = dBackbone1Y[numXY - 1];

			DisAngleBetweenTwoPoints (dXTemp, dYTemp, dXTemp1, dYTemp1, &dAngle, &dDistance);

			dSlope1 = tan(dAngle);
			dIntercept1 = dCent1Y - dCent1X * dSlope1;

			//Second one
			dXTemp = dBackbone2X[0];
			dYTemp = dBackbone2Y[0];

			dXTemp1 = dBackbone2X[numXY - 1];
			dYTemp1 = dBackbone2Y[numXY - 1];

			DisAngleBetweenTwoPoints (dXTemp, dYTemp, dXTemp1, dYTemp1, &dAngle, &dDistance);

			dSlope2 = tan(dAngle);
			dIntercept2 = dCent2Y - dCent2X * dSlope2;
	
			dFitting1X [0] = dMinX;
			dFitting2X [0] = dMinX;
			dFitting1X [1] = dMaxX;
			dFitting2X [1] = dMaxX;
			
			for (index = 0; index < 2; index ++)
			{
				dFitting1Y[index] = dSlope1 * dFitting1X[index] + dIntercept1;
				dFitting2Y[index] = dSlope2 * dFitting2X[index] + dIntercept2;
			}
	
			if (iPlotTwoImage1 > 0) iPlotTwoImage1 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImage1, VAL_IMMEDIATE_DRAW);
			if (iPlotTwoImage2 > 0) iPlotTwoImage2 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImage2, VAL_IMMEDIATE_DRAW);

			if (iPlotTwoImageFitting1 > 0) iPlotTwoImageFitting1 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImageFitting1, VAL_IMMEDIATE_DRAW);
			if (iPlotTwoImageFitting2 > 0) iPlotTwoImageFitting2 = DeleteGraphPlot (panel, PANEL_ANAL_grphTwoImage, iPlotTwoImageFitting2, VAL_IMMEDIATE_DRAW);


			iPlotTwoImage1 = PlotXY (panel, PANEL_ANAL_grphTwoImage, dBackbone1X, dBackbone1Y, numXY, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);

			if (iNextAvailable == 1)   
			iPlotTwoImage2 = PlotXY (panel, PANEL_ANAL_grphTwoImage, dBackbone2X, dBackbone2Y, numXY, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_BLUE);

			iPlotTwoImageFitting1 = PlotXY (panel, PANEL_ANAL_grphTwoImage, dFitting1X, dFitting1Y, 2, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_NO_POINT, VAL_SOLID, 1, VAL_RED);
			
			if (iNextAvailable == 1)   
			iPlotTwoImageFitting2 = PlotXY (panel, PANEL_ANAL_grphTwoImage, dFitting2X, dFitting2Y, 2, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_NO_POINT, VAL_SOLID, 1, VAL_BLUE);

//Consider change into one function
			if (iNextAvailable == 0) goto exit;  
			dXTemp = dMaxX - dMinX;
			dYTemp = dMaxY - dMinY;


			if (dXTemp >= dYTemp)
			{
				dDiff = dXTemp - dYTemp ;
				SetAxisScalingMode (panel, PANEL_ANAL_grphTwoImage, VAL_XAXIS, VAL_MANUAL, dMinX - 10, dMaxX + 10);
				SetAxisScalingMode (panel, PANEL_ANAL_grphTwoImage, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - dDiff/2 - 10, dMaxY + dDiff/2 + 10);
			}

			if (dXTemp < dYTemp)
			{
				dDiff = dYTemp - dXTemp ;
				SetAxisScalingMode (panel, PANEL_ANAL_grphTwoImage, VAL_XAXIS, VAL_MANUAL, dMinX - dDiff/2 - 10, dMaxX + dDiff/2 + 10);
				SetAxisScalingMode (panel, PANEL_ANAL_grphTwoImage, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - 10, dMaxY + 10);
			}

//Consider change into one function
exit:
			SetGraphCursorIndex (panel, PANEL_ANAL_grphTwoImage, 1, iPlotTwoImage1, 0);
			if (iNextAvailable == 1)   
			SetGraphCursorIndex (panel, PANEL_ANAL_grphTwoImage, 2, iPlotTwoImage2, 0);
			
			free (dBackbone1X);
			free (dBackbone2X);
			free (dBackbone1Y);
			free (dBackbone2Y);
			
			free (dFitting1X);
			free (dFitting1Y);
			free (dFitting2X);
			free (dFitting2Y);
end:

	return 1;
}

int disRotatedBkb (int panel, int whichNode, BackboneSet *bbs)  
{

int iWhichBackbonePoint, index;
double dXLow, dXHigh;
double dYLow, dYHigh;

int iTemp;
double dXTemp, dYTemp;
double dXTemp1, dYTemp1;
double dDiff;

double *dFittingX, *dFittingY;
double *dDisplayXRotated, *dDisplayYRotated;

int iNumXY;
double dCentX, dCentY;
double dAngle;
double dSlope, dIntercept;

	if (iIsBkbp[whichNode] != 1)
	{
		if (iPlotBkbRotated > 0) iPlotBkbRotated = DeleteGraphPlot (panel, PANEL_ANAL_grphBkbRotated, iPlotBkbRotated, VAL_IMMEDIATE_DRAW);
		if (iPlotBkbRotatedFitting > 0) iPlotBkbRotatedFitting = DeleteGraphPlot (panel, PANEL_ANAL_grphBkbRotated, iPlotBkbRotatedFitting, VAL_IMMEDIATE_DRAW);
			
		return 0;
	}
			
	iNumXY = bbs->NumXYpairs;

	dFittingX = (double *)calloc (2, sizeof(double));
	dFittingY = (double *)calloc (2, sizeof(double));
	
	dDisplayXRotated = (double *)malloc (iNumXY * sizeof(double)) ; 
	dDisplayYRotated = (double *)malloc (iNumXY * sizeof(double)) ; 

	for (iWhichBackbonePoint = 0; iWhichBackbonePoint < iNumXY; iWhichBackbonePoint ++)
	{
		dDisplayXRotated[iWhichBackbonePoint] = dXRotated[whichNode][iWhichBackbonePoint];
		dDisplayYRotated[iWhichBackbonePoint] = dYRotated[whichNode][iWhichBackbonePoint];
	}


//Get the fitting
	//Central mass
	Mean (dDisplayXRotated, iNumXY, &dCentX);
	Mean (dDisplayYRotated, iNumXY, &dCentY);
			
	//First One
	dXTemp = dDisplayXRotated[0];
	dYTemp = dDisplayYRotated[0];
	dXTemp1 = dDisplayXRotated[iNumXY - 1];
	dYTemp1 = dDisplayYRotated[iNumXY - 1];

	DisAngleBetweenTwoPoints (dXTemp, dYTemp, dXTemp1, dYTemp1, &dAngle, &dXLow);

	dSlope = tan(dAngle);
	dIntercept = dCentY - dCentX * dSlope;
 	
			


	//*make it according to image size
	MaxMin1D (dDisplayXRotated, iNumXY, &dXHigh, &iTemp, &dXLow, &iTemp);
	MaxMin1D (dDisplayYRotated, iNumXY, &dYHigh, &iTemp, &dYLow, &iTemp);
	dXTemp = dXHigh - dXLow;
	dYTemp = dYHigh - dYLow;
	
	dFittingX[0] = dXLow;
	dFittingX[1] = dXHigh;
	
	for (index = 0; index < 2; index ++)
	{
		dFittingY[index] = dSlope * dFittingX[index] + dIntercept;
	}

	
	if (iPlotBkbRotated > 0) iPlotBkbRotated = DeleteGraphPlot (panel, PANEL_ANAL_grphBkbRotated, iPlotBkbRotated, VAL_IMMEDIATE_DRAW);
	if (iPlotBkbRotatedFitting > 0) iPlotBkbRotatedFitting = DeleteGraphPlot (panel, PANEL_ANAL_grphBkbRotated, iPlotBkbRotatedFitting, VAL_IMMEDIATE_DRAW);

	if (dXTemp >= dYTemp)
	{
		dDiff = dXTemp - dYTemp ;
		SetAxisScalingMode (panel, PANEL_ANAL_grphBkbRotated, VAL_XAXIS, VAL_MANUAL, dXLow - 10, dXHigh + 10);
		SetAxisScalingMode (panel, PANEL_ANAL_grphBkbRotated, VAL_LEFT_YAXIS, VAL_MANUAL, dYLow - dDiff/2 - 10, dYHigh + dDiff/2 + 10);
	}

	if (dXTemp < dYTemp)
	{
		dDiff = dYTemp - dXTemp ;
		SetAxisScalingMode (panel, PANEL_ANAL_grphBkbRotated, VAL_XAXIS, VAL_MANUAL, dXLow - dDiff/2 - 10, dXHigh + dDiff/2 + 10);
		SetAxisScalingMode (panel, PANEL_ANAL_grphBkbRotated, VAL_LEFT_YAXIS, VAL_MANUAL, dYLow - 10, dYHigh + 10);
	}
	
	iPlotBkbRotated = PlotXY (panel, PANEL_ANAL_grphBkbRotated, dDisplayXRotated, dDisplayYRotated, iNumXY, VAL_DOUBLE, VAL_DOUBLE, VAL_SCATTER, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);

	iPlotBkbRotatedFitting = PlotXY (panel, PANEL_ANAL_grphBkbRotated, dFittingX, dFittingY, 2, VAL_DOUBLE, VAL_DOUBLE,
									 VAL_THIN_LINE, VAL_NO_POINT,
									 VAL_SOLID, 1, VAL_DK_RED);

	SetGraphCursorIndex (panel, PANEL_ANAL_grphBkbRotated, 1, iPlotBkbRotated, 0);
	
	free (dDisplayXRotated);
	free (dDisplayYRotated);
	
	free (dFittingX);
	free (dFittingY);

	return 1;
//*/
}

int disBkbvv (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;

double *dDisplayX, *dDisplayY;

int iDisplayCount = 0;

int iWhichAttribute;
int iWhichBkbp;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;

	
	GetCtrlVal (panel, PANEL_ANAL_lstBkbvv, &iWhichAttribute);
	GetCtrlVal (panel, PANEL_ANAL_WhichBackbonePoint, &iWhichBkbp);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iIsBkbp[indexNode]  > 0)
		{
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "Bkbvv Agl Ave");
					if (dBkbvvAngleAverage[indexNode]  > - 181)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbvvAngleAverage[indexNode];
						iBkbvv[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iBkbvv[indexNode] = - 1;
				break;
				
				case 2:
					sprintf (sTitle, "Bkbvv Agl Max");
					if (dBkbvvAngleMaxium[indexNode] > - 181)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = dBkbvvAngleMaxium[indexNode];
						iBkbvv[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else iBkbvv[indexNode] = - 1;  
				break;
				
				case 3:
					sprintf (sTitle, "Bkbvv Agl[%d]", iWhichBkbp);
					if (dBkbvvAngle[indexNode][iWhichBkbp] > - 181)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbvvAngle[indexNode][iWhichBkbp];
						iBkbvv[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iBkbvv[indexNode] = - 1;  
				break;

			}
	
		}
	}
	
	if (iPlotBkbvv > 0) iPlotBkbvv = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphBkbvv, iPlotBkbvv, VAL_IMMEDIATE_DRAW);
	iPlotBkbvv = PlotXY (panel, PANEL_ANAL_grphBkbvv, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphBkbvv, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 7, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 7), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 7), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 7), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 7), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disWave (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;

double *dDisplayX, *dDisplayY;

int iDisplayCount = 0;

int iWhichAttribute;
int iWhichBkbp = 0;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;

	
	GetCtrlVal (panel, PANEL_ANAL_lstWave, &iWhichAttribute);
	GetCtrlVal (panel, PANEL_ANAL_WhichBackbonePoint, &iWhichBkbp); 
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iIsBkbp[indexNode]  > 0)
		{
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "Bkbp Speed Ave");
					if (dBkbpSpeedAverage[indexNode]  > - 1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbpSpeedAverage[indexNode];
						iWave[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iWave[indexNode] = - 1;  
				break;
				
				case 2:
					sprintf (sTitle, "Bkbp Head To Tail");
					if (dBkbpHeadToTail[indexNode] > 0 && dBkbpHeadToTail[indexNode] < 100)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = dBkbpHeadToTail[indexNode];
						iWave[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else iWave[indexNode] = - 1; 
				break;
				
				case 3:
					sprintf (sTitle, "Bkbp Speed[%d]", iWhichBkbp);
					if (dBkbpSpeed[indexNode][iWhichBkbp] > -1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkbpSpeed[indexNode][iWhichBkbp];
						iWave[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iWave[indexNode] = - 1; 
				break;

				case 4:
					sprintf (sTitle, "Agl to Centoid[%d]", iWhichBkbp);
					if (dAngleToCentroid[indexNode][iWhichBkbp] > -1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dAngleToCentroid[indexNode][iWhichBkbp];
						iWave[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iWave[indexNode] = - 1; 
				break;

			}
	
		} else iWave[indexNode] = - 1; 
	}
	
	if (iPlotWave > 0) iPlotWave = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphWave, iPlotWave, VAL_IMMEDIATE_DRAW);
	iPlotWave = PlotXY (panel, PANEL_ANAL_grphWave, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphWave, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 8, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 8), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 8), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 8), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 8), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disIMAQBkb (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;
double *dDisplayX, *dDisplayY;

//int iNodeCount;
int iDisplayCount = 0;

int iWhichAttribute;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;


	GetCtrlVal (panel, PANEL_ANAL_lstIMAQBkb, &iWhichAttribute);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iLoop[indexNode]  != - 10)
		{
		
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "BkbIMAQ inert XX");
					if (dBkpDXX[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = dBkpDXX[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++; 
					} else iIMAQBkb[indexNode] = - 1; 
				break;
				
				case 2:
					sprintf (sTitle, "BkbIMAQ inert YY");
					if (dBkpDYY[indexNode]  > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkpDYY[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iIMAQBkb[indexNode] = - 1; 
				break;

				case 3:
					sprintf (sTitle, "BkbIMAQ inert XY");
					if (dBkpDXY[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkpDXY[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iIMAQBkb[indexNode] = - 1; 
				break;
					
				case 4:
					sprintf (sTitle, "BkbIMAQ Elgt'n");
					if (dBkpElgFactor[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkpElgFactor[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iIMAQBkb[indexNode] = - 1; 
				break;

				case 5:
					sprintf (sTitle, "BkbIMAQ compact");
					if (dCmpctFactor[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dCmpctFactor[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iIMAQBkb[indexNode] = - 1; 
				break;

				case 6:
					sprintf (sTitle, "BkbIMAQ Hight");
					if (dBkpHight[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dBkpHight[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iIMAQBkb[indexNode] = - 1; 
				break;

				case 7:
					sprintf (sTitle, "BkbIMAQ Sym XX");
					//if (dXSym[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dXSym[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} //else iIMAQBkb[indexNode] = - 1; 
				break;

				case 8:
					sprintf (sTitle, "BkbIMAQ Sym YY");
					//if (dYSym[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dYSym[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} //else iIMAQBkb[indexNode] = - 1; 
				break;
				
				case 9:
					sprintf (sTitle, "BkbIMAQ Sym XY");
					if (dXYSym[indexNode] > 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = dXYSym[indexNode];
						iIMAQBkb[indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iIMAQBkb[indexNode] = - 1;
				break;
			}
	
		} else iIMAQBkb[indexNode] = - 1; 
	}
	
	if (iPlotIMAQBkb > 0) iPlotIMAQBkb = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphIMAQBkb, iPlotIMAQBkb, VAL_IMMEDIATE_DRAW);
	iPlotIMAQBkb = PlotXY (panel, PANEL_ANAL_grphIMAQBkb, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphIMAQBkb, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 9, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 9), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 9), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 9), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 9), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disMvPtn (int panel, int iStartingNode, int iEndNode, BackboneSet *bbs)
{
int indexNode;
double *dDisplayX, *dDisplayY;

//int iNodeCount;
int iDisplayCount = 0;

int iWhichAttribute;
char sTitle[200];
int iPositiveCount = 0; 
double dPercent;
int index;

	GetCtrlVal (panel, PANEL_ANAL_lstMvPtn, &iWhichAttribute);
	
	dDisplayX = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) );
	dDisplayY = (double *) calloc ( (iEndNode - iStartingNode + 1), sizeof (double) ); 
	
	for (indexNode = iStartingNode; indexNode <= iEndNode; indexNode++)
	{
		if (iLoop[indexNode]  != - 10)
		//if (iIsBkbp[indexNode] == 1)
		{
			switch (iWhichAttribute)
			{
			
				case 1:
					sprintf (sTitle, "Reversal Pattern");
					if (iRevese[indexNode] >= 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 						
						dDisplayY[iDisplayCount] = iRevese[indexNode] * 1.0;
						iPtnIndex [indexNode] = iDisplayCount; 
						iDisplayCount ++; 
					} else iPtnIndex [indexNode] = -1;
				break;
				
				case 2:
					sprintf (sTitle, "Forging Pattern");
					if (iForging[indexNode]  >= 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = iForging[indexNode] * 1.0;
						iPtnIndex [indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iPtnIndex [indexNode] = -1; 
				break;

				case 3:
					sprintf (sTitle, "Loop Pattern");
					if (iLoop[indexNode] >= - 1)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = iLoop[indexNode] * 1.0;
						iPtnIndex [indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iPtnIndex [indexNode] = -1; 
				break;
					
				case 4:
					sprintf (sTitle, "Sharp Turn Pattern");
					if (iTurn[indexNode] >= 0)
					{
						dDisplayX[iDisplayCount] = dTime[indexNode]; 
						dDisplayY[iDisplayCount] = iTurn[indexNode] * 1.0;
						iPtnIndex [indexNode] = iDisplayCount;
						iDisplayCount ++;
					} else iPtnIndex [indexNode] = -1; 
				break;
			}
	
		} else iPtnIndex [indexNode] = -1;  

		//iDisplayCount ++;
	}
	
	if (iPlotMvPtn > 0) iPlotMvPtn = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphMvPtn, iPlotMvPtn, VAL_IMMEDIATE_DRAW);
	iPlotMvPtn = PlotXY (panel, PANEL_ANAL_grphMvPtn, dDisplayX, dDisplayY, iDisplayCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	SetCtrlAttribute (panel, PANEL_ANAL_grphMvPtn, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 3, ATTR_LABEL_TEXT, sTitle);
	
	for (index = 0; index < iDisplayCount; index++)
	{
	 	if (dDisplayY[index] > 0) iPositiveCount++; 
	}
	
	dPercent = iPositiveCount * 100.0 / (iEndNode - iStartingNode);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (5, 3), iPositiveCount);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (6, 3), dPercent);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int disAngle (int panel, int whichNode, BackboneSet *bbs)
{

double *dDisplayX, *dDisplayY;

int iWhichAttribute;

int iNumXY;
int index;
int iWhichBkbp;
char sTitle[200];
double dMax, dMin, dMean, dSD;
int iTemp;
int iDisplayCount;

	
	if (iIsBkbp[whichNode] != 1)
	{
		if (iPlotAngle > 0) iPlotAngle = DeleteGraphPlot (panel, PANEL_ANAL_grphAngle, iPlotAngle, VAL_IMMEDIATE_DRAW);
		return 0;
	}
	
	iNumXY = bbs->NumXYpairs;  	
																	
	GetCtrlVal (panel, PANEL_ANAL_WhichBackbonePoint, &iWhichBkbp); 
	GetCtrlVal (panel, PANEL_ANAL_lstAngle, &iWhichAttribute);
	
	dDisplayX = (double *) calloc (iNumXY, sizeof (double) );
	dDisplayY = (double *) calloc (iNumXY, sizeof (double) ); 
	
	for (index = 0; index < iNumXY; index ++)
	{
		dDisplayX[index] = index * 1.0;
		
		if (iWhichAttribute == 1)
		{
			sprintf (sTitle, "Bkbv Angle[%d]", whichNode);
			dDisplayY[index] = dBkbvAngles[whichNode][index] * 1.0;
		}
		else if (iWhichAttribute == 2) 
		{
			sprintf (sTitle, "Bkbvv Angle[%d]", whichNode);
			dDisplayY[index] = dBkbvvAngle[whichNode][index] * 1.0;
		}
		else
			sprintf (sTitle, "Agl to Centroid[%d]", whichNode);
			dDisplayY[index] = dAngleToCentroid[whichNode][index] * 1.0;
	}
	
	if (iPlotAngle > 0) iPlotAngle = DeleteGraphPlot (PANEL_ANAL, PANEL_ANAL_grphAngle, iPlotAngle, VAL_IMMEDIATE_DRAW);
	
	switch (iWhichAttribute)
	{
			
		case 1:
			iPlotAngle = PlotXY (panel, PANEL_ANAL_grphAngle, dDisplayX, dDisplayY, iNumXY - 1, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
			iDisplayCount = iNumXY - 1;
		break;
				
		case 2:
			iPlotAngle = PlotXY (panel, PANEL_ANAL_grphAngle, dDisplayX, dDisplayY, iNumXY - 2, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
			iDisplayCount = iNumXY - 2;
		break;

		case 3:
			iPlotAngle = PlotXY (panel, PANEL_ANAL_grphAngle, dDisplayX, dDisplayY, iNumXY, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
			iDisplayCount = iNumXY;
		break;
					
	}

	SetCtrlAttribute (panel, PANEL_ANAL_grphAngle, ATTR_YNAME, sTitle);
	SetTableRowAttribute (panel, PANEL_ANAL_tblSpeed, 11, ATTR_LABEL_TEXT, sTitle);

	MaxMin1D (dDisplayY, iDisplayCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dDisplayY, iDisplayCount, &dMean, &dSD);

	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (1, 11), dMean);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (2, 11), dMin);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (3, 11), dMax);
	SetTableCellVal (panel, PANEL_ANAL_tblSpeed, MakePoint (4, 11), dSD);

	free (dDisplayX);
	free (dDisplayY);
	
	return 1;

}

int CVICALLBACK changeCurrentNode (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int iWhichNode;
int iIndex;
int iSet;

	switch (event)
		{
		case EVENT_COMMIT:
		
			GetCtrlVal (panel, PANEL_ANAL_numCursorIndex, &iWhichNode); 
			GetCtrlVal (panel, PANEL_ANAL_nSet, &iSet);  
			disPlayTwoImages (panel, iWhichNode, gBksForAnalysis[iSet]); 			
			disRotatedBkb (panel, iWhichNode,  gBksForAnalysis[iSet]); 
			
			if (iPlotMvPtn > 0) 
			{
				iIndex = iPtnIndex[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphMvPtn, 1, iPlotMvPtn, iIndex);
			}

			if (iPlotCenTrack > 0)
			{
				iIndex = iCentIndex[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphCenTrack, 1, iPlotCenTrack, iIndex);
			}

			if (iPlotGlb > 0)
			{
				iIndex = iGlbIndex[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphGlb, 1, iPlotGlb, iIndex);
			}

			if (iPlotLcl > 0)
			{
				iIndex = iLclIndex[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphLcl, 1, iPlotLcl, iIndex);
			}

			if (iPlotGrey > 0)
			{
				iIndex = iGrey[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphGrey, 1, iPlotGrey, iIndex);
			}

			if (iPlotMorph > 0)
			{
				iIndex = iMorph[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphMorph, 1, iPlotMorph, iIndex);
			}

			if (iPlotIMAQ > 0)
			{
				iIndex = iIMAQ[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphIMAQ, 1, iPlotIMAQ, iIndex);
			}

			if (iPlotVct > 0)
			{
				iIndex = iVct[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphVct, 1, iPlotVct, iIndex);
			}

			if (iPlotBkbvv > 0)
			{
				iIndex = iBkbvv[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphBkbvv, 1, iPlotBkbvv, iIndex);
			}

			if (iPlotWave > 0)
			{
				iIndex = iWave[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphWave, 1, iPlotWave, iIndex);
			}

			if (iPlotIMAQBkb > 0)
			{
				iIndex = iIMAQBkb[iWhichNode];   //, *iPtnIndex;
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphIMAQBkb, 1, iPlotIMAQBkb, iIndex);
			}
			
			disAngle (panel, iWhichNode, gBksForAnalysis[iSet]) ;	
			

			break;
		}
	return 0;
}

int CVICALLBACK changeBkbp (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int iStartingNode, iEndNode;
int iNumPt;
int iIndex;
int iWhichBkbp;
int iSet;
	switch (event)
		{
		case EVENT_COMMIT:

			GetCtrlVal (panel, PANEL_ANAL_StartingNode, &iStartingNode);
			GetCtrlVal (panel, PANEL_ANAL_nEndNode, &iEndNode);
			GetCtrlVal (panel, PANEL_ANAL_WhichBackbonePoint, &iWhichBkbp); 
			GetCtrlVal (panel, PANEL_ANAL_nSet, &iSet);
		
			if (iPlotAngle > 0)
			{
				GetPlotAttribute (panel, PANEL_ANAL_grphAngle, iPlotAngle, ATTR_NUM_POINTS, &iNumPt) ;
				if (iNumPt == gBksForAnalysis[iSet] -> NumXYpairs - 1) iIndex = iWhichBkbp - 1;
				else if (iNumPt == gBksForAnalysis[iSet] -> NumXYpairs - 2) iIndex = iWhichBkbp - 2;
				else if (iNumPt == gBksForAnalysis[iSet] -> NumXYpairs) iIndex = iWhichBkbp;
				else exit;
				
				if (iIndex >= 0)
				SetGraphCursorIndex (panel, PANEL_ANAL_grphAngle, 1, iPlotAngle, iIndex);
			}
			
			if (iPlotBkbRotated > 0)
			{
				SetGraphCursorIndex (panel, PANEL_ANAL_grphBkbRotated, 1, iPlotBkbRotated, iWhichBkbp);
			}
			break;
//set to it and then do it
			SetCtrlVal (panel, PANEL_ANAL_lstLcl, 3);
			SetCtrlVal (panel, PANEL_ANAL_lstVct, 0);
			SetCtrlVal (panel, PANEL_ANAL_lstWave, 2);
			
			disLcl (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disVct (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disWave (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			
		}
	return 0;
}


void CVICALLBACK PrintIt (int menuBar, int menuItem, void *callbackData,
		int panel)
{
char sMessage[300];
int iControl;
int iSet;


			//*Get the backbone Set index
			if (gBksForAnalysis == null || gAnalBkbFileLoaded == 0) 
			{
				MessagePopup ("Error!", "Load Data First!");
				goto exit;
			}//*/
			
			GetCtrlVal (panel, PANEL_ANAL_nSet, &iSet);

			iControl = GetActiveCtrl (panel);
			
			if ( (iControl == PANEL_ANAL_grphCenTrack) ||
				 (iControl == PANEL_ANAL_grphGlb) ||
				 (iControl == PANEL_ANAL_grphGrey) ||
				 (iControl == PANEL_ANAL_grphMvPtn) ||
				 (iControl == PANEL_ANAL_grphIMAQ) ||
				 (iControl == PANEL_ANAL_grphMorph) ||
				 (iControl == PANEL_ANAL_grphVct) ||
				 (iControl == PANEL_ANAL_grphBkbvv) ||
				 (iControl == PANEL_ANAL_grphWave) ||
				 (iControl == PANEL_ANAL_grphIMAQBkb) ||
				 (iControl == PANEL_ANAL_grphLcl) ||
				 (iControl == PANEL_ANAL_grphAngle) ||
				 
				 (iControl == PANEL_ANAL_tblSpeed) ||
				 (iControl == PANEL_ANAL_grphTwoImage) ||
				 (iControl == PANEL_ANAL_grphBkbRotated) )
			{
				if (iControl == PANEL_ANAL_tblSpeed) 
				{
					SetPrintAttribute (ATTR_XOFFSET, 300);
					SetPrintAttribute (ATTR_YOFFSET, 0);
					SetPrintAttribute (ATTR_PRINT_AREA_HEIGHT, VAL_USE_ENTIRE_PAPER);
					SetPrintAttribute (ATTR_PRINT_AREA_WIDTH, VAL_INTEGRAL_SCALE);
		
				} else
				{
					SetPrintAttribute (ATTR_PRINT_AREA_HEIGHT, 1000);
					SetPrintAttribute (ATTR_PRINT_AREA_WIDTH, 1000);
				}
					
				
				SetPrintAttribute (ATTR_EJECT_AFTER, 0) ;
				SetPrintAttribute (ATTR_SHOW_DATE, 1);
				SetPrintAttribute (ATTR_SHOW_PAGE_NUMBERS, 1);
				SetPrintAttribute (ATTR_COLOR_MODE, VAL_BW);

				sprintf(sMessage, "File: %s", gBksForAnalysis[iSet]->setName);
				PrintTextBuffer (sMessage, "");
				sprintf(sMessage, "WormMiner Version 1.0");
				PrintTextBuffer (sMessage, "");
   				sprintf(sMessage, "Made by Tracker Group");
				PrintTextBuffer (sMessage, "");  

				PrintCtrl (panel, iControl, "", 1, 1);
				SetPrintAttribute (ATTR_EJECT_AFTER, 1) ;

			} else 	MessagePopup ("Caution", "Choose a figure or table before I can print!");
			
exit: 	exit;

}

int CVICALLBACK setCurrentNode (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

int iCurrentCurssor;
int iPlot;
char sMessage[200];
int iCom = 0;
int iSet;

	switch (event)
		{
			case  EVENT_LEFT_CLICK :
			
			   iCom = 1;
			break;
 
			case  EVENT_RIGHT_CLICK :
				iCom = 2;
			break;
			
			case EVENT_LEFT_DOUBLE_CLICK :
				iCom = 3;
			
		}
		
		
		if (iPlotCenTrack > 0  && iCom > 1)
		{
			GetGraphCursorIndex (panel, PANEL_ANAL_grphCenTrack, 1, &iPlot, &iCurrentCurssor);
			GetCtrlVal (panel, PANEL_ANAL_nSet, &iSet);

			if (iCom == 2)
			{
				SetCtrlVal (panel, PANEL_ANAL_nEndNode, gIStartingNode + iCurrentCurssor);

			}
						
			if (iCom == 3)
			{
				SetCtrlVal (panel, PANEL_ANAL_StartingNode, gIStartingNode + iCurrentCurssor);
				SetCtrlVal (panel, PANEL_ANAL_numCursorIndex, gIStartingNode + iCurrentCurssor);
				disPlayTwoImages (panel,  gIStartingNode + iCurrentCurssor, gBksForAnalysis[iSet]); 
				disRotatedBkb (panel, gIStartingNode + iCurrentCurssor,  gBksForAnalysis[iSet]); 
				disAngle (panel, gIStartingNode + iCurrentCurssor, gBksForAnalysis[iSet]);		
				
			}
			
		}		
		
	return 0;
}

int CVICALLBACK UpdataFigures (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int iStartingNode;
int iEndNode;
int iNodeCount;
int iSet;


	switch (event)
		{
		case EVENT_COMMIT:
		
			GetCtrlVal (panel, PANEL_ANAL_StartingNode, &iStartingNode);
			GetCtrlVal (panel, PANEL_ANAL_nEndNode, &iEndNode);
			GetCtrlVal (panel, PANEL_ANAL_nSet, &iSet); 

			if (gAnalBkbFileLoaded == 0 || gBksForAnalysis[iSet] == null)
			{
				MessagePopup ("Error", "No backbone set available yet!");
				return 1;
			}		

			iNodeCount = gBksForAnalysis[iSet]->NodeCount;

			if (iStartingNode < 0 || iEndNode >= iNodeCount)
			{
				MessagePopup ("Error", "Out of range.");
				return 1;
			}
		
			disPlayTrack (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);   
			disPlayTwoImages (panel, iStartingNode, gBksForAnalysis[iSet]); 			
			disRotatedBkb (panel, iStartingNode,  gBksForAnalysis[iSet]); 
			disAngle (panel, iStartingNode, gBksForAnalysis[iSet]);		

				

			disGlb (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disGrey (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disMorph (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disIMAQ (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disLcl (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disVct (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disBkbvv (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disWave (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disIMAQBkb (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);
			disMvPtn (panel, iStartingNode, iEndNode, gBksForAnalysis[iSet]);

			break;
		}
	return 0;
}




int writeToAccess (int panel, BackboneSet * bbs, int hdbc, int *resCode)
{

int iTotalNodes, iNumXY;
char fileName[MAX_FILENAME_LEN];
char sMessage[200];

//int hdbc = 0;       //* Handle to database connection    */
//int resCode; 
int hstmt;
int numRecs = 0;

char ExpID[MAX_FILENAME_LEN]; 
int iSLength;
char SQL[600];

//* Result code */
//for static calculation
double dAve, dMax, dMin, dTemp;
int iTemp;

//*gValidNode
int iLoop1f, iLoop2f, iLoop3f, iForgingf, iTurnf, iReversalf;
double dLoop1, dLoop2, dLoop3, dForging, dTurn, dReversal; 


//Temporay new feature
double dU10Speed, dL10Speed, dMPSpeed, dPMPSpeed;
double dU10Area, dL10Area, dMPArea, dPMPArea;
//double dU10Area, dL10Area, dMPArea, dPMPArea;

//reversal
double *dReversalDistance; 
int iCount;

double *dMax1, *dMin1, *dAve1;
int indexCalTech;


	strcpy(fileName, bbs->setName) ; 
			
	iTotalNodes = bbs-> NodeCount;
	iNumXY = bbs-> NumXYpairs;
			
	SplitPath (fileName, NULL, NULL, fileName);
	iSLength = strlen (fileName);
	memset (ExpID, '\0', MAX_FILENAME_LEN);
	strncpy (ExpID, fileName, iSLength - 4);
		
 	sprintf(SQL, "SELECT * FROM BasicStatistic WHERE ExpID = '%s'" , ExpID);
    		
    hstmt = DBActivateSQL(hdbc, SQL);

    numRecs = DBNumberOfRecords(hstmt);
    		
    if (numRecs != 0)
    {
 		sprintf(sMessage, "\nThere is a record with ExpID of %s. \nTherefore record is NOT inserted", ExpID);
		InsertTextBoxLine (panel, PANEL_ANAL_SET_NAMES, -1, sMessage);
    	return 0;
    }
						   
   	*resCode = DBDeactivateSQL(hstmt);
    
 	sprintf(SQL, "INSERT INTO BasicStatistic (ExpID)  VALUES ('%s')" , ExpID);
   	*resCode = DBImmediateSQL(hdbc, SQL); 
   	if (*resCode != DB_SUCCESS) 
   	{
   		MessagePopup("Database Error",DBErrorMessage());
   		//goto disconnect;
   		return 0;
   	}  

	getMvPtnStatistic (iTotalNodes, &iLoop1f, &iLoop2f, &iLoop3f, &iReversalf, &iForgingf, &iTurnf);
	
	//for (index = 0; index < gValidNode	
	dLoop1 = iLoop1f * 1.0 / gValidNode ;
	dLoop2 = iLoop2f * 1.0 / gValidNode ;
	dLoop3 = iLoop3f * 1.0 / gValidNode ;
	dReversal = iReversalf * 1.0 / gValidNode ;
	dForging = iForgingf * 1.0 / gValidNode ;
	dTurn = iTurnf * 1.0 / gValidNode ;
	writeAccessData ("loop1", "loop2", "loop3", dLoop1, dLoop2, dLoop3, hdbc, resCode, ExpID);
	writeAccessData ("reversal", "forging", "turn", dReversal, dForging, dTurn, hdbc, resCode, ExpID);

//*Example of get statitistics and save it
	getStatistic (gSpeed, iTotalNodes, &dAve, &dMax, &dTemp, 0, 1, 1, 0.0, 0, 0);
	writeAccessData ("GlbSpdAve", "GlbSpdMax", "GlbMvScope", dAve, dMax, gScope, hdbc, resCode, ExpID);

//Repeat to save all						 
	getStatistic (lclSpeedAverage, iTotalNodes, &dAve, &dMax, &dTemp, 1, 0, 1, - 1, 1, 10);
	getStatistic (dPushing, iTotalNodes, &dMin, &dTemp, &dTemp, 1, 0, 1, 0.0, 1, 100);
	writeAccessData ("LclspdAve", "LclSpdMax", "Pushing", dAve, dMax, dMin, hdbc, resCode, ExpID); 
			
	getStatistic (dBkbvvAngleAverage, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, - 181, 0, 0);
	writeAccessData ("BkvvAglAveAve", "BkvvAglAveMax", "BkvvAglAveMin",dAve, dMax, dMin, hdbc, resCode, ExpID);  
			
	getStatistic (dBkbvvAngleMaxium, iTotalNodes, &dMax, &dMin, &dTemp, 1, 0, 1, - 181, 0, 0);
	getStatistic (dBkbpHeadToTail, iTotalNodes, &dAve, &dTemp, &dTemp, 1, 0, 1, 0.0, 1, 100);  
	writeAccessData ("HdTlRatio", "BkvvAglMaxAve", "BkvvAglMaxMax", dAve, dMax, dMin, hdbc, resCode, ExpID);  
			
	getStatistic (dBkbvAngleAverage, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, - 3.15, 0, 0);  
	writeAccessData ("BkvAglAveAve", "BkbAglAveMax", "BkvAglAveMin", dAve, dMax, dMin, hdbc, resCode, ExpID);  
			
	getStatistic (dBkbvDistMinToBackboneLength, iTotalNodes, &dAve, &dMax, &dTemp, 1, 0, 1, 0.0, 0, 0);   
//int getStatistic (double * dArray, int iTotal, double *Ave, double *Max, double *Min, int checkBkp, int checkNull, int isLowLimit, double dLowLimit, int isHighLimit, double dHighLimit)

	getStatistic (dArea, iTotalNodes, &dMin, &dTemp, &dTemp, 0, 1, 1, 0.0, 0, 10000);   
	writeAccessData ("BkvDisMinToLengthAve", "BkvDisMinToLengthMin", "Area", dAve, dMax, dMin, hdbc, resCode, ExpID);  
 			
 	getStatistic (dBkbvDistAveToBackboneLength, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 1, 100);  
 	writeAccessData ("BkvDisAveToLengthAve", "BkvDisAveToLengthMax", "BkvDisAveToLengthMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
 			
 	getStatistic (dBkbvDistMaxToBackboneLength, iTotalNodes, &dAve, &dMax, &dTemp, 1, 0, 1, 0.0, 1, 100);   
 	getStatistic (dWormLength, iTotalNodes, &dMin, &dTemp, &dTemp, 0, 1, 1, 0, 0, 0); 
 	writeAccessData ("BkvDisMaxToLengthAve", "BkvDisMaxToLengthMax", "Length", dAve, dMax, dMin, hdbc, resCode, ExpID);
 			
 	getStatistic (dMaxIntercept, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0); 
 	writeAccessData ("MaxInterceptAve", "MaxInterceptMax", "MaxInterceptMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
 			
 	getStatistic (dTransparency, iTotalNodes, &dAve, &dTemp, &dTemp, 0, 1, 1, 0.0, 0, 0); 
 	getStatistic (dFatness, iTotalNodes, &dMax, &dTemp, &dTemp, 0, 1, 1, 0.0, 0, 0); 
 	getStatistic (dThickness, iTotalNodes, &dMin, &dTemp, &dTemp, 0, 1, 1, 16, 0, 0);   
 	writeAccessData ("Transparency", "Fatness", "Thickness", dAve, dMax, dMin, hdbc, resCode, ExpID);
 			
 	getStatistic (dMeanInterceptPerpendicular, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0); 
 	writeAccessData ("MeanIntcptPpdclAve", "MeanIntcptPpdclMax", "MeanIntcptPpdclMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	getStatistic (dEquivalenceEllipsRatio, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);
	writeAccessData ("EqvlEllRatioAve", "EqvlEllRatioMax", "EqvlEllRatioMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 			
			
	getStatistic (dEllipsMajorAxis, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);
	writeAccessData ("EllMAxisAve", "EllMAxisMax", "EllMAxisMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
			
	getStatistic (dEllipsRatio, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0); 
	writeAccessData ("EllRatioAve", "EllRatioMax", "EllRatioMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
			
	getStatistic (dElongationFactor, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);   
	writeAccessData ("ElgFactorAve", "ElgFactorMax", "ElgFactorMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
			
	getStatistic (dCompactnessFactor, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0); 
	writeAccessData ("CmptFactorAve", "CmptFactorMax", "CmptFactorMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
			
	getStatistic (dHeywoodCicularityFactor, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);  
	writeAccessData ("HeywoodAve", "HeywoodMax", "HeywoodMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	getStatistic (dTypeFactor, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);
	writeAccessData ("TypeFactorAve", "TypeFactorMax", "TypeFactorMin", dAve, dMax, dMin, hdbc, resCode, ExpID);			
			
	getStatistic (dHydraulicRadius, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);  
	writeAccessData ("HydraulicAve", "HydraulicMax", "HydraulicMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
			
	getStatistic (dWaddelDiskDiameter, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0); 
	writeAccessData ("WaddelAve", "WaddelMax", "WaddelMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 			

	getStatistic (dIXX, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0); 
	writeAccessData ("IXXAve", "IXXMax", "IXXMin", dAve, dMax, dMin, hdbc, resCode, ExpID);  			
			
	getStatistic (dIYY, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);
	writeAccessData ("IYYAve", "IYYMax", "IYYMin", dAve, dMax, dMin, hdbc, resCode, ExpID);  
	
//Arreor could be here. There is a lower error control.  Which might not be suitable.  Consider removing it.			
	getStatistic (dIXY, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0); 
	writeAccessData ("IXYAve", "IXYMax", "IXYMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
			
	getStatistic (dBkpElgFactor, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 0, 0); 
	writeAccessData ("BkbElgFactorAve", "BkbElgFactorMax", "BkbElgFactorMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	getStatistic (dCmpctFactor, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 0, 0);
	writeAccessData ("BkbCmptFactorAve", "BkbCmptFactorMax", "BkbCmptFactorMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	getStatistic (dBkpHight, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 0, 0); 
	writeAccessData ("BkbHightAve", "BkbHightMax", "BkbHightMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	getStatistic (dXSym, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 0, 0, 0, 0);    
	writeAccessData ("XSymAve", "XSymMax", "XSymMin", dAve, dMax, dMin, hdbc, resCode, ExpID);			
			
	getStatistic (dYSym, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 0, 0, 0, 0); 
	writeAccessData ("YSymAve", "YSymMax", "YSymMin", dAve, dMax, dMin, hdbc, resCode, ExpID);			
			
	getStatistic (dXYSym, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 0, 0, 0, 0);  
	writeAccessData ("XYSymAve", "XYSymMax", "XYSymMin", dAve, dMax, dMin, hdbc, resCode, ExpID);			
			
	getStatistic (dBkpDXX, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 0, 0); 
	writeAccessData ("bkbIXXAve", "bkbIXXMax", "bkbIXXMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	getStatistic (dBkpDYY, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 0, 0); 
	writeAccessData ("bkbIYYAve", "bkbIYYMax", "bkbIYYMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	getStatistic (dBkpDXY, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 0, 0); 
	writeAccessData ("bkbIXYAve", "bkbIXYMax", "bkbIXYMin", dAve, dMax, dMin, hdbc, resCode, ExpID);
			
	//"LengthToPixel" dLengthToPixelNumber
	getStatistic (dLengthToPixelNumber, iTotalNodes, &dAve, &dMax, &dMin, 1, 0, 1, 0.0, 0, 0); 
	writeAccessData ("LengthToPixelAve", "LengthToPixelMax", "LengthToPixelMin", dAve, dMax, dMin, hdbc, resCode, ExpID);

//forget
	getStatistic (dRectBigSide, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);
	writeAccessData ("RectBigSideAve", "RectBigSideMax", "RectBigSideMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 

	getStatistic (dRectRatio, iTotalNodes, &dAve, &dMax, &dMin, 0, 1, 1, 0.0, 0, 0);
	writeAccessData ("RectRatioAve", "RectRatioMax", "RectRatioMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 

//The new feature 09/04/2002
  
	getSPC (gSpeed, iTotalNodes, &dU10Speed, &dL10Speed, &dMPSpeed, &dPMPSpeed);
	getSPC (dArea, iTotalNodes, &dU10Area, &dL10Area, &dMPArea, &dPMPArea);

	writeAccessData ("Top10Speed", "Low10Speed", "MostPopularSpeed", dU10Speed, dL10Speed, dMPSpeed, hdbc, resCode, ExpID);
	writeAccessData ("Top10Area", "Low10Area", "MostPopularArea", dU10Area, dL10Area, dMPArea, hdbc, resCode, ExpID);
	writeAccessData ("PercentageMPSpeed", "PercentageMPArea", "TotalTravelDistance", dPMPSpeed, dPMPArea, gTotalDistance, hdbc, resCode, ExpID);
//
//more reversal
//new feature 10/05/2002   
//JF 2004This shoudl give goto something else and output to 
	dReversalDistance = (double *)malloc(iTotalNodes * sizeof (double));
	iCount = countReversal (iRevese,iTotalNodes, gMovingDistances, dReversalDistance) ;

	MaxMin1D (dReversalDistance, iCount, &dMax, &iTemp, &dMin, &iTemp);
	StdDev (dReversalDistance, iCount, &dAve, &dTemp);
	writeAccessData ("ReversalCount", "ReversalDisAve", "ReversalDisMax", (iCount * 1.0)/gValidNode, dAve, dMax, hdbc, resCode, ExpID);

	free (dReversalDistance);
	
//New feature 2004  should go to excel too and should combined .   Call simplely put into Get
	 //SktWidthAve
	 //foragingDistance
	 //Somegthing wrong here
	getStatistic (dForagingDis,iTotalNodes, &dAve, &dMax, &dMin, 1, 1, 1, 0.0, 0, 0);
	writeAccessData ("SktWidthAve", "SktWidthMax", "SktWidthMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 

	getStatistic (dForagingDis,iTotalNodes, &dAve, &dMax, &dMin, 1, 1, 1, 0.0, 0, 0);
	writeAccessData ("foragingDistanceAve", "foragingDistanceMax", "foragingDistanceMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 

	getStatistic (dForagingAlg,iTotalNodes, &dAve, &dMax, &dMin, 1, 1, 1, -500.0, 1, 500);
	//iOmega is going here with that.
	writeAccessData ("foragingAlgAve", "foragingAlgMax", "Omega", dAve, dMax, iOmegaCount, hdbc, resCode, ExpID); 


//Write CalTechData //redesign the database
//forget
	getStatistic (dWavlength, iTotalNodes, &dAve, &dMax, &dMin, 1, 1, 1, 0.0, 0, 0);
	writeAccessData ("WavLengAve", "WavLengMax", "WavLengMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 

	getStatistic (dAmpt, iTotalNodes, &dAve, &dMax, &dMin, 1, 1, 1, 0.0, 0, 0);
	writeAccessData ("AmptAve", "AmptMax", "AmptMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 

//double *dMax1, *dMin1, *dAve1;
//int indexCalTech;
//CalTech, Chris's staff
//	if (iCalTech == 1)
//	{
		dMax1 = (double *)malloc(iTotalNodes * sizeof (double));
		dMin1 = (double *)malloc(iTotalNodes * sizeof (double));
		dAve1 = (double *)malloc(iTotalNodes * sizeof (double));
	
		for (indexCalTech = 0; indexCalTech < iTotalNodes; indexCalTech++)
		{	 //does not mmatther whether the last two is not there
			getStatistic (dFlex[indexCalTech], iNumXY-2, &dAve1[indexCalTech], &dMax1[indexCalTech], &dMin1[indexCalTech], 1, 1, 1, 0.0, 0, 0);
		}

		Mean (dMax1, iTotalNodes, &dMax);
		Mean (dMin1, iTotalNodes, &dMin);
		Mean (dAve1, iTotalNodes, &dAve);
		writeAccessData ("FLEXAve", "FLEXMax", "dFLEXMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 


		for (indexCalTech = 0; indexCalTech < iTotalNodes; indexCalTech++)
		{
			//It does not matter 
			getStatistic (dFRE[indexCalTech], iNumXY-2, &dAve1[indexCalTech], &dMax1[indexCalTech], &dMin1[indexCalTech], 1, 1, 1, 0.0, 0, 0);
		}

		Mean (dMax1, iTotalNodes, &dMax);
		Mean (dMin1, iTotalNodes, &dMin);
		Mean (dAve1, iTotalNodes, &dAve);
		writeAccessData ("FREAve", "FREMax", "FREMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
//		writeAccessData ("AmptAve", "AmptMax", "AmptMin", dAve, dMax, dMin, hdbc, resCode, ExpID); 
	
		free (dMax1);
		free (dMin1);
		free (dAve1);

//	}

//Telling user
 	sprintf(sMessage, "\nRecord %s. saved", ExpID);
	InsertTextBoxLine (panel, PANEL_ANAL_SET_NAMES, -1, sMessage);
	goto break1;

Error:
    		
    MessagePopup ("Error", DBErrorMessage());
    return 0;
                  
break1:    

	return 1;
	
}


int CVICALLBACK writeAccessExcel (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
HRESULT error = 0;
int iDubug;
int hdbc;
int resCode;
int indexSet;
int iNumXY, iNumImage;
int iExcel, iAccess;


	switch (event)
		{
		case EVENT_COMMIT:
		
			//Get the backbone Set index
			if (gBksForAnalysis == null || gAnalBkbFileLoaded == 0) 
			{
				MessagePopup ("Error!", "Load Data First!");
				return 1;
			}
			//connect database here
			hdbc = DBConnect ("DSN=wormBehaviror");
    		
    		if (hdbc <= 0) 
    		{
    			MessagePopup ("Error", DBErrorMessage());
    			return 0;
			}
			
			InsertTextBoxLine (panel, PANEL_ANAL_SET_NAMES, -1, "\nSuccessfully connected to database: wormBehaviror");

			DBSetBackwardCompatibility(200);
			
			//Open a new excel application
			//*excel
			Excel_NewApp (NULL, 1, LOCALE_NEUTRAL, 0, &ExcelAppHandle);
			//excelLaunched = 1;
			
			SetWaitCursor (1); 
			
			//Get information whether writ excel or access
			GetCtrlVal (panel, PANEL_ANAL_radioAccess, &iAccess);
			GetCtrlVal (panel, PANEL_ANAL_radioExcel, &iExcel);
			
 			//*/
 			for (indexSet = 0; indexSet < gFileNumber; indexSet ++)
			{
			   	unloadAll(gCurrentNodeNumber);
			   	iNumXY = gBksForAnalysis[indexSet]->NumXYpairs;
			   	iNumImage = gBksForAnalysis[indexSet]->NodeCount;  
			   	
				initiate (iNumXY, iNumImage);  
				gCurrentNodeNumber = iNumImage;
				SetCtrlVal (panel, PANEL_ANAL_nSet, indexSet);
				
//set the start node nuber  = 0
				SetCtrlVal (panel, PANEL_ANAL_StartingNode, 0);
				SetCtrlAttribute (panel, PANEL_ANAL_StartingNode, ATTR_MAX_VALUE, iNumImage - 2) ;
//set the end numb er = iNumXY -1;
//set hte max of end = iNumXY - 1;
				SetCtrlVal (panel, PANEL_ANAL_nEndNode, iNumImage - 1);
				SetCtrlAttribute (panel, PANEL_ANAL_nEndNode, ATTR_MAX_VALUE, iNumImage - 1);

//set the current Node to 0;
//set the max of current node = iNumXY - 1;
				SetCtrlVal (panel, PANEL_ANAL_numCursorIndex, 0);
				SetCtrlAttribute (panel, PANEL_ANAL_numCursorIndex, ATTR_MAX_VALUE, iNumImage - 1);

//get data do not need to be further calculate.
				splitBackbone (gBksForAnalysis[indexSet], &gValidNode, &gIsBkpCount);  
				RotateBackbone (gBksForAnalysis[indexSet]);  
				GetGlbMvData (gBksForAnalysis[indexSet]);
				GetLclMvData (gBksForAnalysis[indexSet]); 
				GetBkbvvData (gBksForAnalysis[indexSet]);
				GetBkbAnalysisData (gBksForAnalysis[indexSet]); 

//should remove
//CalTech
				//if (iNumXY == 25)
				GetCalTechData (gBksForAnalysis[indexSet]);   
				GetAdditionalData1 (gBksForAnalysis[indexSet]);
			
				//User interface
				disPlayTrack (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);   
				disPlayTwoImages (panel, 0, gBksForAnalysis[indexSet]); 			
				disRotatedBkb (panel, 0,  gBksForAnalysis[indexSet]); 

				disGlb (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disGrey (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disMorph (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disIMAQ (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disLcl (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disVct (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disBkbvv (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disWave (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disIMAQBkb (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disMvPtn (panel, 0, iNumImage - 1, gBksForAnalysis[indexSet]);
				disAngle (panel, 0, gBksForAnalysis[indexSet]);
				
				if (iAccess == 1) writeToAccess (panel, gBksForAnalysis[indexSet], hdbc, &resCode);
				if (iExcel == 1)writeExcelData (panel, gBksForAnalysis[indexSet]);
			}

        	/*
        	if (excelLaunched == 1) 
        	{
            	// Quit the Application
           		Excel_ActiveApp (NULL, 1, LOCALE_NEUTRAL, 0, &ExcelAppHandle);
            	error = Excel_AppQuit (ExcelAppHandle, NULL);
       		 }
       		 
        	excelLaunched = 0;
        	//*/
        	//*excle
     		if (ExcelAppHandle) {
     		
     		//CA_VariantClear(&myVariant); //causing error.  To lazy to debug this.
     		CA_DiscardObjHandle (ExcelAppHandle);  
     		}
     		
     		ExcelAppHandle = 0;
			//*/
//disconnent here
disconnect:
    		resCode = DBDisconnect (hdbc);
   			if (resCode != DB_SUCCESS) 
   			{
  				MessagePopup("Database Error",DBErrorMessage());	
				InsertTextBoxLine (panel, PANEL_ANAL_SET_NAMES, -1, "\nDisconnected error");
   				goto Error;
   			} 


			InsertTextBoxLine (panel, PANEL_ANAL_SET_NAMES, -1, "\nSuccessfully disconnected from database: wormBehaviror");

     		
Error:		SetWaitCursor (0); 
			MessagePopup ("Message", "Work is done!");
  			
			break;
		}
	return 0;
}

int writeExcelData (int panel, BackboneSet * bbs)
{

int iTotalNodes, iNumXY;
char fileName[MAX_FILENAME_LEN];
int iSLength ;
char sSaveName[MAX_FILENAME_LEN];

HRESULT error = 0;
VARIANT myTitle;
VARIANT myNum;

char sMessage[200];
int index;

	strcpy(fileName, bbs->setName) ; 
			
	iTotalNodes = bbs-> NodeCount;
	iNumXY = bbs-> NumXYpairs;
			
	SplitPath (fileName, NULL, NULL, fileName);
	iSLength = strlen (fileName);
	memset (sSaveName, '\0', MAX_FILENAME_LEN);
	strncpy (sSaveName, fileName, iSLength - 4);


//application is already there
//	Excel_NewWorkbook (NULL, 1, LOCALE_NEUTRAL, 0, &ExcelAppHandle);
	//Get Excel workbooks object
    error = Excel_GetProperty (ExcelAppHandle, NULL, Excel_AppWorkbooks, CAVT_OBJHANDLE, &ExcelWorkbooksHandle);
    if (error < 0) MessagePopup ("Error", "some thing is wrong!");

    // Add Workbook and make it active - by default, 3 sheets will be created
    error = Excel_WorkbooksAdd (ExcelWorkbooksHandle, NULL, CA_DEFAULT_VAL, &ExcelWorkbookHandle);
	Excel_SetProperty (ExcelAppHandle, NULL, Excel_AppVisible, CAVT_BOOL, VTRUE);

    // Get Active Workbook Sheets
    error = Excel_GetProperty (ExcelWorkbookHandle, NULL, Excel_AppSheets, CAVT_OBJHANDLE, &ExcelSheetsHandle);
         
    // Add more sheet and Get First Sheet
    
//	for (index = 0; index < 9; index ++)
//CalTech	   add two more sheets
	//for (index = 0; index < 11; index ++)
//new feature1	   add one more sheet
	for (index = 0; index < 12; index ++)
	{
		error = Excel_WorksheetsAdd (ExcelSheetsHandle, NULL,
						CA_DEFAULT_VAL, CA_DEFAULT_VAL,
						CA_DEFAULT_VAL, CA_DEFAULT_VAL,
						&ExcelWorksheetHandle);
	}
//New Feature


//Save data here
//finish all here

//why index starts from 1, we will see??
//CalTech
//	for (index = 1; index < 12; index ++)
//new feature
//	for (index = 1; index < 14; index ++)
	for (index = 1; index < 15; index ++)
	{
		//get the work sheet handler
        error = Excel_SheetsItem (ExcelSheetsHandle, NULL, CA_VariantInt(index), &ExcelWorksheetHandle);
                    	
        switch (index)
        {
           case 1:
           		//here prepare the sheet title
                sprintf (sMessage, "Global Movement");
                //write to this sheet
                writeGlbData (ExcelWorksheetHandle, iTotalNodes, iNumXY) ; 
           break;

           case 2:
               	sprintf (sMessage, "GreyImage Anal.");
				writeBasicImageAnalysisData (ExcelWorksheetHandle, iTotalNodes, iNumXY);
           break;
                	
           case 3:
                sprintf (sMessage, "Beh Pattern");
               	writeMvPtnData (ExcelWorksheetHandle, iTotalNodes, iNumXY) ;
           break;
                	
           case 4:
                sprintf (sMessage, "IMAQ");
                writeIMAQ (ExcelWorksheetHandle, iTotalNodes, iNumXY) ;
           break;
                	
           case 5:
                sprintf (sMessage, "Morphology");
                writeMorphology (ExcelWorksheetHandle, iTotalNodes, iNumXY) ;
           break;
                	
           case 6:
                sprintf (sMessage, "Vector Anal.");
                writeBackboneVector (ExcelWorksheetHandle, iTotalNodes, iNumXY) ; 
           break;
                	
           case 7:
                sprintf (sMessage, "Bkbvv Anal.");
                writeBackbonePosture (ExcelWorksheetHandle, iTotalNodes, iNumXY) ; 
           break;
                	
           case 8:
              	sprintf (sMessage, "Bkb IMAQ");
             	writeQuantitativeImageAnalysis (ExcelWorksheetHandle, iTotalNodes, iNumXY) ;
           break;

           case 9:
                sprintf (sMessage, "Lcl Mv");
                writeLocalMovementAnalysis (ExcelWorksheetHandle, iTotalNodes, iNumXY); 
           break;

           case 10:
                sprintf (sMessage, "Angle Anal.");
                writeBackbonePointAnalysis (ExcelWorksheetHandle, iTotalNodes, iNumXY);
           break;

           case 11:
                sprintf (sMessage, "Coordinates");
                saveCoordinates (ExcelWorksheetHandle, iTotalNodes, iNumXY) ;
           break;

//CalTech
           case 12:
         
           		//here prepare the sheet title
                sprintf (sMessage, "CalTech1");
                //write to this sheet
 //               if (iCalTech == 1)
                writeCalTech1 (ExcelWorksheetHandle, iTotalNodes, iNumXY) ; 
           break;

           case 13:
           		//here prepare the sheet title
                sprintf (sMessage, "CalTech2");
                //write to this sheet
//should be removed.
 //               if (iCalTech == 1)
                writeCalTech2 (ExcelWorksheetHandle, iTotalNodes, iNumXY) ; 
           break;
           
           case 14:
           		sprintf (sMessage, "Additional Data1");
           		writeAdditionalData1 (ExcelWorksheetHandle, iTotalNodes, iNumXY);
           		
    	} //swith


     	//set sheet name    
		Excel_SetProperty (ExcelWorksheetHandle, NULL, Excel_QueryTableName,
						CAVT_CSTRING, sMessage);

    	//Get range string
    	error = CA_VariantSetCString (&MyCellRangeV, "A1:C5" );
    	//Set range
    	error = Excel_WorksheetRange (ExcelWorksheetHandle, NULL, MyCellRangeV, CA_DEFAULT_VAL, &ExcelRangeHandle);
		//Active range
		error = Excel_RangeActivate (ExcelRangeHandle, NULL, NULL); 
	   			
   		sprintf (sMessage, "Worm behaverial miner raw data");
    	CA_VariantSetCString(&myTitle, sMessage );
    	error = Excel_RangeSetItem (ExcelRangeHandle, NULL, CA_VariantInt (1), CA_VariantInt (1), myTitle);
   			
    	sprintf (sMessage, "Made by wormTrackerGroup (John Feng/Chris Cronin)");
    	CA_VariantSetCString(&myTitle, sMessage );
    	error = Excel_RangeSetItem (ExcelRangeHandle, NULL, CA_VariantInt (2), CA_VariantInt (1), myTitle);

		//write TotalNodes
    	sprintf (sMessage, "Total Node");
    	CA_VariantSetCString(&myTitle, sMessage );
    	error = Excel_RangeSetItem (ExcelRangeHandle, NULL, CA_VariantInt (4), CA_VariantInt (1), myTitle);
    	CA_VariantSetInt(&myNum, iTotalNodes );
    	error = Excel_RangeSetItem (ExcelRangeHandle, NULL, CA_VariantInt (4), CA_VariantInt (2), myNum);

		//write iNumXY
    	sprintf (sMessage, "Bkbp Number");
    	CA_VariantSetCString(&myTitle, sMessage );
    	error = Excel_RangeSetItem (ExcelRangeHandle, NULL, CA_VariantInt (5), CA_VariantInt (1), myTitle);
    	CA_VariantSetInt(&myNum, iNumXY );
    	error = Excel_RangeSetItem (ExcelRangeHandle, NULL, CA_VariantInt (5), CA_VariantInt (2), myNum);

	}//for loop				   
 
//save the file
	SaveAppFile (sSaveName, ExcelWorkbookHandle) ;
    
  	CA_VariantClear(&MyCellRangeV);
    CA_VariantClear(&myTitle);
    CA_VariantClear(&myNum);   
  
//close this workbook, work range, and clean up for later use
    if ( (&ExcelRangeHandle) && ExcelRangeHandle) CA_DiscardObjHandle (ExcelRangeHandle);  
    		if ( (&ExcelWorksheetHandle) && ExcelWorksheetHandle) CA_DiscardObjHandle (ExcelWorksheetHandle);  
    		if ( (&ExcelSheetsHandle) && ExcelSheetsHandle) CA_DiscardObjHandle (ExcelSheetsHandle);  
        	if (ExcelWorkbookHandle) 
        	{
    			
            	// Close workbook without saving
            	error = Excel_WorkbookClose (ExcelWorkbookHandle, NULL, CA_VariantBool (VFALSE), 
                            CA_DEFAULT_VAL, CA_VariantBool (VFALSE));

        		CA_DiscardObjHandle (ExcelWorkbookHandle); 
        		ExcelWorkbookHandle = 0;
                        
        	}
    
    		if ( (&ExcelWorkbooksHandle) && ExcelWorkbooksHandle) CA_DiscardObjHandle (ExcelWorkbooksHandle);  
    
    		ExcelRangeHandle = 0;
    		ExcelWorksheetHandle = 0;
			ExcelSheetsHandle = 0;
			ExcelWorkbookHandle = 0;
			ExcelWorkbooksHandle = 0;
    
		
	return 1;
}

int getStatistic (double * dArray, int iTotal, double *Ave, double *Max, double *Min, int checkBkp, int checkNull, int isLowLimit, double dLowLimit, int isHighLimit, double dHighLimit)
{

int iCount = 0;
int index;

double *dTemp;
int iSatisfied = 0;
int iPassed = 0;
double Temp;
int iTemp;

int i5Percent;
double *dUpper, *dLower;
int iMax, iMin;
double dMax, dMin;

	if( (checkBkp == 1 && checkNull == 1) || (checkBkp == 0 && checkNull == 0))
	{
		MessagePopup ("Parameter error", "These two should NOT be one at the same time!");
		return 0;
	}
	
	i5Percent = floor (iTotal * 0.05);
	
	dTemp = (double *)malloc (iTotal * sizeof (double));
	
	for (index = 0; index < iTotal; index++)
	{
		if ( checkBkp == 1 && iIsBkbp[index] == 1 ) iSatisfied = 1;
		else if ( checkNull == 1 && iLoop[index]  != - 10) iSatisfied = 1;
		else iSatisfied = 0;
		
		if (iSatisfied == 0) goto exit;
		
		iPassed = 0;
		if (iSatisfied == 1) 
		{
			if ( (isLowLimit == 1) && (isHighLimit == 1) )
			{
			 	if (dArray[index] > dLowLimit && dArray[index] < dHighLimit)
			 	iPassed = 1;
			}else
			if ( (isLowLimit == 1) && (isHighLimit == 0) )
			{
			 	if (dArray[index] > dLowLimit)
			 	iPassed = 1;
			}else
			if ( (isLowLimit == 0) && (isHighLimit == 1) )
			{
			 	if (dArray[index] < dHighLimit)
			 	iPassed = 1;
			}else
			
			if ( (isLowLimit == 0) && (isHighLimit == 0) )
			{
			 	iPassed = 1;
			}
		}
		
		if (iPassed == 0) goto exit;

		if (iPassed == 1)
		{
			dTemp[iCount] = dArray[index];
			iCount ++;
		}
		
exit:	exit;

	} 
	
	
//need replace top 5% instead of Max and low 5% instead of Min
	dUpper = (double *)malloc(i5Percent * sizeof(double));
	dLower = (double *)malloc(i5Percent * sizeof(double));

	if (iCount != 0)
	{
	
		MaxMin1D (dTemp, iCount, &dMax, &iTemp, &dMin, &iTemp);
	}
	else 
	{
		*Max = -1.0;
		*Min = -1.0;
		*Ave = - 1.0;
		
		return 0;
	
	}

	Set1D (dUpper, i5Percent, dMin - 20);
	Set1D (dLower, i5Percent, dMax + 20);

	for (index = 0; index < iCount; index ++)
	{
		MaxMin1D (dUpper, i5Percent, &Temp, &iTemp, &dMin, &iMin);
		MaxMin1D (dLower, i5Percent, &dMax, &iMax, &Temp, &iTemp);
		
		if (dTemp[index] >= 0)
		{
			if (dMin < dTemp[index]) dUpper[iMin] = dTemp[index];
			if (dMax > dTemp[index]) dLower[iMax] = dTemp[index];
		}
	}
	
	Mean (dUpper, i5Percent, Max);
	Mean (dLower, i5Percent, Min);
	
	StdDev (dTemp, iCount, Ave, &Temp);

	free (dUpper);
	free (dLower);

	free (dTemp);
	
	return 1;
}



int getMvPtnStatistic (int iTotal, int *loop1f, int *loop2f, int *loop3f, int *reversalf, int *forgingf, int *turnf)
{

int index;


	*loop1f = 0;
	*loop2f = 0;
	*loop3f = 0;
	*reversalf = 0;
	*forgingf = 0;
	*turnf = 0;

	for (index = 0; index < iTotal; index++)
	{
		if (iLoop[index]  != - 10)
		{
		
			if (iRevese[index] > 0) *reversalf = *reversalf + 1;
			if (iForging[index]  > 0) *forgingf = *forgingf + 1;
			if (iLoop[index] == 1)
			{	
				*loop1f = *loop1f + 1;
			}else
			if (iLoop[index] == 2) 
			{
				*loop2f = *loop2f + 1;
			} else
			if (iLoop[index] == 3)
			{
				*loop3f = *loop3f + 1;
			}
			
			if (iTurn[index] > 0) *turnf = *turnf + 1;
		}
	} 
	
	return 1;
}

/*

int GetCalTechData (BackboneSet *bbs)  //remember call it after call other gets
//int GetBkbAnalysisData (BackboneSet *bbs) 
//int ExtrapolateCalTechFeature (int iNumImage, int iNumXY, double **dX, double **dY, double **dBkvvAgle, double  )
{
int index;
int index1;

mxArray *thisX;
mxArray *thisY;
mxArray *thisMMPS;
mxArray **thisWavelength;
mxArray *thisAmpt;

//arrow Control
mxArray *thisIsBkp;

mxArray *thisFRE;
mxArray *thisJunk;
mxArray *thisFlex;
mxArray *thisSpc;

mxArray *thisAngle;

int *iTemp;


//Will be funciton input
int iNumImage = 500, iNumXY = 13;


//Glb data
double **dThisX;
double **dThisY;
double **dThisBkbAgle;

int iThisFrameRate = 2;


	iNumImage = bbs->NodeCount;
	iNumXY = bbs->NumXYpairs;
//will modify it later
//	iThisFrameRate = bbs->iFrameRage;

	//should be taken care bofre
	dThisX = (double **)malloc(iNumImage * sizeof(double *));
	dThisY = (double **)malloc(iNumImage * sizeof(double *));

	//dFRE = (double **)malloc(iNumImage * sizeof(double *));
	//dFlex = (double **)malloc(iNumImage * sizeof(double *));
	dThisBkbAgle = (double **)malloc(iNumImage * sizeof(double *));

	for (index = 0; index < iNumImage; index ++)
	{
		//Memory
		dThisX = (double *)malloc (iNumXY * sizeof(double));
		dThisY = (double *)malloc (iNumXY * sizeof(double));
		//dFRE[index] = (double *)malloc (iNumXY * sizeof(double));
		//dFlex[index] = (double *)malloc (iNumXY * sizeof(double));
		dThisBkbAgle[index] = (double *)malloc ((iNumXY - 2) * sizeof(double));
		
		//get the cooridnates of the other one
		for (index1 = 0; index1 < iNumXY; index1 = index1 + 2)
		{
			if (iIsBkbp[index] == 1)
			{
				dThisX[index][index1] = dX[index][index1];
				dThisY[index][index1] = dY[index][index1];
			}
			//else
			//{
			//	dThisX[index][index1] = 0;
			//	dThisY[index][index1] = 0;
			//}
		}

		//if there is bkbp calculate it 
		//Calculate the new Angle use new set of coordinates
		if (iIsBkbp[index] == 1)
		{
			AngleBtwBkbv (dThisX[index], dThisY[index], dThisBkbAgle[index], iNumXY) ; 
		} //else
		//dThisBkbAgle[index] = 0;

	}
	

	//Claim meory
	thisX = mxCreateDoubleMatrix(iNumImage, iNumXY, mxREAL);
	thisY = mxCreateDoubleMatrix(iNumImage, iNumXY, mxREAL);

	thisSpc = mxCreateDoubleMatrix(1, 1, mxREAL);

	//Get it there
	//iThisFrameRate, modify it later	   iThisFrameRate is the initiate value
	//thisMMPS = mxCreateDoubleMatrix(iThisFrameRate, 1, mxREAL); //this is is scarlar 
	thisMMPS = mxCreateDoubleMatrix(1, 1, mxREAL); //this is is scarlar 

	thisAmpt = mxCreateDoubleMatrix(1, iNumImage, mxREAL);
	thisWavelength = mxCreateDoubleMatrix(1, iNumImage, mxREAL);

	thisFRE = mxCreateDoubleMatrix(iNumImage, iNumXY-2, mxREAL); 
	thisAngle = mxCreateDoubleMatrix(iNumImage, iNumXY - 2, mxREAL);

	//some should be one way array
	thisJunk = mxCreateDoubleMatrix(iNumImage, iNumXY - 2, mxREAL); 
	thisFlex = mxCreateDoubleMatrix(iNumImage, iNumXY - 2, mxREAL); 
	
	//the error contrl
	thisIsBkp = mxCreateDoubleMatrix(1, iNumImage, mxREAL);
	mxSetIr (thisIsBkp, iIsBkbp);
	
	//Claim memory
	iTemp = (int *)malloc (1 * sizeof (int));
			
	//Put in data	 //some should  iNumXy-2
	for (index = 0; index < iNumImage; index ++)
	{
		*iTemp = index;
		mxSetIr (thisX, iTemp);
		mxSetPr(thisX, dThisX[index]);  
		mxSetIr (thisY, iTemp);
		mxSetPr(thisY, dThisY[index]); 
		mxSetIr (thisAngle, iTemp);
		mxSetPr(thisAngle, dThisBkbAgle[index]); 

	}

			
	//initional dll file  this has to be the last thing to do 
	//initional the dll files
	contraction4libInitialize(); 				
	trackslibInitialize(); 				
	
	//call the mlf c function
	mlfAssign (&thisFRE, mlfContraction4(&thisJunk, &thisFlex, thisAngle, thisSpc);
	mlfAssign (&thisAmpt, mlfTracks(&thisWavelength, thisX, thisY, thisMMPS);
//Pass with error control. Need to see the h file
	//mlfAssign (&thisFRE, mlfContraction4(&thisJunk, &thisFlex, thisAngle, thisSpc, thisIsBkp);
	//mlfAssign (&thisAmpt, mlfTracks(&thisWavelength, thisX, thisY, thisMMPS, thisIsBkp);
																			   

	//read the data
	*iTemp = 0;
	mxSetIr (thisAmpt, iTemp);
	dAmpt = mxGetPr(thisAmpt);  
	mxSetIr (thisWavelength, iTemp);
	dWavlength = mxGetPr(thisWavelength);  

	//should be a matrix
	for (index = 0; index < iNumImage; index ++)
	{
		*iTemp = index;
		mxSetIr (thisFRE[index], iTemp);
		dFRE[index] = mxGetPr(thisAmpt);  
		mxSetIr (thisFlex[index], iTemp);
		dFlex[index] = mxGetPr(thisAmpt);  
	}
	//free memeory
	//free (iTemp);
			
	mxDestroyArray (thisX);
	mxDestroyArray (thisY);
	mxDestroyArray (thisAmpt);
	mxDestroyArray (thisFRE);
	mxDestroyArray (thisSpc);
	mxDestroyArray (thisAngle);

	//should be the input, I do not need to take care of this.
	for (index = 0; index < iNumImage; index++)
	{
		free (dThisX[index]);
		free (dThisY[index]);
		free (dThisBkbAgl[index]);
		//free (dFRE[index]);
		//free (dFlex [index]);
	}
			
	free (dThisX);
	free (dThisY);
	free (dThisBkbAgl);
	free (dFRE);
	free (dFlex);
	free (iTemp);

	mxDestroyArray (thisWavelength);
	mxDestroyArray (thiJunk);
	mxDestroyArray (thisFlex);
			
	//close the dll file.
	contraction4libTerminate();		
	trackslibTerminate();

	return 1;
}
//*/

int GetAdditionalData1 (BackboneSet *bbs) 		//Remember call it after all other Gets 
//int GetBkbAnalysisData (BackboneSet *bbs) 
//int ExtrapolateCalTechFeature (int iNumImage, int iNumXY, double **dX, double **dY, double **dBkvvAgle, double  )
{
int index;

//Will be funciton input
int iNumImage;


	iNumImage = bbs->NodeCount;
//	iNumXY = bbs->NumXYpairs;
	iOmegaCount = countingOmega (dBkpElgFactor, iNumImage, 0.85, iOmega);
	foragingDistance (iForging, iNumImage, dForagingDis, dForagingAlg, dX, dY);


	return 1;
}
//*/

