/*******Project Information*******************************************************************/
/*																							 */
/*		Worm Project:  Data miner															 */
/*		This is one of the four parts of quantitative behavrior project (4/4)   			 */
/*																							 */
/*																							 */
/*		Zhaoyang Feng   																	 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*																							 */
/*********************************************************************************************/
//******File Information**********************************************************************/
//**																						 */
//**  File name: 				backboneDataStruct.h										 */
//**  File function:			Data structure in worm data analysis			 			 */
//**																						 */
//**  Caution:  This file and it c file are used by the second and third parts of   		 */
//**			quatitative behaviror project (2/4,3/4), convertor and lineup   			 */
//**			Becareful when make changes 												 */
//**																						 */
//**  Author:					Zhaoyang (John) Feng										 */
//**  Last time modification:   March. 25, 2001.											 */
//**																						 */
//********************************************************************************************/
//******Update Information********************************************************************/
//**																						 */
//**		August, 2003  Christopher Cronin, Dr. Paul Sternberg from CalTech and Zhaoyang   */
//**             Feng, Dr.Schafer in UCSD decided to combine two systems together.			 */
//**              																			 */
//**		In this combined system, this data structure will serve as the joint point     	 */
//**		  of convertor/lineup (UCSD) and recognizor (CalTech)                            */
//**		                                                                                 */														 						 */
//**		wormDataStruct.h																 */
//**																						 */
//**																						 */
//**		Last modification data: 8/19/2003												 */
//********************************************************************************************/

//**********************************************codes start here
#define FULL_SET_ERROR -1
#define MEM_ERROR 0
#define MAX_NAME_LEN 500

#define null 0

//**************************************************************************************
//	ImageInfors Definition
//	Written by John Feng
//	Commented by John Feng:
//	ImageInfors holds the data that from the grey/binary image processing, which are lost after image processing
//	Most of the features here are results of library function called from National Instrument, IMAQ  
//**************************************************************************************
typedef struct ImageInfors
{
//features defined and/or obtained by self written functions
int iLoopType;   //self defined data.  Produced when navigating the skeleton.  There are three types.
				 //type 1, loop with one end (head/tail) touches the other.
				 //type 2. loop when worm crosses it body
				 //type 3. Extremely short or long skeleton indicating a coil (short) or wrong image (long)
double dArea;	 //the total pixel number of the binary images, should related to magnificant factor of microscope
				 //will add information to this
double dWormLength; //the length of skeleton by 9 pixel neighborhood method
double dTransparency; //Mean vale - background and rescale to 0 and 1
double dThickness;  //the width of the middle point of worm
double dFatness;	//is the area/length (seems is removable because information is here
double dLengthToPixelNumber;  //the length / pixel number of skelton 

//shape equivalence analysis from National Instrument IMAQ library.  The detail mathematical algorithms/methods can be found
//in the published IAMQ library document.  Most of the features has been published in academic journal and utilized in industry
double dMaxIntercept;
double dMeanInterceptPerpendicular;
double dEquivalenceEllipsRatio;
double dEllipsMajorAxis;
double dEllipsRatio;
double dRectBigSide;
double dRectRatio;

//shape feature analysis from National Instrument IMAQ library.  The detail mathematical methods can be found
//in the published IAMQ library document.  Most of the features has been published in academic journal and utilized in industry
double dElongationFactor;
double dCompactnessFactor;
double dHeywoodCicularityFactor;
double dTypeFactor;
double dHydraulicRadius;
double dWaddelDiskDiameter;
double dIXX, dIYY, dIXY;

}  ImageInfor ;


//**************************************************************************************
//	BackboneNode Definition
//	Written by John Feng based on previous version written by John Wittig Jr.
//  Commented by John Feng
//	The backbone nodes hold the the data of bakcbone points
//**************************************************************************************
typedef struct BackboneNodes
{
	// the absolute (with reference to the stage & image box) centroid of the binary Backbone
	//JF
	double Time;	//The time stamp
	double absCentX, absCentY;   //X, Y coorinates of centroid, kind of redundant but also used 
								//as errpr control

	ImageInfor imageInfor;   //The information described above which is lost after discard images

	int iIsBkbp;   //In this node, whether there is a skeleton point availabe here. 
				   //There are two values, 1:  there is valid skeleton points; 0: there is no valid skeleton points 

	double * xPoints;	   //where to hold it
	double * yPoints;

	//should add additional information but ok at this time 
	//This information including; whether there is a mechnical or chemical stimulation at this node
		//an integer is fine
	//int iIsStimulation;
	//int iIsMultlight;  //0 only normal light; 1 normal light + green fluorescence; 2 normal light + both

	//When there is multilight source, intensity of green, red, normal fluorescence
		//three doubles  
	//int WaveLenth1;
	//int Wavelenth2;
	//double dGreen; 	//green fluorescence Value
	//double dRed;   	//red fluorescence
	//double dNormal;   //normal light
} BackboneNode ;
//*/

typedef long BackboneNodePtr ;
//**************************************************************************************
//	BackboneSet Definition
//	Written by John Feng based on a previous version written by John Wittig Jr.
//	Commented by John Feng
//  The BackboneSet holds the information of the data of when data collected, and other 
//  information helps reading and writing backbone nodes
// declaration of the variable
//**************************************************************************************
typedef struct BackboneSets
{

	char * setName ;  //Used during file writing and reading

	//data for programming control
	char Date[11];    //for version control and data collect information
	int isBbpAligned; //flags whether the skeleton points are indentified for head and tail

	int NumXYpairs; 	// how many backbone points per node

	// counts the nodes when they are written, good for programming control    
	int NodeCount; //total nodes here.
	int type1LoopCount; //total type1 loop
	int type2LoopCount; //total type2 loop
	int type3LoopCount; //total type3 loop
	int invalidNodeCount; //total of invalid node count, should be sum of all type and missing nodes

	// array of long values which are pointers to BackboneNodes in memory, see typedef just above the definition
	BackboneNode ** backboneNodePtr ;
	
	//Programming control
	int filePtr ;  //programming control
	int byteCount; //should renamed as checksum. 

	//should have something indicate the magnificancy 
	//int iMag;
	
	//Flags that indicate whether there is multiple light source and/or stimilator
	//int iMultiLight;  //0 is no; 1: two light; 2: three light
	//int iStimulator;  //0 is no; 1 is yes;
} BackboneSet ;


// **************************************************************************************
//	Function prototypes
//  Most of functions were orignially defined by John Wittig Jr.  A large percentage of 
//  the function were rewritten by John Feng, though the function name is remain same.
//	commented by John Feng
//  The functions are used to read/write skeleton points from/to hard drive, memeory
//   Most likely, none of these functions need compeletely rewrite.  Howver, modifications 
//		are definitely required.
//
// The version control is not in a smarter way, but keep like this to avoid modifying a lot of functions.
//
// **************************************************************************************

// **************************************************************************************
//	newBackboneNode
//		backbone node constructor
// **************************************************************************************
BackboneNode * newBackboneNode(int numXYpairs, double newTime, double newAbsCentX, double newAbsCentY, ImageInfor newImageInfor, double * newXpoints, double * newYpoints, int iVersion);

// **************************************************************************************
//	readBackboneNode
//		read backbone set from a file, given the file pointer and the backboneSet it belongs
// **************************************************************************************
BackboneNode * readBackboneNode(int filePtr, BackboneSet * thisSet, int iVersion);

// **************************************************************************************
//	writeBackboneNode
//		write backbone node to a file, given the file pointer and the backboneSet it belongs
// **************************************************************************************
int writeBackboneNode(BackboneNode * thisNode, int filePtr, BackboneSet * thisBackboneSet);

// **************************************************************************************
//	destroyBackboneNode
//		backbone node destructor
// **************************************************************************************
int destroyBackboneNode(BackboneNode * thisNode);

// **************************************************************************************
//	newBackboneSet
//		backbone set constructor, need to know the number of skeleton point in a skeleton
//			set and the totoal number of nodes in the set
// **************************************************************************************
BackboneSet * newBackboneSet(char * newBackboneSetName, int newNumXYpairs, int newNodeCount);

// **************************************************************************************
//	readBackboneSet
//		read the backbone set given the backboneSetName which is actually the name of the file
//  Usage
//      Just pass the file name to it, it will return the data of backboneSet
//		The readbackboneNode function will be called in this function to read each node
// **************************************************************************************
BackboneSet * readBackboneSet(char * newBackboneSetName);

// **************************************************************************************
//	writeBackboneSet
//		write the backbone set given the backboneSetName which is actually the name of the file
//  Usage
//      Just pass the backboneSet to it, it will write and return a flag
//		The writebackboneNode function will be called in this function to read each node
//      The file name will obtained from the bakboneSet data (see backboneDAtaStruct.h)
// **************************************************************************************
int writeBackboneSet(BackboneSet * thisBackboneSet);

// **************************************************************************************
//	destroyBackboneSet
//		backboneSet destructor
//		bakboneNode destructor will be called here.
// **************************************************************************************
int destroyBackboneSet(BackboneSet ** BackboneSetPtrPtr);  

// **************************************************************************************
//	addBackbone
//		backbone node destructor, the backboneNode constructor will be called here.
// **************************************************************************************
int addBackbone(BackboneSet * thisBackboneSet, int whichNode, double newTime, double newAbsCentX, double newAbsCentY, ImageInfor newImageInfor, double * newXpoints, double * newYpoints, int iVersion);

// **************************************************************************************
//	getBackboneVersion
//		get Backbone version from the date the data collected
// **************************************************************************************
void getBackboneVersion (BackboneSet *newSet, int *iVersion);
