
/*******Project Infromation*******************************************************************/
/*																							 */
/*		Worm Project:  Data miner															 */
/*		This is one of the four parts of quantitative behavrior project (4/4)   			 */
/*																							 */
/*																							 */
/*		Zhaoyang Feng   																	 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*																							 */
/*********************************************************************************************/

//********************************************************************************************/
//**																						 */
//**  File name: 				WormDataManipulation.h										 */
//**  File function:			header file for data manipuation in worm data analysis		 */
//**  Author:					Zhaoyang (John) Feng										 */
//**  Last time modification:   April. 25, 2001.											 */
//**																						 */
//********************************************************************************************/
#define PI 3.14159265258979


//*********************//
//*					  *//
//*  Not Used		  *//
//*					  *//
//*********************//
//****distance analysis
int DisPointsToLine (double slope, double intercept, double * xArray, double * yArray, int numXY, double * distance ) ;
int XAlongLine (double slope, double intercept, double *X, double *Y, int numXY, double *XOut) ;
int GetDifferentsOfDistancesAndAngles (double * Distances, double * Angles, int NumXY, double * DistancesOut, double * AnglesOut) ;
//reconstruction
int ReconstCordinatesFromDistandAndLine (double slope, double intercept, double * xArray, int numXY, double * distance, double * yArray) ;
int ReconstructBackboneFromDistanceAndAnglesDifference (double * Distances, double * Angles, int NumXY, double * XOut, double * YOut);
int ReconstructBackboneFromDistanceAndAngles (double * Distances, double * Angles, int NumXY, double * XOut, double * YOut) ;
int countFrequent(double *dAngle, double * dSpeed, int totalNodes, double dMean, int *count, int *unchange);

//*********************//
//*					  *//
//*  Used			  *//
//*					  *//
//*********************//

//*****Get backboneset and reconstructed
int SplitBackboneToDistanceAndAngles (double * X, double * Y, int NumXY, double * Distances, double * Angles);

//****angles
//Used
int DisAngleBetweenTwoPoints (double dX1, double dY1, double dX2, double dY2, double * dAngle, double * dDistance);
int angleAverage (double *angles, int iArrayNumber, double * dAverage);


//Bkbv analysis
int AngleBtwBkbv (double * X, double * Y, double * Theta, int numXY);

//forging
int IsForging (double ** dBkbpSpeed, int iCurrentNode, int iNextNode, int iNumXY, double *gSpeed, double *dTime, double *dWormLength) ;

//reverse
int IsReversal (double *dX1, double *dY1, double *dX2, double *dY2, int iNumXY) ;

//********help functions
//******************************************************************************************//
//  GetSPC
//	  data passed: 
//			1. dData: data array;  2. iTotal: total number in the array; 
//    data modified (by reference):
//			1. dUpper10: the upper 10%
//			2. dLower10: the lower 10% 
//			3. dMostPopular:  split value from min to max into 12 bin, the mean value of the data with largest data point in whole set
//          4. dPercentage:  the percentage of the data that in the bin of dMostPopular compared with the whole set
//******************************************************************************************//
int getSPC (double *dData, int iNumImage, double *dUpper10, double *dLower10, double *dMostPopular, double *dPercentage) ;

//******************************************************************************************//
//  countReversal
//	  data passed: 
//			1. iRevese: reversal validation, in the array, if iRevese[i] == 1 there is a reversal at frame number i ;  
//          2. int numImage: total number in the backboneSet; 
//    data modified (by reference) or returned:
//			3. gMovingDistances is the array that holds the centroids distance at each frame
//			1. it return the revesalCount. On reversalCount counts when a worm starting and ending resverse
//			2. dReversalDistance holds the distace of worm centroid moves during a reversalCount
//				the total number of data in this array is the number return by this function
//******************************************************************************************//
int countReversal (int *iRevese, int numImage, double *gMovingDistances, double *dReversalDistance);

//Omega Bending
int countingOmega (double *dBkpElgFactor, int iNumNode, double dThreshold, int* omega) ;

//two features here.  If there is a foraging, 1) count the head move distance, 2) count the angle.
int foragingDistance (int *isForaging, int iNumNode, double *dForagingDis, double *dForagingAgl, double **dX, double **dY) ;
