/*******Project Infromation*******************************************************************/
/*																							 */
/*		Worm Project:  Tracker system														 */
/*		This is one of the four parts of quantitative behavrior project (4/4)   			 */
/*																							 */
/*																							 */
/*		Zhaoyang Feng   																	 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*		Tracker group  (Zhaoyang Feng, Christopher Cronin, Paul Sternberg, William Schafer)	 */
/*																							 */
/*********************************************************************************************/

//********************************************************************************************/
//**																						 */
//**  File name: 				WormDataManipulation.c										 */
//**  File function:			Data manipuation in worm data analysis		 				 */
//**  Author:					Zhaoyang (John) Feng										 */
//**  Last time modification:   April. 25, 2001.											 */
//**																						 */
//********************************************************************************************/

//#include <userint.h>
#include <analysis.h>
#include <ansi_c.h>

#include <backboneDataStruct.h>
#include <WormDataManipulation.h>


//*******************************************************************************
//*******************************************************************************
//**																		   **
//**     Following are the function manipulate the backboneset and the image   **
//**																		   **
//*******************************************************************************

//************************ DisPointsToLine***************************************************************************************
// 																																 
// 		This function takes, a line (defined by slope and intercept, and take a set of points (x, y is defined by xArray         
//            yArray and the number of total points (numXY).  It dertermines the distances of each point to the line.            
// 																																 
//*******************************************************************************************************************************
int DisPointsToLine (double slope, double intercept, double * xArray, double * yArray, int numXY, double * distance )	

{

int index;

//variables used in the calculation
double dAngleLine, dAnglePerpendicular;
double dSlopePerpendicular;
double  dInterceptPerpendicular;
double  dXOrg, dYOrg;

//variables used to make code faster
double dDifSlope;

	//Get the angle of the line
	dAngleLine = atan(slope);
	
	//Get the angle of the Perpendicular Line
	dAnglePerpendicular = dAngleLine + PI/2;
	
	//Get the slope of the perpendicular line
	dSlopePerpendicular = tan (dAnglePerpendicular);
	
	//Calculate the difference here to make the code run faster
	dDifSlope = slope - dSlopePerpendicular;

	for (index = 0; index < numXY; index++)
	{
		//Get the intercept of the perpendicular line for each point
		dInterceptPerpendicular = yArray[index] - dSlopePerpendicular * xArray[index];
		
		//Get the coridinate of the respective original point
		dXOrg = (dInterceptPerpendicular - intercept)/dDifSlope;
		dYOrg = (dXOrg * dSlopePerpendicular) + dInterceptPerpendicular ;
		
		//Get the distance
		distance[index] = sqrt( (dXOrg - xArray[index]) * (dXOrg - xArray[index]) + (dYOrg - yArray[index]) * (dYOrg - yArray[index]) );
		
		//add negative if point is below the line in Y axis
	   if (yArray[index] < xArray[index] * slope + intercept)
	   {
	   		distance[index] = - distance[index] ;
	   }
	   	
	} 

	//report failure for debug purpose
	if (distance == null)
	{
		return 0 ;

	}else return 1;

}



//************************SplitBackboneToDistanceAndAngles***********************************************************************
// 																																 
// 		This function takes, a Backbone Image node (X, Y array and number of backbone points. This fuction will split the X/Y
//            coordinate to yield two array of data: the distance of each backbone to its previous one, and the angle of each
//            backbone to its previous one.  The first data in the distance and angles are reference the first backbone points
//			  with the orignial point(distance(0) and angle (0)).
// 																																 
//*******************************************************************************************************************************
//Used
int SplitBackboneToDistanceAndAngles (double * X, double * Y, int NumXY, double * Distances, double * Angles)
{

int index;

		for (index = 0; index < NumXY - 1; index ++)
		{
		
			DisAngleBetweenTwoPoints (X[index], Y[index], X[index + 1], Y[index + 1], &Angles[index +1], &Distances[index +1]) ;
		}
		
		//The first one is referenced to original point
		DisAngleBetweenTwoPoints (0, 0, X[0], Y[0], &Angles[0], &Distances[0]) ;
		

		if (Angles != 0 && Distances != 0)
		{
			return 1;
			
		}else return 0;
}

//************************ReconstructBackboneFromDistanceAndAngles***************************************************************
// 																																 
// 		This function takes, a set of arrays: Arrays of distances and arrays of angles.  This function just assume, the arrays are
//            data from the function of SplitBackboneToDistanceAndAngle.  This function will reconstruct the X and Y cooridinate
//            from the input data.
// 																																 
//*******************************************************************************************************************************
int ReconstructBackboneFromDistanceAndAngles (double * Distances, double * Angles, int NumXY, double * XOut, double * YOut)
{

int index;

		//Get the first one
		XOut[0] = Distances[0] * cos(Angles[0]);
		YOut[0] = Distances[0] * sin(Angles[0]);
	
		//For the later
		for (index = 0; index < NumXY - 1; index ++)
		{
			XOut[index + 1] = XOut[index] + Distances[index + 1] * cos(Angles[index + 1]);
			YOut[index + 1] = YOut[index] + Distances[index + 1] * sin(Angles[index + 1]);
		}
		
		if (XOut != null && YOut != null)
		{
			return 1;
		}else return 0;
		
}

//************DisAngleBetweenTwoPoints***************************************************************************************
//																															
//			This function calculates the distance and the angle for point 2 to point 1.										
//																															
//***************************************************************************************************************************
int DisAngleBetweenTwoPoints (double dX1, double dY1, double dX2, double dY2, double * dAngle, double * dDistance)
{

double dXTemp, dYTemp;
		dXTemp = dX2 - dX1;
		dYTemp = dY2 - dY1;
				
		* dDistance = sqrt(dXTemp * dXTemp + dYTemp * dYTemp);

		if (* dDistance < 0)
		{
			return -1;
		}

		* dAngle = atan2 (dYTemp, dXTemp);
		
		if (* dAngle > PI || * dAngle < PI)
		{
			return 0 ;
		}
		
		return 1;
}


//******************************************************************************
//*
//*         Function still needs work.
//*
//******************************************************************************

//
int AngleBtwBkbv (double * X, double * Y, double * Theta, int numXY)     
{

int index;
double TempX, TempY;
double TempX1, TempY1;
double TempX2, TempY2;


//double newX, newY;
double aX, aY;
double bX, bY;
double ab;
double absA, absB;

double z;
double dAngleOutput;
double dTemp;


	for (index = 0; index < numXY - 2; index ++)
	{
		TempX = X[index];
		TempY = Y[index]; 

		TempX1 = X[index + 1];
		TempY1 = Y[index + 1];
		
		TempX2 = X[index + 2];
		TempY2 = Y[index + 2];

		//a->
		aX = (TempX1 - TempX);
		aY = (TempY1 - TempY);

		//b->
		bX = (TempX2 - TempX1);
		bY = (TempY2 - TempY1);

		//a*b
		ab = aX * bX + aY * bY;
		
		//|a| |b|
		absA = (aX * aX + aY * aY);
		absB = (bX * bX + bY * bY);
		
		z = aX * bY - bX * aY;
		
		dTemp = sqrt (absA * absB);
		dTemp = ab / dTemp;
		if (dTemp > 1) dTemp = 1.0;
		else if (dTemp < - 1) dTemp = -1.0;
		
		dAngleOutput = acos (dTemp);
		
		//if it is anticlockwise add minus
		if (z < 0) dAngleOutput = - dAngleOutput;

		Theta[index] = dAngleOutput * 180/PI;
		
	}
	
	/*
	for (index = 0; index < numXY - 2; index ++)
	{
	
		Theta[index] = Theta[index] - Theta[0];
	}
	//*/
	
	return 1; 
}


// **************************************************************************************
//				BackboneSet addBackbone
//
// 	pass in newBackbone, which is already an allocated array from imaqBackbone
//  BackboneNode destructor calles imaqDestroy to clear the memory
// **************************************************************************************
int angleAverage (double *angles, int iArrayNumber, double * dAverage)
{
int index;
double dTempSin, dTempCos;

		dTempSin = 0;
		dTempCos = 0;

		//We do not need the first one
		for (index = 0; index < iArrayNumber; index ++)
		{
			dTempSin = dTempSin + sin(angles[index]);
			dTempCos = dTempCos + cos(angles[index]);
		}
			
		dTempSin = dTempSin / iArrayNumber;
		dTempCos = dTempCos / iArrayNumber;
		
		* dAverage = atan2(dTempSin, dTempCos);
		//* dAverage = fabs ( (* dAverage) * 180 / PI); 
		* dAverage =  (* dAverage) * 180 / PI; 

		return 1; 
}


//************************GetDifferentsOfDistancesAndAngles**********************************************************************
// 																																 
// 		This function will get the distance and angle array to calculate the difference between those two consequent data points
// 																																 
//*******************************************************************************************************************************

int GetDifferentsOfDistancesAndAngles (double * Distances, double * Angles, int NumXY, double * DistancesOut, double * AnglesOut)
{

int index ;

		for (index = 1; index < NumXY - 1; index ++)
		{
			DistancesOut[index + 1] = Distances[index + 1] - Distances[index] ;
			AnglesOut[index + 1] = Angles[index + 1] - Angles[index] ;
			
			if (DistancesOut[index + 1] < 0)
			{
				DistancesOut[index + 1] = - DistancesOut[index + 1];
			}

			if (AnglesOut[index + 1] < 0)
			{
				AnglesOut[index + 1] = - AnglesOut[index + 1];
			}

		}
		
		DistancesOut[0] = Distances[0];
		AnglesOut[0] = Angles[0];
		
		if (DistancesOut != null && AnglesOut != null)
		{
			return 1;
		}else return 0;
}

//************************countFrequent**********************************************************************
// 																																 
// 		This function count the larges time (i.e. continued count) that did not change much.
// 																																 
//*******************************************************************************************************************************
int countFrequent(double *dAngle, double * dSpeed, int totalNodes, double dMean, int *count, int *unchange)
{

double *dAngleTemp;
int iCount = 0, iIsCross;
int index;
int iLongestNonChange = 1;
int iCurrentNonChange = 0;

int iNotMove = 0;

	dAngleTemp = (double *)malloc(totalNodes * sizeof (double));

	LinEv1D (dAngle, totalNodes, 1.0, - dMean, dAngleTemp);
	
  	for (index = 0; index < totalNodes - 1; index ++)
  	{
  		if (dSpeed[index] <=  0.5)  iNotMove = 1;
  		
 		if ((dAngleTemp[index] * dAngleTemp[index + 1] <= 0 ) && iNotMove !=1) iIsCross = 1;
 		
 		if (iIsCross == 1)
 		{
 			iIsCross = 0;
 			iCount += 1;
 			if (iLongestNonChange < iCurrentNonChange) iLongestNonChange = iCurrentNonChange ;
 			iCurrentNonChange = 0;

 		} else iCurrentNonChange += 1;
 	}
 	
 	*count = iCount;
 	*unchange = iLongestNonChange;
 	
 	free (dAngleTemp);
 	
 	return 1;
}

//************************IsForging*************************************************************
// 																																 
// 		This function is to judge whether a forging is happen
// 																																 
//**********************************************************************************************
int IsForging (double ** dBkbpSpeed, int iCurrentNode, int iNextNode, int iNumXY, double *gSpeed, double *dTime, double *dWormLength)
{

int iLowerOneThirdBody;
int index;

double dTempTime;
double dGlbSpeed;
double dAveLength;
double dAveSpeed, dSD;
double *dLocalSpeed;
int iIsForging;

	iLowerOneThirdBody = floor (iNumXY * 1 / 3) ;
	
	dLocalSpeed = (double *) calloc ( (iNumXY - iLowerOneThirdBody), sizeof(double));
	
	dTempTime = fabs (dTime[iNextNode] - dTime[iCurrentNode]);
	
	for (index = iLowerOneThirdBody; index < iNumXY; index ++)
	{
		dLocalSpeed[index - iLowerOneThirdBody] = dBkbpSpeed[iCurrentNode][index];
	}

	dAveLength = (dWormLength[iCurrentNode] + dWormLength[iNextNode]) / 2;
	StdDev (dLocalSpeed, (iNumXY - iLowerOneThirdBody), &dAveSpeed, &dSD);

	dGlbSpeed = gSpeed[iCurrentNode];
	
	if ( 
	//global speed is smaller than 
	( dGlbSpeed <= (dAveLength * 0.05 / dTempTime) ) &&  
	//lower 2/3 body is moving 1/2 of the global movement
	( dAveSpeed <= (dGlbSpeed / 2) ) && 
	//Head is significantly more active than 2/3 lower part
	( dBkbpSpeed[iCurrentNode][0] >= (3 * dAveSpeed + dSD) )  )
	
		iIsForging = 1;
	else iIsForging = 0;
	
	free (dLocalSpeed);
	return iIsForging;
}	


//************************IsReversal************************************************************
// 																																 
// 		This function is to judge whether a reversal is happen
// 																																 
//**********************************************************************************************
int IsReversal (double *dX1, double *dY1, double *dX2, double *dY2, int iNumXY)
{

double dXHead1, dYHead1;
double dXTail1, dYTail1;

double dXHead2, dYHead2;
double dXTail2, dYTail2;

int index;

double *dTempDistance;
double dMax, dMin1, dMin2;

int iIndexMin1, iIndexMin2;
int indexMax;

double dMin3, dMin4;
int iIndexMin3, iIndexMin4;

int iIsReverse;

//head/tail of first one
	dXHead1 = dX1[0];
	dYHead1 = dY1[0];
	dXTail1 = dX1[iNumXY -1];
	dYTail1 = dY1[iNumXY -1];

//head/tail of second one
	dXHead2 = dX2[0];
	dYHead2 = dY2[0];
	dXTail2 = dX2[iNumXY -1];
	dYTail2 = dY2[iNumXY -1];
	
	dTempDistance = (double *)calloc (iNumXY, sizeof (double));

	for (index = 0; index < iNumXY; index++)
	{
		dTempDistance[index] = sqrt ( (dXHead1 - dX2[index]) * (dXHead1 - dX2[index]) + (dYHead1 - dY2[index]) * (dYHead1 - dY2[index]) ) ;
	}
	
	MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin1, &iIndexMin1);
	
	
	for (index = 0; index < iNumXY; index++)
	{
		dTempDistance[index] = sqrt ( (dXTail1 - dX2[index]) * (dXTail1 - dX2[index]) + (dYTail1 - dY2[index]) * (dYTail1 - dY2[index]) ) ;
	}
	
	MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin2, &iIndexMin2);

	//

	for (index = 0; index < iNumXY; index++)
	{
		dTempDistance[index] = sqrt ( (dXHead2 - dX1[index]) * (dXHead2 - dX1[index]) + (dYHead2 - dY1[index]) * (dYHead2 - dY1[index]) ) ;
	}
	
	MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin3, &iIndexMin3);
	
	
	for (index = 0; index < iNumXY; index++)
	{
		dTempDistance[index] = sqrt ( (dXTail2 - dX1[index]) * (dXTail2 - dX1[index]) + (dYTail2 - dY1[index]) * (dYTail2 - dY1[index]) ) ;
	}
	
	MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin4, &iIndexMin4);
	
	//if the head of current frameis closer to next frame body (head of current frame is superimposed with next frame
	if ( (iIndexMin1 < iNumXY/2) && (dMin1 < dMin2) && (iIndexMin2 > iNumXY /2 ) )
	{
		iIsReverse = 0;  //it is a forwarding move
	}
	else
	if ( (iIndexMin3 < iNumXY/2) && (dMin3 < dMin4) && (iIndexMin4 > iNumXY /2 ) ) //if the head is closer to next frame body (head of current frame is superimposed with next frame
	{
		iIsReverse = 1;  //it is a forwarding move
	}
	else
	{
		iIsReverse = 0;
	}
	
	
	free (dTempDistance) ;

	return iIsReverse;
}



int getSPC (double *dData, int iNumImage, double *dUpper10, double *dLower10, double *dMostPopular, double *dPercentage)
{

int iCount, index;
double *dUpper, *dLower;
int iBin = 12;
double *dXHistogram;
int *iHistogram;
int iMax, iMin;
double dMax, dMin;
double dTemp;
int iTemp;

double dULimit, dLLimit = 0;
//To do
//1. Get the dULimit, dLLimit	 --- Done

	MaxMin1D (dData, iNumImage, &dULimit, &iTemp, &dTemp, &iTemp);

	iCount = iNumImage / 10;

	dUpper = (double *)malloc(iCount * sizeof(double));
	dLower = (double *)malloc(iCount * sizeof(double));

	iHistogram = (int *)malloc(iBin * sizeof(int));
	dXHistogram = (double *)malloc(iBin * sizeof(double));

//2. Set the array	 ---- Done

//3. check how this function is used.  ---done
//4. Modififying the database,		   
//5. Add codes to write to database.   ---done
//6. Test it.

	Set1D (dUpper, iCount, -1);
	Set1D (dLower, iCount, dULimit + 20);

	for (index = 0; index < iNumImage; index ++)
	{
		MaxMin1D (dUpper, iCount, &dTemp, &iTemp, &dMin, &iMin);
		MaxMin1D (dLower, iCount, &dMax, &iMax, &dTemp, &iTemp);
		
		if (dData[index] >= 0)
		{
			if (dMin < dData[index]) dUpper[iMin] = dData[index];
			if (dMax > dData[index]) dLower[iMax] = dData[index];
		}
	}
	
	Mean (dUpper, iCount, dUpper10);
	Mean (dLower, iCount, dLower10);
	
	//debug
	//YGraphPopup ("Upper", dUpper, iCount, VAL_DOUBLE);
	//YGraphPopup ("Lower", dLower, iCount, VAL_DOUBLE);

//	MaxMin1D (dData, iNumImage, &dULimit, &iTemp, &dTemp, &iTemp);
	Histogram (dData, iNumImage, dLLimit, dULimit, iHistogram, dXHistogram, iBin);


	iMax = 0;
	iTemp = -1;
	for (index = 0; index < iBin; index++)
	{
		if (iHistogram[index] > iTemp)
		{
			iTemp = iHistogram[index];
			iMax = index;
		}
	}
	
	*dMostPopular = dXHistogram[iMax];
	*dPercentage = iTemp * 100.0 / (iNumImage * 1.0);
			
	free (dXHistogram);
	free (iHistogram);
	free (dUpper);
	free (dLower);
	
	return 1;
	
}


int countReversal (int *iRevese, int numImage, double *gMovingDistances, double *dReversalDistance)
{

int iReversalCount = 0;

double dTempDistance = 0; 

int iPrevious;

int iRevesalOn, iRevesalOff;

int index;

int *iTempRevesal;

	iTempRevesal = (int *) malloc (numImage * sizeof(int));
	
	for (index = 0; index < numImage; index ++)
	{
	
		if (iRevese[index] == 1)
		{
			iTempRevesal[index] = 1;
		} else iTempRevesal[index] = 0;
		
		
	}

	for (index = 1; index < numImage - 1; index ++)
	{
		if (iTempRevesal[index] == 0 && iTempRevesal[index - 1] == 1 && gMovingDistances[index] < 10 && iRevese[index + 1] == 1)
		{
				
				iTempRevesal[index] = 1;
		}
	}
		
	
	iPrevious = 0;
	
	for (index = 0; index < numImage; index++)
	{
		if (iTempRevesal[index] == 1 && iPrevious == 0)
		{
			iRevesalOn = 1;
			iRevesalOff = 0;
			iReversalCount ++;
			
		}
		else if (iTempRevesal[index] == 0 && iPrevious == 1)
		{
			
			iRevesalOn = 0;
			iRevesalOff = 1;
			
			dReversalDistance[iReversalCount - 1] = dTempDistance; 
			dTempDistance = 0;
		}
		
		if (iRevesalOn == 1 && iRevesalOff == 0)
		{
			if (gMovingDistances[index] > 0)
			{
				dTempDistance = dTempDistance + gMovingDistances[index];
			}
		}
		
		iPrevious = iTempRevesal[index];
		
		
	}
	
	free (iTempRevesal);
	
	return iReversalCount;

}


//************************Omega*****************************************************************
// 																																 
// 		This function is to judge whether an omega bending is happening
//
// 	dBkpElgFactor is the data																															 
//**********************************************************************************************

int countingOmega (double *dBkpElgFactor, int iNumNode, double dThreshold, int* omega)
{
int iCount = 0;
int index;

	iCount = 0;
	
	for (index = 0; index < iNumNode; index++)
	{
		//if there is no skpt, the dBkpElgFactor will flagged as -1.  Therefore, this is automatically checked.
		if (dBkpElgFactor[index] > dThreshold) 
		{
			omega[index] = 1;
			iCount++;
		}
		
		else omega[index] = 0;
	}

	return iCount;
	
}


//************************ForagingDistance******************************************************
// 																																 
// 		This function is to judge whether an omega bending is happening
//
// 																																 
//**********************************************************************************************

int foragingDistance (int *isForaging, int iNumNode, double *dForagingDis, double *dForagingAgl, double **dX, double **dY)
{

int index;

	//You can not count the first one anyway
	for (index = 1; index < iNumNode; index++)
	{
		if (isForaging[index] == 1)
		{
		
			DisAngleBetweenTwoPoints (dX[index][0], dY[index][0], dX[index-1][0], dY[index-1][0], &dForagingAgl[index - 1], &dForagingDis[index - 1]);
		
		}
	}
	
	return 0;

}



