/**************************************************************************/
/* LabWindows/CVI User Interface Resource (UIR) Include File              */
/* Copyright (c) National Instruments 2002. All Rights Reserved.          */
/*                                                                        */
/* WARNING: Do not add to, delete from, or otherwise modify the contents  */
/*          of this include file.                                         */
/**************************************************************************/

#include <userint.h>

#ifdef __cplusplus
    extern "C" {
#endif

     /* Panels and Controls: */

#define  pLineupBBS                      1
#define  pLineupBBS_tblBackbone          2
#define  pLineupBBS_nWhichSet            3       /* callback function: changeCurrentSet */
#define  pLineupBBS_nWhichNode           4       /* callback function: showLineupImages */
#define  pLineupBBS_gphLineupBBS         5
#define  pLineupBBS_nTotalNodes          6
#define  pLineupBBS_btnLoad              7       /* callback function: loadingBackboneForLineup */
#define  pLineupBBS_txtWorkStatus        8
#define  pLineupBBS_txtStatus            9
#define  pLineupBBS_nAngle               10
#define  pLineupBBS_nNextFrame           11
#define  pLineupBBS_cmdDoLineup          12      /* callback function: doAllLineup */
#define  pLineupBBS_bSwchTblON           13
#define  pLineupBBS_cmdSaveToFile        14      /* callback function: saveLineupFile */
#define  pLineupBBS_cmdSortHeadTail      15      /* callback function: sortHeadTail */
#define  pLineupBBS_cmdSetStatus         16      /* callback function: setToNotAlined */
#define  pLineupBBS_nAngleUpperLimit     17
#define  pLineupBBS_swtMan               18
#define  pLineupBBS_numLength            19
#define  pLineupBBS_bCut                 20
#define  pLineupBBS_nLow                 21
#define  pLineupBBS_nUp                  22
#define  pLineupBBS_txtMsg2              23
#define  pLineupBBS_txtMsgLineupStatus   24

#define  pnlHdTl                         2
#define  pnlHdTl_cmdSetIt                2       /* callback function: SetIt */
#define  pnlHdTl_gphHdTlRatio            3
#define  pnlHdTl_gphHdTl                 4
#define  pnlHdTl_binSwitch               5
#define  pnlHdTl_nAvgLast                6
#define  pnlHdTl_nAvgFirst               7
#define  pnlHdTl_nRatio                  8
#define  pnlHdTl_nRatioSD                9
#define  pnlHdTl_cmdPrintIt              10      /* callback function: printHdTlFigures */
#define  pnlHdTl_nIndex                  11
#define  pnlHdTl_txtInstruction          12


     /* Menu Bars, Menus, and Menu Items: */

#define  WORM                            1
#define  WORM_Lineup                     2       /* callback function: ShowLineupPanel */
#define  WORM_QUIT                       3       /* callback function: DoQuitMenu */


     /* Callback Prototypes: */ 

int  CVICALLBACK changeCurrentSet(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK doAllLineup(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
void CVICALLBACK DoQuitMenu(int menubar, int menuItem, void *callbackData, int panel);
int  CVICALLBACK loadingBackboneForLineup(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK printHdTlFigures(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK saveLineupFile(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK SetIt(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK setToNotAlined(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
int  CVICALLBACK showLineupImages(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);
void CVICALLBACK ShowLineupPanel(int menubar, int menuItem, void *callbackData, int panel);
int  CVICALLBACK sortHeadTail(int panel, int control, int event, void *callbackData, int eventData1, int eventData2);


#ifdef __cplusplus
    }
#endif
