#include <formatio.h>


/*********************************************************************************************/
/*																							 */
/*		Worm Project:  Data collection and saving											 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*																							 */
/*		Written John Feng 											 						 */
/*        																					 */
/*																							 */
/*********************************************************************************************/



//********************************************************************************************************************
//*		Inlcluding header files																						 *
//********************************************************************************************************************
#include <ansi_c.h>
#include <userint.h>

#include "wormClassify.h"


static panelLineup;
//********************************************************************************************************************/
//*	      CONSTANT AND VARIABLES DECLARATION. 																		 */
//*																													 */
//*       JF:  These codes should be in the header file.  It is kind of time-consuming to move these code to 		 */
//*            header files.  So I keep these untouched.															 */							
//*               																									 */
//********************************************************************************************************************/




/*********************************************************************************************/
/*																							 */
/*		The codes start here																 */
/*																							 */
/*********************************************************************************************/


/*********************************************************************************************/
/*		The main funciton. part is written by comiler										 */
/*********************************************************************************************/

int main (int argc, char *argv[])
{
	
	//* written by compiler
	if (InitCVIRTE (0, argv, 0) == 0)	/* Needed if linking in external compiler; harmless otherwise */
		return -1;	/* out of memory */
	if ((panelLineup = LoadPanel (0, "wormClassify.uir", pLineupBBS)) < 0)
		return -1;
		
	//* written by compeler	  
	DisplayPanel (panelLineup);
	RunUserInterface ();
	
}

//********************************************************************************************************************//
//*																													 *//
//*		Menu Item Functions: switch between different programs and quit												 *//
//*																													 *//
//********************************************************************************************************************//

void CVICALLBACK DoQuitMenu (int menuBar, int menuItem, void *callbackData, int panel)
{

		QuitUserInterface (0);
		
}


void CVICALLBACK ShowLineupPanel (int menuBar, int menuItem, void *callbackData, int panel)
{
	//int top, left ;

		HidePanel (panel); 
		
		if ((panelLineup = LoadPanel (0, "wormClassify.uir", pLineupBBS)) < 0)
		exit;

		SetPanelPos (panelLineup, VAL_AUTO_CENTER, VAL_AUTO_CENTER);

		DisplayPanel (panelLineup);
}

