//**********************************************************************************
//**
//**  File name: 				WormDataManipulation.h
//**  File function:			head file for data manipuation in worm data analysis
//**  Author:					Zhaoyang (John) Feng
//**  Last time modification:   Nov. 19, 2001.
//**
//**********************************************************************************
#define PI 3.14159265258979

//****distance analysis
int DisPointsToLine (double slope, double intercept, double * xArray, double * yArray, int numXY, double * distance ) ;
int ReconstCordinatesFromDistandAndLine (double slope, double intercept, double * xArray, int numXY, double * distance, double * yArray) ;
int XAlongLine (double slope, double intercept, double *X, double *Y, int numXY, double *XOut) ;

//*****Get backboneset and reconstructed
int SplitBackboneSet (BackboneSet * thisBackbone, int numXY, double ** dXOutput, double ** dYOutput, double * dMajorX, double * dCentX, double * dCentY, double * Time, int nodeCount, int startNode, double * dArea, double * dLength) ;
int SplitBackboneToDistanceAndAngles (double * X, double * Y, int NumXY, double * Distances, double * Angles);
int ReconstructBackboneFromDistanceAndAngles (double * Distances, double * Angles, int NumXY, double * XOut, double * YOut) ;
int GetDifferentsOfDistancesAndAngles (double * Distances, double * Angles, int NumXY, double * DistancesOut, double * AnglesOut) ;

//****angles
int DisAngleBetweenTwoPoints (double dX1, double dY1, double dX2, double dY2, double * dAngle, double * dDistance);
int angleAverage (double *angles, int iArrayNumber, double * dAverage);
int ReconstructBackboneFromDistanceAndAnglesDifference (double * Distances, double * Angles, int NumXY, double * XOut, double * YOut);
int GetDifferentsOfDistancesAndAngles (double * Distances, double * Angles, int NumXY, double * DistancesOut, double * AnglesOut);


//More angle analysis
int AngleIndependentOfX (double * X, double * Y, double * Theta, int numXY);
//int rotateCoordinate(double *dXCurrentNode, double *dYCurrentNode, int iNumXY, double * dXCorrected, double * dYCorrected);
int countFrequent(double *dAngle, double * dSpeed, int totalNodes, double dMean, int *count, int *unchange);
int RotateBackbones (double ** X, double ** Y, int iTotalNodes, int numXY, double **OutX, double **OutY, double ** dAC, double **BPAs, double *dBPAAverage);


//forging
int IsForging (double *dX1, double *dY1, double *dX2, double *dY2, int iNumXY, double dUpLimit, double dLowLimit);
int countingForging (double **dX, double **dY, int iStartingNode, int iTotalNodes, int iNumXY);




