//**********************************************************************************
//**
//**  File name: 				WormDataManipulation.h
//**  File function:			head file for data manipuation in worm data analysis
//**  Author:					Zhaoyang (John) Feng
//**  Last time modification:   Nov. 19, 2001.
//**
//**********************************************************************************

#include <userint.h>
#include <analysis.h>
#include <ansi_c.h>

#include <backboneDataStruct.h>
#include <WormDataManipulation.h>
#include <wormClassify.h>


//*******************************************************************************
//*******************************************************************************
//**																		   **
//**     Following are the function manipulate the backboneset and the image   **
//**																		   **
//*******************************************************************************

//************************ DisPointsToLine***************************************************************************************
// 																																 
// 		This function takes, a line (defined by slope and intercept, and take a set of points (x, y is defined by xArray         
//            yArray and the number of total points (numXY).  It dertermines the distances of each point to the line.            
// 																																 
//*******************************************************************************************************************************
int DisPointsToLine (double slope, double intercept, double * xArray, double * yArray, int numXY, double * distance )	

{

int index;

//variables used in the calculation
double dAngleLine, dAnglePerpendicular;
double dSlopePerpendicular;
double  dInterceptPerpendicular;
double  dXOrg, dYOrg;

//variables used to make code faster
double dDifSlope;

	//Get the angle of the line
	dAngleLine = atan(slope);
	
	//Get the angle of the Perpendicular Line
	dAnglePerpendicular = dAngleLine + PI/2;
	
	//Get the slope of the perpendicular line
	dSlopePerpendicular = tan (dAnglePerpendicular);
	
	//Calculate the difference here to make the code run faster
	dDifSlope = slope - dSlopePerpendicular;

	for (index = 0; index < numXY; index++)
	{
		//Get the intercept of the perpendicular line for each point
		dInterceptPerpendicular = yArray[index] - dSlopePerpendicular * xArray[index];
		
		//Get the coridinate of the respective original point
		dXOrg = (dInterceptPerpendicular - intercept)/dDifSlope;
		dYOrg = (dXOrg * dSlopePerpendicular) + dInterceptPerpendicular ;
		
		//Get the distance
		distance[index] = sqrt( (dXOrg - xArray[index]) * (dXOrg - xArray[index]) + (dYOrg - yArray[index]) * (dYOrg - yArray[index]) );
		
		//add negative if point is below the line in Y axis
	   if (yArray[index] < xArray[index] * slope + intercept)
	   {
	   		distance[index] = - distance[index] ;
	   }
	   	
	} 

	//report failure for debug purpose
	if (distance == null)
	{
		return 0 ;

	}else return 1;

}


//************************SplitBackboneSet***************************************************************************************
// 																																 
// 		This function takes, a BackboneSet, the number of the backbone points in the set, and total number of desired, and the
//            number of the starting one and split the backbone into two array of coordinates matrix (X, Y) and the major 
//            X angle array for each image node in unit of radius.   This function returns the total valid image numbers                                                                                                           
// 																																 
//*******************************************************************************************************************************
int SplitBackboneSet (BackboneSet * thisBackbone, int numXY, double ** dXOutput, double ** dYOutput, double * dMajorX, double * dCentX, double * dCentY, double * Time, int nodeCount, int startNode, double * dArea, double * dLength)
{

int indexXYPairs, indexNode;
int indexValidNode = 0;

double dCentXTemp = 0, dCentYTemp = 0;

double dMedian; 
double *dTempLength;
int iTemp = 0;
double dTemp;

		dTempLength = (double *)malloc(nodeCount * sizeof(double));
//*get rid of the short length one
		for (indexNode = 0; indexNode < nodeCount; indexNode ++)
		{
			if (thisBackbone->backboneNodePtr[startNode + indexNode] != null )
			{
		
				//dTempLength[indexValidNode] = thisBackbone->backboneNodePtr[startNode + indexNode]->Length; 
				iTemp ++;
			}
			
		}
		
		Median (dTempLength, iTemp, &dMedian);
		dMedian = 0.75 * dMedian;

//*/
		//get the coordinates matrix for X, Y and the majorAxis array for XAxis angle
	for (indexNode = 0; indexNode < nodeCount; indexNode ++)
	{
		if (thisBackbone->backboneNodePtr[startNode + indexNode] != null )
		{
			//dTemp =  thisBackbone->backboneNodePtr[startNode + indexNode]->Length;
			if (dTemp > dMedian)
			{
				for (indexXYPairs = 0; indexXYPairs < numXY; indexXYPairs ++)
				{
					dXOutput[indexValidNode][indexXYPairs] = thisBackbone->backboneNodePtr[startNode + indexNode]->xPoints[indexXYPairs] ;
					dYOutput[indexValidNode][indexXYPairs] = thisBackbone->backboneNodePtr[startNode + indexNode]->yPoints[indexXYPairs] ;

					//dArea[indexValidNode] = thisBackbone->backboneNodePtr[startNode + indexNode]->Area;
					//dLength[indexValidNode] = thisBackbone->backboneNodePtr[startNode + indexNode]->Length; 
					
					//Time[indexValidNode] = indexNode * 1;
				}
				
			 	//dArea[indexValidNode] = thisBackbone->backboneNodePtr[startNode + indexNode]->Area;
				//dLength[indexValidNode] = thisBackbone->backboneNodePtr[startNode + indexNode]->Length; 
				Time[indexValidNode] = indexNode * 1;
				
				//dMajorX[indexValidNode] =  (thisBackbone->backboneNodePtr[startNode + indexNode]-> majorAxis) * PI/180 ;

				//dCentX[indexValidNode] = (thisBackbone->backboneNodePtr[startNode + indexNode]->absCentX);
				//dCentY[indexValidNode] = (thisBackbone->backboneNodePtr[startNode + indexNode]->absCentY) ;

				Sum1D (dXOutput[indexValidNode], numXY, &dCentXTemp);
				Sum1D (dYOutput[indexValidNode], numXY, &dCentYTemp);
				
				dCentX[indexValidNode] = dCentXTemp / numXY;
				dCentY[indexValidNode] = dCentYTemp / numXY;

				indexValidNode ++;
			}
		}
	}
	
	free (dTempLength);
	
	return indexValidNode;
}

//************************SplitBackboneToDistanceAndAngles***********************************************************************
// 																																 
// 		This function takes, a Backbone Image node (X, Y array and number of backbone points. This fuction will split the X/Y
//            coordinate to yield two array of data: the distance of each backbone to its previous one, and the angle of each
//            backbone to its previous one.  The first data in the distance and angles are reference the first backbone points
//			  with the orignial point(distance(0) and angle (0)).
// 																																 
//*******************************************************************************************************************************
int SplitBackboneToDistanceAndAngles (double * X, double * Y, int NumXY, double * Distances, double * Angles)
{

int index;
double dNextCentX, dNextCentY;

		for (index = 0; index < NumXY - 1; index ++)
		{
		
			DisAngleBetweenTwoPoints (X[index], Y[index], X[index + 1], Y[index + 1], &Angles[index +1], &Distances[index +1]) ;
		}
		
		//The first one is referenced to original point
		DisAngleBetweenTwoPoints (0, 0, X[0], Y[0], &Angles[0], &Distances[0]) ;
		

		if (Angles != 0 && Distances != 0)
		{
			return 1;
			
		}else return 0;
}

//************************ReconstructBackboneFromDistanceAndAngles***************************************************************
// 																																 
// 		This function takes, a set of arrays: Arrays of distances and arrays of angles.  This function just assume, the arrays are
//            data from the function of SplitBackboneToDistanceAndAngle.  This function will reconstruct the X and Y cooridinate
//            from the input data.
// 																																 
//*******************************************************************************************************************************
int ReconstructBackboneFromDistanceAndAngles (double * Distances, double * Angles, int NumXY, double * XOut, double * YOut)
{

int index;

		//Get the first one
		XOut[0] = Distances[0] * cos(Angles[0]);
		YOut[0] = Distances[0] * sin(Angles[0]);
	
		//For the later
		for (index = 0; index < NumXY - 1; index ++)
		{
			XOut[index + 1] = XOut[index] + Distances[index + 1] * cos(Angles[index + 1]);
			YOut[index + 1] = YOut[index] + Distances[index + 1] * sin(Angles[index + 1]);
		}
		
		if (XOut != null && YOut != null)
		{
			return 1;
		}else return 0;
		
}

//************DisAngleBetweenTwoPoints***************************************************************************************
//																															
//			This function calculates the distance and the angle for point 2 to point 1.										
//																															
//***************************************************************************************************************************
int DisAngleBetweenTwoPoints (double dX1, double dY1, double dX2, double dY2, double * dAngle, double * dDistance)
{

double dXTemp, dYTemp;

		dXTemp = dX2 - dX1;
		dYTemp = dY2 - dY1;
				
		* dDistance = sqrt(dXTemp * dXTemp + dYTemp * dYTemp);
		if (* dDistance < 0)
		{
			return -1;
		}

		* dAngle = atan2 (dYTemp, dXTemp);
		
		if (* dAngle > PI || * dAngle < PI)
		{
			return 0 ;
		}
		
		return 1;
}


//******************************************************************************
//*
//*         Function still needs work.
//*
//******************************************************************************

//
int AngleIndependentOfX (double * X, double * Y, double * Theta, int numXY)     
{

int index;
double TempX, TempY;
double TempX1, TempY1;
double TempX2, TempY2;


//double newX, newY;
double aX, aY;
double bX, bY;
double ab;
double absA, absB;

double z;
double dAngleOutput;


	for (index = 0; index < numXY - 2; index ++)
	{
		TempX = X[index];
		TempY = Y[index]; 

		TempX1 = X[index + 1];
		TempY1 = Y[index + 1];
		
		TempX2 = X[index + 2];
		TempY2 = Y[index + 2];

		//a->
		aX = (TempX1 - TempX);
		aY = (TempY1 - TempY);

		//b->
		bX = (TempX2 - TempX1);
		bY = (TempY2 - TempY1);

		//a*b
		ab = aX * bX + aY * bY;
		
		//|a| |b|
		absA = (aX * aX + aY * aY);
		absB = (bX * bX + bY * bY);
		
		z = aX * bY - bX * aY;
		
		dAngleOutput = acos (ab / sqrt (absA * absB));
		
		//if it is anticlockwise add minus
		if (z < 0) dAngleOutput = - dAngleOutput;

		Theta[index] = dAngleOutput * 180/PI;
		
	}
	
	/*
	for (index = 0; index < numXY - 2; index ++)
	{
	
		Theta[index] = Theta[index] - Theta[0];
	}
	//*/
	
	return 1; 
}


// **************************************************************************************
//				BackboneSet addBackbone
//
// 	pass in newBackbone, which is already an allocated array from imaqBackbone
//  BackboneNode destructor calles imaqDestroy to clear the memory
// **************************************************************************************
int angleAverage (double *angles, int iArrayNumber, double * dAverage)
{
int index;
double dTempSin, dTempCos;

		dTempSin = 0;
		dTempCos = 0;

		//We do not need the first one
		for (index = 0; index < iArrayNumber; index ++)
		{
			dTempSin = dTempSin + sin(angles[index]);
			dTempCos = dTempCos + cos(angles[index]);
		}
			
		dTempSin = dTempSin / iArrayNumber;
		dTempCos = dTempCos / iArrayNumber;
		
		* dAverage = atan2(dTempSin, dTempCos);

		return 1; 
}


//************************GetDifferentsOfDistancesAndAngles**********************************************************************
// 																																 
// 		This function will get the distance and angle array to calculate the difference between those two consequent data points
// 																																 
//*******************************************************************************************************************************

int GetDifferentsOfDistancesAndAngles (double * Distances, double * Angles, int NumXY, double * DistancesOut, double * AnglesOut)
{

int index ;

		for (index = 1; index < NumXY - 1; index ++)
		{
			DistancesOut[index + 1] = Distances[index + 1] - Distances[index] ;
			AnglesOut[index + 1] = Angles[index + 1] - Angles[index] ;
			
			if (DistancesOut[index + 1] < 0)
			{
				DistancesOut[index + 1] = - DistancesOut[index + 1];
			}

			if (AnglesOut[index + 1] < 0)
			{
				AnglesOut[index + 1] = - AnglesOut[index + 1];
			}

		}
		
		DistancesOut[0] = Distances[0];
		AnglesOut[0] = Angles[0];
		
		if (DistancesOut != null && AnglesOut != null)
		{
			return 1;
		}else return 0;
}

int countFrequent(double *dAngle, double * dSpeed, int totalNodes, double dMean, int *count, int *unchange)
{

double *dAngleTemp;
int iCount = 0, iIsCross;
int index;
int iLongestNonChange = 1;
int iCurrentNonChange = 0;

int iNotMove = 0;

	dAngleTemp = (double *)malloc(totalNodes * sizeof (double));

	LinEv1D (dAngle, totalNodes, 1.0, - dMean, dAngleTemp);
	
  	for (index = 0; index < totalNodes - 1; index ++)
  	{
  		if (dSpeed[index] <=  0.5)  iNotMove = 1;
  		
 		if ((dAngleTemp[index] * dAngleTemp[index + 1] <= 0 ) && iNotMove !=1) iIsCross = 1;
 		
 		if (iIsCross == 1)
 		{
 			iIsCross = 0;
 			iCount += 1;
 			if (iLongestNonChange < iCurrentNonChange) iLongestNonChange = iCurrentNonChange ;
 			iCurrentNonChange = 0;

 		} else iCurrentNonChange += 1;
 	}
 	
 	*count = iCount;
 	*unchange = iLongestNonChange;
 	
 	free (dAngleTemp);
 	
 	return 1;
}


int RotateBackbones (double ** X, double ** Y, int iTotalNodes, int numXY, double **OutX, double **OutY, double ** dAC, double **BPAs, double *dBPAAverage)
{

int indexWhichNode, indexWhichBackbonePoint;

double dHeadX, dHeadY, dTailX, dTailY;
double *dCurrentX, *dCurrentY;
double dAngleRotated, dDistance;
double dXTemp, dYTemp;
double dXMean, dYMean;

double dXCurrentRotated, dYCurrentRotated;
double dTempDistance;
double dAngleC;
double *dAngle, *dDistances;

double dTempSin, dTempCos;

	dCurrentX = (double *) malloc (numXY * sizeof(double));
	dCurrentY = (double *) malloc (numXY * sizeof(double));
	dAngle = (double *) malloc (numXY * sizeof(double));
	dDistances = (double *) malloc (numXY * sizeof(double));
	
	for (indexWhichNode = 0; indexWhichNode < iTotalNodes; indexWhichNode ++)
	{
	
//Get the data
		for (indexWhichBackbonePoint = 0; indexWhichBackbonePoint < numXY; indexWhichBackbonePoint ++)
		{
			dCurrentX[indexWhichBackbonePoint] = X[indexWhichNode][indexWhichBackbonePoint];
			dCurrentY[indexWhichBackbonePoint] = Y[indexWhichNode][indexWhichBackbonePoint];
		}
		
		dHeadX = dCurrentX[0];
		dHeadY = dCurrentY[0];
		
		dTailX = dCurrentX[numXY - 1];
		dTailY = dCurrentY[numXY - 1];

		Mean (dCurrentX, numXY, &dXMean);
		Mean (dCurrentY, numXY, &dYMean);

		DisAngleBetweenTwoPoints (dTailX, dTailY, dHeadX, dHeadY, &dAngleRotated, &dDistance);

		for(indexWhichBackbonePoint = 0; indexWhichBackbonePoint < numXY; indexWhichBackbonePoint ++)
		{
			dXTemp = dCurrentX[indexWhichBackbonePoint] - dXMean;
			dYTemp = dCurrentY[indexWhichBackbonePoint] - dYMean;
		
			dXCurrentRotated = dXTemp * cos (dAngleRotated) + dYTemp * sin (dAngleRotated);
			dYCurrentRotated = - dXTemp * sin (dAngleRotated) + dYTemp * cos (dAngleRotated);
			
			//DisAngleBetweenTwoPoints (dCenX[indexWhichNode], dCenY[indexWhichNode], dXCurrent, dYCurrent, &dAngleToCentroid[indexWhichNode][index], &dDistanceTemp) ;
			DisAngleBetweenTwoPoints (0, 0, dXCurrentRotated, dYCurrentRotated, &dAngleC, &dTempDistance) ;
			
			if (dAngleC > PI/2) dAngleC = PI - dAngleC;
			if (dAngleC < - PI/2) dAngleC = - PI - dAngleC;
		
			OutX[indexWhichNode][indexWhichBackbonePoint] = dXCurrentRotated;
			OutY[indexWhichNode][indexWhichBackbonePoint] = dYCurrentRotated;

			dCurrentX[indexWhichBackbonePoint] = dXCurrentRotated;
			dCurrentY[indexWhichBackbonePoint] = dYCurrentRotated;
			
			dAC[indexWhichNode][indexWhichBackbonePoint] = dAngleC;
			
		}
		
		SplitBackboneToDistanceAndAngles (dCurrentX, dCurrentY, numXY, dDistances, dAngle);

		for(indexWhichBackbonePoint = 0; indexWhichBackbonePoint < numXY; indexWhichBackbonePoint ++)
		{
			BPAs[indexWhichNode][indexWhichBackbonePoint]  = dAngle[indexWhichBackbonePoint];
		}
		
		dTempSin = 0;
		dTempCos = 0;

		//We do not need the first one
		for (indexWhichBackbonePoint = 1; indexWhichBackbonePoint < numXY; indexWhichBackbonePoint ++)
		{
			dTempSin = dTempSin + sin(dAngle[indexWhichBackbonePoint]);
			dTempCos = dTempCos + cos(dAngle[indexWhichBackbonePoint]);
		}
			
		dTempSin = dTempSin / (numXY - 1);
		dTempCos = dTempCos / (numXY - 1);
		
		dBPAAverage[indexWhichNode] = atan2(dTempSin, dTempCos);
		
   }
   
   free (dCurrentX);
   free (dCurrentY);
   free (dAngle);
   free (dDistances);
   
   return 1;
}


int IsForging (double *dX1, double *dY1, double *dX2, double *dY2, int iNumXY, double dUpLimit, double dLowLimit)
{

int indexWhichBackbonePoint;

double * dTempLocalSpeedTail;												  
double * dTempLocalSpeedHead;

double dXTemp1, dXTemp2, dYTemp1, dYTemp2;
double dTempDistance;
double dTempLocalSpeed1, dTempLocalSpeed2;
double dTailAverage;
double dHeadAverage;
double dTemp;
int iHead = 4, iTail = 20;
int iIsForging;

	dTempLocalSpeedHead = (double *) malloc (4 * sizeof(double));
	dTempLocalSpeedTail = (double *) malloc (20 * sizeof (double));

	
	for (indexWhichBackbonePoint = 0; indexWhichBackbonePoint < iNumXY; indexWhichBackbonePoint ++)
	{
		if (indexWhichBackbonePoint < iHead || indexWhichBackbonePoint >= iTail)
		{
			dXTemp1 = dX1[indexWhichBackbonePoint];
			dXTemp2 = dX2[indexWhichBackbonePoint];
				
			dYTemp1 = dY1[indexWhichBackbonePoint];
			dYTemp2 = dY2[indexWhichBackbonePoint];
		}else exit;
		
		dTempDistance = sqrt ((dXTemp2 - dXTemp1)*(dXTemp2 - dXTemp1) + (dYTemp2 - dYTemp1) * (dYTemp2  - dYTemp1));

		if (indexWhichBackbonePoint < iHead)
		{
			dTempLocalSpeedHead[indexWhichBackbonePoint] = dTempDistance;
		}
			
		if (indexWhichBackbonePoint >= iTail)
		{
			dTempLocalSpeedTail[indexWhichBackbonePoint - iTail] = dTempDistance;
		}
			
	}
	
	StdDev (dTempLocalSpeedHead, iHead, &dHeadAverage, &dTemp);
	StdDev (dTempLocalSpeedTail, iTail, &dTailAverage, &dTemp);
	
	if (dHeadAverage >= dUpLimit && dTailAverage <= dLowLimit) iIsForging = 1;
	else iIsForging = 0;
	
	free (dTempLocalSpeedHead);
	free (dTempLocalSpeedTail);
	
	return iIsForging;

}

//*
int countingForging (double **dX, double **dY, int iStartingNode, int iTotalNodes, int iNumXY)
{
int indexWhichNode, indexWhichBackbonePoint;

double * dCurrentX;
double * dCurrentY;

double * dNextX;
double * dNextY;

int iIsForging = 0;

	dCurrentX = (double *) malloc (iNumXY * sizeof(double));
	dCurrentY = (double *) malloc (iNumXY * sizeof (double));
	dNextX = (double *) malloc (iNumXY * sizeof(double));
	dNextY = (double *) malloc (iNumXY * sizeof (double));

	for (indexWhichNode = iStartingNode; indexWhichNode < iStartingNode + iTotalNodes - 1; indexWhichNode ++)
	{
	
		for (indexWhichBackbonePoint = 0; indexWhichBackbonePoint < iNumXY; indexWhichBackbonePoint ++)
		{
			dCurrentX[indexWhichBackbonePoint] = dX[indexWhichNode][indexWhichBackbonePoint];
			dNextX[indexWhichBackbonePoint] = dX[indexWhichNode + 1][indexWhichBackbonePoint];
				
			dCurrentY[indexWhichBackbonePoint] = dY[indexWhichNode][indexWhichBackbonePoint];
			dNextY[indexWhichBackbonePoint] = dY[indexWhichNode + 1][indexWhichBackbonePoint];
		}
			
		iIsForging = iIsForging + IsForging (dCurrentX, dCurrentY, dNextX, dNextY, iNumXY, 20, 10);
	
	}
	
	free (dCurrentX);
	free (dCurrentY);
	free (dNextX);
	free (dNextY);

	return 0;
}
//*/


