#include <utility.h>
//#include <formatio.h>
#include "nivision.h"
#include <ansi_c.h>
#include "lowlvlio.h"
#include "backboneDataStruct.h"  

// **************************************************************************************
//				BackboneNode constructor
// **************************************************************************************
BackboneNode * newBackboneNode(int numXYpairs, double newTime, double newAbsCentX, double newAbsCentY, ImageInfor newImageInfor, double * newXpoints, double * newYpoints, int iVersion)
{

int index ; 
BackboneNode * newNode ;

	newNode = (BackboneNode *) malloc ( sizeof(BackboneNode) ) ;
	
	if (newNode == null) return MEM_ERROR ;
	
	//controls
	newNode->Time = newTime;
	newNode->absCentX = newAbsCentX ;
	newNode->absCentY = newAbsCentY ;

	if (iVersion <= 1)
	{
		newNode->imageInfor.iLoopType = newImageInfor.iLoopType;
		newNode->imageInfor.dArea = newImageInfor.dArea;
		newNode->imageInfor.dWormLength = newImageInfor.dWormLength;
		newNode->imageInfor.dTransparency = newImageInfor.dTransparency;
		newNode->imageInfor.dThickness = newImageInfor.dThickness;
		newNode->imageInfor.dFatness = newImageInfor.dFatness;

		//self define
		newNode->imageInfor.dLengthToPixelNumber = newImageInfor.dLengthToPixelNumber;
		//shape equivalence analysis
		newNode->imageInfor.dMaxIntercept = newImageInfor.dMaxIntercept;
		newNode->imageInfor.dMeanInterceptPerpendicular = newImageInfor.dMeanInterceptPerpendicular;
		newNode->imageInfor.dEquivalenceEllipsRatio = newImageInfor.dEquivalenceEllipsRatio;
		newNode->imageInfor.dEllipsMajorAxis = newImageInfor.dEllipsMajorAxis;
		newNode->imageInfor.dEllipsRatio = newImageInfor.dEllipsRatio;
		newNode->imageInfor.dRectBigSide = newImageInfor.dRectBigSide;
		newNode->imageInfor.dRectRatio = newImageInfor.dRectRatio;
		//shape feature

		newNode->imageInfor.dElongationFactor = newImageInfor.dElongationFactor;
		newNode->imageInfor.dCompactnessFactor = newImageInfor.dCompactnessFactor;
		newNode->imageInfor.dHeywoodCicularityFactor = newImageInfor.dHeywoodCicularityFactor;
		newNode->imageInfor.dTypeFactor = newImageInfor.dTypeFactor;
		newNode->imageInfor.dHydraulicRadius = newImageInfor.dHydraulicRadius;
		newNode->imageInfor.dWaddelDiskDiameter = newImageInfor.dWaddelDiskDiameter;
		newNode->imageInfor.dIXX = newImageInfor.dIXX;
		newNode->imageInfor.dIYY = newImageInfor.dIYY;
		newNode->imageInfor.dIXY = newImageInfor.dIXY;
		
//need to continew
	}

	if ( (newXpoints != null) && (newYpoints != null) )
	{
		// these point to memory allocated previously from the heap!!!
		newNode->xPoints = (double *) malloc( numXYpairs * sizeof(double) ) ;
		newNode->yPoints = (double *) malloc( numXYpairs * sizeof(double) ) ;
		newNode->iIsBkbp = 1;
	
	
		for (index = 0; index < numXYpairs; index++)
		{
			newNode->xPoints[index] = newXpoints[index] ;
			newNode->yPoints[index] = newYpoints[index] ;
		}
	} else
	{
			newNode->xPoints = null ;
			newNode->yPoints = null ; //make sure it is null.
			newNode->iIsBkbp = 0;

	}
exit1:
	return newNode ;
}


// **************************************************************************************
//				BackboneNode:: destructor
// **************************************************************************************
int destroyBackboneNode(BackboneNode * thisNode)
{
	// possibly the node was not initialized, should not be deleting it though
	if (!thisNode) 
		return 1 ;
	
	if (!thisNode->xPoints) free(thisNode->xPoints) ;
	if (!thisNode->yPoints) free(thisNode->yPoints) ;
	
	
	free(thisNode) ;
	
	return 1 ;

}



// **************************************************************************************
//				BackboneNode:: readBackboneNode
// **************************************************************************************
BackboneNode * readBackboneNode(int filePtr, BackboneSet * thisSet, int iVersion)
{
  
  double newTime;
  double newAbsCentX, newAbsCentY;
  double * newXpoints, * newYpoints ;
  ImageInfor newImageInfor;
  int iIsbbp;
 // int iLoopType;
//  double dDebug;
//  int iDebug;

	read (filePtr, &newTime, 8); 
//	dDebug = newTime;
	
	read (filePtr, &newAbsCentX, 8); 
//	dDebug = newAbsCentX;

	read (filePtr, &newAbsCentY, 8); 
//	dDebug =  newAbsCentY;
	
	if (iVersion <= 1)
	{
		read (filePtr, &newImageInfor.iLoopType, 4); 
		//iDebug = newImageInfor.iLoopType;
		read (filePtr, &newImageInfor.dArea, 8);
		if ( (newTime == - 2.0))
		{
			if( (newImageInfor.dArea == -2.0) && (newAbsCentX == -2.0) && (newAbsCentY == -2.0) )
			{
				if( (newImageInfor.iLoopType == -2) || (newImageInfor.iLoopType == 0) )

				return null;
			}
		}
		read (filePtr, &newImageInfor.dWormLength, 8); 
//		dDebug = newImageInfor.dWormLength;
//here is bug
		read (filePtr, &newImageInfor.dTransparency, 8); 
		read (filePtr, &newImageInfor.dThickness, 8);
		read (filePtr, &newImageInfor.dFatness, 8); 
		read (filePtr, &newImageInfor.dLengthToPixelNumber, 8);
		read (filePtr, &newImageInfor.dMaxIntercept, 8); 
		read (filePtr, &newImageInfor.dMeanInterceptPerpendicular, 8); 
		read (filePtr, &newImageInfor.dEquivalenceEllipsRatio, 8); 
		read (filePtr, &newImageInfor.dEllipsMajorAxis, 8); 
		read (filePtr, &newImageInfor.dEllipsRatio, 8); 
		read (filePtr, &newImageInfor.dRectBigSide, 8); 
		read (filePtr, &newImageInfor.dRectRatio, 8); 

		read (filePtr, &newImageInfor.dElongationFactor, 8); 
		read (filePtr, &newImageInfor.dCompactnessFactor, 8); 
		read (filePtr, &newImageInfor.dHeywoodCicularityFactor, 8); 
		read (filePtr, &newImageInfor.dTypeFactor, 8); 
		read (filePtr, &newImageInfor.dHydraulicRadius, 8); 
		read (filePtr, &newImageInfor.dWaddelDiskDiameter, 8); 
		read (filePtr, &newImageInfor.dIXX, 8); 
		read (filePtr, &newImageInfor.dIYY, 8); 
		read (filePtr, &newImageInfor.dIXY, 8); 
		
	}
	
	read (filePtr, &iIsbbp, 4);

	if (iIsbbp == 1)
	{
		newXpoints = (double *) calloc (thisSet->NumXYpairs, sizeof(double) ) ;
		newYpoints = (double *) calloc (thisSet->NumXYpairs, sizeof(double) ) ;

		read (filePtr, newXpoints, 8 * thisSet->NumXYpairs) ;
		read (filePtr, newYpoints, 8 * thisSet->NumXYpairs) ;
	} else
	{
	  	newXpoints = null;
	  	newYpoints = null;
	
	}
																		
	return newBackboneNode(thisSet->NumXYpairs, newTime, newAbsCentX, newAbsCentY, newImageInfor, newXpoints, newYpoints, iVersion); 
}

// **************************************************************************************
//				BackboneNode:: writeBackboneNode
// **************************************************************************************
int writeBackboneNode(BackboneNode * thisNode, int filePtr, BackboneSet * thisSet)
{

  int error ;
  double negTwo = -2.0;
  int iZero = 0;
  int iOne = 1;
  int iMinusTwo = -2;

	if (thisNode == null)
	{
		// if a null node, write the height and width are zero, and move onto the next node
		write (filePtr, &negTwo, 8);    //Time
		write (filePtr, &negTwo, 8);   //absCentX
		write (filePtr, &negTwo, 8);   //absCentY
		
		//
		write (filePtr, &iMinusTwo, 4);	//iLoopTyp
		write (filePtr, &negTwo, 8);	//dArea
		
		return 1 ;
	}

	write (filePtr, &(thisNode->Time), 8);
	write (filePtr, &(thisNode->absCentX), 8);
	write (filePtr, &(thisNode->absCentY), 8);

	//JF
	write (filePtr, &thisNode->imageInfor.iLoopType, 4); 
	write (filePtr, &thisNode->imageInfor.dArea, 8); 
	write (filePtr, &thisNode->imageInfor.dWormLength, 8); 
	write (filePtr, &thisNode->imageInfor.dTransparency, 8); 
	write (filePtr, &thisNode->imageInfor.dThickness, 8); 
	write (filePtr, &thisNode->imageInfor.dFatness, 8); 

	write (filePtr, &thisNode->imageInfor.dLengthToPixelNumber, 8);
		
	write (filePtr, &thisNode->imageInfor.dMaxIntercept, 8); 
	write (filePtr, &thisNode->imageInfor.dMeanInterceptPerpendicular, 8); 
	write (filePtr, &thisNode->imageInfor.dEquivalenceEllipsRatio, 8); 
	write (filePtr, &thisNode->imageInfor.dEllipsMajorAxis, 8); 
	write (filePtr, &thisNode->imageInfor.dEllipsRatio, 8); 
	write (filePtr, &thisNode->imageInfor.dRectBigSide, 8); 
	write (filePtr, &thisNode->imageInfor.dRectRatio, 8); 

	write (filePtr, &thisNode->imageInfor.dElongationFactor, 8); 
	write (filePtr, &thisNode->imageInfor.dCompactnessFactor, 8); 
	write (filePtr, &thisNode->imageInfor.dHeywoodCicularityFactor, 8); 
	write (filePtr, &thisNode->imageInfor.dTypeFactor, 8); 
	write (filePtr, &thisNode->imageInfor.dHydraulicRadius, 8); 
	write (filePtr, &thisNode->imageInfor.dWaddelDiskDiameter, 8); 
	write (filePtr, &thisNode->imageInfor.dIXX, 8); 
	write (filePtr, &thisNode->imageInfor.dIYY, 8); 
	write (filePtr, &thisNode->imageInfor.dIXY, 8); 
	
	if ( ( (thisNode->xPoints != NULL) && (thisNode->yPoints != NULL ) ) || (thisNode->iIsBkbp == 1) )
	{
	
		write (filePtr, &iOne, 4); 
	
	}else 
	{
		write (filePtr, &iZero, 4); 
	}
	
	if ( ( (thisNode->xPoints != NULL) && (thisNode->yPoints != NULL ) ) || (thisNode->iIsBkbp == 1) )
	{
		error = write (filePtr, thisNode->xPoints, 8 * thisSet->NumXYpairs) ;
		if (error != 8 * thisSet->NumXYpairs) ;
		error = write (filePtr, thisNode->yPoints, 8 * thisSet->NumXYpairs) ;
	}
	return 1; 
}


// **************************************************************************************
//				BackboneSet constructor
// **************************************************************************************
BackboneSet * newBackboneSet(char * newBackboneSetName, int newNumXYpairs, int newNodeCount, int iFrameRate)
{

int index ;
BackboneSet * newSet ;
	
	newSet = (BackboneSet *) malloc ( sizeof(BackboneSet) ) ;

//setName
	index = 0 ;
	while (newBackboneSetName[index] != '\0' && index < MAX_NAME_LEN) index++ ;
	index-- ;
	newBackboneSetName[index--] = '\0' ;	 // 't'
	newBackboneSetName[index--] = '\0' ;	 // 'a'
	newBackboneSetName[index--] = '\0' ;	 // 'd'
	newBackboneSetName[index--] = '\0' ;	 // '.'

	newSet->setName = (char *) malloc ( (index + 10) * sizeof(char) ) ;
	sprintf(newSet->setName, "%sBack.bkb", newBackboneSetName) ;

//setDate for version control
	strcpy( newSet->Date, DateStr() ) ; 
	
	newSet->isBbpAligned = - 1;
	newSet->NumXYpairs = newNumXYpairs ;
	newSet->NodeCount = newNodeCount ;
	
//AVI change
	newSet->FrameRate = iFrameRate;
	
//other count should be modified later
	newSet->filePtr = null ;
	
	// allocate space to point to all of the BackboneNodes within (pointers are size long)
	newSet->backboneNodePtr = (BackboneNode **) malloc ( newSet->NodeCount * sizeof(BackboneNodePtr) ) ;

	for (index = 0; index < newSet->NodeCount; index++)
	{
		// make sure the pointers aren't pointing anywhere
		newSet->backboneNodePtr[index] = null ;
	}
	
	return newSet ;
}




// **************************************************************************************
//				BackboneSet constructor from file
//
//			if newBackboneSetNum = -1, newBackboneSetName already has the setNum included
//
//			otherwise, concatinate the setNum with the setName + .dat to read from disk
//
// **************************************************************************************
BackboneSet * readBackboneSet(char * newBackboneSetName)
{

 int index, error; 

 int testFilePtr ;
 BackboneSet * newSet ;
 char fileName[MAX_NAME_LEN + 3] ; 
 char charCount[4] ;
 int iVersion = -1;
 
// int iDubug;
 
	testFilePtr = open (newBackboneSetName, O_RDONLY, 0);
	
	if ( testFilePtr == -1 ) return null ;
	
	newSet = (BackboneSet *) malloc ( sizeof(BackboneSet) ) ;

	newSet->filePtr = testFilePtr ;
	lseek (newSet->filePtr, 0, SEEK_SET);

//read name	
	index = 0 ;
	while (newBackboneSetName[index] != '\0' && index < MAX_NAME_LEN + 3) index++ ;
	newSet->setName = (char *) malloc ( (index + 1) * sizeof(char) ) ;
	strcpy(newSet->setName, newBackboneSetName) ; 

//read date
	error = read (newSet->filePtr, &(newSet->Date), 11);
	getBackboneVersion (newSet, &iVersion);

	error = read (newSet->filePtr, &(newSet->isBbpAligned), 4);
	error = read (newSet->filePtr, &(newSet->NumXYpairs), 4);
//	iDubug = newSet->NumXYpairs;
	
	error = read (newSet->filePtr, &(newSet->NodeCount), 4);
//	iDubug = newSet->NodeCount;

	error = read (newSet->filePtr, &(newSet->type1LoopCount), 4);
//	iDubug = newSet->type1LoopCount;

	error = read (newSet->filePtr, &(newSet->type2LoopCount), 4);
//		iDubug = newSet->type2LoopCount;

	error = read (newSet->filePtr, &(newSet->type3LoopCount), 4);
//		iDubug = newSet->type3LoopCount;

	error = read (newSet->filePtr, &(newSet->invalidNodeCount), 4);
//		iDubug = newSet->invalidNodeCount;

//AVI change
	if (iVersion >= 2)
	{
		error =  read (newSet->filePtr, &(newSet->FrameRate), 4); 
	}
	// allocate space to point to all of the BackboneNodes within (pointers are size long)
	newSet->backboneNodePtr = (BackboneNode **) malloc ( newSet->NodeCount * sizeof(BackboneNodePtr) ) ;


	for (index = 0; index < newSet->NodeCount; index++)
	{
		newSet->backboneNodePtr[index] = readBackboneNode(newSet->filePtr, newSet, iVersion) ;
	}

	return newSet ;
}


// **************************************************************************************
//				BackboneSet:: writeBackboneSet
// **************************************************************************************
int writeBackboneSet(BackboneSet * thisBackboneSet)
{
	
  int index, error ;
	
  char fileName[MAX_NAME_LEN + 3] ;
	
	
	// create new file, or erase current file, position the file pointer to the beginning of the file
	thisBackboneSet->filePtr = open (thisBackboneSet->setName, O_WRONLY | O_CREAT | O_TRUNC, S_IRWXU);

	// write the startDate and startTime strings, followed by the number of Backbones in the Set
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->Date), 11);
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->isBbpAligned), 4);
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->NumXYpairs), 4);
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->NodeCount), 4);
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->type1LoopCount), 4);
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->type2LoopCount), 4);
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->type3LoopCount), 4);
	
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->invalidNodeCount), 4);
//
	error = write (thisBackboneSet->filePtr, &(thisBackboneSet->FrameRate), 4);

	for (index = 0; index < thisBackboneSet->NodeCount; index++)
	{
		writeBackboneNode(thisBackboneSet->backboneNodePtr[index], thisBackboneSet->filePtr, thisBackboneSet) ;
	}
	
	return close (thisBackboneSet->filePtr) ;	   // -1 is error, all else is okay

}


// **************************************************************************************
//				BackboneSet destructor
// **************************************************************************************
int destroyBackboneSet(BackboneSet ** BackboneSetPtrPtr)
{
	int index ;

	BackboneSet * thisSet = *BackboneSetPtrPtr ;
	
	// catch the NULL pointer 
	if (thisSet == null) return (0) ;
	
	free( thisSet->setName ) ;
	
	for (index = 0; index < thisSet->NodeCount; index++)
	{
		destroyBackboneNode( thisSet->backboneNodePtr[index] ) ;
		thisSet->backboneNodePtr[index] = null ;
	}
	
	free ( thisSet->backboneNodePtr ) ;
	
	// can free the memory through another pointer, but need to set this to zero
	// to effect thisBackboneSet in main
	*BackboneSetPtrPtr = null ;
	
	return 1 ;
}	


// **************************************************************************************
//				BackboneSet addBackbone
//
// 	pass in newBackbone, which is already an allocated array from imaqBackbone
//  BackboneNode destructor calles imaqDestroy to clear the memory
// **************************************************************************************
int addBackbone(BackboneSet * thisBackboneSet, int whichNode, double newTime, double newAbsCentX, double newAbsCentY, ImageInfor newImageInfor, double * newXpoints, double * newYpoints, int iVersion)
{

	//if an Backbone is passed in, create an Backbone node to hold it, otherwise, point to NULL
	if (newImageInfor.dArea >= 0)																							
	{																														
		thisBackboneSet->backboneNodePtr[whichNode] = newBackboneNode (thisBackboneSet->NumXYpairs, newTime, newAbsCentX, newAbsCentY, newImageInfor, newXpoints, newYpoints, iVersion) ;
	}
	else  thisBackboneSet->backboneNodePtr[whichNode] = null ;
	
	if (thisBackboneSet->backboneNodePtr[whichNode] == null && newXpoints != null && newYpoints != null) return MEM_ERROR ;
	
	return 1 ;
}


//****************************************//
//****************************************//
//*
//*		Help functions
//*
//****************************************//
void getBackboneVersion (BackboneSet *newSet, int *iVersion)
{
int iYear;
char sDate[9] = "";

	sDate[0] = newSet->Date[6];
	sDate[1] = newSet->Date[7];
	sDate[2] = newSet->Date[8];
	sDate[3] = newSet->Date[9];
	sDate[4] = newSet->Date[0];
	sDate[5] = newSet->Date[1];
	sDate[6] = newSet->Date[3];
	sDate[7] = newSet->Date[4];

	iYear = strtoul (sDate, NULL, 10);
	if ( iYear >= 20011210 && iYear <= 20040101)
	{
		*iVersion = 1;
	} else *iVersion = 2;

}
