//**************************************************************************************
//*
//* filename: ImageProcessing.h
//* by: Zhaoyang Feng
//* at: Schafer Lab, UCSD
//*
//* Last modification date: 11/13/2001
//*
//**************************************************************************************


//***************************************************************************************
//*
//*  The algorithm are disigned by Dr. Joongwoo Baek, a Korean postdoct in Pamela Cosman 
//*		 group in Department of Electronic engineering. Most of the codes are originally 
//*      written by him, but are modified and integerated by Zhaoyang Feng.
//*
//***************************************************************************************


//*****Image processing
void DilateOrErodeImage (unsigned char **image_matrix, int H, int W, int Dilate_nErode, int times, int bin_gray) ;
void Smoothing (unsigned char **image_matrix, int H, int W, int times) ;
void ConvertToBinary(unsigned char **image_matrix, int H, int W, int BG_val) ;
int Binarization(unsigned char  **image, int imageHeight, int imageWidth) ;

void GetNeighbors (int row, int col, int *p, unsigned char **image_matrix, int H, int W, int BG_val) ;
void GetNeighborsLabel (int row, int col, int *p, int **image_matrix, int H, int W, int BG_val) ;

void RemoveIsolatedObjects(unsigned char **image_matrix, int image_H, int image_W, int BG_val) ;
void ThresholdingByHistogram(unsigned char **image_matrix, int H, int W, int BG_val) ; 

int GenerateSkelPixelList(int * skelpixList_row, int * skelpixList_col, unsigned char **image_matrix, int imageHeight, int imageWidth) ;
int ThinImage ( unsigned char ** imageMatrix, int imageHeight, int imageWidth) ;

void IntegerateImage2DArrayTo1DArray (unsigned char **image_matrix, int imageHeight, int imageWidth, unsigned char *image) ;
void BreakImage1DArrayTo2DArray (unsigned char *image, int imageHeight, int imageWidth, unsigned char **image_matrix) ;

int DelRedundantSkeleton (unsigned char **image_matrix, int imageWidth, int imageHeight) ;
//****** Constant used here.
#define TRUE 1 
#define FALSE 0 

