/*******Project Infromation*******************************************************************/
/*																							 */
/*		Worm Project:  Tracker system														 */
/*		This is one of the four parts of quantitative behavrior project (4/4)   			 */
/*																							 */
/*																							 */
/*		Zhaoyang Feng   																	 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*		Tracker group  (Zhaoyang Feng, Christopher Cronin, Paul Sternberg, William Schafer)	 */
/*																							 */
/*********************************************************************************************/

//********************************************************************************************/
//**																						 */
//**  File name: 				talkWithDatabase.c           								 */
//**  File function:			functions related to communicate with database    			 */
//**																						 */
//**																						 */
//**																						 */
//**  Author:					Zhaoyang (John) Feng										 */
//**  Last time modification:   April. 25, 2001.											 */
//**																						 */
//**																						 */
//********************************************************************************************/
#include "excel2000.h"
#include "cvi_db.h"
#include <utility.h>
#include <ansi_c.h>
#include <userint.h>
#include <wormMiner.h>
#include <talkWithDatabase.h>
#include <miner.h>

//Onlyone need work, but it is hard, because of some reason	   (the range)

int saveCoordinates (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

//VARIANT *vArray = NULL;
//LPSAFEARRAY MySafeArray = NULL;

//char fileName[MAX_PATHNAME_LEN]; 
VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;


		iTotalNode2 = iTotalNode + 2;
		
		iTotalDataColumn = 4 * iNumXY + 1;
		//write title
    	//Get range string write title
    	if (iNumXY != 30)
    	{
    		MessagePopup ("Sorry", "Have NOT been implemented yet!");
    		return 0;
    	}
    	sprintf(sMessage, "A7:DQ%d", iTotalNode2 + 6);		 //The DQ is the number I need get automatically
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
	   	vArray = (VARIANT *) calloc ( (iTotalDataColumn * iTotalNode2), sizeof(VARIANT));   
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
	    for (index = 0; index < iNumXY; index ++)
	    {
    		sprintf (sMessage, "X[%d]", index);
        	CA_VariantSetCString(&vArray[1 + index * 4], sMessage );
        	
    		sprintf (sMessage, "Y[%d]", index);
        	CA_VariantSetCString(&vArray[2 + index * 4], sMessage );
        	
    		sprintf (sMessage, "Rotated X[%d]", index);
        	CA_VariantSetCString(&vArray[3 + index * 4], sMessage );
        	
    		sprintf (sMessage, "Rotated Y[%d]", index);
        	CA_VariantSetCString(&vArray[4 + index * 4], sMessage );
        }
    	  
    	for (index = 0; index < iTotalDataColumn; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + iTotalDataColumn], sMessage );
    	}
    	
    	for (indexNode = 0; indexNode < iTotalNode; indexNode++)
    	{
        	CA_VariantSetDouble(&vArray[ iTotalDataColumn * (2 + indexNode) + 0], dTime[indexNode] );
   
			if ( iIsBkbp[indexNode]	> 0)
			{

        		for (indexBkp = 0; indexBkp < iNumXY; indexBkp ++)
        		{
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (1 + 4 * indexBkp)], dX[indexNode][indexBkp] );
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (2 + 4 * indexBkp)], dY[indexNode][indexBkp] );
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (3 + 4 * indexBkp)], dXRotated[indexNode][indexBkp] );
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (4 + 4 * indexBkp)], dYRotated[indexNode][indexBkp] );
        		}	
        	}
        	else
        	{
        	    for (indexBkp = 0; indexBkp < iNumXY; indexBkp ++)
        		{
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (1 + 4 * indexBkp)], 0 );
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (2 + 4 * indexBkp)], 0 );
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (3 + 4 * indexBkp)], 0 );
        			CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + (4 + 4 * indexBkp)], 0 );
        		}	

        	
    		}  
    	}	
    	
   		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, iTotalDataColumn, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < iTotalDataColumn; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * iTotalDataColumn + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);    
    
	return 1;
}

int writeGlbData (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;


		iTotalNode2 = iTotalNode + 2;
//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:F%d", iTotalNode2 + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
	   	
	   	vArray = (VARIANT *) calloc ( (6 * iTotalNode2), sizeof(VARIANT));
	   	// if (!vArray)
	   	 //	goto Error;
	   	 	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );

    	sprintf (sMessage, "Global Speed");
        CA_VariantSetCString(&vArray[1], sMessage );

    	sprintf (sMessage, "GlbMvAng");
        CA_VariantSetCString(&vArray[2], sMessage );
       
    	sprintf (sMessage, "DistTo1stCen");
        CA_VariantSetCString(&vArray[3], sMessage );
       
    	sprintf (sMessage, "AngTo1stCen");
        CA_VariantSetCString(&vArray[4], sMessage );
       	
    	sprintf (sMessage, "AngBdFit");
        CA_VariantSetCString(&vArray[5], sMessage );


    	for (index = 0; index < 6; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + 6], sMessage );
    	}
    	
    	for (index = 0; index < iTotalNode; index++)
    	{
        	CA_VariantSetDouble(&vArray[12 + 6*index], dTime[index] );
        	CA_VariantSetDouble(&vArray[13 + 6*index], gSpeed[index] );
        	CA_VariantSetDouble(&vArray[14 + 6*index], gMovingAngles[index] );
        	CA_VariantSetDouble(&vArray[15 + 6*index], gDistanceToFirstPoint[index] );
        	CA_VariantSetDouble(&vArray[16 + 6*index], gAngleToFirstPoint[index] );
        	CA_VariantSetDouble(&vArray[17 + 6*index], gAngleWholeBody[index] );
        			  
    	
    	}	
   	
    	// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 6, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < 6; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * 6 + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
   	//CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);    
    
    return 1;
}  
   		 	 
//Put omega here
//Put foragingAlg foragingDis here
int writeMvPtnData (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;

		iTotalNode2 = iTotalNode + 2;    

//write title
    	//Get range string write title
    	//sprintf(sMessage, "A7:G%d", iTotalNode + 6);
//    	sprintf(sMessage, "A7:H%d", iTotalNode + 6);
    	sprintf(sMessage, "A7:J%d", iTotalNode + 6);

    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
//	   	vArray = (VARIANT *) calloc ( (7 * iTotalNode2), sizeof(VARIANT));   
//	   	vArray = (VARIANT *) calloc ( (8 * iTotalNode2), sizeof(VARIANT));   
	   	vArray = (VARIANT *) calloc ( (10 * iTotalNode2), sizeof(VARIANT));   
	   	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	sprintf (sMessage, "Reversal");
        CA_VariantSetCString(&vArray[1], sMessage );
        
    	sprintf (sMessage, "Forging");
        CA_VariantSetCString(&vArray[2], sMessage );
        
    	sprintf (sMessage, "Loop");
        CA_VariantSetCString(&vArray[3], sMessage );
        
    	sprintf (sMessage, "Sharp Turn");
        CA_VariantSetCString(&vArray[4], sMessage );
        
    	sprintf (sMessage, "Centorid X");
        CA_VariantSetCString(&vArray[5], sMessage );
        
    	sprintf (sMessage, "Centroid Y");
        CA_VariantSetCString(&vArray[6], sMessage );
        
      	sprintf (sMessage, "Omega");
        CA_VariantSetCString(&vArray[7], sMessage );

   		sprintf (sMessage, "foraging Agl");
        CA_VariantSetCString(&vArray[8], sMessage );

    	sprintf (sMessage, "foraging Dis");
        CA_VariantSetCString(&vArray[9], sMessage );

//		for (index = 0; index < 8; index++)
//		for (index = 0; index < 7; index++)
		for (index = 0; index < 10; index++)
    	{
    		sprintf (sMessage, "");
        	//CA_VariantSetCString(&vArray[index + 7], sMessage );
        	CA_VariantSetCString(&vArray[index + 8], sMessage );
    	}
    	
    	for (index = 0; index < iTotalNode; index++)
    	{
        	CA_VariantSetDouble(&vArray[20 + 10*index], dTime[index] );
        	CA_VariantSetDouble(&vArray[21 + 10*index], iRevese[index] );
        	CA_VariantSetDouble(&vArray[22 + 10*index], iForging[index] );
        	CA_VariantSetDouble(&vArray[23 + 10*index], iLoop[index] );
        	CA_VariantSetDouble(&vArray[24 + 10*index], iTurn[index] );
        	CA_VariantSetDouble(&vArray[25 + 10*index], dCenX[index] );
        	CA_VariantSetDouble(&vArray[26 + 10*index], dCenY[index] );
        	CA_VariantSetDouble(&vArray[27 + 10*index], iOmega[index] );
        	CA_VariantSetDouble(&vArray[28 + 10*index], dForagingAlg[index] );
        	CA_VariantSetDouble(&vArray[29 + 10*index], dForagingDis[index] );
    	}	  

		// Create a SAFEARRAY
//    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 7, &MySafeArray);
//    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 8, &MySafeArray);
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 10, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		//for (indexRow = 0; indexRow < 7; indexRow++)
   		 		//for (indexRow = 0; indexRow < 8; indexRow++)
   		 		for (indexRow = 0; indexRow < 10; indexRow++)
   		 		{
   		 	 		//CA_VariantClear (&vArray[index * 7 + indexRow]);
   		 	 		//CA_VariantClear (&vArray[index * 8 + indexRow]);
   		 	 		CA_VariantClear (&vArray[index * 10 + indexRow]);
   		 	 	}
   		 	}
   		 	
   		 	free(vArray);
   		}  

		CA_VariantClear(&myRange);
    	CA_DiscardObjHandle (myRangeHandle);    
    
	return 1;
}

//*/
int writeAccessData (char *Ave, char *Max, char *Min, double val1, double val2, double val3, int hdbc, int *resCode, char *ExpID)  
{

char SQL[1000];
 
	sprintf(SQL, "UPDATE BasicStatistic SET %s = %f, %s = %f, %s = %f WHERE ExpID = '%s'", Ave, val1, Max, val2, Min, val3, ExpID);

	//MessagePopup ("Check", SQL);
   	*resCode = DBImmediateSQL(hdbc, SQL);
   
   	if (*resCode != DB_SUCCESS) 
   	{
   		MessagePopup("Database Error",DBErrorMessage());
   		return 0;
   	}  

	return 1;
}



//----------------------------------------------------------------------------
// SaveAppFile
//----------------------------------------------------------------------------
int SaveAppFile (char *fileName, ExcelObj_Workbook ExcelWorkbookHandle)
{
HRESULT error = 0;
VARIANT MyVariant;
char sExcelPath[MAX_PATHNAME_LEN];
char *sName; 

     if (ExcelWorkbookHandle) 
     { 
            
			SetDir ("c:\\wormExcelData");
			GetDir (sExcelPath);
			sName = strcat (sExcelPath, "\\");
			sName = strcat (sName, fileName);
			sName = strcat (sName, ".xls");
            
            error = CA_VariantSetCString(&MyVariant, sName);
            error = Excel_WorkbookSaveAs (ExcelWorkbookHandle, NULL, MyVariant,
                                                  CA_DEFAULT_VAL, CA_DEFAULT_VAL,
                                                  CA_DEFAULT_VAL, CA_DEFAULT_VAL,
                                                  CA_DEFAULT_VAL, ExcelConst_xlNoChange,
                                                  CA_DEFAULT_VAL, CA_DEFAULT_VAL,
                                                  CA_DEFAULT_VAL, CA_DEFAULT_VAL);
             //close it without saving it
			error = Excel_WorkbookClose (ExcelWorkbookHandle, NULL,
										 CA_VariantBool (VFALSE), MyVariant,
										 CA_DEFAULT_VAL);
										 
            CA_VariantClear(&MyVariant);
    }
    
    CA_VariantClear(&MyVariant);
    
    return 1;
}


int writeBasicImageAnalysisData (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;

			iTotalNode2 = iTotalNode + 2;     

//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:G%d", iTotalNode2 + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
    	vArray = (VARIANT *) calloc ( (7 * iTotalNode2), sizeof(VARIANT));     
    	
	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	sprintf (sMessage, "Area");
        CA_VariantSetCString(&vArray[1], sMessage );
        
    	sprintf (sMessage, "WormLength");
        CA_VariantSetCString(&vArray[2], sMessage );
        
    	sprintf (sMessage, "Transparency");
        CA_VariantSetCString(&vArray[3], sMessage );
        
    	sprintf (sMessage, "Thickness");
        CA_VariantSetCString(&vArray[4], sMessage );
        
    	sprintf (sMessage, "Fatness");
        CA_VariantSetCString(&vArray[5], sMessage );
        
    	sprintf (sMessage, "LengthToPixelNumber");
        CA_VariantSetCString(&vArray[6], sMessage );
        
  		for (index = 0; index < 7; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + 7], sMessage );
    	}
    	
    	for (index = 0; index < iTotalNode; index++)
    	{
        	CA_VariantSetDouble(&vArray[14 + 7*index], dTime[index] );
        	CA_VariantSetDouble(&vArray[15 + 7*index], dArea[index] );
        	CA_VariantSetDouble(&vArray[16 + 7*index], dWormLength[index] );
        	CA_VariantSetDouble(&vArray[17 + 7*index], dTransparency[index] );
        	CA_VariantSetDouble(&vArray[18 + 7*index], dThickness[index] );
        	CA_VariantSetDouble(&vArray[19 + 7*index], dFatness[index] );
        	CA_VariantSetDouble(&vArray[20 + 7*index], dLengthToPixelNumber[index] );   
        }			  
    	
	// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 7, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < 7; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * 7 + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);    
    
    return 1;
}  
    	
    	
int writeIMAQ (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;

			iTotalNode2 = iTotalNode + 2;     

//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:J%d", iTotalNode + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
	   	vArray = (VARIANT *) calloc ( (10 * iTotalNode2), sizeof(VARIANT));   
	   	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	sprintf (sMessage, "ElongationFactor");
        CA_VariantSetCString(&vArray[1], sMessage );
        
    	sprintf (sMessage, "CompactnessFactor");
        CA_VariantSetCString(&vArray[2], sMessage );
        
    	sprintf (sMessage, "HeywoodCicularityFactor");
        CA_VariantSetCString(&vArray[3], sMessage );
        
    	sprintf (sMessage, "TypeFactor");
        CA_VariantSetCString(&vArray[4], sMessage );
        
    	sprintf (sMessage, "HydraulicRadius");
        CA_VariantSetCString(&vArray[5], sMessage );
        
    	sprintf (sMessage, "WaddelDiskDiameter");
        CA_VariantSetCString(&vArray[6], sMessage );
        
		sprintf (sMessage, "IXX");
        CA_VariantSetCString(&vArray[7], sMessage );
        
		sprintf (sMessage, "IYY");
        CA_VariantSetCString(&vArray[8], sMessage );
        
		sprintf (sMessage, "IXY");
        CA_VariantSetCString(&vArray[9], sMessage );
        
    	
    	for (index = 0; index < 10; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + 10], sMessage );
    	}
    	
    	for (index = 0; index < iTotalNode; index++)
    	{
        	CA_VariantSetDouble(&vArray[20 + 10*index], dTime[index] );
        	CA_VariantSetDouble(&vArray[21 + 10*index], dElongationFactor[index] );
        	CA_VariantSetDouble(&vArray[22 + 10*index], dCompactnessFactor[index] );
        	CA_VariantSetDouble(&vArray[23 + 10*index], dHeywoodCicularityFactor[index] );
        	CA_VariantSetDouble(&vArray[24 + 10*index], dTypeFactor[index] );
        	CA_VariantSetDouble(&vArray[25 + 10*index], dHydraulicRadius[index] );
        	CA_VariantSetDouble(&vArray[26 + 10*index], dWaddelDiskDiameter[index] );
        	CA_VariantSetDouble(&vArray[27 + 10*index], dIXX[index] );  
    		CA_VariantSetDouble(&vArray[28 + 10*index], dIYY[index] ); 
    		CA_VariantSetDouble(&vArray[29 + 10*index], dIXY[index] ); 
    	
    	}	
    	
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 10, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < 10; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * 10 + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);      	
    	
	return 1;
}

int writeMorphology (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;

			iTotalNode2 = iTotalNode + 2;     

//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:H%d", iTotalNode + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
    	vArray = (VARIANT *) calloc ( (8 * iTotalNode2), sizeof(VARIANT));
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	sprintf (sMessage, "MaxIntercept");
        CA_VariantSetCString(&vArray[1], sMessage );
        
    	sprintf (sMessage, "MeanInterceptPerpendicular");
        CA_VariantSetCString(&vArray[2], sMessage );
       
    	sprintf (sMessage, "EquivalenceEllipsRatio");
        CA_VariantSetCString(&vArray[3], sMessage );
        
    	sprintf (sMessage, "EllipsMajorAxis");
        CA_VariantSetCString(&vArray[4], sMessage );
        
    	sprintf (sMessage, "EllipsRatio");
        CA_VariantSetCString(&vArray[5], sMessage );
        
    	sprintf (sMessage, "RectBigSide");
        CA_VariantSetCString(&vArray[6], sMessage );
        
		sprintf (sMessage, "RectRatio");
        CA_VariantSetCString(&vArray[7], sMessage );
        
        
    	for (index = 0; index < 8; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + 8], sMessage );
    	}
    	
    	for (index = 0; index < iTotalNode; index++)
    	{
        	CA_VariantSetDouble(&vArray[16 + 8*index], dTime[index] );
        	CA_VariantSetDouble(&vArray[17 + 8*index], dMaxIntercept[index] );
        	CA_VariantSetDouble(&vArray[18 + 8*index], dMeanInterceptPerpendicular[index] );
        	CA_VariantSetDouble(&vArray[19 + 8*index], dEquivalenceEllipsRatio[index] );
        	CA_VariantSetDouble(&vArray[20 + 8*index], dEllipsMajorAxis[index] );
        	CA_VariantSetDouble(&vArray[21 + 8*index], dEllipsRatio[index] );
        	CA_VariantSetDouble(&vArray[22 + 8*index], dRectBigSide[index] );
        	CA_VariantSetDouble(&vArray[23 + 8*index], dRectRatio[index] );  
    		
    	}	
    	
    	// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 8, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < 8; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * 8 + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);   
    	
    return 1;
}

int writeBackboneVector (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;

		iTotalNode2 = iTotalNode + 2;     

		iTotalDataColumn = iNumXY * 2 + 5;
//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:BM%d", iTotalNode2 + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   									
	   //65 = the number of following									
    	//vArray = (VARIANT *) calloc ( (65 * iTotalNode2), sizeof(VARIANT));		 //what this 65 is
    	vArray = (VARIANT *) calloc ( ( iTotalDataColumn * iTotalNode2), sizeof(VARIANT));		 //what this 65 is
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	sprintf (sMessage, "BkbvAngleAverage");
        CA_VariantSetCString(&vArray[1], sMessage );
        
		for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
    		sprintf (sMessage, "BkbvAngles[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[2 + indexBkp], sMessage );
        }
		
		for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
		
    		sprintf (sMessage, "BkbvDistance[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[2 + iNumXY + indexBkp], sMessage );
        }
															    
    	sprintf (sMessage, "BkbvDistanceToBackboneMinimum");
        CA_VariantSetCString(&vArray[2 + iNumXY * 2], sMessage );
        
    	sprintf (sMessage, "BkbvDistanceToBackboneMaximum");
        CA_VariantSetCString(&vArray[3 + iNumXY * 2], sMessage );
        
    	sprintf (sMessage, "BkbvDistanceTo BackboneAverage");
        CA_VariantSetCString(&vArray[4 + iNumXY * 2], sMessage );
        
    	for (index = 0; index < iTotalDataColumn; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + iTotalDataColumn], sMessage );
    	}
    	
    	for (indexNode = 0; indexNode < iTotalNode; indexNode++)
    	{
    	//Reclame
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 0 ], dTime[indexNode] );
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 ], dBkbvAngleAverage[indexNode] );
			
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        	
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 2 + indexBkp], dBkbvAngles[indexNode][indexBkp] );
        	}
        	
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        	
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 2 + iNumXY + indexBkp], dBkbvDistance[indexNode][indexBkp] );
        	}
        	
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 2 + iNumXY*2], dBkbvDistMinToBackboneLength[indexNode] );
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 3 + iNumXY*2], dBkbvDistMaxToBackboneLength[indexNode] );
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 4 + iNumXY*2], dBkbvDistAveToBackboneLength[indexNode] );
        	
    	}	
    	
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, iTotalDataColumn, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < iTotalDataColumn; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * iTotalDataColumn + indexRow]);
   		 	 	}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
//    CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);   
    	
    return 1;
}

int writeLocalMovementAnalysis (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;

		iTotalNode2 = iTotalNode + 2;     
		iTotalDataColumn = iNumXY + 4;
		//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:AH%d", iTotalNode2 + 6);
    	
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
	   	vArray = (VARIANT *) calloc ( (iTotalDataColumn * iTotalNode2), sizeof(VARIANT));		//34 = iNumXY (3) + 4
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
    		sprintf (sMessage, "Speed[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + indexBkp], sMessage );
        }

    	sprintf (sMessage, "SpeedAverage");
        CA_VariantSetCString(&vArray[1 + iNumXY], sMessage );
        
    	sprintf (sMessage, "HeadToTailRatio");
        CA_VariantSetCString(&vArray[2 + iNumXY], sMessage );
        
    	sprintf (sMessage, "Pushing");
        CA_VariantSetCString(&vArray[3 + iNumXY], sMessage );
        
    	for (index = 0; index < iTotalDataColumn; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + iTotalDataColumn], sMessage );
    	}
    	
    	for (indexNode = 0; indexNode < iTotalNode; indexNode++)
    	{
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 0], dTime[indexNode] );
        	
        	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn * 2  + 1 + indexBkp], lclSpeed[indexNode][indexBkp] );
        	}
        	
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + iNumXY], lclSpeedAverage[indexNode] );
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 2 + iNumXY], lclHeadToTailRatio[indexNode] );
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 3 + iNumXY], dPushing[indexNode] );
        	
    	}	
    	
    	
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, iTotalDataColumn, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < iTotalDataColumn; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * iTotalDataColumn + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);   

	return 1;
}

int writeBackbonePosture (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;

			iTotalNode2 = iTotalNode + 2; 

		iTotalDataColumn = iNumXY + 3;
//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:AG%d", iTotalNode2 + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
    	vArray = (VARIANT *) calloc ( (iTotalDataColumn * iTotalNode2), sizeof(VARIANT));
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        //error = Excel_RangeSetItem (myRangeHandle, NULL, CA_VariantInt (1), CA_VariantInt (1), myTitle);

    	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
    		sprintf (sMessage, "BkbvvAngle[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + indexBkp], sMessage );
        	//error = Excel_RangeSetItem (myRangeHandle, NULL, CA_VariantInt (1), CA_VariantInt (2 + indexBkp), myTitle);
        
        }

    	sprintf (sMessage, "BkbvvAngleAverage");
        CA_VariantSetCString(&vArray[1 + iNumXY], sMessage );
        //error = Excel_RangeSetItem (myRangeHandle, NULL, CA_VariantInt (1), CA_VariantInt (3 + iNumXY), myTitle);

    	sprintf (sMessage, "BkbvvAngleMaximum");
        CA_VariantSetCString(&vArray[2 + iNumXY], sMessage );
        //error = Excel_RangeSetItem (myRangeHandle, NULL, CA_VariantInt (1), CA_VariantInt (4 + iNumXY), myTitle);

    	for (index = 0; index < iTotalDataColumn; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + iTotalDataColumn], sMessage );
    	}
    	

    	for (indexNode = 0; indexNode < iTotalNode; indexNode++)
    	{
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 0], dTime[indexNode] );
        	
        	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
        	{
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + indexBkp], dBkbvvAngle[indexNode][indexBkp] );
        	}
        	
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + iNumXY], dBkbvvAngleAverage[indexNode] );
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 2 + iNumXY], dBkbvvAngleMaxium[indexNode] );
        	
    	}	
    					  
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, iTotalDataColumn, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < iTotalDataColumn * (2 + indexNode); indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * iTotalDataColumn * (2 + indexNode) + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);   
    
	return 1;
}

int writeBackbonePointAnalysis (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVrt;
ExcelObj_Range myRangeHandle;

int index;
int iTotalNode2;
int indexRow;

int iTotalDataColumn;

			iTotalNode2 = iTotalNode + 2;     
		iTotalDataColumn= iNumXY * 2 + 3;
		//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:BK%d", iTotalNode2 + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL);
	   	
	   	vArray = (VARIANT *) calloc ( (iTotalDataColumn * iTotalNode2), sizeof(VARIANT));
    	
	   	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
    		sprintf (sMessage, "BkbpSpeed[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + indexBkp], sMessage );
        	
        }						 

    	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
    		sprintf (sMessage, "AngleToCentroid[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + iNumXY + indexBkp], sMessage );
        	
        }

    	sprintf (sMessage, "BkbpSpeedAverage");
        CA_VariantSetCString(&vArray[1 + iNumXY * 2], sMessage );
        
    	sprintf (sMessage, "BkbpHeadToTail");
        CA_VariantSetCString(&vArray[2 + iNumXY * 2], sMessage );
        
    	
    	for (index = 0; index < iTotalDataColumn; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + iTotalDataColumn], sMessage );
    	}
    	
    	for (indexNode = 0; indexNode < iTotalNode; indexNode++)
    	{
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 0], dTime[indexNode] );
        	
        	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        	
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + indexBkp], dBkbpSpeed[indexNode][indexBkp] );
        	}
        	
        	for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        									  
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + iNumXY + indexBkp], dAngleToCentroid[indexNode][indexBkp] );
        	}
        	
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + iNumXY * 2], dBkbpSpeedAverage[indexNode] );
        	CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 2 + iNumXY * 2], dBkbpHeadToTail[indexNode] );
        	
    	}	
    	
  
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode2, iTotalDataColumn, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVrt, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVrt);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < iTotalDataColumn; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * iTotalDataColumn + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVrt);
    CA_DiscardObjHandle (myRangeHandle);  
    
	return 1;
}

int writeQuantitativeImageAnalysis (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;

			iTotalNode2 = iTotalNode + 2;     

		iTotalDataColumn = 10;  //+0*iNumXY
		//write title
    	//Get range string write title
    	sprintf(sMessage, "A7:J%d", iTotalNode + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
	   	vArray = (VARIANT *) calloc ( (10 * iTotalNode2), sizeof(VARIANT));
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	sprintf (sMessage, "BkpDXX");
        CA_VariantSetCString(&vArray[1], sMessage );
        	
    	sprintf (sMessage, "BkpDXY");
        CA_VariantSetCString(&vArray[2], sMessage );
        	
    	sprintf (sMessage, "BkpXY");
        CA_VariantSetCString(&vArray[3], sMessage );
        
    	sprintf (sMessage, "BkpElongationFactor");
        CA_VariantSetCString(&vArray[4], sMessage );
        
		sprintf (sMessage, "CompactnessFactor");
        CA_VariantSetCString(&vArray[5], sMessage );
        
		sprintf (sMessage, "BkpHeight");
        CA_VariantSetCString(&vArray[6], sMessage );
        
		sprintf (sMessage, "XSym");
        CA_VariantSetCString(&vArray[7], sMessage );
        
		sprintf (sMessage, "YSym");
        CA_VariantSetCString(&vArray[8], sMessage );
        
		sprintf (sMessage, "XYSym");
        CA_VariantSetCString(&vArray[9], sMessage );
        
    	for (index = 0; index < 10; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + 10], sMessage );
    	}
    	
    	for (index = 0; index < iTotalNode; index++)	 //there are 20 head
    	{
        	CA_VariantSetDouble(&vArray[20 + 10*index], dTime[index] );
        	CA_VariantSetDouble(&vArray[21 + 10*index], dBkpDXX[index] );
        	CA_VariantSetDouble(&vArray[22 + 10*index], dBkpDYY[index] );
        	CA_VariantSetDouble(&vArray[23 + 10*index], dBkpDXY[index] );
        	CA_VariantSetDouble(&vArray[24 + 10*index], dBkpElgFactor[index] );
        	CA_VariantSetDouble(&vArray[25 + 10*index], dCmpctFactor[index] );
        	CA_VariantSetDouble(&vArray[26 + 10*index], dBkpHight[index] );
        	CA_VariantSetDouble(&vArray[27 + 10*index], dXSym[index] );  
    		CA_VariantSetDouble(&vArray[28 + 10*index], dYSym[index] );  
    		CA_VariantSetDouble(&vArray[29 + 10*index], dXYSym[index] );  
    		
    	}	
    	
    	
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 10, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < 10; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * 10 + indexRow]);
   		 	 		}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
    //CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);   

	return 1;
}


int writeCalTech1 (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;

		iTotalNode2 = iTotalNode + 2;
//write title
    	//Get range string write title
//    	sprintf(sMessage, "A7:F%d", iTotalNode2 + 6);
    	sprintf(sMessage, "A7:C%d", iTotalNode2 + 6);
    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   	
	   	
	   	//vArray = (VARIANT *) calloc ( (6 * iTotalNode2), sizeof(VARIANT));
	   	//3 here means there is 3 sets of data are going to be written.
	   	vArray = (VARIANT *) calloc ( (3 * iTotalNode2), sizeof(VARIANT));
	   	// if (!vArray)
	   	 //	goto Error;
	   	 	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );

    	sprintf (sMessage, "WaveLength");
        CA_VariantSetCString(&vArray[1], sMessage );

    	sprintf (sMessage, "Ampt");
        CA_VariantSetCString(&vArray[2], sMessage );
       

    	//for (index = 0; index < 6; index++)
    	for (index = 0; index < 3; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + 3], sMessage );
    	}
    	
    	for (index = 0; index < iTotalNode; index++)
    	{

        	CA_VariantSetDouble(&vArray[6 + 3*index], dTime[index] );		   //there is 6 ahead
        	CA_VariantSetDouble(&vArray[7 + 3*index], dWavlength[index] );
        	CA_VariantSetDouble(&vArray[8 + 3*index], dAmpt[index] );
    	}	
   	
    	// Create a SAFEARRAY
//    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 6, &MySafeArray);
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, 3, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < 3; indexRow++)
   		 		//for (indexRow = 0; indexRow < 6; indexRow++)
   		 		{
   		 	 		//CA_VariantClear (&vArray[index * 6 + indexRow]);
   		 	 		CA_VariantClear (&vArray[index * 3 + indexRow]);
   		 	 	}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
   	//CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);    
    
    return 1;
}  

int writeCalTech2 (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;

			iTotalNode2 = iTotalNode + 2;     
		
		iTotalDataColumn = 2 * iNumXY + 1;

//write title
    	//Get range string write title
//    	sprintf(sMessage, "A7:BM%d", iTotalNode2 + 6);
    	sprintf(sMessage, "A7:W%d", iTotalNode2 + 6);

    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   									
    	//vArray = (VARIANT *) calloc ( (65 * iTotalNode2), sizeof(VARIANT));
    	vArray = (VARIANT *) calloc ( (iTotalDataColumn * iTotalNode2), sizeof(VARIANT));
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	//sprintf (sMessage, "");
        //CA_VariantSetCString(&vArray[1], sMessage );
        
		//for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
    		sprintf (sMessage, "dFlex[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + indexBkp], sMessage );
        }
		
		for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
		
    		sprintf (sMessage, "dFRE[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + iNumXY + indexBkp], sMessage );
        }
															    
    	for (index = 0; index < iTotalDataColumn; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + iTotalDataColumn], sMessage );
    	}
    	
    	for (indexNode = 0; indexNode < iTotalNode; indexNode++)
    	{
        	CA_VariantSetDouble(&vArray[iTotalDataColumn* (2 + indexNode) + 0], dTime[indexNode] );
        	//CA_VariantSetDouble(&vArray[(11*2 + 5)*2  + 1 + (11*2 + 5)*indexNode], dBkbvAngleAverage[indexNode] );
			
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        	
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn* (2 + indexNode) + 1 + indexBkp], dFlex[indexNode][indexBkp] );
        	}
        	
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        	
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + iNumXY + indexBkp], dFRE[indexNode][indexBkp] );
        	}
        	
    	}	
    	
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, iTotalDataColumn, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < iTotalDataColumn; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * iTotalDataColumn + indexRow]);
   		 	 	}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
//    CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);   
    	
    return 1;
}

//put some thing about Omega, foragingAlg foragingDis here
/*
int writeAdditionalData1 (ExcelObj_Worksheet sheet, int iTotalNode, int iNumXY)
{

VARIANT *vArray = NULL;
LPSAFEARRAY MySafeArray = NULL;
HRESULT error = 0;

//char fileName[MAX_PATHNAME_LEN]; 
char sMessage[200];
int indexNode, indexBkp;

VARIANT myRange; 
VARIANT myVariant;
ExcelObj_Range myRangeHandle;
//VARIANT myTitle;
//VARIANT myNum;
int index;
int iTotalNode2;
int indexRow;
int iTotalDataColumn;

		iTotalNode2 = iTotalNode + 2;     
		
		//iTotalDataColumn = 2 * iNumXY + 1;
		//Do not need to do so
		
//write title
    	//Get range string write title
//    	sprintf(sMessage, "A7:BM%d", iTotalNode2 + 6);
    	sprintf(sMessage, "A7:D%d", iTotalNode2 + 6);

    	error = CA_VariantSetCString (&myRange, sMessage);
    	//Set range
    	error = Excel_WorksheetRange (sheet, NULL, myRange, CA_DEFAULT_VAL, &myRangeHandle);
	   	//Active range
	   	error = Excel_RangeActivate (myRangeHandle, NULL, NULL); 
	   									
    	//vArray = (VARIANT *) calloc ( (65 * iTotalNode2), sizeof(VARIANT));
    	vArray = (VARIANT *) calloc ( (iTotalDataColumn * iTotalNode2), sizeof(VARIANT));
    	
    	sprintf (sMessage, "Time (s)");
        CA_VariantSetCString(&vArray[0], sMessage );
        
    	//sprintf (sMessage, "");
        //CA_VariantSetCString(&vArray[1], sMessage );
        
		//for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
    		sprintf (sMessage, "dFlex[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + indexBkp], sMessage );
        }
		
		for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)
		{
		
    		sprintf (sMessage, "dFRE[%d]", indexBkp);
        	CA_VariantSetCString(&vArray[1 + iNumXY + indexBkp], sMessage );
        }
															    
    	for (index = 0; index < iTotalDataColumn; index++)
    	{
    		sprintf (sMessage, "");
        	CA_VariantSetCString(&vArray[index + iTotalDataColumn], sMessage );
    	}
    	
    	for (indexNode = 0; indexNode < iTotalNode; indexNode++)
    	{
        	CA_VariantSetDouble(&vArray[iTotalDataColumn* (2 + indexNode) + 0], dTime[indexNode] );
			
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        	
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn* (2 + indexNode) + 1 + indexBkp], dFlex[indexNode][indexBkp] );
        	}
        	
			for (indexBkp = 0; indexBkp < iNumXY; indexBkp++)        	
        	{
        		CA_VariantSetDouble(&vArray[iTotalDataColumn * (2 + indexNode) + 1 + iNumXY + indexBkp], dFRE[indexNode][indexBkp] );
        	}
        	
    	}	
    	
		// Create a SAFEARRAY
    	error = CA_Array2DToSafeArray (vArray, CAVT_VARIANT, iTotalNode + 2, iTotalDataColumn, &MySafeArray);
 
   		//Set SafeArray to send to Excel
   		error = CA_VariantSetSafeArray (&myVariant, CAVT_VARIANT, MySafeArray);
   		
   		//Set Range with call passing SafeArray as Variant
   		error = Excel_SetProperty (myRangeHandle, NULL, Excel_RangeValue2, CAVT_VARIANT, myVariant);
   		
   	
   		if (vArray)
   		{
   		 	for (index=0;index < iTotalNode2;index++)
   		 	{
   		 		for (indexRow = 0; indexRow < iTotalDataColumn; indexRow++)
   		 		{
   		 	 		CA_VariantClear (&vArray[index * iTotalDataColumn + indexRow]);
   		 	 	}
   		 	}
   		 free(vArray);
   		}
   		
    CA_VariantClear(&myRange);
//    CA_VariantClear(&myVariant);
    CA_DiscardObjHandle (myRangeHandle);   
    	
    return 1;
}
//*/
