#include <userint.h>
#include <utility.h>
//#include <formatio.h>
#include "nivision.h"
#include <ansi_c.h>
#include "lowlvlio.h"
#include "wormDataStruct.h"  

// **************************************************************************************
//				ImageNode constructor
// **************************************************************************************
ImageNode * newImageNode(int newAbsX, int newAbsY, int newHeight, int newWidth, char * newImage, long newImageFilePtr, int fromFile)
{
	ImageNode * newNode ;
	
	newNode = (ImageNode *) malloc ( sizeof(ImageNode) ) ;
	
	if (newNode == null) return MEM_ERROR ;
	
	newNode->absX = newAbsX ;
	newNode->absY = newAbsY ;
	newNode->height = newHeight ;
	newNode->width = newWidth ;
	
	newNode->image = newImage ;
	newNode->imageFilePtr = newImageFilePtr ;
	
	newNode->fromFile = fromFile ;
	
	return newNode ;
}


// **************************************************************************************
//				ImageNode:: destructor
// **************************************************************************************
int destroyImageNode(ImageNode * thisNode)
{
	// possibly the node was not initialized, should not be deleting it though
	if (thisNode == null) 
		return 1 ;
	
	//if (thisNode->fromFile == 0) imaqDispose(thisNode->image) ;
	
		
	else 
	{   // this should never be necessary, when read from file, the image * should be null    
		if (thisNode->image != null) 
			free(thisNode->image) ;
	}
	
	free(thisNode) ;
	
	return 1 ;

}



// **************************************************************************************
//				ImageNode:: readImageNode
// **************************************************************************************
ImageNode * readImageNode(int filePtr, long * byteCount)
{
	long imageFilePtr;
	int index, totPixel ;
	int newAbsX, newAbsY, newHeight, newWidth ;

	read (filePtr, &newHeight, 4); 
	read (filePtr, &newWidth, 4); 

	*byteCount += 8 ;
	
	if (newHeight == 0 && newWidth == 0) return null ;
	
	read (filePtr, &newAbsX, 4); 
	read (filePtr, &newAbsY, 4); 

	*byteCount += 8 ;

	imageFilePtr = *byteCount ;

	/*JW used to read the compressed image
	//JF not need any more because the image is not compressed.
	totPixel = (newHeight * newWidth) / 8 ;
	//*/

	//*JF not need any more because the image is not compressed.
	totPixel = newHeight * newWidth ;
	//*/


	*byteCount += totPixel ;

	lseek (filePtr, totPixel, SEEK_CUR);
	
																		// fromFile equals 1
	return newImageNode(newAbsX, newAbsY, newHeight, newWidth, null, imageFilePtr, 1); 
}



// **************************************************************************************
//			Helper Function:: makeImageChar
// **************************************************************************************
unsigned char * makeImageChar(ImageSet * thisSet, int thisNode)
{
	unsigned char * newImage, data;
	int index, totPixel ;

	totPixel = thisSet->imageNodePtr[thisNode]->height * thisSet->imageNodePtr[thisNode]->width ;

	newImage = (unsigned char *) calloc (totPixel, sizeof(char));

	// throw away the extra pixels not in 
	/*JW used to compress the image
	totPixel = floor(totPixel / 8.0) * 8 ;
	*/


	lseek (thisSet->filePtr, thisSet->imageNodePtr[thisNode]->imageFilePtr, SEEK_SET);

	/*JW used to compress the image.  Because the iamge is no more compressed. This is not need anymore.
	for (index = 0; index < totPixel; index+=8)
	{
		read (thisSet->filePtr, &data, 1); 

		newImage[index] = (128 & data) >> 7 ;
		newImage[index+1] = (64 & data) >> 6 ;
		newImage[index+2] = (32 & data) >> 5 ;
		newImage[index+3] = (16 & data) >> 4 ;
		newImage[index+4] = (8 & data) >> 3 ;
		newImage[index+5] = (4 & data) >> 2 ;
		newImage[index+6] = (2 & data) >> 1 ;
		newImage[index+7] = 1 & data ;
	}
	//*/									


	//*JF read the uncompressed image
	for (index = 0; index < totPixel; index++)
	{
		read (thisSet->filePtr, &data, 1); 
		newImage[index] = data ;
	}
	//*/									

	return newImage ;
}



// **************************************************************************************
//				ImageNode:: writeImageNode
// **************************************************************************************
int writeImageNode(ImageNode * thisNode, int filePtr, ImageSet * thisImageSet, int thisNodeIndex)
{
	int index, totPixel ;
	unsigned char data ;
	int zero ;
	
	if (thisNode == null)
	{
		zero = 0 ;
		// if a null node, write the height and width are zero, and move onto the next node
		write (filePtr, &zero, 4);
		write (filePtr, &zero, 4);
		
		return 1 ;
	}
	
	totPixel = thisNode->height * thisNode->width ;

	// throw away the extra pixels not in 
	/*JW used to compress the image
	totPixel = floor(totPixel / 8.0) * 8 ;
	*/

	write (filePtr, &(thisNode->height), 4);
	write (filePtr, &(thisNode->width), 4);
	write (filePtr, &(thisNode->absX), 4);
	write (filePtr, &(thisNode->absY), 4);


	if (thisNode->fromFile == 1) thisNode->image = makeImageChar(thisImageSet, thisNodeIndex) ;

	/*JW used to compress the image
	for (index = 0; index < totPixel; index+=8)
	{																		   
		data = 0 ;
		
		data = thisNode->image[index] << 7 | thisNode->image[index+1] << 6 | thisNode->image[index+2] << 5 | thisNode->image[index+3] << 4 ;
		data = data | thisNode->image[index+4] << 3 | thisNode->image[index+5] << 2 | thisNode->image[index+6] << 1 | thisNode->image[index+7] ;
		
		write (filePtr, &(data), 1); 
	}	
	//*/

	//*JF compression is not needed any more
	for (index = 0; index < totPixel; index++)
	{
		data = 0 ;
		
		data = thisNode->image[index];
		
		write (filePtr, &(data), 1); 
	}	
	//*/

	if (thisNode->fromFile == 1) free(thisNode->image) ;

	return 1; 
}




// **************************************************************************************
//				ImageSet constructor
// **************************************************************************************
ImageSet * newImageSet(char * newImageSetName, int newImageSetNum, int MaxNumImages)
{
  
  int index ;
	
  ImageSet * newSet ;
	
	
	newSet = (ImageSet *) malloc ( sizeof(ImageSet) ) ;
	
	index = 0 ;
	while (newImageSetName[index] != '\0' && index < MAX_NAME_LEN) index++ ;
	newSet->setName = (char *) malloc ( (index + 1) * sizeof(char) ) ;
	strcpy(newSet->setName, newImageSetName) ; 
	
	strcpy( newSet->startDate, DateStr() ) ;  
	strcpy( newSet->startTime, TimeStr() ) ;  
	
	newSet->setNum = newImageSetNum ;
	
	newSet->MaxCount = MaxNumImages ;
	newSet->imageCount = 0 ;

	newSet->filePtr = null ;
	
	// allocate space to point to all of the imageNodes within (pointers are size long)
	newSet->imageNodePtr = (ImageNode **) malloc ( newSet->MaxCount * sizeof(ImageNodePtr) ) ;

	for (index = 0; index < newSet->MaxCount; index++)
	{
		// make sure the pointers aren't pointing anywhere
		newSet->imageNodePtr[index] = null ;
	}
	
	newSet->highDList = null ;
	
	return newSet ;
}


// **************************************************************************************
//				ImageSet constructor from file
//
//			if newImageSetNum = -1, newImageSetName already has the setNum included
//
//			otherwise, concatinate the setNum with the setName + .dat to read from disk
//
// **************************************************************************************
ImageSet * readImageSet(char * newImageSetName, int newImageSetNum)
{
	int index, error; 
	
	int testFilePtr ;
	ImageSet * newSet ;
	char fileName[MAX_NAME_LEN + 3] ; 
	char charCount[4] ;
	
	
	if (newImageSetNum == -1)
	{
		// setName has already been processed an has setNum + ".dat" added
		strcpy(fileName, newImageSetName) ;
	}
	else
	{
		// set name and set number are contained within the fileName
		sprintf(fileName, "%s%d.dat", newImageSetName, newImageSetNum) ;
	}
	
	testFilePtr = open (fileName, O_RDONLY, 0);
	
	if ( testFilePtr == -1 ) return null ;
	
	newSet = (ImageSet *) malloc ( sizeof(ImageSet) ) ;

	newSet->filePtr = testFilePtr ;
	lseek (newSet->filePtr, 0, SEEK_SET);

	
	index = 0 ;
	while (newImageSetName[index] != '\0' && index < MAX_NAME_LEN + 3) index++ ;
	newSet->setName = (char *) malloc ( (index + 1) * sizeof(char) ) ;
	strcpy(newSet->setName, newImageSetName) ; 
	
	newSet->setNum = newImageSetNum ;
	

	error = read (newSet->filePtr, &(newSet->startDate), 11);
	error = read (newSet->filePtr, &(newSet->startTime), 9);
	error = read (newSet->filePtr, &(newSet->imageCount), 4);
	
	// the initial number of bytes before image nodes start is 24
	newSet->byteCount = 24 ;

	// allocate space to point to all of the imageNodes within (pointers are size long)
	newSet->imageNodePtr = (ImageNode **) malloc ( newSet->imageCount * sizeof(ImageNodePtr) ) ;

	for (index = 0; index < newSet->imageCount; index++)
	{
		// make sure the pointers aren't pointing anywhere
		newSet->imageNodePtr[index] = readImageNode(newSet->filePtr, &newSet->byteCount) ;
	}
	
	newSet->highDList = null ;

	return newSet ;
}


// **************************************************************************************
//				ImageSet:: writeImageSet
// **************************************************************************************
int writeImageSet(ImageSet * thisImageSet)
{
	int index, error ;
	
	char fileName[MAX_NAME_LEN + 3] ;
	
	
	// set name and set number are contained within the fileName
	sprintf(fileName, "%s%d.dat", thisImageSet->setName, thisImageSet->setNum) ;

	// create new file, or erase current file, position the file pointer to the beginning of the file
	thisImageSet->filePtr = open (fileName, O_WRONLY | O_CREAT | O_TRUNC, S_IRWXU);

	// write the startDate and startTime strings, followed by the number of images in the Set
	error = write (thisImageSet->filePtr, &(thisImageSet->startDate), 11);
	error = write (thisImageSet->filePtr, &(thisImageSet->startTime), 9);
	error = write (thisImageSet->filePtr, &(thisImageSet->imageCount), 4);


	for (index = 0; index < thisImageSet->imageCount; index++)
	{
		writeImageNode(thisImageSet->imageNodePtr[index], thisImageSet->filePtr, thisImageSet, index) ;
	}
	
	
	return close (thisImageSet->filePtr) ;	   // -1 is error, all else is okay

}


// **************************************************************************************
//				ImageSet destructor
// **************************************************************************************
int destroyImageSet(ImageSet ** imageSetPtrPtr)
{
	int index ;

	ImageSet * thisSet = *imageSetPtrPtr ;
	
	// catch the NULL pointer 
	if (thisSet == null) return (0) ;
	
	free( thisSet->setName ) ;
	
	for (index = 0; index < thisSet->imageCount; index++)
	{
	
		destroyImageNode( thisSet->imageNodePtr[index] ) ;
		thisSet->imageNodePtr[index] = null ;
	}
	
	free ( thisSet->imageNodePtr ) ;
	
	free ( thisSet->highDList ) ;

	free ( thisSet ) ;
	
	
	// can free the memory through another pointer, but need to set this to zero
	// to effect thisImageSet in main
	*imageSetPtrPtr = null ;
	
	return 1 ;
}	


// **************************************************************************************
//				ImageSet addImage
//
// 	pass in newImage, which is already an allocated array from imaqImage
//  imageNode destructor calles imaqDestroy to clear the memory
// **************************************************************************************
int addImage(ImageSet * thisImageSet, int newAbsX, int newAbsY, int newHeight, int newWidth, char * newImage)
{

	if (thisImageSet->imageCount >= thisImageSet->MaxCount ) return FULL_SET_ERROR ;
	
	// if an image is passed in, create an image node to hold it, otherwise, point to NULL
	if (newImage != null)																							
	{																														// 0 means live capture (1 is read from disk)
		thisImageSet->imageNodePtr[thisImageSet->imageCount] = newImageNode (newAbsX, newAbsY, newHeight, newWidth, newImage, null, 0) ;
	}
	else  thisImageSet->imageNodePtr[thisImageSet->imageCount] = null ;
	
	// increment even if null pointer to signify that a frame was lost
	thisImageSet->imageCount++ ;  
	
	if (thisImageSet->imageNodePtr[thisImageSet->imageCount - 1] == null && newImage != null) return MEM_ERROR ;
	
	return 1 ;
}




