#include <utility.h>
#include <userint.h>
#include <analysis.h>
#include <ansi_c.h>

#include <backboneDataStruct.h>
//#include <WormDataManipulation.h>
#include <wormClassify.h>
#include <backboneLineup.h>
//#include <backboneData.h>


//**********************************************************************************************************/
//*
//* Local variables
//* 
//**********************************************************************************************************/

//****All user inter handlers**********************************
//*************************************************************
static int pHdTl;

//Plot handler
int iPlotLineupBBSWorm1;
int iPlotLineupBBSWorm2;
int iPlotLineupFitting1;
int iPlotLineupFitting2;


//Control the global variable
int gWhichSet = - 1;
int gCountErrorNoGap;
int gCountErrorGap;
int iRunCounter = 0;

//backbone set for analysis
BackboneSet ** gBksForLineup; 
int gTotalFileNumber = 0;

int gLineupBkbFileLoaded = 0;

static char * txtMsgStatusNotLined = "The current bacbkone set is NOT lined!";
static char * txtMsgStatusLinedNotSorted = "The current backbone set is lined. \nHead and tail are NOT sorted.";
static char * txtMsgStatusLinedAndSorted = "The current backbone set is lined and sorted.";

//the X and Y coordinates
double ** dX = null, ** dY = null;					//hold all the cordinates (node #: total of gTotalValidNodes)(backbone points #)
double *dTime = null;							//hold the node index of valid nodes in the array 

//needs for display
double *dBackbone1X, *dBackbone2X, *dBackbone1Y, *dBackbone2Y;
double *dFitting1X, *dFitting1Y, *dFitting2X, *dFitting2Y;

//to remove extremly short stuff
double *dDistanceArray;

//to sort had and tail
double **dDistanceHead, **dDistanceTail;
int *iValidNodes;

//Array to control the invalide node;
//int *iLoopType = null;
//int *iIsBkbp = null;
//int *gTotalValidNodes;

//Indicate next one is deleted
int iNextFrameDeleted = 0;


//**********************************************************************************************************/
//*
//* Local functions
//* 
//**********************************************************************************************************/
//local function declare
int initiateIt (BackboneSet *bkbs, int panel);
int cleanIt(BackboneSet *bkbs, int panel);

//Get data
int SplitBackboneSetForLineup (int panel, BackboneSet * thisBackbone) ;
//Function
int DisplayTwoImageForLineup (int panel, int iCurrentSet, int iJustShow);

int suggestSwitch(double *dX1, double *dY1, double *dX2, double *dY2, int iNumXY, int iGap) ;
//help
int DisAngleBetweenTwoPoints (double dX1, double dY1, double dX2, double dY2, double * dAngle, double * dDistance);


//***************************
//*****************
//*****************
//Codes start here.

//************************DoSelectFilesAnal**************************************************************************************
// 																																 
// 		This function will get the backbone for analysis, parse it into the global data for other function to analysis the data.
// 																																 
//*******************************************************************************************************************************
int CVICALLBACK loadingBackboneForLineup(int panel, int control, int event, void *callbackData, int eventData1, int eventData2)
{

int index ;
int iFileReadingError ;
int iFilesLoaded ;
char **sFileSelected = null;

//for file reading needs
char sMessage[MAX_FILENAME_LEN+20];   
char sTextLine[MAX_PATHNAME_LEN + 200] = "";
char fileName[MAX_PATHNAME_LEN];

int iLineupStatus;

	switch (event)
		{
		case EVENT_COMMIT:

//******************************** dealing with uir
//***********get what user wants
			GetCtrlVal(panel, pLineupBBS_btnLoad, &iFilesLoaded) ;

//***********If user wants is unloading
			if (iFilesLoaded == 0)
			{

//******************uir			
				ResetTextBox (panel, pLineupBBS_txtStatus, "Ready to load backbone point sets");  
				SetCtrlVal (panel, pLineupBBS_txtStatus, ""); 

//***************************intitial some global parmeters
				if (gWhichSet >= 0)
				{
					cleanIt (gBksForLineup[gWhichSet], panel);   
				}

//free distance array
				if (dDistanceHead != null)
				{
					for (index = 0; index < gTotalFileNumber; index++)
					{
						free (dDistanceHead[index]);
						free (dDistanceTail[index]);
						
					}	
					free (dDistanceHead);
					free (dDistanceTail);
					free (iValidNodes);
					
				}

			 	if (!gBksForLineup)
			 	{
			 		for (index = 0; index < gTotalFileNumber; index ++)
			 		{
						destroyBackboneSet (&gBksForLineup[index]);
			 		
					 	free (gBksForLineup[index]);
					}
					 	
					gBksForLineup = null;
				}
				
//set the flag
				
				gLineupBkbFileLoaded = 0;
				gTotalFileNumber = 0;
				gWhichSet = -1;

				SetCtrlVal (panel, pLineupBBS_nWhichSet, 0);
				SetCtrlVal (panel, pLineupBBS_nAngle, -1.0);
															   
				SetCtrlVal (panel, pLineupBBS_nWhichNode, 0);
				SetCtrlVal (panel, pLineupBBS_nNextFrame, 1);

				SetCtrlVal (panel, pLineupBBS_nTotalNodes, 0);

				//SetCtrlVal (panel, pLineupBBS_nAngleUpperLimit, 30.0);
				
   				sprintf (sTextLine, "%d files loaded.", gTotalFileNumber);
				ResetTextBox (panel, pLineupBBS_txtWorkStatus, sTextLine);
		
		 		SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, "");

				return 0 ;
			}

//************loading the analysis set

//*************************************Read the file
			iFileReadingError = MultiFileSelectPopup ("c:\\backboneset", "*.bkb", "*.bkb; *.bbs", "Select backbone set for analysis.",
													  0, 1, 1, &gTotalFileNumber,
													  &sFileSelected);

			if (iFileReadingError < 1)
			{
			 	SetCtrlVal(panel, pLineupBBS_btnLoad, 0) ;
			 	gTotalFileNumber = 0;
			 	
				return (0) ;
			}
			

//JW comments, keep for a whil
//********************** read the current file containing backbone sets.  for the firt one, just read it, for all other's to see, if*********
//********************** it has the same number of backbone points as the first one.  Dump it if not, otherwise save it**********************
			//allocate memory for bkbset
			gBksForLineup = (BackboneSet**) malloc(gTotalFileNumber * sizeof(BackboneSet*) ) ;     
	
//add user interface
			sprintf(sMessage, "%d Backbone sets are loaded: \n\n", gTotalFileNumber) ;
			ResetTextBox (panel, pLineupBBS_txtStatus, sMessage);  
			
			SetCtrlAttribute (panel, pLineupBBS_nWhichSet, ATTR_MAX_VALUE, gTotalFileNumber - 1);
			

			if (gBksForLineup == null)
			{
				MessagePopup ("Warning", "Loading failed");
				return (0) ;
			}

//*********load the backbone set
			for (index = 0; index < gTotalFileNumber; index ++)
			{
				SplitPath (sFileSelected[index], NULL, NULL, fileName) ;    
   
   				gBksForLineup[index] = readBackboneSet(sFileSelected[index]) ; 

//***************************tell the user
				if (gBksForLineup[index] != null) 
				{
					sprintf(sTextLine, "Set(%d): %s (%d nodes)\n  from %s\n", index + 1, fileName, gBksForLineup[index]->NodeCount, gBksForLineup[index]->Date);
				}	else
				{
					 sprintf(sTextLine, "LOAD ERROR!! %s", fileName ) ;
				}
				
				//The default number/index of images for analysis is set
   				InsertTextBoxLine (panel, pLineupBBS_txtStatus, -1, sTextLine);
   				free (sFileSelected[index] ) ;
			}
			
			sFileSelected = null;
			
   			sprintf (sTextLine, "%d files loaded.", gTotalFileNumber);
			ResetTextBox (panel, pLineupBBS_txtWorkStatus, sTextLine);

			SetCtrlAttribute (panel, pLineupBBS_nWhichSet, ATTR_MAX_VALUE,
							  gTotalFileNumber - 1);

			gLineupBkbFileLoaded = 1;

//Allocate memeory
			dDistanceHead = (double **) malloc ( gTotalFileNumber * sizeof (double *));
			dDistanceTail = (double **) malloc ( gTotalFileNumber * sizeof (double *));
			iValidNodes = (int *) calloc ( gTotalFileNumber, sizeof (int));
			
			for (index = 0; index < gTotalFileNumber; index ++)
			{
				dDistanceHead[index] = (double *) calloc ( (gBksForLineup[index]->NodeCount), sizeof(double ) );
				dDistanceTail[index] = (double *) calloc ( (gBksForLineup[index]->NodeCount), sizeof(double ) );
			}
			
			if (gBksForLineup[0] != null);
			{
			
				initiateIt (gBksForLineup[0], panel); 
//				gTotalValidNodes = SplitBackboneSetForLineup (gBksForLineup[0]);
				SplitBackboneSetForLineup (panel, gBksForLineup[0]);

//***************************tell the user
				SetCtrlVal (panel, pLineupBBS_nTotalNodes, gBksForLineup[0]->NodeCount);
				SetCtrlAttribute (panel, pLineupBBS_nWhichNode, ATTR_MAX_VALUE, gBksForLineup[0]->NodeCount - 1);
				SetCtrlVal (panel, pLineupBBS_nWhichNode, 0);
				SetCtrlVal (panel, pLineupBBS_nNextFrame, 1);

//tell the user			
				iLineupStatus = gBksForLineup[0]->isBbpAligned;
				
				switch (iLineupStatus)
				{
			
					case -1:
						SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusNotLined);
					break;
					
					case 0:
						SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusNotLined);
					break;
				
					case 1:
						SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusLinedNotSorted);
					break;
				
					case 2:
						SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusLinedAndSorted);
					break;	
				}

				gWhichSet = 0;
				DisplayTwoImageForLineup (panel, 0, 1);
				
			}
			break;
		}																		
		
	return 0;
}

//*
int DisplayTwoImageForLineup (int panel, int iCurrentSet, int iJustShow)
{
												  
int indexWhichBackbonePoint, index;

double dMax1, dMin1;
double dMax2, dMin2;
double dMaxX, dMaxY, dMinX, dMinY;

int iTemp;

double dXTemp, dYTemp;
double dDiff;

double dCent1X, dCent1Y, dCent2X, dCent2Y;

//double *dFittingOutput;
double dSlope1, dIntercept1;
double dSlope2, dIntercept2;

double dXTemp1, dYTemp1; 
double dAngle, dDistance;
double dAngle1, dAngle2;

double dDistance1, dDistance2;
double dX1, dY1, dX2, dY2;
double dX3, dY3, dX4, dY4;

int iSwitch = 0;
char sMessage1[80];
char sMessage2[25] = "\nDo you need a switch?"; 
char *sMessage;

double dMedian;

int iCurrentFrame, iNextFrame;
int iShowTable;

//int iCurrentSet = -1;
int numXY, iTotalNodes;
double dAngleUpperLimit;

int iGapFlag = 0;
int iFlagInOrderNoGap = 1;
int iFlagInOrderGap = 1;

int iSwiched = 0;
int iCut = 0;
int iLow, iUp;

	
	numXY = gBksForLineup[iCurrentSet]->NumXYpairs;
	iTotalNodes = gBksForLineup[iCurrentSet]->NodeCount;

	//Get current set index
//	GetCtrlVal (panel, pLineupBBS_nWhichSet, &iCurrentSet);
	//Get current node index
	GetCtrlVal (panel, pLineupBBS_nWhichNode, &iCurrentFrame);

restart:   
	if ( (gBksForLineup[iCurrentSet]->backboneNodePtr[iCurrentFrame] == null) || (gBksForLineup[iCurrentSet]->backboneNodePtr[iCurrentFrame]->iIsBkbp != 1) )

	{
		//if Current frame bkbp is NOT available
		//Go to next noe
		iCurrentFrame ++;
//clay report program quit here		  april 29, 2002
		//if (iCurrentFrame >= iTotalNodes)
		if (iCurrentFrame > iTotalNodes - 1)
		{
			MessagePopup ("Warning!", "The end of the array has been reached.");
			return 2;
		}
		
		SetCtrlVal (panel, pLineupBBS_nWhichNode, iCurrentFrame);
		SetCtrlVal (panel, pLineupBBS_nNextFrame, iCurrentFrame + 1);
		goto restart;
	}

	//Get next node index
	GetCtrlVal (panel, pLineupBBS_nNextFrame, &iNextFrame);

restart1: 
//clay report program quit here		  april 29, 2002   //
//The reason for that is if the iNext is still set by following codes.  Last one is NULL, it increase by one and hence create problem out of array.
 	if (iNextFrame >= iTotalNodes) return 2;
	if ( (gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame] == null) || (gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->iIsBkbp != 1) )
	{
		//if next frame bkbp is NOT available
		//Go to next one of the next one
		iNextFrame ++;
		
		if (iNextFrame >= iTotalNodes)
		{
			MessagePopup ("Warning!", "The end of the array has been reached.");
			return 2;
		}
		
		SetCtrlVal (panel, pLineupBBS_nNextFrame, iNextFrame);
		goto restart1;
	}

//******************Get the data
	for (indexWhichBackbonePoint = 0; indexWhichBackbonePoint < numXY; indexWhichBackbonePoint ++)
	{
		dBackbone1X[indexWhichBackbonePoint] = dX[iCurrentFrame][indexWhichBackbonePoint];
		dBackbone1Y[indexWhichBackbonePoint] = dY[iCurrentFrame][indexWhichBackbonePoint];

		dBackbone2X[indexWhichBackbonePoint] = dX[iNextFrame][indexWhichBackbonePoint];
		dBackbone2Y[indexWhichBackbonePoint] = dY[iNextFrame][indexWhichBackbonePoint];
	}
	

//************************Get the fitting
	//Central mass
	Mean (dBackbone1X, numXY, &dCent1X);
	Mean (dBackbone2X, numXY, &dCent2X);
			
	Mean (dBackbone1Y, numXY, &dCent1Y);
	Mean (dBackbone2Y, numXY, &dCent2Y);

	//First One
	dXTemp = dBackbone1X[0];
	dYTemp = dBackbone1Y[0];

	dXTemp1 = dBackbone1X[numXY - 1];
	dYTemp1 = dBackbone1Y[numXY - 1];

	DisAngleBetweenTwoPoints (dXTemp, dYTemp, dXTemp1, dYTemp1, &dAngle1, &dDistance);

	dSlope1 = tan(dAngle1);
	dIntercept1 = dCent1Y - dCent1X * dSlope1;

	//Second one
	dXTemp = dBackbone2X[0];
	dYTemp = dBackbone2Y[0];

	dXTemp1 = dBackbone2X[numXY - 1];
	dYTemp1 = dBackbone2Y[numXY - 1];

	DisAngleBetweenTwoPoints (dXTemp, dYTemp, dXTemp1, dYTemp1, &dAngle2, &dDistance);

	dSlope2 = tan(dAngle2);
	dIntercept2 = dCent2Y - dCent2X * dSlope2;

//Get the max and min
	MaxMin1D (dBackbone1X, numXY, &dMax1, &iTemp, &dMin1, &iTemp);
	MaxMin1D (dBackbone2X, numXY, &dMax2, &iTemp, &dMin2, &iTemp);

	if (dMax1 > dMax2)
	{
		dMaxX = dMax1;
	}else dMaxX = dMax2;

	if (dMin1 < dMin2)
	{
		dMinX = dMin1;
	}else dMinX = dMin2;
			
	MaxMin1D (dBackbone1Y, numXY, &dMax1, &iTemp, &dMin1, &iTemp);
	MaxMin1D (dBackbone2Y, numXY, &dMax2, &iTemp, &dMin2, &iTemp);

	if (dMax1 > dMax2)
	{
		dMaxY = dMax1;
	}else dMaxY = dMax2;

	if (dMin1 < dMin2)
	{
		dMinY = dMin1;
	}else dMinY = dMin2;

	dFitting1X [0] = dMinX;
	dFitting2X [0] = dMinX;
	dFitting1X [1] = dMaxX;
	dFitting2X [1] = dMaxX;

	//Fitting line		
	for (index = 0; index < 2; index ++)
	{
		dFitting1Y[index] = dSlope1 * dFitting1X[index] + dIntercept1;
		dFitting2Y[index] = dSlope2 * dFitting2X[index] + dIntercept2;
	}
	
//*****************figures
	if (iPlotLineupBBSWorm1 > 0) iPlotLineupBBSWorm1 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupBBSWorm1, VAL_IMMEDIATE_DRAW);
	if (iPlotLineupBBSWorm2 > 0) iPlotLineupBBSWorm2 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupBBSWorm2, VAL_IMMEDIATE_DRAW);

	if (iPlotLineupFitting1 > 0) iPlotLineupFitting1 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupFitting1, VAL_IMMEDIATE_DRAW);
	if (iPlotLineupFitting2 > 0) iPlotLineupFitting2 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupFitting2, VAL_IMMEDIATE_DRAW);


	iPlotLineupBBSWorm1 = PlotXY (panel, pLineupBBS_gphLineupBBS, dBackbone1X, dBackbone1Y, numXY, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
	iPlotLineupBBSWorm2 = PlotXY (panel, pLineupBBS_gphLineupBBS, dBackbone2X, dBackbone2Y, numXY, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_BLUE);

	iPlotLineupFitting1 = PlotXY (panel, pLineupBBS_gphLineupBBS, dFitting1X, dFitting1Y, 2, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_NO_POINT, VAL_SOLID, 1, VAL_RED);
	iPlotLineupFitting2 = PlotXY (panel, pLineupBBS_gphLineupBBS, dFitting2X, dFitting2Y, 2, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_NO_POINT, VAL_SOLID, 1, VAL_BLUE);

//Consider change into one function
	dXTemp = dMaxX - dMinX;
	dYTemp = dMaxY - dMinY;

	if (dXTemp >= dYTemp)
	{
		dDiff = dXTemp - dYTemp ;
		SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_XAXIS, VAL_MANUAL, dMinX - 10, dMaxX + 10);
		SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - dDiff/2 - 10, dMaxY + dDiff/2 + 10);
	}
	
	if (dXTemp < dYTemp)
	{
		dDiff = dYTemp - dXTemp ;
		SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_XAXIS, VAL_MANUAL, dMinX - dDiff/2 - 10, dMaxX + dDiff/2 + 10);
		SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - 10, dMaxY + 10);
	}

//Set the cursor
	SetGraphCursorIndex (panel, pLineupBBS_gphLineupBBS, 1, iPlotLineupBBSWorm1, 0);
	SetGraphCursorIndex (panel, pLineupBBS_gphLineupBBS, 2, iPlotLineupBBSWorm2, 0);

//**only showit
//	if (iJustShow == 1) return 4;

//*******calculate the distance
	dX1 = dBackbone1X[0];
	dY1 = dBackbone1Y[0];
	dX2 = dBackbone1X[numXY - 1];
	dY2 = dBackbone1Y[numXY - 1];
		
	dX3 = dBackbone2X[0];
	dY3 = dBackbone2Y[0];
	dX4 = dBackbone2X[numXY - 1];
	dY4 = dBackbone2Y[numXY - 1];

	dDistance1 = sqrt( (dX1-dX3)*(dX1-dX3) + (dY1-dY3)*(dY1-dY3));
	dDistance1 = dDistance1 + sqrt( (dX2-dX4)*(dX2-dX4) + (dY2-dY4)*(dY2-dY4));
		
	dDistance2 = sqrt((dX1-dX4)*(dX1-dX4) + (dY1-dY4)*(dY1-dY4));
	dDistance2 = dDistance2 + sqrt( (dX2-dX3)*(dX2-dX3) + (dY2-dY3)*(dY2-dY3));
	
//************calculate the angle
	dAngle = fabs (dAngle1 - dAngle2); 
	dAngle = fmod (dAngle, PI) * 180 / PI;
	
	if (dAngle > 90)
	{
		dAngle = 180 - dAngle;
	}
	//Set the angle 
	SetCtrlVal (panel, pLineupBBS_nAngle, dAngle);
//**only showit
	//if (iJustShow == 1) return 4;


//***********Judge if there is a sharp turn
repeat:
	GetCtrlVal (panel, pLineupBBS_nAngleUpperLimit, &dAngleUpperLimit);
	if (iNextFrame - iCurrentFrame > 1) dAngleUpperLimit = dAngleUpperLimit/6;
	if (iNextFrame - iCurrentFrame > 2) dAngleUpperLimit = dAngleUpperLimit / 10;

	GetCtrlVal (panel, pLineupBBS_bCut, &iCut);
	if (iCut == 1)
	{
		GetCtrlVal (panel, pLineupBBS_nLow, &iLow);
		GetCtrlVal (panel, pLineupBBS_nUp, &iUp);
	
	
		if (iCurrentFrame > iLow && iCurrentFrame < iUp) dAngleUpperLimit = 0;
	}

	if ( (dAngle > dAngleUpperLimit) || (iNextFrame - iCurrentFrame > 10) )
	{
		if (iNextFrame - iCurrentFrame == 1)
		{
			iGapFlag = 2;
			
			iFlagInOrderNoGap = suggestSwitch(dBackbone1X, dBackbone1Y, dBackbone2X, dBackbone2Y, numXY, 0);
			if (iFlagInOrderNoGap == 1)
			{
				//goto reverseNeeded;
				sprintf (sMessage1, "Overlay analysis suggests a switch!");
			}
			else 
				//goto noReverseNeeded;
				sprintf (sMessage1, "Overlay analysis suggests NO switch!");
			
		}
		else 
		{
			iGapFlag = 1;
			
//			if (dDistance1 >= dDistance2)
			iFlagInOrderGap = suggestSwitch(dBackbone1X, dBackbone1Y, dBackbone2X, dBackbone2Y, numXY, 0);
			if (iFlagInOrderGap == 1) 
			{
				sprintf (sMessage1, "Overlay analysis suggests a switch!");
			} 
			else sprintf (sMessage1, "Overlay analysis suggests NO switch!");
		}
		
		sMessage = strcat (sMessage1, sMessage2);

		//Whether user want to switch it
		iSwitch = ConfirmPopup ("A sharp turn is detected!", sMessage);
		
		//if user wants to switch it
		if (iSwitch == 1)
		{
			Reverse (dBackbone2X, numXY, dBackbone2X);
			Reverse (dBackbone2Y, numXY, dBackbone2Y);
			
//Show in result to user
			if (iPlotLineupBBSWorm2 > 0) iPlotLineupBBSWorm2 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupBBSWorm2, VAL_IMMEDIATE_DRAW);
			iPlotLineupBBSWorm2 = PlotXY (panel, pLineupBBS_gphLineupBBS, dBackbone2X, dBackbone2Y, numXY, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_BLUE);

			if (dXTemp >= dYTemp)
			{
				dDiff = dXTemp - dYTemp ;
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_XAXIS, VAL_MANUAL, dMinX - 10, dMaxX + 10);
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - dDiff/2 - 10, dMaxY + dDiff/2 + 10);
			}
	
			if (dXTemp < dYTemp)
			{
				dDiff = dYTemp - dXTemp ;
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_XAXIS, VAL_MANUAL, dMinX - dDiff/2 - 10, dMaxX + dDiff/2 + 10);
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - 10, dMaxY + 10);
			}

			SetGraphCursorIndex (panel, pLineupBBS_gphLineupBBS, 2, iPlotLineupBBSWorm2, 0);

//Confirm the switch
			iSwitch = ConfirmPopup ("Warning", "Confirm your switch?");
			
			if (iSwitch == 1)
			{
				iSwiched = 1;
				
				Reverse (dX[iNextFrame], numXY, dX[iNextFrame]);
				Reverse (dY[iNextFrame], numXY, dY[iNextFrame]);

				Reverse (gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->xPoints, numXY, gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->xPoints);
				Reverse (gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->yPoints, numXY, gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->yPoints);
			}
			else goto restart;
		}
		else 
		{
			iSwitch = ConfirmPopup ("Warning", "Confirm you do NOT switch?");
			if (iSwitch == 0)
			goto restart;
		}
	}
	else
	{
		if (dDistance1 >= dDistance2)
		{

reverseNeeded:
			Reverse (dBackbone2X, numXY, dBackbone2X);
			Reverse (dBackbone2Y, numXY, dBackbone2Y);
			
//*need do something more			
			if (iPlotLineupBBSWorm2 > 0) iPlotLineupBBSWorm2 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupBBSWorm2, VAL_IMMEDIATE_DRAW);
			iPlotLineupBBSWorm2 = PlotXY (panel, pLineupBBS_gphLineupBBS, dBackbone2X, dBackbone2Y, numXY, VAL_DOUBLE, VAL_DOUBLE, VAL_CONNECTED_POINTS, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_BLUE);

			if (dXTemp >= dYTemp)
			{
				dDiff = dXTemp - dYTemp ;
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_XAXIS, VAL_MANUAL, dMinX - 10, dMaxX + 10);
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - dDiff/2 - 10, dMaxY + dDiff/2 + 10);
			}
	
			if (dXTemp < dYTemp)
			{
				dDiff = dYTemp - dXTemp ;
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_XAXIS, VAL_MANUAL, dMinX - dDiff/2 - 10, dMaxX + dDiff/2 + 10);
				SetAxisScalingMode (panel, pLineupBBS_gphLineupBBS, VAL_LEFT_YAXIS, VAL_MANUAL, dMinY - 10, dMaxY + 10);
			}
//Consider change into one function
			SetGraphCursorIndex (panel, pLineupBBS_gphLineupBBS, 2, iPlotLineupBBSWorm2, 0);
			Reverse (dX[iNextFrame], numXY, dX[iNextFrame]);
			Reverse (dY[iNextFrame], numXY, dY[iNextFrame]);

			Reverse (gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->xPoints, numXY, gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->xPoints);
			Reverse (gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->yPoints, numXY, gBksForLineup[iCurrentSet]->backboneNodePtr[iNextFrame]->yPoints);
		}
	}

noReverseNeeded:
//*********************Set error count if neccessary
	if (iRunCounter == 1)
	{
		if (iGapFlag == 2)
		{
			if (iSwiched != iFlagInOrderNoGap) gCountErrorNoGap ++;
		}
		else if (iGapFlag == 1)
		{
			if (iSwiched != iFlagInOrderGap) gCountErrorGap ++;
		}
	}


//calculate head tail speed
  	if (iJustShow == 0)
  	{
		dX1 = dX[iCurrentFrame][0];
		dY1 = dY[iCurrentFrame][0];
		dX2 = dX[iCurrentFrame][numXY - 1];
		dY2 = dY[iCurrentFrame][numXY - 1];
		
		dX3 = dX[iNextFrame][0];
		dY3 = dY[iNextFrame][0];
		dX4 = dX[iNextFrame][numXY - 1];
		dY4 = dY[iNextFrame][numXY - 1];

  		
  		dDistanceHead[iCurrentSet][iValidNodes[iCurrentSet]] =   sqrt ( (dX1 - dX3) *  (dX1 - dX3) + (dY1 - dY3) * (dY1 - dY3) ) / ( dTime [iNextFrame] - dTime [iCurrentFrame] );
  		dDistanceTail[iCurrentSet][iValidNodes[iCurrentSet]] =   sqrt ( (dX2 - dX4) *  (dX2 - dX4) + (dY2 - dY4) * (dY2 - dY4) ) / ( dTime [iNextFrame] - dTime [iCurrentFrame] );
  
    }


//******************post it in table
	GetCtrlVal (panel, pLineupBBS_bSwchTblON, &iShowTable);
	if (iShowTable == 1)
	{
		for (indexWhichBackbonePoint = 0; indexWhichBackbonePoint < numXY; indexWhichBackbonePoint ++)
		{
			SetTableCellVal (panel, pLineupBBS_tblBackbone, MakePoint(1, indexWhichBackbonePoint + 1), dBackbone1X[indexWhichBackbonePoint]);
			SetTableCellVal (panel, pLineupBBS_tblBackbone, MakePoint(2, indexWhichBackbonePoint + 1), dBackbone1Y[indexWhichBackbonePoint]);
			SetTableCellVal (panel, pLineupBBS_tblBackbone, MakePoint(4, indexWhichBackbonePoint + 1), dBackbone2X[indexWhichBackbonePoint]);
			SetTableCellVal (panel, pLineupBBS_tblBackbone, MakePoint(5, indexWhichBackbonePoint + 1), dBackbone2Y[indexWhichBackbonePoint]);
		}
	}

	return 1;
}

//*/
int CVICALLBACK showLineupImages (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int iWhichNode;
int iWhichSet;
int iLineupStatus;

//
	switch (event)
		{
		case EVENT_COMMIT:


			GetCtrlVal (panel, pLineupBBS_nWhichSet, &iWhichSet); 
			
			if ( gBksForLineup[iWhichSet] == null || gLineupBkbFileLoaded == 0) 
			{
				MessagePopup ("Warning!", "No backboneset is ready for lineup, please choose backbone set for analysis.");
				return (0) ;
			}

//should copy to another function
			if (iWhichSet != gWhichSet)
			{
				gWhichSet = iWhichSet;
				//SetCtrlVal (panel, pLineupBBS_nWhichSet, iWhichSet);  
				cleanIt (gBksForLineup[gWhichSet], panel);      
				initiateIt (gBksForLineup[gWhichSet], panel) ;
				//get information
				SplitBackboneSetForLineup (panel, gBksForLineup[gWhichSet]) ; 
				
			}
//*/

//tell the user			
			iLineupStatus = gBksForLineup[iWhichSet]->isBbpAligned;
			switch (iLineupStatus)
			{
			
				case -1:
					SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusNotLined);
				break;
				case 0:
					SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusNotLined);
				break;
				
				case 1:
					SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusLinedNotSorted);
				break;
				
				case 2:
					SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusLinedAndSorted);
				break;	
			}
			
			
			GetCtrlVal (panel, pLineupBBS_nWhichNode, &iWhichNode);

			if (iWhichNode >= gBksForLineup[iWhichSet]->NodeCount - 1)
			{
				MessagePopup ("Warning!", "The index of image for showing backbone exeeds the boundary!");
				SetCtrlVal (panel, pLineupBBS_nWhichNode, gBksForLineup[iWhichSet]->NodeCount - 2);
				SetCtrlVal (panel, pLineupBBS_nNextFrame, gBksForLineup[iWhichSet]->NodeCount - 1);
				return 0;
			}else
			{
				SetCtrlVal (panel, pLineupBBS_nNextFrame, iWhichNode + 1);
				DisplayTwoImageForLineup (panel, iWhichSet, 1);
			}

			break;
		}

	return 0;
}


int CVICALLBACK doAllLineup (int panel, int control, int event, void *callbackData, int eventData1, int eventData2)
{
//*
int indexWhichNode;
int indexWhichSet;
int iNodeCount;

int iFlag = 0;
char sMessage[200];
int iCountErrorNoGap;
int iCountErrorGap;
int iChangeCount = 0;


	switch (event)
		{
		case EVENT_COMMIT:
	
			if ( gBksForLineup == null || gLineupBkbFileLoaded == 0) 
			{
				MessagePopup ("Warning!", "No backboneset is ready for lineup, please choose backbone set for analysis.");
				return (0) ;
			}
			
			ResetTextBox (panel, pLineupBBS_txtWorkStatus, "Lining up.\n\n");
			gCountErrorNoGap = 0;
			gCountErrorGap = 0;
			iRunCounter = 1;
	
			for (indexWhichSet = 0; indexWhichSet < gTotalFileNumber; indexWhichSet++)
			{
				//reset counter
				iCountErrorNoGap = 0;
				iCountErrorGap = 0;
				
				if (gWhichSet != 0)
				{
					cleanIt (gBksForLineup[gWhichSet], panel); 
					initiateIt (gBksForLineup[0], panel) ;
					SplitBackboneSetForLineup (panel, gBksForLineup[0]) ;
				}
				
 				SetCtrlVal (panel, pLineupBBS_nWhichSet, indexWhichSet);

//if current set is alreday lined, goto next one
				if (gBksForLineup[indexWhichSet]->isBbpAligned > 0)
				{
					MessagePopup ("Hi!", "Backboneset is already lined up!");
					goto exit;
				}
				
				iNodeCount = gBksForLineup[indexWhichSet]->NodeCount;

				SetCtrlVal (panel, pLineupBBS_nTotalNodes, iNodeCount);
				SetCtrlAttribute (panel, pLineupBBS_nWhichNode, ATTR_MAX_VALUE, iNodeCount - 1);
				SetCtrlVal (panel, pLineupBBS_nWhichNode, 0);
				SetCtrlVal (panel, pLineupBBS_nNextFrame, 1);
				
				//here
   				sprintf (sMessage, "Line up (%d) of %d backbone set.\n", indexWhichSet, gTotalFileNumber);
				InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, - 1, sMessage);

//reset iValidNodes	
				iValidNodes[indexWhichSet] = 0;
				for (indexWhichNode = 0; indexWhichNode < iNodeCount - 1; indexWhichNode ++)
				{
				
//fix the bug not pass quick


					//SetCtrlVal (panel, pLineupBBS_nWhichNode, indexWhichNode);
					//SetCtrlVal (panel, pLineupBBS_nNextFrame, indexWhichNode + 1);
					SetCtrlVal (panel, pLineupBBS_nWhichNode, iChangeCount);
					SetCtrlVal (panel, pLineupBBS_nNextFrame, iChangeCount + 1);
				
					iFlag = DisplayTwoImageForLineup (panel, indexWhichSet, 0);
//increase
					iValidNodes[indexWhichSet] ++;
					
					
					GetCtrlVal (panel, pLineupBBS_nNextFrame, &iChangeCount);		   //Fix bug: Get next change
					

					if (iFlag == 2) 
					{

						gBksForLineup[indexWhichSet]->isBbpAligned = LINED_NOTSORTED;
						goto exit;
					}
				}
		
				gBksForLineup[indexWhichSet]->isBbpAligned = LINED_NOTSORTED;
				SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusLinedNotSorted);

				iCountErrorNoGap =  gCountErrorNoGap - iCountErrorNoGap;
				iCountErrorGap =  gCountErrorGap - iCountErrorGap;

   				sprintf (sMessage, "Prediction erro in this set: \n  (%d) overlay (%d) distance.\n", iCountErrorNoGap, iCountErrorGap);
				InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, - 1, sMessage);

//load the new one
exit: 
				//SetCtrlVal (panel, pLineupBBS_nWhichSet, iWhichSet);
				if (indexWhichSet < gTotalFileNumber - 1)
				{
					cleanIt (gBksForLineup[indexWhichSet], panel); 
					initiateIt (gBksForLineup[indexWhichSet + 1], panel) ;
					SplitBackboneSetForLineup (panel, gBksForLineup[indexWhichSet + 1]) ;
				}
				
   				sprintf (sMessage, "(%d) of %d backbone sets is done.\n", indexWhichSet, gTotalFileNumber);  
				InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, - 1, sMessage);

		  	}//set cycle

			gWhichSet = gTotalFileNumber - 1;
//			MessagePopup ("Message", "Bonebone sets are all aligned but NOT sorted yet.");
			//here
   			sprintf (sMessage, "Backbone Sets All Lined up\n");
			InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, -1, sMessage);

			iRunCounter = 0;
			
			break;
		} //switch
	return 0;
	
}

int CVICALLBACK saveLineupFile(int panel, int control, int event, void *callbackData, int eventData1, int eventData2)
{

int iIsNoLinedup = 0;
int indexWhichSet;
int iLength = 0;
char * fileName1;
char * fileName2;
char sMessage[MAX_PATHNAME_LEN + 200];

	switch (event)
		{
		case EVENT_COMMIT:
		
			if ( gBksForLineup == null || gLineupBkbFileLoaded == 0) 
			{
				MessagePopup ("Warning!", "No backboneset is ready for save, please choose backbone set for analysis.");
				return (0) ;
			}

			//if there is one set is NOT lined up
			for (indexWhichSet = 0; indexWhichSet < gTotalFileNumber; indexWhichSet++)
			{
				if (gBksForLineup[indexWhichSet]->isBbpAligned < 2)  iIsNoLinedup ++;
				
			}

			if (iIsNoLinedup > 0)
			{
				MessagePopup ("Warning!", "There is backbone set is NOT lined and sorted.  Please line and sort up before you save.");
				return 1;
			}

			if (iIsNoLinedup == 0) 
			{
			
				ResetTextBox (panel, pLineupBBS_txtWorkStatus, "Saving data.\n\n");

				//saveLinedupBBSToFile (panel) ;
				for (indexWhichSet = 0 ; indexWhichSet < gTotalFileNumber; indexWhichSet ++)
				{
					fileName1 = gBksForLineup[indexWhichSet]->setName;
					iLength = strlen (fileName1);
					
					fileName2 = (char *) malloc (iLength + 2 * sizeof(char));
					memset (fileName2, NULL, iLength + 2);
					strncpy (fileName2, fileName1, iLength - 4);
					strcat (fileName2, ".bbs");					
					
					//save them			
					strcpy (gBksForLineup[indexWhichSet]->setName, fileName2);
					
					writeBackboneSet(gBksForLineup[indexWhichSet]) ;
					
					strcpy (sMessage, gBksForLineup[indexWhichSet]->setName);
   					strcat (sMessage, " is saved\n");
					InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, - 1, sMessage);

					fileName1 = null;
					fileName2 = null;
				}
				
			}
			
			
   			sprintf (sMessage, "All data are saved\n");
			InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, - 1, sMessage);
			
			
			MessagePopup ("Congradulation", "Job is done");

			break;
		}
	return 0;

}


int CVICALLBACK sortHeadTail (int panel, int control, int event, void *callbackData, int eventData1, int eventData2)
{

//*
int iNumXY;
int indexWhichNode;
int indexWhichSet;
int iIsNoLinedup = 0;

double dTemp;

int *iSwitchWholeSet;
int iTotalValidNodes;

double dSpeedHead, dSpeedTail;
double dMax1, dMax2, dMax, dMin1, dMin2, dMin;
int iTemp;

double *dRatioHeadTail; 
double *dOne;
double dRatio;
double dSD;
int iNodeCount;

int iPanel;
int iControl;
int iSwitch;

int iJustShow;

char sMessage[200];


	switch (event)
		{
		case EVENT_COMMIT:

			//if there is NO file loaded
			if ( gBksForLineup == null || gLineupBkbFileLoaded == 0) 
			{
				MessagePopup ("Warning!", "No backboneset is ready for sort, please choose backbone set for analysis.");
				return (1) ;
			}
			
			//if there is one set is NOT lined up
			for (indexWhichSet = 0; indexWhichSet < gTotalFileNumber; indexWhichSet++)
			{
				if (gBksForLineup[indexWhichSet]->isBbpAligned < 1)  iIsNoLinedup ++;
				
			}
			if (iIsNoLinedup > 0)
			{
				MessagePopup ("Warning!", "There is backbone set is NOT all lined up yet.  Please line them up before you sort them.");
				return 1;
			}

			//Start from zero
			if (gWhichSet != 0)
			{
				cleanIt (gBksForLineup[gWhichSet], panel); 
				initiateIt (gBksForLineup[0], panel) ;
				SplitBackboneSetForLineup (panel, gBksForLineup[0]) ;
				
			}
			
			//memory
			iSwitchWholeSet = (int *) calloc (gTotalFileNumber, sizeof (int));
			
			//for each set
			for (indexWhichSet = 0; indexWhichSet < gTotalFileNumber; indexWhichSet ++)
			{

//if current set is alreday lined, goto next one
				if (gBksForLineup[indexWhichSet]->isBbpAligned > 1)
				{
					//MessagePopup ("Error", "Backboneset is already lined up!");
					iSwitch = gBksForLineup[indexWhichSet]->isBbpAligned;
					goto exit;
				}
			
				//get the valid node count
				iNodeCount = iValidNodes[indexWhichSet] ;
				
				//Get the average and max of the head and tail
				StdDev (dDistanceHead[indexWhichSet], iNodeCount,
						&dSpeedHead, &dTemp);
				MaxMin1D (dDistanceHead[indexWhichSet], iNodeCount,
						  &dMax1, &iTemp, &dMin1, &iTemp);
				
				StdDev (dDistanceTail[indexWhichSet], iNodeCount,
						&dSpeedTail, &dTemp);

				MaxMin1D (dDistanceTail[indexWhichSet], iNodeCount,
						  &dMax2, &iTemp, &dMin2, &iTemp);

				//memory
				dRatioHeadTail = (double *)calloc (iNodeCount, sizeof (double));
				dOne = (double *)calloc (iNodeCount, sizeof (double));

				//get the ration and set the line
				for (indexWhichNode = 0; indexWhichNode < iNodeCount; indexWhichNode++)
				{
					if (dDistanceTail[indexWhichSet][indexWhichNode] != 0)
					{
						dRatioHeadTail[indexWhichNode] = dDistanceHead[indexWhichSet][indexWhichNode] / dDistanceTail[indexWhichSet][indexWhichNode];
					}else dRatioHeadTail[indexWhichNode] = 1;
					dOne[indexWhichNode] = 1;
				}

				if (dMax1 > dMax2)
				{
					dMax = dMax1 + 10;
				}else dMax = dMax2 + 10;
				
				if (dMin1 > dMin2)
				{
					dMin = dMin1 + 10;
				}else dMin = dMin2 + 10;

				//load panel
				pHdTl = LoadPanel (pLineupBBS, "wormClassify.uir", pnlHdTl) ;
				//install popup
				InstallPopup (pHdTl);		

				//set value
				SetCtrlVal (pHdTl, pnlHdTl_nAvgFirst, dSpeedHead);
				SetCtrlVal (pHdTl, pnlHdTl_nAvgLast, dSpeedTail);
				
				//plots
				PlotXY (pHdTl, pnlHdTl_gphHdTl, dTime, dDistanceHead[indexWhichSet],
						iNodeCount, VAL_DOUBLE, VAL_DOUBLE, VAL_SCATTER,
						VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
						
				PlotXY (pHdTl, pnlHdTl_gphHdTl, dTime, dDistanceTail[indexWhichSet],
						iNodeCount, VAL_DOUBLE, VAL_DOUBLE,
						VAL_SCATTER, VAL_SOLID_SQUARE, VAL_SOLID, 1, VAL_BLUE);
				
				//set scale
				SetAxisScalingMode (pHdTl, pnlHdTl_gphHdTl, VAL_LEFT_YAXIS, VAL_MANUAL, dMin, dMax);
				
				//get the ratio value
				StdDev (dRatioHeadTail, iNodeCount, &dRatio, &dSD);
				
				//Suggest switch or not
				if (dRatio <= 1)
				SetCtrlVal (pHdTl, pnlHdTl_binSwitch, 1);
		
			  //show the value
				SetCtrlVal (pHdTl, pnlHdTl_nRatio, dRatio);
				SetCtrlVal (pHdTl, pnlHdTl_nRatioSD, dSD);
				
				//plot it
				PlotXY (pHdTl, pnlHdTl_gphHdTlRatio, dTime, dRatioHeadTail,
						iNodeCount, VAL_DOUBLE, VAL_DOUBLE, VAL_THIN_LINE,
						VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_BLUE);
						
				PlotXY (pHdTl, pnlHdTl_gphHdTlRatio, dTime, dOne, iNodeCount,
						VAL_DOUBLE, VAL_DOUBLE, VAL_FAT_LINE, VAL_NO_POINT, VAL_SOLID,
						1, VAL_RED);
						
				//set the hidden value
				SetCtrlVal (pHdTl, pnlHdTl_nIndex, indexWhichSet);
						
				//wait user finished it		
wait:
				GetUserEvent (1, &iPanel, &iControl);
				//get the value of final decision
				GetCtrlVal (pHdTl, pnlHdTl_binSwitch, &iSwitch);
				if (iSwitch == 1)
				{
					sprintf(sMessage, "You are going to switch the whole set!") ;
				}else
					sprintf(sMessage, "You are NOT going to switch the whole set!") ;
				MessagePopup ("Check it", sMessage);
				
				
				if ( (iPanel != pHdTl) || (iControl != pnlHdTl_cmdSetIt) ) goto wait; 
				
				free (dRatioHeadTail);
				free (dOne);
exit:
				//set the flag
				iSwitchWholeSet[indexWhichSet] = iSwitch; 

//load a new set
				//SetCtrlVal (panel, pLineupBBS_nWhichSet, iWhichSet);
				if (indexWhichSet < gTotalFileNumber - 1)
				{
					cleanIt (gBksForLineup[indexWhichSet], panel); 
					initiateIt (gBksForLineup[indexWhichSet + 1], panel) ;
					SplitBackboneSetForLineup (panel, gBksForLineup[indexWhichSet + 1]) ;
				}

			}
			
//Then Switch them if neccesssary


			ResetTextBox (panel, pLineupBBS_txtWorkStatus, "Sorting Head and Tail.\n\n");
			
 			for (indexWhichSet = 0; indexWhichSet < gTotalFileNumber; indexWhichSet ++)
			{
				iNodeCount = gBksForLineup[indexWhichSet]->NodeCount;
				iNumXY = gBksForLineup[indexWhichSet]->NumXYpairs;
				for (indexWhichNode = 0; indexWhichNode < iNodeCount; indexWhichNode ++)
				{
					if ( gBksForLineup[indexWhichSet]->backboneNodePtr[indexWhichNode] != null)
					{
						//iTemp =  gBksForLineup[indexWhichSet]->backboneNodePtr[indexWhichNode]->iIsBkbp;
						//iTemp = iSwitchWholeSet[indexWhichSet];
						if ( (gBksForLineup[indexWhichSet]->backboneNodePtr[indexWhichNode]->iIsBkbp == 1) && (iSwitchWholeSet[indexWhichSet] == 1) )
						{
							Reverse (gBksForLineup[indexWhichSet]->backboneNodePtr[indexWhichNode]->xPoints, iNumXY, gBksForLineup[indexWhichSet]->backboneNodePtr[indexWhichNode]->xPoints);
							Reverse (gBksForLineup[indexWhichSet]->backboneNodePtr[indexWhichNode]->yPoints, iNumXY, gBksForLineup[indexWhichSet]->backboneNodePtr[indexWhichNode]->yPoints);
						}
					}
				}
				
				gBksForLineup[indexWhichSet]->isBbpAligned = LINED_SORTED;
				
				SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, txtMsgStatusLinedAndSorted);
   				sprintf (sMessage, "\nSet: (%d) of total %d sets is done.", indexWhichSet, gTotalFileNumber);
				InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, - 1, sMessage);
			}

   			sprintf (sMessage, "\nAll Sets are sorted.");
			InsertTextBoxLine (panel, pLineupBBS_txtWorkStatus, - 1, sMessage);
			
			free (iSwitchWholeSet);

			break;
		}
	return 0;
}


int CVICALLBACK setToNotAlined (int panel, int control, int event, void *callbackData, int eventData1, int eventData2)
{
int indexWhichSet;
int iContinue ;

	switch (event)
		{
		case EVENT_COMMIT:
	
			if ( gBksForLineup == null || gLineupBkbFileLoaded == 0) 
			{
				MessagePopup ("Warning!", "No backboneset is ready yet, please choose backbone set for analysis.");
				return (0) ;
			}
			
			GetCtrlVal (panel, pLineupBBS_nWhichSet, &indexWhichSet);
			
			if (gBksForLineup[indexWhichSet]->isBbpAligned > 0)  
			{
				iContinue = ConfirmPopup ("Warning!", "Are you sure you want to set lineup status to \n unlined and unsorted?");
				if (iContinue == 1)
				{
					gBksForLineup[indexWhichSet]->isBbpAligned = 0;

 					ResetTextBox (panel, pLineupBBS_txtWorkStatus, "Current set is set to NOT Lined and NOT Sorted");
		 			SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, "");
 					
				}else return (0);
			}

			break;
		}
		
	return 0;
}
//*/

int initiateIt (BackboneSet *bkbs, int panel)
{

int iNumXY;
int iNumImage;
int index;
//*should move to new function when line up			
//**********************************get some paramenter
			iNumXY =  bkbs->NumXYpairs ; 
			iNumImage = bkbs->NodeCount;
			
//***********************Get the data values from the backbone set 
			//Assign the memory
			dX = (double **) malloc ( iNumImage * sizeof(double *) );	    
			dY = (double **) malloc ( iNumImage * sizeof(double *) ) ; 
			dTime = (double *)malloc (iNumImage * sizeof(double) );

			for (index = 0; index < iNumImage; index ++)
			{
				dX[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
				dY[index] = (double *)malloc(iNumXY * sizeof(double)) ; 
			}

			//JF help
			dBackbone1X =  (double *)malloc (iNumXY * (sizeof(double)));
			dBackbone2X =  (double *)malloc (iNumXY * (sizeof(double)));
			dBackbone1Y =  (double *)malloc (iNumXY * (sizeof(double)));
			dBackbone2Y =  (double *)malloc (iNumXY * (sizeof(double)));
			dFitting1X =  (double *)malloc (2 * (sizeof(double)));
			dFitting1Y =  (double *)malloc (2 * (sizeof(double)));
			dFitting2X =  (double *)malloc (2 * (sizeof(double)));
			dFitting2Y =  (double *)malloc (2 * (sizeof(double)));
			
//			iLoopType = (int *)calloc (iNumImage, sizeof (int));
//			iIsBkbp = (int *)calloc (iNumImage, sizeof (int));

			dDistanceArray = (double *)malloc (iNumImage * (sizeof(double)));

			return 1;
}

int cleanIt(BackboneSet *bkbs, int panel) 
{
int index;

//*******************************delete the plots
	if (iPlotLineupBBSWorm1 > 0) iPlotLineupBBSWorm1 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupBBSWorm1, VAL_IMMEDIATE_DRAW);
	if (iPlotLineupBBSWorm2 > 0) iPlotLineupBBSWorm2 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupBBSWorm2, VAL_IMMEDIATE_DRAW);

	if (iPlotLineupFitting1 > 0) iPlotLineupFitting1 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupFitting1, VAL_IMMEDIATE_DRAW);
	if (iPlotLineupFitting2 > 0) iPlotLineupFitting2 = DeleteGraphPlot (panel, pLineupBBS_gphLineupBBS, iPlotLineupFitting2, VAL_IMMEDIATE_DRAW);

//******************************free the memory

	free (dTime);
//	free (iLoopType);
//	free (iIsBkbp);

//need more work to free memeory
	for (index = 0; index < bkbs->NodeCount; index ++)
	{
		free (dX[index]);
		free (dY[index]);
	}
	
	free (dX) ; 
	free (dY) ; 				
//*************free more memory
	free (dBackbone1X);				  
	free (dBackbone2X);
	free (dBackbone1Y);							 
	free (dBackbone2Y);
	free (dFitting1X);
	free (dFitting1Y);
	free (dFitting2X);
	free (dFitting2Y);
				
	free (dDistanceArray);
	
	return 1;
				
}

//************************SplitBackboneSet***************************************************************************************
// 																																 
// 		This function takes, a BackboneSet, the number of the backbone points in the set, and total number of desired, and the
//            number of the starting one and split the backbone into two array of coordinates matrix (X, Y) and the major 
//            X angle array for each image node in unit of radius.   This function returns the total valid image numbers                                                                                                           
// 																																 
//*******************************************************************************************************************************
int SplitBackboneSetForLineup (int panel, BackboneSet * thisBackbone)
{
int indexXYPairs, indexNode;
int indexValidNode = 0;

double dMedian; 
double *dTempLength;

int nodeCount;
int numXY;
double dTemp = 0.0;
char sMessage[200];
double dTempTime = 0;
int iRmvshortBkb = 0;

int iRemoved = 0;
int iPanel;

int iMan = 0;
double dUpperLimit;
double dTempMedian;

//double dDebug;


//should add control for alined one
																							  
	nodeCount = thisBackbone->NodeCount;
	numXY = thisBackbone->NumXYpairs;

	if (thisBackbone->isBbpAligned < 0) iRmvshortBkb = 1;

	if (iRmvshortBkb == 1)
	dTempLength = (double *)calloc(nodeCount, sizeof(double));
		
//*get rid of the short length one
	for (indexNode = 0; indexNode < nodeCount; indexNode ++)
	{
		if (thisBackbone->backboneNodePtr[indexNode] != null )
		{
			if (iRmvshortBkb == 1)
			{
				dTempLength[indexNode] = thisBackbone->backboneNodePtr[indexNode]->imageInfor.dWormLength;
				//dDebug = dTempLength[indexNode];
			}
			
			if (thisBackbone->backboneNodePtr[indexNode]->Time > 0)
			{
				dTempTime = dTempTime + thisBackbone->backboneNodePtr[indexNode]->Time; 
				dTime[indexNode] = dTempTime ; 
			}else 
			{
				dTempTime = dTempTime + 0.50;
				dTime[indexNode] = dTempTime ; 
			}
				
		} else 
		{
			dTempTime = dTempTime + 0.50;
			dTime[indexNode] = dTempTime ; 
		}
	}

	if (iRmvshortBkb == 0) goto next;  

	GetCtrlVal (panel, pLineupBBS_swtMan, &iMan);
	if (iMan == 0)
	{
		Median (dTempLength, nodeCount, &dTempMedian);
		
		dMedian = 0.85 * dTempMedian;
		
		dUpperLimit = 1.15 * dTempMedian;
	}
	else
	{
	
		GetCtrlVal (panel, pLineupBBS_numLength, &dMedian); 
		dMedian = dMedian;
		dUpperLimit = 1.5 * dMedian ;

	}
	
	
	
	XYGraphPopup ("Check", dTime, dTempLength, nodeCount, VAL_DOUBLE, VAL_DOUBLE);

	//get the coordinates matrix for X, Y and the majorAxis array for XAxis angle
	for (indexNode = 0; indexNode < nodeCount; indexNode ++)
	{
		if( (thisBackbone->backboneNodePtr[indexNode] != null ) && (thisBackbone->backboneNodePtr[indexNode]->iIsBkbp == 1) )
		{
			dTemp = dTempLength[indexNode];
			/*
				if (indexNode == 140)
				{
				
				   sprintf (sMessage, "length 140 is %f", dTemp);
				   MessagePopup ("Check it", sMessage);
				
				}
			//*/
			if (dTemp >= dMedian && dTemp <= dUpperLimit)
			{
				for (indexXYPairs = 0; indexXYPairs < numXY; indexXYPairs ++)
				{
					dX[indexNode][indexXYPairs] = thisBackbone->backboneNodePtr[indexNode]->xPoints[indexXYPairs] ;
					dY[indexNode][indexXYPairs] = thisBackbone->backboneNodePtr[indexNode]->yPoints[indexXYPairs] ;
				}
				
				thisBackbone->backboneNodePtr[indexNode]->iIsBkbp = 1; 
				indexValidNode ++;
			} //if this set is long enough
			else if ( ( (dTemp) > 0 && (dTemp < dMedian) ) || dTemp > dUpperLimit)
			{
				thisBackbone->backboneNodePtr[indexNode]->iIsBkbp = 0;
				thisBackbone->backboneNodePtr[indexNode]->imageInfor.iLoopType = 3;
				thisBackbone->type3LoopCount++;
				thisBackbone->backboneNodePtr[indexNode]->imageInfor.dWormLength = -1.0;
				thisBackbone->backboneNodePtr[indexNode]->imageInfor.dTransparency = -1.0;
				thisBackbone->backboneNodePtr[indexNode]->imageInfor.dFatness = -1.0;
				thisBackbone->backboneNodePtr[indexNode]->imageInfor.dThickness = 1.0;
				thisBackbone->backboneNodePtr[indexNode]->imageInfor.dLengthToPixelNumber = -1.0;
				thisBackbone->backboneNodePtr[indexNode]->xPoints = null;
				thisBackbone->backboneNodePtr[indexNode]->xPoints = null;
			}  //if this set is too short
		}  //end of if null node or node has no bkbk

	} //end of node

	free (dTempLength);
	iRemoved = nodeCount - indexValidNode - thisBackbone->invalidNodeCount;
	sprintf (sMessage, "Information: \n%d short backbone sets, %d invalide node\nfrom total of %d valid nodes", iRemoved, thisBackbone->invalidNodeCount, nodeCount);
	
	iPanel = GetActivePanel ();
	ResetTextBox (iPanel, pLineupBBS_txtWorkStatus, sMessage);
	
	goto next1;
	
next:

	for (indexNode = 0; indexNode < nodeCount; indexNode ++)
	{
		//dTemp =  thisBackbone->backboneNodePtr[indexNode]->iIsBkbp *1.0;
		if( (thisBackbone->backboneNodePtr[indexNode] != null ) && (thisBackbone->backboneNodePtr[indexNode]->iIsBkbp == 1) )
		{
			for (indexXYPairs = 0; indexXYPairs < numXY; indexXYPairs ++)
			{
				dX[indexNode][indexXYPairs] = thisBackbone->backboneNodePtr[indexNode]->xPoints[indexXYPairs] ;
				dY[indexNode][indexXYPairs] = thisBackbone->backboneNodePtr[indexNode]->yPoints[indexXYPairs] ;
			}
		}
//Is Not Used Consider remove it
//		iLoopType[indexNode] = thisBackbone->backboneNodePtr[indexNode]->imageInfor.iLoopType;
//		iIsBkbp[indexNode] = thisBackbone->backboneNodePtr[indexNode]->iIsBkbp;
		
		indexValidNode ++;
	}

next1:

	return indexValidNode;
}

int suggestSwitch(double *dX1, double *dY1, double *dX2, double *dY2, int iNumXY, int iGap)
{

int index;

double *dTempDistance;
double dX0, dY0;
double dXLast, dYLast;

double dMax, dMin1, dMin2, dMin3, dMin4;
int indexMax, indexMin1, indexMin2, indexMin3, indexMin4;

int iSuggestSwich;

char sMessage[200];

	dTempDistance = (double *)calloc(iNumXY, sizeof(double));

	switch (iGap)
	{
		case 0:
	
			dX0 = dX1[0];
			dY0 = dY1[0];
			dXLast = dX1[iNumXY -1];
			dYLast = dY1[iNumXY -1];
	
			for (index = 0; index < iNumXY; index++)
			{
				dTempDistance[index] = sqrt ( (dX0 - dX2[index]) * (dX0 - dX2[index]) + (dY0 - dY2[index]) * (dY0 - dY2[index]) ) ;
			}
	
			MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin1, &indexMin1);
	
			for (index = 0; index < iNumXY; index++)
			{
				dTempDistance[index] = sqrt ( (dXLast - dX2[index]) * (dXLast - dX2[index]) + (dYLast - dY2[index]) * (dYLast - dY2[index]) ) ;
			}
	
			MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin2, &indexMin2);

			dX0 = dX2[0];
			dY0 = dY2[0];
			dXLast = dX2[iNumXY -1];
			dYLast = dY2[iNumXY -1];	

			for (index = 0; index < iNumXY; index++)
			{
				dTempDistance[index] = sqrt ( (dX0 - dX1[index]) * (dX0 - dX1[index]) + (dY0 - dY1[index]) * (dY0 - dY1[index]) ) ;
			}
	
			MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin3, &indexMin3);

			for (index = 0; index < iNumXY; index++)
			{
				dTempDistance[index] = sqrt ( (dXLast - dX1[index]) * (dXLast - dX1[index]) + (dYLast - dY1[index]) * (dYLast - dY1[index]) ) ;
			}
	
			MaxMin1D (dTempDistance, iNumXY, &dMax, &indexMax, &dMin4, &indexMin4);

			if ( (indexMin1 - 0 < 29 - indexMin1) && (29 - indexMin2 < indexMin2 - 0)  && (indexMin3 - 0 < 29 - indexMin3) && (29 - indexMin4 < indexMin4 - 0) )
			{
				iSuggestSwich = 0;
			} else iSuggestSwich = 1;
			
		break;

		case 1:
		
			dX0 = dX1[0];
			dY0 = dY1[0];
			dXLast = dX2[0];
			dYLast = dY2[0];
			dTempDistance[0] = sqrt ( (dX0 - dXLast) * (dX0 - dXLast) + (dY0 - dYLast) * (dY0 - dYLast) ) ;

			dX0 = dX1[iNumXY - 1];
			dY0 = dY1[iNumXY - 1];
			dXLast = dX2[iNumXY - 1];
			dYLast = dY2[iNumXY - 1];
			dTempDistance[1] = sqrt ( (dX0 - dXLast) * (dX0 - dXLast) + (dY0 - dYLast) * (dY0 - dYLast) ) ;

			dX0 = dX1[0];
			dY0 = dY1[0];
			dXLast = dX2[iNumXY - 1];
			dYLast = dY2[iNumXY - 1];
			dTempDistance[2] = sqrt ( (dX0 - dXLast) * (dX0 - dXLast) + (dY0 - dYLast) * (dY0 - dYLast) ) ;

			dX0 = dX1[iNumXY - 1];
			dY0 = dY1[iNumXY - 1];
			dXLast = dX2[0];
			dYLast = dY2[0];
			dTempDistance[3] = sqrt ( (dX0 - dXLast) * (dX0 - dXLast) + (dY0 - dYLast) * (dY0 - dYLast) ) ;

			MaxMin1D (dTempDistance, 4, &dMax, &indexMax, &dMin4, &indexMin4);
		
			if ( indexMin4 <= 1)
			{
				iSuggestSwich = 0;
			} else iSuggestSwich = 1;
		break;
	}

	free (dTempDistance);

	return iSuggestSwich;
}

int CVICALLBACK changeCurrentSet (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int iWhichSet;
	switch (event)
		{
		case EVENT_COMMIT:
		
		
			GetCtrlVal (panel, pLineupBBS_nWhichSet, &iWhichSet); 
			
			if ( gBksForLineup[iWhichSet] == null || gLineupBkbFileLoaded == 0) 
			{
				MessagePopup ("Warning!", "No backboneset is ready for lineup, please choose backbone set for analysis.");
				return (0) ;
			}

//should copy to another function
			if (iWhichSet != gWhichSet)
			{
				gWhichSet = iWhichSet;
				//SetCtrlVal (panel, pLineupBBS_nWhichSet, iWhichSet);  
				cleanIt (gBksForLineup[gWhichSet], panel);      
				initiateIt (gBksForLineup[gWhichSet], panel) ;
				//get information
				SplitBackboneSetForLineup (panel, gBksForLineup[gWhichSet]) ; 
				
			}
//*/

			break;
		}
	return 0;
}

int CVICALLBACK SetIt (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
	switch (event)
		{
		case EVENT_COMMIT:
		
			RemovePopup (0);

			break;
		}
	return 0;
}

int CVICALLBACK printHdTlFigures (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
double dAveHead;
double dAveTail;
double dRatio;
double dSD;
char sMessage[200];
int index;

	switch (event)
		{
		case EVENT_COMMIT:
			
			//Get the backbone Set index
			GetCtrlVal (panel, pnlHdTl_nAvgFirst, &dAveHead);
			GetCtrlVal (panel, pnlHdTl_nAvgLast, &dAveTail);
			GetCtrlVal (panel, pnlHdTl_nRatio, &dRatio);
			GetCtrlVal (panel, pnlHdTl_nRatioSD, &dSD);

			GetCtrlVal (panel, pnlHdTl_nIndex, &index);
		
			SetPrintAttribute (ATTR_SHOW_DATE, 1);
			SetPrintAttribute (ATTR_SHOW_PAGE_NUMBERS, 1);
			SetPrintAttribute (ATTR_PRINT_AREA_HEIGHT, 800);
			SetPrintAttribute (ATTR_PRINT_AREA_WIDTH, 800);

			SetPrintAttribute (ATTR_EJECT_AFTER, 0);
			PrintCtrl (panel, pnlHdTl_gphHdTl, "", 1, 1);

			sprintf(sMessage, gBksForLineup[index]->setName);
			PrintTextBuffer (sMessage, "");
   			sprintf(sMessage, "Average speed of first bkbp: %f\nAverage speed of last bkbp: %f", dAveHead, dAveTail);
			PrintTextBuffer (sMessage, "");
			SetPrintAttribute (ATTR_EJECT_AFTER, 1);

				
			SetPrintAttribute (ATTR_EJECT_AFTER, 0);
			PrintCtrl (panel, pnlHdTl_gphHdTlRatio, "", 1, 1);
			sprintf(sMessage, gBksForLineup[index]->setName);
			PrintTextBuffer (sMessage, "");
			sprintf(sMessage, "Average ratio (First/Last): %f\nS.D.: %f", dRatio, dSD);
			PrintTextBuffer (sMessage, "");
			SetPrintAttribute (ATTR_EJECT_AFTER, 1);

			break;
		}
	return 0;
}

/*
int CVICALLBACK setToNotSorted (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
int indexWhichSet;
int iContinue ;

	switch (event)
		{
		case EVENT_COMMIT:
	
			if ( gBksForLineup == null || gLineupBkbFileLoaded == 0) 
			{
				MessagePopup ("Warning!", "No backboneset is ready yet, please choose backbone set for analysis.");
				return (0) ;
			}
			
			//Get the backbone Set index
			GetCtrlVal (panel, pLineupBBS_nWhichSet, &indexWhichSet);

			//IF the current backbone set is NOT sorted
			if (gBksForLineup[indexWhichSet]->isBbpAligned < 2) 
			{
				MessagePopup ("Error", "This is set is NOT sorted anyway.");
			
			}
			
			//the current backbone set is lined
			if (gBksForLineup[indexWhichSet]->isBbpAligned > 1)  
			{
				//confirm the user input
				iContinue = ConfirmPopup ("Warning!", "Are you sure you want to set lineup status to \n lined but NOT sorted?");
				
				//if user want to reset the flag
				if (iContinue == 1)
				{
					gBksForLineup[indexWhichSet]->isBbpAligned = 1;
					
					//tell the change is done to user
					ResetTextBox (panel, pLineupBBS_txtWorkStatus, "Current set is set to Lined but NOT Sorted");
			 		SetCtrlVal (panel, pLineupBBS_txtMsgLineupStatus, "");
					
				}else return (0);
			}
			
			break;
		}
		
	return 0;
}
//*/

//************DisAngleBetweenTwoPoints***************************************************************************************
//																															
//			This function calculates the distance and the angle for point 2 to point 1.										
//																															
//***************************************************************************************************************************
int DisAngleBetweenTwoPoints (double dX1, double dY1, double dX2, double dY2, double * dAngle, double * dDistance)
{

double dXTemp, dYTemp;

		dXTemp = dX2 - dX1;
		dYTemp = dY2 - dY1;
				
		* dDistance = sqrt(dXTemp * dXTemp + dYTemp * dYTemp);
		if (* dDistance < 0)
		{
			return -1;
		}

		* dAngle = atan2 (dYTemp, dXTemp);
		
		if (* dAngle > PI || * dAngle < PI)
		{
			return 0 ;
		}
		
		return 1;
}
