// ***********************************************************************************************

// 			Worm Project:  Data structures and associated functions

//			UCSD Biology, Schafer Lab

// 			Written by John Wittig Jr. 

//			wormDataStruct.h

// ***********************************************************************************************


// calculation shows 20 minutes of data would maximally equal 384 MBytes. (in reality it is more like 7MB)
// define NODES_PER_SET to not exceed the physical memory of the computer
#define FULL_SET_ERROR -1
#define MEM_ERROR 0
#define MAX_NAME_LEN 500

#define null 0

typedef struct ImageInfors
{
//general
int iLoopType;
double dArea;
double dWormLength;
double dTransparency;
double dThickness;
double dFatness;

//selfdefine
double dLengthToPixelNumber;

//shape equivalence analysis
double dMaxIntercept;
double dMeanInterceptPerpendicular;
double dEquivalenceEllipsRatio;
double dEllipsMajorAxis;
double dEllipsRatio;
double dRectBigSide;
double dRectRatio;

//shape feature
double dElongationFactor;
double dCompactnessFactor;
double dHeywoodCicularityFactor;
double dTypeFactor;
double dHydraulicRadius;
double dWaddelDiskDiameter;
double dIXX, dIYY, dIXY;

}  ImageInfor ;


//**************************************************************************************
//				BackboneNode Definition
//**************************************************************************************
typedef struct BackboneNodes
{
	// the absolute (with reference to the stage & image box) centroid of the binary Backbone
	//JF
	double Time;
	double absCentX, absCentY ; 

	ImageInfor imageInfor;

	int iIsBkbp;

	double * xPoints;
	double * yPoints;
	
} BackboneNode ;
//*/

typedef long BackboneNodePtr ;
// **************************************************************************************
//				BackboneSet Definition
/**************************************************************************************
// the BackboneSet will be a pointer to an object. Memory is allocated automatically upon
// declaration of the variable
typedef struct BackboneSets
{
	
	char * setName ;
	// how many backbone points per node
	int NumXYpairs ;
	// counts the nodes as they are written, saved and read from BackboneSet file    
	int NodeCount ;	
	// array of long values which are pointers to BackboneNodes in memory
	BackboneNode ** backboneNodePtr ;
	
	int filePtr ;
	int byteCount ;
	
	// used in analysis: this defines the nuber of high dimensional points contained within this set
	int * highDList ;
	
} BackboneSet ;
//*/
//**************************************************************************************
//				BackboneSet Definition
//**************************************************************************************
// the BackboneSet will be a pointer to an object. Memory is allocated automatically upon
// declaration of the variable
typedef struct BackboneSets
{
	char * setName ;
	//data
	char Date[11]; //for version control
	int isBbpAligned;
	// how many backbone points per node
	int NumXYpairs ;
	// counts the nodes as they are written, saved and read from BackboneSet file    
	int NodeCount ;	
	// array of long values which are pointers to BackboneNodes in memory
	int type1LoopCount;
	int type2LoopCount;
	int type3LoopCount;
	int invalidNodeCount;
	
//AVI change
	int FrameRate;
	
	BackboneNode ** backboneNodePtr ;
	
	int filePtr ;
	int byteCount ;
	
	// used in analysis: this defines the nuber of high dimensional points contained within this set
} BackboneSet ;


// **************************************************************************************
//				Function prototypes
// **************************************************************************************
BackboneNode * newBackboneNode(int numXYpairs, double newTime, double newAbsCentX, double newAbsCentY, ImageInfor newImageInfor, double * newXpoints, double * newYpoints, int iVersion);
BackboneNode * readBackboneNode(int filePtr, BackboneSet * thisSet, int iVersion) ;

double * getBackbone(BackboneSet * thisSet, int thisNode) ;
int writeBackboneNode(BackboneNode * thisNode, int filePtr, BackboneSet * thisBackboneSet) ;
int destroyBackboneNode(BackboneNode * thisNode) ;

BackboneSet * newBackboneSet(char * newBackboneSetName, int newNumXYpairs, int newNodeCount, int iFrameRate) ;
BackboneSet * readBackboneSet(char * newBackboneSetName) ;
int writeBackboneSet(BackboneSet * thisBackboneSet) ;
int destroyBackboneSet(BackboneSet ** BackboneSetPtrPtr) ;  

int addBackbone(BackboneSet * thisBackboneSet, int whichNode, double newTime, double newAbsCentX, double newAbsCentY, ImageInfor newImageInfor, double * newXpoints, double * newYpoints, int iVersion);
void getBackboneVersion (BackboneSet *newSet, int *iVersion);

BackboneSet * readBackboneSetAVI(char * newBackboneSetName) ;
