////////////////////////////////////////////////////////////////////////////////////////
// 
// filename: backBoneAnalysis.h
// by: Jay Silver
// at: Schafer Lab, UCSD
//
////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: extractBackboneFromBinImg
// header last updated: 07/18/2001
//
// PURPOSE: to find, clean, and sample the backbone of a series of binary images of a C. elegans
//
// SPECIFICATIONS/INPUT: 	1) a binary skeleton represented as a 2d matrix of pointers to characters  							
//							2) the number of desired sample points along the backbone (should be less than
//								half of the minimum dimension of the image)
//							3) the width and height of the binary skeleton image
//
// OUTPUT: 1) lists of x and y coordinates of the sampled backbone represented as pointers to doubles
//						
// RETURNS: 1 if successful
//			0 if logically unable to create backbone
//
//
// REQUIREMENTS:  when the calling program is finished analyzing a sequence of images 
//			  	  with this function, the calling program must call resetExtractBackboneFromBinImg() 
//
// NOTES: The calling function's binary skeleton will be corrupted (pruned, altered, etc.), so if the program
//			will need this information later, a copy must be passed in (instead of the original)			
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////

int extractBackboneFromBinImg(  
								// specifications/input
								char ** binaryImageOfSkeletonToAnalyze,
			   					int numOfSamplesToTakeFromTheBackBone,
			   					int widthOfBinaryImage,
			   					int heightOfBinaryImage,
			   					
			   					// output
			   					double * xCoordinatesOfSampledBackBone,
			   					double * yCoordinatesOfSampledBackBone 
			   				  ); 
			   				  
			   				  
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: thinImg
// header last updated: 07/24/2001
//
// PURPOSE: To thin an image to a line as described by T.Y.Zhang and C.Y.Suen in "A Fast Parallel 
//				Algorithm for Thinning Digital Patterns
//
// SPECIFICATIONS/INPUT: 1) a binary image of a worm held as a matrix of pointers to chars
//						 2) the height and width of the image
//
// OUTPUT: 1) the image that is passed in will be altered, acting as the output
//		   2) the return value is also an output, it tells whether or not another iteration is necessary
//
// RETURNS: 1 if the image was altered on this iteration (indicating another iteration is required)
//		    0 if the image was unaltered (indicating that the thinning is complete)
//
// REQUIREMENTS: the image must be one pixel wide before being passed to extractBackboneFromBinImg,
//				      so this function must be called iteratively until it returns 0 prior to extracting
//					  the backbone information.
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////		   				  
int thinImg(char ** binImg, int height, int width);     			   				  




//////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: resetExtractBackboneFromBinImg
// header last updated: 07/11/2001
//
// PURPOSE: to clean up memory allocated by extractBackboneFromBinImg() and set all conditions to initial
//
// SPECIFICATIONS/INPUT: none
//
// OUTPUT: none
//
// RETURNS: 1 if successful
//		    0 if unsuccessful
//
// REQUIREMENTS: call whenever a sequence of images is done being analyzed with extractBackboneFromBinImg() 
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////

int resetExtractBackboneFromBinImg();



/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// CONSTANTS SECTION
//
// Most Important: ensure that the image dimensions used match the constants defined below, should be set to width+2 and height+2
//
// These are the programmer's variables.  Change the program to give the desired amount of debug output, and altar memory settings etc.
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// 


// if DEBUG is defined, a window will appear to show what the analysis is doing

/*
#define DEBUG 
#ifdef DEBUG
	void showImageWithGray( char ** char2d, int height, int width, int windowNumber, int rowGray, int colGray, char valGray );
	void showImage( char ** char2d, int height, int width, int windowNumber ); 
	// Turn these on and off to get a glimpse into the operation of different parts of the program
	#define DEBUG_SAMPLE
	#define DEBUG_TRAVERSE
	//#define DEBUG_SWITCH_HEAD_AND_TAIL
	#ifdef DEBUG_SWITCH_HEAD_AND_TAIL 
		// these decide how long to show a picture to the screen, sometimes it is nice to examine the backbone points for longer periods of time
		//#define DELAY_TIME_FOR_DISPLAY_OF_FINAL_PRODUCT 2 // in seconds (note, final product implies the sampled backbone points)
		//#define DELAY_TIME_FOR_SHOWING_WHERE_TAIL_IS 1 // in seconds
		//#define SAMPLE_POINTS_DISPLAY_COLOR 150 // valid numbers are 0-255 
	#endif
	//#define DEBUG_PROCESS_SYSTEM_EVENTS  // whether or not to allow system events to be processed with each image iteration
	//#define DEBUG_PRUNE
	//#define DEBUG_DISTS
	//#define DEBUG_EXPLORE_DIR
	//#define DEBUG_DIAGONALIZE
	// these files are only included if debug is defined because this entire file does not depend on anything except ansiC
	#include "nivision.h"
	#include "userint.h"
	#include <utility.h>     
#endif	
*/

// don't mess with these unless you know the implications.  lowering them will save memory, raising them will fix errors caused by catastrophic starting images (which should not be put in in the first place)
#define MAX_NUM_PSOI 200
#define MAX_PIXELS_IN_WORM 1000
#define MAX_PIXELS_TO_REP_BACKBONE 200

// the following preprocessor instruction (THERE_MAY_BE_FANS) must be defined if there could possibly be the following pattern or this patterns' reflection
//
// Example of a "Fan"
// 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
// 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
// 0 0 0 0 0 0 0 0 * 0 0 0 0 0 0 0
// 0 0 0 0 0 0 * * * 0 0 0 0 0 0 0
// 0 0 0 0 0 0 0 * * * 0 0 0 0 0 0   stars (*'s) are foreground
// 0 0 0 0 0 0 0 * 0 0 0 0 0 0 0 0   0's are background
// 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
// 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
//
// this pattern will have a probability of existing if the thinning algorithm provided in this file is used to obtain a part of the skeleton
#define THERE_MAY_BE_FANS

// change these if the image size changes
#define MAX_WIDTH 377 // give image 1 extra pixel on all sides for a border 
#define MAX_HEIGHT 377 // so, MAXWIDTH = actualWidth+2; and MAXHEIGHT = actual height+2


