

/*********************************************************************************************/
/*																							 */
/*		Worm Project:  Data collection and saving											 */
/*																							 */
/*		UCSD Biology, Schafer Lab															 */
/*																							 */
/*		Written by John Feng and John Wittig							 					 */
/*        																					 */
/*      John Wittig left the project 8/29/2001, JF continues after 8/30/2001				 */
/*																							 */
/*		Actually, almost all codes here are from John Feng.                                  */																					 
/*																							 */
/*																							 */
/*********************************************************************************************/


//********************************************************************************************************************

//*		Inlcluding header files																						 *

//********************************************************************************************************************
#include "nivision.h"
#include <formatio.h>
#include <analysis.h>
#include <utility.h>
#include <ansi_c.h>
#include <cvirte.h>		/* Needed if linking in external compiler; harmless otherwise */
#include <userint.h>

#include "niimaq.h"

//********************************************************************************************************************
//*		JF Inlcluding header files																						
//********************************************************************************************************************
#include "wormClassify.h"
#include "backboneDataStruct.h"
#include "backboneAnalysis.h"
#include "ImageProcessing.h"
#include "time.h"

//AVI stuff
#include "OpenAVILib.h"
#include "getAVIInforLib.h"
#include "closeAVI.h"
#include "readAVIsFrame.h"   

//********************************************************************************************************************/
//*	      CONSTANT AND VARIABLES DECLARATION. 																		 */
//*																													 */
//*       JF:  These codes should be in the header file.  It is kind of time-consuming to move these code to 		 */
//*            header files.  So I keep these untouched.															 */							
//*               																									 */
//********************************************************************************************************************/

#define IMAGE_X 640
#define IMAGE_Y 480

#define DEBUG_SKEL // added by jay


//********************************************************************************************************************/
//***********      GLOBAL VARIABLE DECLARATION   *********************************************************************/
//********************************************************************************************************************/
static int panelConvert;

//*********************************************************************************************//
//  Image objective and related definitions by JW
//*********************************************************************************************//

// Color palette 
int	paletteGrey[256] ;   
int	paletteBin[256] ;   

static RGBValue paletteBinOut[256];  
PixelValue 	pixZero, whitePix ; 		// initalized to value zero in "initVar()"



// ***********      flags and handlers							************************************************** / 
int gConvSetSize = 0 ;
int iPlotBackbone = 0;
char ** fileList ;


//********************************************************************************************************************/
//*	      Local function DECLARATION. 																				 */
//*																													 */
//********************************************************************************************************************/
void InitVariables (void) ;
//bakcbone extraction
//int MagicSkel( char * thisImageChar, int thisWidth, int thisHeight, int thisAbsX, int thisAbsY, int numXYpairs, double * thisXcoord, double * thisYcoord, int iPrevious, double *dPreviousX, double *dPreviousY, int *iLoopType) ;
int MagicSkel( char * thisImageChar, int thisWidth, int thisHeight, int thisAbsX, int thisAbsY, int numXYpairs, double * thisXcoord, double * thisYcoord, int *iLoopType, double *dLength);
int countTransparency(unsigned char *greyImage, unsigned char *binImage, int height, int width, double *dTransparency, double background) ;
//actually more error than others 
int thickness (double * thisXcoord, double * thisYcoord, unsigned char *thisBinImageChar, int height, int width, int thisAbsX, int thisAbsY, int iNumXY, double *dThickness);

int CVICALLBACK writeBkbFile(void * functionData) ; 
/*********************************************************************************************/
/*																							 */
/*		The codes start here																 */
/*																							 */
/*********************************************************************************************/



/*********************************************************************************************/
/*		The main funciton. part is written by comiler										 */
/*********************************************************************************************/
int main (int argc, char *argv[])
{
	//* written by compiler
	if (InitCVIRTE (0, argv, 0) == 0)	/* Needed if linking in external compiler; harmless otherwise */
		return -1;	/* out of memory */
	if ((panelConvert = LoadPanel (0, "wormClassify.uir", PANEL_CONV)) < 0)
		return -1;

	//* innitialize the global variables
	InitVariables() ;
		  
	//* written by compeler	  
	DisplayPanel (panelConvert);
	RunUserInterface ();

	//* run after uir is quit
	ProcessSystemEvents() ;
	
	return 0;
}



void CVICALLBACK DoQuitMenu (int menuBar, int menuItem, void *callbackData, int panel)
{

// Color palette 
		QuitUserInterface (0);
}




/*********************************************************************************************/
/*		Initiate the globle variable										 				 */
/*********************************************************************************************/

void InitVariables(void)
{

  int count,index ;

  	// color palletes used in image display functions
	for(count=0; count<256; count++)
	{					  
		paletteGrey[count] = MakeColor(count, count, count);
		paletteBin[count] = MakeColor(255,255,255);

		paletteBinOut[count].B = 0 ;
		paletteBinOut[count].R = 0 ;
		paletteBinOut[count].G = 0 ;
		paletteBinOut[count].alpha = 0 ;		

	}

	paletteBin[0] = MakeColor(0,0,0);  
	paletteBin[2] = MakeColor(255,0,0);
	paletteBin[3] = MakeColor(0,255,0);
	paletteBin[4] = MakeColor(0,0,255);

	paletteBinOut[0].B = 0 ;
	paletteBinOut[0].R = 0 ;
	paletteBinOut[0].G = 0 ;
	paletteBinOut[0].alpha = 1 ;

	paletteBinOut[1].B = 255 ;
	paletteBinOut[1].R = 255 ;
	paletteBinOut[1].G = 255 ;
	paletteBinOut[1].alpha = 1 ;

  // create a pixel value of zero for display clearing and rotation in ViewImageBig and BigLoop
	pixZero.grayscale = 0.0 ;	
	whitePix.grayscale = 255 ;

}


//***********************DoSelectFilesConvert*********************************************************************/
//		This function provide user the interface to choose files to be convert from binary file to 
//			backbone files   
//
//		gConvSetPtr is the image set array holds the binary image.  gConverSize will be used 
//		both as index and as the set count
//****************************************************************************************************************/

int CVICALLBACK DoSelectFilesConvert (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{

int filesLoaded ;

//AVI change, make these two global
//int numFiles ;
//char ** fileList ;

char fileName[MAX_FILENAME_LEN] ;
int index, error ;
char textLine[MAX_FILENAME_LEN+20];


	switch (event)
		{
		case EVENT_COMMIT:

			//Get Select_Files button state
			GetCtrlVal(panel, PANEL_CONV_SELECT_FILES, &filesLoaded) ;

			if (filesLoaded == 0)									//If it is off
			{
				ResetTextBox (panel, PANEL_CONV_STATUS, "Ready to Load Image Sets");  
				SetCtrlVal (panel, PANEL_CONV_STATUS, ""); 
				ResetTextBox (panel, PANEL_CONV_SET_NAMES, "Empty...");

				//clear convas
				//CanvasClear (panel, PANEL_CONV_CANVAS_SMALL, VAL_ENTIRE_OBJECT);
				//CanvasClear (panel, PANEL_CONV_CANVAS_Bin, VAL_ENTIRE_OBJECT);
				//CanvasClear (panel, PANEL_CONV_CANVAS_BIG, VAL_ENTIRE_OBJECT);
				
				//AVI change 
				if (iPlotBackbone > 0) iPlotBackbone = DeleteGraphPlot (panel, PANEL_CONV_grphBackbone, iPlotBackbone, VAL_IMMEDIATE_DRAW);
				
			//reset parameter
				//AVI change
				for (index = 0; index < gConvSetSize; index++)
				{
					free (fileList[index]);
				
				}
				free (fileList);
				gConvSetSize = 0 ;
				//free(gConvSetPtr) ;
				//gConvSetPtr = null ;
				return (0) ;
			}
			
			
			//Get a file list for converting
			error = MultiFileSelectPopup ("C:\\ImageData", "*.avi", ".avi", "Select Files for Viewing and Conversion", 0, 1, 1, &gConvSetSize, &fileList);
			
			if (error < 1)
			{
			 	SetCtrlVal(panel, PANEL_CONV_SELECT_FILES, 0) ;
				return (0) ;
			}
			
			//AVI change
			ResetTextBox (panel, PANEL_CONV_SET_NAMES, "List of files::");  
			SetCtrlVal (panel, PANEL_CONV_STATUS, ""); 

			for (index = 0; index < gConvSetSize; index++)
			{
				SplitPath (fileList[index], NULL, NULL, fileName) ;    
				sprintf( textLine, "File:: %s", fileName ) ; 
				ResetTextBox (panel, PANEL_CONV_STATUS, textLine);
				
				InsertTextBoxLine (panel, PANEL_CONV_SET_NAMES, -1, textLine);
				//AVI change
				ProcessSystemEvents() ;
			}
			
			ResetTextBox (panel, PANEL_CONV_STATUS, "Image Set Files are Loaded");  SetCtrlVal (panel, PANEL_CONV_STATUS, ""); 

			break;
		}
	return 0;
}


//*****************************************MagicSkel**********************************************************************************************
//*	Written by Jay. and modified by John Feng.																																			 *
//*																																				 *
//*  This function takes in an imageChar of a thinned image, with the width and height of that imageChar already defined						 *
//*																																				 *
//*  The top left coordinate of the image char is thisAbsX and thisAbsY which are used to offset the determined coordinates						 *
//*																																				 *
//*  numXYpairs tells how much memory has already been reserved for thisXcoord and thisYcoord. These variables are passed by reference			 *
//*																																				 *
//*		and will be filled with numXYpair equidistance points along the backbone of the worm. These points should take thisAbsX and Y into		 *
//*																																				 *
//* 		account such that they define the location of the backbone in the space of the stage/screen/image. They will be normalized later.	 *
//*																																				 *
//*  The function returns a 1 if it successfully extracts the skeleton, a zero is returned otherwise											 *
//*																																				 *
//************************************************************************************************************************************************
//int MagicSkel( char * thisImageChar, int thisWidth, int thisHeight, int thisAbsX, int thisAbsY, int numXYpairs, double * thisXcoord, double * thisYcoord, int iPrevious, double *dPreviousX, double *dPreviousY, int *iLoopType, double *dLength)
int MagicSkel( char  * thisImageChar, int thisWidth, int thisHeight, int thisAbsX, int thisAbsY, int numXYpairs, double * thisXcoord, double * thisYcoord, int *iLoopType, double *dLength)
{
int success = 0;
int index ;
unsigned char ** char2d;
int padWidth = 5; // border space for image
	// convert 1d array to 2d array
int rowIndex = 0;
int colIndex = 0;
int didImageChange=1;
int loopType = -1;

	char2d = (unsigned char ** ) calloc( (2*padWidth+thisHeight),sizeof(unsigned char *) ); 
	for( rowIndex = 0; rowIndex<(thisHeight+2*padWidth); rowIndex++ )
	{
		char2d[rowIndex] = ( char * ) calloc( (2*padWidth+thisWidth),sizeof(unsigned char) );
	}	
	
	for( rowIndex = 0; rowIndex<(thisHeight); rowIndex++ )
	{
		for( colIndex = 0; colIndex<(thisWidth); colIndex++ )
		{
			char2d[rowIndex+padWidth][colIndex+padWidth] = thisImageChar[(rowIndex)*thisWidth+(colIndex)];
		}
	}
	
	// THIS IS WHERE IT ALL TAKES PLACE
	//success = extractBackboneFromBinImg(char2d, numXYpairs, (thisWidth+2*padWidth), (thisHeight+2*padWidth),  &loopType, dPreviousX, dPreviousY, dLenght);

	success = extractBackboneFromBinImg(char2d, numXYpairs, (thisWidth+2*padWidth), (thisHeight+2*padWidth), thisXcoord, thisYcoord, &loopType, dLength);
	if (success == 1) 
	{
		*iLoopType = loopType;
	} else *iLoopType = -1;
		
	for( rowIndex = 0; rowIndex<(thisHeight+2*padWidth); rowIndex++ )    
	{
		free( char2d[rowIndex] );
	}
	
	free( char2d );

//	if (success==1) return 0;
	
	for (index = 0; index < numXYpairs; index++)
	{
		thisXcoord[index] = thisAbsX + thisXcoord[index] ;
		thisYcoord[index] = thisAbsY - thisYcoord[index] ;		  // convert the Ycoord in image plane to cartesian plane
	}

	//if (loopType != 0) return 0;
	if (success != 0) return 0;
	else return 1 ;
}

//******************************Function  DoConvertFile***********************************************************************
//		This function shows the image of the node (hold by SmallImage of the one being transferd in the UIR convas_small for 
//			original image, or UIR convas_big for the backbone image (hold by BigImage) which is been transfered.
//
//****************************************************************************************************************************
int CVICALLBACK DoConvertFile (int panel, int control, int event,
		void *callbackData, int eventData1, int eventData2)
{
			
// read from file about the chosen image set node
//int thisHeight = 0, thisWidth = 0;
int thisAbsX = 0, thisAbsY = 0;
//binary and thin it
int iLengthOfBackbone = 0;
int iArea = 0;

unsigned char * thisImageChar ;		//origninal image
unsigned char * thisBinImageChar ;  //binary image
unsigned char *thisThinnedImageChar ; //thinned image

// image processing temps and output
//int bitmapBig, bitmapBin, bitmapSmall ;

//backbone set
BackboneSet * thisBackSet = null;
//Backbone
int iNumXY = 30;
double *thisXcoord, *thisYcoord;
int goodSkel = 0;

//backbone procssing needs
unsigned char **cImageMatrix ;
int index;
int iWriteFile;
int indexSet, indexNode;
int iLocalBackboneFailures = 0, iNoImage = 0;
int iErrorFlag = FALSE;

//previouse
//double *dPreviousX, *dPreviousY;
//loop type
int iLoopType = -1;
double dWormLength;
double dTransparency = 0.0;
double thisBackground = 256.0;
//time
double thisTime;
double dThickness; 
double dRatio;

//cout the loop
int loop1 = 0;
int loop2 = 0;
int loop3 = 0;

//iVersion
int iVersion = 0;

//debug and show
char sMessage[200];

ImageInfor thisImageInfor;

//**wormshape
//selfdefined
//double dLengthToPixelNumber;
//*shape features help
ParticleReport *Report;
Image *binImage;
int iReportCount;
float fValue;
int indexParticle;
int iReport = 0;
float fArea = 0.0;
int iSuccess = 0;

//image information
//selfdefine
double dLengthToPixelNumber;
float fThisCenX;
float fThisCenY;
double dThisCenX;
double dThisCenY;


//*shape equivalence analysis
float fMaxIntercept;
float fMeanInterceptPerpendicular;
float fEquivalenceEllipsRatio;
float fEllipsMajorAxis;
float fEllipsRatio;
float fRectBigSide;
float fRectRatio;

//shape feature
float fElongationFactor;
float fCompactnessFactor;
float fHeywoodCicularityFactor;
float fTypeFactor;
float fHydraulicRadius;
float fWaddelDiskDiameter;
float fIXX, fIYY, fIXY;
//*/

double dBackground;

char execution_time_string[1024];
int start_time;

//AVI change
//for each of the file list.  Do read avery one
//AVI
LVRefNum newAVI; 
char aviFileName[MAX_NAME_LEN + 3] ; 
char *compressionFilter;
unsigned long ulNumFrame = 2;
unsigned long ulNumFramePerSec = 2;
long lLenFilter;
unsigned long ulWidth, ulHeight;   
short int siHasData;  
double dThisX, dThisY;

//Error control
//
int iImageError = 0;

//save interested image
//Image *saveGreyImage, *saveBinImage, *saveBkbImage;

	switch (event)
		{
		case EVENT_COMMIT:
		
			//*add new feature
			//* JF get the parameters
			start_time = time(0);
			
			GetCtrlVal (panelConvert, PANEL_CONV_binSwWriteFile, &iWriteFile)  ;
			GetCtrlVal (panelConvert, PANEL_CONV_NUM_XY_PAIRS, &iNumXY)  ;

			thisXcoord = (double *)malloc (iNumXY * sizeof(double));
			thisYcoord = (double *)malloc (iNumXY * sizeof(double));

			// allow user to load the set just by flipping through the node numbers
			// give one chance to load the set, if it doesn't work, get out of this function
			if (gConvSetSize == 0) 
			{
				SetCtrlVal (panel, PANEL_CONV_SELECT_FILES, 1) ;
				DoSelectFilesConvert (panel, control, event, callbackData, eventData1, eventData2) ;
				if (gConvSetSize == 0) 
				{
					//SetCtrlVal(panelConvert, PANEL_CONV_SHOW_NODE, 0) ;
					return(0) ;
				}
			}	
			
//cycle the whole set

//AVI change
			dBackground = 197.0;
			//error control not implemented
			binImage = imaqCreateImage (IMAQ_IMAGE_U8, 2) ;
			compressionFilter = malloc (1256 * sizeof(char)); 
			//remember to free it
			
			for (indexSet = 0; indexSet <= gConvSetSize - 1; indexSet++)
			{
			
//Background	is set to 256 might NOT be right	
//Need more work
				//SetCtrlVal (panelConvert, PANEL_CONV_WHICH_SET, indexSet) ;
			//1. Open the file Get AVI information here
				strcpy (aviFileName, fileList[indexSet]);
				OpenAVI(aviFileName, &newAVI); //make a global list and copy from there
				GetAVIInfor(&newAVI, &ulNumFrame, &ulNumFramePerSec, compressionFilter, &lLenFilter, &ulWidth, &ulHeight, &siHasData);

				if (siHasData != 1 || ulNumFrame < 1)
				{
 					//function need 4 (also need for close in writing
 					IMAQAVIClose(&newAVI); 			
					//free (compressionFilter);
					//report error;
      				MessagePopup ("Error", "This file is corrupted or it is not a valid wormbehavioral file");
					//exit
					goto getOutHere;
				}

	
				if (iWriteFile == 1)
				{
					if (thisBackSet != null)	//If there is one, just write it
					{
						thisBackSet->type1LoopCount = loop1;
						thisBackSet->type2LoopCount = loop2;
						thisBackSet->type3LoopCount = loop3;
						thisBackSet->invalidNodeCount = iNoImage;
						//data//string name
						//create a new thread later
						//writeBackboneSet( thisBackSet ) ;
						//destroyBackboneSet( &thisBackSet ) ; //then destroy it
						CmtScheduleThreadPoolFunction (DEFAULT_THREAD_POOL_HANDLE, writeBkbFile, (void*)thisBackSet, NULL);
					}

					// this will create a backboneSet with the same name as the imageSet but "Back.dat" at the end
					//AVI change
					//thisBackSet = newBackboneSet( gConvSetPtr[indexSet]->setName, iNumXY, gConvSetPtr[indexSet]->imageCount) ;
					thisBackSet = newBackboneSet( aviFileName, iNumXY, ulNumFrame, (int) ulNumFramePerSec) ;
				}

				//resetLoop
				loop1 = 0;
				loop2 = 0;
				loop3 = 0;
				iNoImage = 0;
		

				//AVI change this memory will be claimed above
				thisImageChar = (unsigned char *) malloc ((ulWidth * ulHeight) * sizeof (unsigned char));
				thisBinImageChar = (unsigned char *) malloc ((ulWidth * ulHeight) * sizeof (unsigned char));
				thisThinnedImageChar = (unsigned char *) malloc ((ulWidth * ulHeight) * sizeof (unsigned char));

  				cImageMatrix = (unsigned char **) malloc (ulHeight * sizeof (unsigned char *));

  				for (index = 0; index < ulHeight; index++ ) 
  				{
    				cImageMatrix[index] = (unsigned char *) malloc (ulWidth * sizeof (unsigned char ));

    				if (!cImageMatrix[index]) 
    				{
      					MessagePopup ("Error", "Out of memory!");
      					exit(1);
    				}
    				
    				//AVI change
    				//memset(cImageMatrix[index], 255, thisWidth);
    				memset(cImageMatrix[index], 255, ulWidth);
  				}

				
				//for (indexNode = 0; indexNode < gConvSetPtr[indexSet]->imageCount; indexNode++)
				for (indexNode = 0; indexNode < ulNumFrame; indexNode++)
				{
					sprintf (sMessage, "Backbone point extraction is in progress.\n\n Set: %d of %d total sets\n\n Node: %d of %d tatol nodes in current nodes", indexSet + 1, gConvSetSize, indexNode + 1, ulNumFrame);
					ResetTextBox (panelConvert, PANEL_CONV_STATUS, sMessage);
					SetCtrlVal (panelConvert, PANEL_CONV_WHICH_NODE, indexNode) ;

					// catch null images (nodes) here
					//AVI chagne do not need this
					
					ReadAVIFrame (&newAVI, indexNode, ulWidth*ulHeight, thisImageChar, &thisTime, &dThisX, &dThisY, &lLenFilter);

					//dBackground = 197;
 					iArea = binarizationsecond (thisImageChar,  cImageMatrix, ulHeight, ulWidth, dBackground) ;
//For AVI
					Smoothing (cImageMatrix, ulHeight, ulWidth, 2);
	 				//Get the thinned image
					IntegerateImage2DArrayTo1DArray (cImageMatrix, ulHeight, ulWidth, thisBinImageChar) ;

					iLengthOfBackbone = ThinImage ( cImageMatrix, ulHeight, ulWidth) ;
					//remove the redundant skeleton
					iLengthOfBackbone = DelRedundantSkeleton (cImageMatrix, ulWidth, ulHeight) ;
					IntegerateImage2DArrayTo1DArray (cImageMatrix, ulHeight, ulWidth, thisThinnedImageChar) ;

					//function OutputImagesConvert	can do them all.  Should I change it..
					//AVI change this is no needed  no harm to keep here
					if (thisImageChar != null)
					{
						//NewBitmap (thisWidth, 8, thisWidth, thisHeight, paletteGrey, thisImageChar, 0, &bitmapSmall);
						//CanvasDrawBitmap (panel, PANEL_CONV_CANVAS_SMALL, bitmapSmall, VAL_ENTIRE_OBJECT, MakeRect(0,0,thisHeight,thisWidth));	
						//DiscardBitmap (bitmapSmall) ;
//*image information
//get shape features
//find the partical report
						//create image from char
						iSuccess = imaqArrayToImage (binImage, thisBinImageChar, ulWidth, ulHeight);
				
						//Get particle report
						Report = imaqGetParticleInfo ( binImage, TRUE, IMAQ_ALL_INFO, &iReportCount);
				 
						//find the right reposrt
						fArea = 0.0;
						iReport = 0;
						for (indexParticle = 0; indexParticle < iReportCount; indexParticle++)
						{
							iSuccess = imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_AREA, &fValue);
							if (fArea < fValue)
							{
								fArea = fValue;
								iReport = indexParticle;
							}
						}
				
						//Find above imformation
						//shape equivalence analysis
						//AVI change
						if (iReportCount >= 1)
						{
							iImageError = 0;
						
						} else iImageError = 1;
						
						if (iImageError == 0)
						{
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_MAX_INTERCEPT, &fMaxIntercept);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_MEAN_INTERCEPT, &fMeanInterceptPerpendicular);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_EQUIV_ELLIPSE_MINOR, &fEquivalenceEllipsRatio);
								fEquivalenceEllipsRatio = fMaxIntercept / 2 / fEquivalenceEllipsRatio;
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_ELLIPSE_MAJOR, &fEllipsMajorAxis);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_ELLIPSE_RATIO, &fEllipsRatio);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_RECT_LONG_SIDE, &fRectBigSide);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_RECT_RATIO, &fRectRatio);
				
							//shape analysis
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_ELONGATION, &fElongationFactor);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_COMPACTNESS, &fCompactnessFactor);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_HEYWOOD, &fHeywoodCicularityFactor);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_TYPE_FACTOR, &fTypeFactor);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_HYDRAULIC, &fHydraulicRadius);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_WADDLE_DISK, &fWaddelDiskDiameter);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_INERTIA_XX, &fIXX);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_INERTIA_YY, &fIYY);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_INERTIA_XY, &fIXY);

							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_CENTER_MASS_X, &fThisCenX);
							imaqCalcCoeff (binImage, &Report[iReportCount - 1], IMAQ_CENTER_MASS_Y, &fThisCenY);
						}
						//cent
						//AVI change
						//dThisCenX = thisAbsX + fThisCenX ;
						//dThisCenY = thisAbsY - fThisCenY ;		  // convert the Ycoord in image plane to cartesian plane
						dThisCenX = dThisX + fThisCenX ;
						dThisCenY = dThisY - fThisCenY ;		  // convert the Ycoord in image plane to cartesian plane

						//*shape equivalence analysis
//AVI change
//						if (iWriteFile == 1)
						if (iWriteFile == 1 && iImageError == 0)
						{
				
							thisImageInfor.dMaxIntercept = (double) fMaxIntercept;
							thisImageInfor.dMeanInterceptPerpendicular = (double) fMeanInterceptPerpendicular;
							thisImageInfor.dEquivalenceEllipsRatio = (double) fEquivalenceEllipsRatio;
							thisImageInfor.dEllipsMajorAxis = (double) fEllipsMajorAxis;
							thisImageInfor.dEllipsRatio = (double) fEllipsRatio;
							thisImageInfor.dRectBigSide = (double) fRectBigSide;
							thisImageInfor.dRectRatio = (double) fRectRatio;
			   
							//shape featured
							thisImageInfor.dElongationFactor = (double) fElongationFactor;
							thisImageInfor.dCompactnessFactor = (double) fCompactnessFactor;
							thisImageInfor.dHeywoodCicularityFactor = (double) fHeywoodCicularityFactor;
							thisImageInfor.dTypeFactor = (double) fTypeFactor;
							thisImageInfor.dHydraulicRadius = (double) fHydraulicRadius;
							thisImageInfor.dWaddelDiskDiameter = (double) fWaddelDiskDiameter;
							thisImageInfor.dIXX = (double) fIXX;
							thisImageInfor.dIYY = (double) fIYY;
							thisImageInfor.dIXY = (double) fIXY;
						}
//*/end of imageinfor.
						
//						free (thisImageChar) ;
					} //end of if thisImageChar is true
			
					/*JF: Display the binary image as well.
					if (thisBinImageChar != null)
					{
						// Create a bitmap in order to display the original image in the canvas, then Draw the bitmap in the canvas 
						NewBitmap (thisWidth, 8, thisWidth, thisHeight, paletteBin, thisBinImageChar, 0, &bitmapBin);
						CanvasDrawBitmap (panel, PANEL_CONV_CANVAS_Bin, bitmapBin, VAL_ENTIRE_OBJECT, MakeRect(0,0,thisHeight,thisWidth));	
						DiscardBitmap (bitmapBin) ;
					}

					//JF Display thinned image
					//AVI change this condition is not need here
					if (thisThinnedImageChar != null)
					{
						// Create a bitmap in order to display the original image in the canvas, then Draw the bitmap in the canvas 
						NewBitmap (thisWidth, 8, thisWidth, thisHeight, paletteBin, thisThinnedImageChar, 0, &bitmapBig);
						CanvasDrawBitmap (panel, PANEL_CONV_CANVAS_BIG, bitmapBig, VAL_ENTIRE_OBJECT, MakeRect(0,0,thisHeight,thisWidth));	
						DiscardBitmap (bitmapBig) ;
					}
//*					//*/
					//***get backbone
					//AVI change this condition is not need here
//AVI change

//					if (thisThinnedImageChar != null)
					if (iImageError == 0)
					{
						// the name speaks for itself... extraction of numXYpair equidistant points along the backbone --> thisXcoord and thisYcoord
						//AVI change
						iSuccess = imaqArrayToImage (binImage, thisThinnedImageChar, ulWidth, ulHeight);

						//goodSkel = MagicSkel( thisThinnedImageChar, thisWidth, thisHeight, thisAbsX, thisAbsY, iNumXY, thisXcoord, thisYcoord, &iLoopType, &dWormLength) ;
						goodSkel = MagicSkel( thisThinnedImageChar, ulWidth, ulHeight, dThisX, dThisY, iNumXY, thisXcoord, thisYcoord, &iLoopType, &dWormLength) ;

						if (iLoopType > 0)
						{
							switch (iLoopType)
							{
								case 1: loop1++;
								break;
								case 2: loop2++;
								break;
								case 3: loop3++;
								break;
							}
						
						}
						
						if(goodSkel != 1) 
						{
							if (iPlotBackbone > 0) iPlotBackbone = DeleteGraphPlot (panel, PANEL_CONV_grphBackbone, iPlotBackbone, VAL_IMMEDIATE_DRAW);
							iPlotBackbone = PlotXY (panel, PANEL_CONV_grphBackbone, thisXcoord, thisYcoord, iNumXY, VAL_DOUBLE, VAL_DOUBLE, VAL_SCATTER, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_BLUE);

							if (iWriteFile == 1)
							{
								//addBackbone( thisBackSet, indexNode, 0, 0, 0, null, null, 0, 0) ; 
								thisImageInfor.iLoopType = iLoopType ;
								thisImageInfor.dArea = iArea * 1.0;
								
								thisImageInfor.dWormLength = -1.0;
								thisImageInfor.dTransparency = -1.0;
								thisImageInfor.dFatness = - 1.0;
								thisImageInfor.dThickness = -1.0;
								thisImageInfor.dLengthToPixelNumber = -1.0;
								
								addBackbone(thisBackSet, indexNode, thisTime, dThisCenX, dThisCenY, thisImageInfor, null, null, -1) ;
							}
							
							iLocalBackboneFailures++ ;
							iErrorFlag = TRUE;
							dTransparency = - 1.0;
							dThickness = - 1;
							dRatio = -1;
							dWormLength = -2;
						}
				
						if (goodSkel == 1)
						{
							if (iPlotBackbone > 0) iPlotBackbone = DeleteGraphPlot (panel, PANEL_CONV_grphBackbone, iPlotBackbone, VAL_IMMEDIATE_DRAW);
							//SetCtrlAttribute (, , ATTR_XSCALING, );
							iPlotBackbone = PlotXY (panel, PANEL_CONV_grphBackbone, thisXcoord, thisYcoord, iNumXY, VAL_DOUBLE, VAL_DOUBLE, VAL_SCATTER, VAL_SOLID_CIRCLE, VAL_SOLID, 1, VAL_RED);
//How transparent
//AVI chage

							//countTransparency(thisImageChar, thisBinImageChar, thisHeight, thisWidth, &dTransparency, thisBackground);
							countTransparency(thisImageChar, thisBinImageChar, ulHeight, ulWidth, &dTransparency, thisBackground);

//calculate the thickness
							dLengthToPixelNumber = dWormLength/iLengthOfBackbone ;
							dRatio = iArea / dWormLength;
//AVI change
							//if (!thickness (thisXcoord, thisYcoord, thisBinImageChar, thisHeight, thisWidth, thisAbsX, thisAbsY, iNumXY, &dThickness)) dThickness = -1.0 ;
							if (!thickness (thisXcoord, thisYcoord, thisBinImageChar, ulHeight, ulWidth, thisAbsX, thisAbsY, iNumXY, &dThickness)) dThickness = -1.0 ;

							if (iWriteFile == 1)
							{
								thisImageInfor.iLoopType = iLoopType ;
								thisImageInfor.dArea = iArea * 1.0;
								thisImageInfor.dWormLength = dWormLength;
								thisImageInfor.dTransparency = dTransparency;
								thisImageInfor.dFatness = dRatio;
								thisImageInfor.dThickness = dThickness;
								thisImageInfor.dLengthToPixelNumber = dLengthToPixelNumber;

								addBackbone(thisBackSet, indexNode, thisTime, dThisCenX, dThisCenY, thisImageInfor, thisXcoord, thisYcoord, -1) ;

							}
						}

					}  
					else 
					{
					
						iNoImage ++; 
						iErrorFlag = TRUE;
					
						if (iWriteFile == 1)
						{
						   	thisImageInfor.dArea = -1.0;
							addBackbone( thisBackSet, indexNode, thisTime, -1, -1, thisImageInfor, null, null, -1) ; 
						}

					}
//show it
					SetCtrlVal (panel, PANEL_CONV_numAbsX, thisAbsX);
					SetCtrlVal (panel, PANEL_CONV_numAbsY, thisAbsY);

					SetCtrlVal (panel, PANEL_CONV_numWidth, ulWidth);
					SetCtrlVal (panel, PANEL_CONV_numLength, ulHeight);
			
					SetCtrlVal (panel, PANEL_CONV_numTime, thisTime);

					SetCtrlVal (panel, PANEL_CONV_numBackboneLength, dWormLength);
					SetCtrlVal (panel, PANEL_CONV_numArea, iArea);

					SetCtrlVal (panel, PANEL_CONV_numLoopType, iLoopType);
					SetCtrlVal (panel, PANEL_CONV_dTransparent, dTransparency);
					SetCtrlVal (panel, PANEL_CONV_dThickness, dThickness);
					SetCtrlVal (panel, PANEL_CONV_dRatio, dRatio);


//show loop count
					SetCtrlVal (panel, PANEL_CONV_numLoopTypeCount0, iNoImage);
					SetCtrlVal (panel, PANEL_CONV_numLoopTypeCount1, loop1);
					SetCtrlVal (panel, PANEL_CONV_numLoopTypeCount2, loop2);
					SetCtrlVal (panel, PANEL_CONV_numLoopTypeCount3, loop3);
					
				}//end cycle of nodes

				//AVI change
				//6. close this AVI file
				//Close this AVI
				IMAQAVIClose(&newAVI) ;

				//7. take care stuff when exit loop
				//free memory
				if (thisImageChar != NULL) free (thisImageChar) ;
				if (thisThinnedImageChar!= NULL) free (thisThinnedImageChar) ;
				if (thisBinImageChar != NULL)free (thisBinImageChar) ;
				//AVI change
//				for (index = 0; index < thisHeight; index ++)
				for (index = 0; index < ulHeight; index ++)
				{
   	 				free(cImageMatrix[index]);
  				}
  				free(cImageMatrix);
 getOutHere: exit;
			}//end cycle of set


			if (thisBackSet != null)
			{
				if (iWriteFile == 1)
				{
//need to work		
					thisBackSet->type1LoopCount = loop1;
					thisBackSet->type2LoopCount = loop2;
					thisBackSet->type3LoopCount = loop3;
					thisBackSet->invalidNodeCount = iNoImage;
//AVI change
					//open a new thread for this
					//writeBackboneSet( thisBackSet ) ;	//for each image set cycle, it is a new file name, and will be allocated memory again
					//destroyBackboneSet( &thisBackSet ) ;
					CmtScheduleThreadPoolFunction (DEFAULT_THREAD_POOL_HANDLE, writeBkbFile, (void*)thisBackSet, NULL);
					
				}
			}

       		if (thisXcoord != null)
        	{
				free (thisXcoord);
				free (thisYcoord);
//				free (dPreviousX);
//				free (dPreviousY);
			}
			
			imaqDispose (binImage);
			free (compressionFilter);				

			sprintf(execution_time_string,"Finished in %d seconds.",time(0)-start_time);
			MessagePopup("Done!",execution_time_string);

			break;
		}

	return 0;
}
//*/

//******************************Function  CountTransparency***********************************************************************
//		This function counts how transparency a worm is.
//
//****************************************************************************************************************************
int countTransparency(unsigned char *greyImage, unsigned char *binImage, int height, int width, double *dTransparency, double background)
{
int indexRow, indexCol;

double dValue;
int iCount = 0;
int iCount0 = 0;
double dBackground;
double dForeground;

unsigned char **greyImg, **binImg;

	greyImg = (unsigned char **) malloc ((height * width) * sizeof (unsigned char**));
	binImg = (unsigned char **) malloc ((height * width) * sizeof (unsigned char**));
	
	for (indexRow = 0; indexRow < height; indexRow ++)
	{
		greyImg[indexRow]  = (unsigned char *) calloc (width, sizeof (unsigned char*));
		binImg[indexRow]  = (unsigned char *) calloc (width, sizeof (unsigned char*));
	}
	
	BreakImage1DArrayTo2DArray (greyImage, height, width, greyImg) ; 
	BreakImage1DArrayTo2DArray (binImage, height, width, binImg) ; 

	dForeground = 0.0;
	dBackground = 0.0;
	
	for (indexRow = 0; indexRow < height; indexRow ++)
	{
		for (indexCol = 0; indexCol < width; indexCol ++)
		{
		   if (binImg[indexRow][indexCol] == 1)
		   {
		      	iCount ++ ;
		      	dForeground = dForeground + greyImg[indexRow][indexCol] ;
		   } else
		   {
		   		iCount0 ++;
		      	dBackground = dBackground + greyImg[indexRow][indexCol] ;
		   }
		
		}
	
	}

	dForeground = 256 - dForeground/iCount;
	dBackground = 256 - dBackground/iCount0;
	
	*dTransparency = (dForeground - dBackground - (256 - background)) / 256;
	
	for (indexRow = 0; indexRow < height; indexRow ++)
	{
		free (greyImg[indexRow]);
		free (binImg[indexRow]);
	}
	
	free (greyImg);
	free (binImg);
	
	return 1;
}

//******************************Function  CountTransparency***********************************************************************
//		This function counts how transparency a worm is.
//
//********************************************************************************************************************************
int thickness (double * thisXcoord, double * thisYcoord, unsigned char *thisBinImageChar, int height, int width, int thisAbsX, int thisAbsY, int iNumXY, double *dThickness)
{

int index, indexRow, indexCol;
double *dX, *dY;
unsigned char** binImg, **tempImg;
double x1, y1, x2, y2;
double x, y;
double dSlope, dInter;
double dTemp1, dTemp2;
double col;
AnalyzedBackboneInfo tempInfo;
int iFlag = 0;
double dTemp = 0.0;
double dAngle;
int indexAngle;
double dDistance = 100.0;
int iTemp;
double dJunk;
int indexDir, iDir;

	binImg = (unsigned char **) malloc ((height * width) * sizeof (unsigned char**));
	tempImg = (unsigned char **) malloc ((height * width) * sizeof (unsigned char**));
	
	for (indexRow = 0; indexRow < height; indexRow ++)
	{
		binImg[indexRow]  = (unsigned char *) calloc (width, sizeof (unsigned char*));
		tempImg[indexRow]  = (unsigned char *) calloc (width, sizeof (unsigned char*));
	}

	BreakImage1DArrayTo2DArray (thisBinImageChar, height, width, binImg) ; 

	resetInfo (&tempInfo, 0);

//get the points
	index = floor(iNumXY / 2);
	x1 = thisXcoord[index - 1] - thisAbsX;
	y1 = thisAbsY - thisYcoord[index - 1];
	
	x2 = thisXcoord[index] - thisAbsX;
	y2 = thisAbsY - thisYcoord[index];

	x = (x1 + x2)/2;
	y = (y1 + y2)/2;
	
	dAngle = atan2 ((y2 - y1), (x2 - x1));

	for (indexAngle = - 5; indexAngle <= 5; indexAngle ++)
	{
		dSlope = tan(dAngle + indexAngle * 3.14159265358939 / 180 + 3.14159265758919/2);
	
		dInter = y - x * dSlope;
	
		for (index = (int) x; index < width; index++)
		{
	   		dTemp1 = fabs(index * dSlope + dInter);
	   		dTemp2 = floor(dTemp1);
	   		if ((dTemp1 - dTemp2) > 0.5)
	   		{
				dTemp1 = modf ((dTemp2 + 1), &col);
	   		} else dTemp1 = modf (dTemp2, &col);

	   
	   		if ((int)col < 0 || (int)col >= height) goto next1;
	   		if (binImg[(int)col][index] != FOREGROUND) goto next1;
	   
	   		tempImg[(int)col][index] = 1;
		}
	
next1:

		for (index = (int)x; index >= 0; index = index - 1)
		{
	   		dTemp1 = fabs(index * dSlope + dInter);
	   		dTemp2 = floor(dTemp1);
	   		if ((dTemp1 - dTemp2) > 0.5)
	   		{
					dTemp1 = modf ((dTemp2 + 1), &col);
	   		} else dTemp1 = modf (dTemp2, &col);

	   		if ((int)col < 0 || (int)col >= height) goto next2;
//*
	   		if (binImg[(int)col][index] != FOREGROUND) goto next2;
	   
	   		tempImg[(int)col][index] = 1;
//*/
		}

next2:	

		resetInfo (&tempInfo, 1);
		findPointsOfInterest(tempImg, height, width, &tempInfo); 
//*distance	
		if (tempInfo.numEndPoint != 2)
		{
	  		dTemp = 100;
		}else
		{
/*
			x1 = tempInfo.PsOI[tempInfo.EndPointIndex[0]].coord.x;
			x2 = tempInfo.PsOI[tempInfo.EndPointIndex[1]].coord.x;
			y1 = tempInfo.PsOI[tempInfo.EndPointIndex[0]].coord.y;
			y2 = tempInfo.PsOI[tempInfo.EndPointIndex[1]].coord.y;
	
			dTemp = sqrt ( (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1-y2) );
//*/
//new method
//find where to move
	    	for (indexDir = 1; indexDir < NUM_DIRS + 1; indexDir ++)
	    	{
	    		if (tempInfo.PsOI[tempInfo.EndPointIndex[0]].neighborDir[indexDir] == 1)
	    			iDir = indexDir;
			}

			moveToNextPoI(tempImg, &tempInfo.PsOI[tempInfo.EndPointIndex[0]], iDir, height, width, &iTemp, &iTemp, &iTemp, &iTemp, &dTemp);

		}
	
		if (dTemp <= 14) dTemp = -2.0;
		if (dDistance > dTemp) dDistance = dTemp;
//*reset image to 0
		for (indexRow = 0; indexRow < height; indexRow ++)
		{
			for (indexCol = 0; indexCol < width; indexCol ++)
			{
		   		tempImg[indexRow][indexCol] =  0;
		
			}
	
		}
//*/		
		
	}

	for (indexRow = 0; indexRow < height; indexRow ++)
	{
		free (binImg[indexRow]);
		free (tempImg[indexRow]);
	}
	
	free (binImg);
	free (tempImg);

	if (dDistance <= 30)
	{
		*dThickness = dDistance;
	}else *dThickness = -3.0;
	
	if (*dThickness <=  30)
	{
		iFlag = 1;
	}else 
	{
		iFlag = 0;
	}
	return iFlag;
	
//*/return 0;

}
//*/


int CVICALLBACK writeBkbFile(void * functionData)
{

  BackboneSet * thisBkbSet = (BackboneSet *)functionData ;

	//open a new thread for this
	writeBackboneSet( thisBkbSet ) ;	//for each image set cycle, it is a new file name, and will be allocated memory again
//set several values
	destroyBackboneSet( &thisBkbSet ) ;

	return (0) ;
}
