////////////////////////////////////////////////////////////////////////////////////////
// 
// filename: backBoneAnalysis.h
// by: Jay Silver and John Feng.  
// at: Schafer Lab, UCSD
//
//
////////////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// FUNCTION: extractBackboneFromBinImg
// header last updated: 07/18/2001
//
// PURPOSE: to find, clean, and sample the backbone of a series of binary images of a C. elegans
//
// SPECIFICATIONS/INPUT: 	1) a binary skeleton represented as a 2d matrix of pointers to characters  							
//							2) the number of desired sample points along the backbone (should be less than
//								half of the minimum dimension of the image)
//							3) the width and height of the binary skeleton image
//
// OUTPUT: 1) lists of x and y coordinates of the sampled backbone represented as pointers to doubles
//						
// RETURNS: 1 if successful
//			0 if logically unable to create backbone
//
//
// REQUIREMENTS:  when the calling program is finished analyzing a sequence of images 
//			  	  with this function, the calling program must call resetExtractBackboneFromBinImg() 
//
// NOTES: The calling function's binary skeleton will be corrupted (pruned, altered, etc.), so if the program
//			will need this information later, a copy must be passed in (instead of the original)			
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*remove dprevious add lenght
int extractBackboneFromBinImg(  
								// in
								unsigned char ** binImg, // binary image to extract backbone from 
		   						int numPixToRepBackbone,
		   						int width,
		   						int height,
		   						int iPrevious,

		   						//out
		   						double * backboneX,
			   					double * backboneY, 
								int *iLoopType,

								//for loop purpuse
								double * dPreviousX,
								double * dPreviousY
								) ;
//*/
int extractBackboneFromBinImg(  
								// in
								unsigned char ** binImg, // binary image to extract backbone from 
		   						int numPixToRepBackbone,
		   						int width,
		   						int height,
		   						//int iPrevious,

		   						//out
		   						double * backboneX,
			   					double * backboneY, 
								int *iLoopType,

								//for loop purpuse
								//double * dPreviousX,
								//double * dPreviousY
								
								//the lenght
								double * length
								);


			   				  
// don't mess with these unless you know the implications.  lowering them will save memory, raising them will fix errors caused by catastrophic starting images (which should not be put in in the first place)
#define MAX_NUM_PSOI 200
#define MAX_PIXELS_IN_WORM 1000
#define MAX_PIXELS_TO_REP_BACKBONE 200

// this pattern will have a probability of existing if the thinning algorithm provided in this file is used to obtain a part of the skeleton
#define THERE_MAY_BE_FANS

// change these if the image size changes
#define MAX_WIDTH 377 // give image 1 extra pixel on all sides for a border 
#define MAX_HEIGHT 377 // so, MAXWIDTH = actualWidth+2; and MAXHEIGHT = actual height+2


//moved from .c
// ********************************************************************************************** //
// ********************************************* CONSTANTS ************************************** //
// ********************************************************************************************** //

#define N_DIR  1
#define NE_DIR 2
#define E_DIR  3
#define SE_DIR 4
#define S_DIR  5
#define SW_DIR 6
#define W_DIR  7
#define NW_DIR 8
#define NUM_DIRS 8 // how many directions are there, 4 cardinal and 4 inbetween
#define NO_POI   0 // if there is no point of interest in a direction, this is the return value

#define dimOfNeighborHood = 3 // we want our neighborhoods to be 3 by 3 arrays of pixels

#define GEN_FAIL  0
#define SUCCESS   1

#ifndef TRUE
	#define TRUE 1
#endif
#ifndef FALSE
	#define FALSE 0
#endif
#ifndef null
	#define null 0
#endif



#define PAD 1
#define BACKGROUND 0
#define FOREGROUND 1

#define DIAG_DIST 1.41421356237 // sqrt(2)
#define STRAIGHT_DIST 1
#define END_POINT 1
#define NOTHING_IN_THIS_DIR -1

// ********************************************************************************************** //
// ********************************************* STRUCTURES ************************************* //
// ********************************************************************************************** //

// using memcopy, if any pointers are ever used in the data structure
// REMEMBER TO REWORK THE MEMCOPY PORTION OF THE CODE (in passCurrInfoToPrev)

typedef struct iPoints
{
	int x;
	int y;
} iPoint;

/*
typedef struct dPoints
{
	double x;
	double y;
} dPoint;
//*/

typedef struct PointOfInterests // (from here on PointsOfInterest will be "PsOI" and pointOfInterest will be "poi")
{
	iPoint coord; // list of x and y coordinates of the poi (x: positive is right, y: positive is down. starting at top left)
	int numNeighs; // the number (out of 8 theoretically and 4 in this case) of on pixels in the poi's vicinity/neighborhood
	int neighborDir[NUM_DIRS + 1] ;
} PointOfInterest;


typedef struct AnalyzedBackBoneInfos
{
	PointOfInterest PsOI[MAX_NUM_PSOI]; 
	int numPsOI;          
	int headPOI;
	int tailPOI;
	int numEndPoint;
	int iMaxNeighbor;

	int EndPointIndex[MAX_NUM_PSOI];

	int iTotalPixel;
	
//	double contBackbone[MAX_PIXELS_IN_WORM];
} AnalyzedBackboneInfo;


// ********************************************************************************************** //
// ********************************************* GLOBALS **************************************** //
// ********************************************************************************************** //

//AnalyzedBackboneInfo gTempInfo;
AnalyzedBackboneInfo gInfo;

double **dTempX;
double **dTempY;

//*debug
int gWindowExists[10];
//*/

// ********************************************************************************************** //
// ******************************** "PRIVATE" FUNCTION PROTOTYPES ******************************* //
// ********************************************************************************************** //

//Making neighbor, this is OK because before calling this function,  the image is pad to have bounder colored of backboneground.  
int makeVicinity(unsigned char ** img, int y, int x, unsigned char * vicinity);
int moveForward( double * totalDist, int * cameFrom, int * y, int * x, unsigned char * vicinity );  
int move( int dirToMove, int * cameFrom, int * y, int * x );  

//******************************************************************************************
//*
//*    Following are JF's new function or functions that are revsied fom Jay's function
//*
//******************************************************************************************

//POI and POI information
int findPointsOfInterest(unsigned char ** binImg,int height,int width, AnalyzedBackboneInfo *Info);
int isPoi(unsigned char * vicinity, int  * numNeighsToUpdate, int * neighborDir);

/* remove previous
int removeMaxBranched (unsigned char ** img, int iMax, int iNumNeibors, int index, AnalyzedBackboneInfo *Info);
int removeBranched (unsigned char ** img, int height, int width);
//*/

int moveToNextPoI( unsigned char ** img, PointOfInterest * startPoi, int firstMove, int height, int width, int *outX, int *outY, int *xPrevious, int *yPrevious, double *dDistance);
int CountVicinity(unsigned char ** img, unsigned char * vicinity, int xFirst, int yFirst, int *iNeighborX, int *iNeighborY);

//reset gInfo
int resetInfo(AnalyzedBackboneInfo * Info, int iFlag);

//POI and POI information
int exploreDir( unsigned char ** img, PointOfInterest * startPoi, int firstMove, int * numPsOI, PointOfInterest * PsOI, int height, int width );      
void DisconnectBranch(unsigned char **orgImg, unsigned char **prunedImg, int height, int width, AnalyzedBackboneInfo *Info);
int pruneImage (unsigned char **img, int height, int width);
int createEpImage (unsigned char ** epImg, int height, int width, AnalyzedBackboneInfo *Info);

//add length
//int sampleSkel( unsigned char ** img, int height, int width, double * backboneY, double * backboneX, int numXY) ;
int sampleSkel( unsigned char ** img, int height, int width, double * backboneY, double * backboneX, int numXY, double *length) ;

//JF debug
void char2dToChar1d( unsigned char * img1d, unsigned char ** img2d, int height, int width ); 
void showImage( unsigned char ** char2d, int height, int width, int windowNumber );   


