#include <analysis.h>
////////////////////////////////////////////////////////////////////////////////////////
// 
// filename: backBoneAnalysis.h
// by: John Feng and Jay.  
// at: Schafer Lab, UCSD
////////////////////////////////////////////////////////////////////////////////////////


/*****************************************************NOTES*************************

Jay's algorithm to extract the backbone are laregly removed and resinged. 

JF removes, keeps or revises Jay's function to use a whole new designed algorithm. 

//*/

///////////////////////////////////////////////////////////////////////////////////////////////////////////////



#include "nivision.h"
#include <userint.h>
#include <ansi_c.h>
#include "backBoneAnalysis.h" 
#include "ImageProcessing.h" 


// ********************************************************************************************** //
// ***************************************** MAIN FUNCTIONS ************************************* //
// ********************************************************************************************** //

// **************************** extractBackboneFromBinImg **************************************** // 
int extractBackboneFromBinImg(  
								// in
								unsigned char ** binImg, // binary image to extract backbone from 
		   						int numPixToRepBackbone,
		   						int width,
		   						int height,
		   						//int iPrevious,

		   						//out
		   						double * backboneX,
			   					double * backboneY, 
								int *iLoopType,

								//for loop purpuse
								//double * dPreviousX,
								//double * dPreviousY
								
								//the lenght
								double *length
								)

{
int index = 0;
int indexRow, indexColumn;

//decide casecase
int iNumEndingPoint = 0;
int iMax = 0;
int iCase = 0;

//handle case 3
int iThree = 0;
int iFour = 0;

//int cMessage[500];

//handle case5
//seperate type I and type II
int indexCase5;
int iCount;
double dTemp;
int iDir;
int outX[5];
int outY[5];
int xPrevious;
int yPrevious;
double dDistance;

//*Debug
		for( index = 0; index<9; index++) 
		{			
			gWindowExists[index] = 0;
		}
//*/
    resetInfo(&gInfo, 0);

 
restart:
    resetInfo(&gInfo, 1);

	findPointsOfInterest(binImg, height, width, &gInfo);
	if (gInfo.iTotalPixel <= 125)
	{
//count type I coils here.
		*iLoopType = 3; 
		goto NOTPassed;	
	}
	//showImage( binImg, height, width, 1 ) ;  

//*Test the POI
	iMax = gInfo.iMaxNeighbor;
	iNumEndingPoint = gInfo.numEndPoint;
	//iTemp = gInfo.numPsOI;
	
//*
	if ( (iNumEndingPoint == 2) && (iMax < 2) ) iCase = 1;
	else if ( (iNumEndingPoint == 0)  && (iMax >= 4) ) iCase = 2;
	else if ( (iNumEndingPoint >= 3) ) iCase = 3;
	else if ( (iNumEndingPoint == 1) ) iCase = 4;
	else if ( (iNumEndingPoint == 2)  && (iMax >= 2) ) iCase = 5;
	else iCase = 0;

	//sprintf(sMessage, "Type is: %d. ", iCase);
	//MessagePopup ("Check",  sMessage);


	switch (iCase)
	{
		case 1:
			*iLoopType = 0;
		  	goto Passed;
	    break;

	    case 0:
//count type III coils here.
			*iLoopType = 3;
	    	//MessagePopup ("Type", "I am type III");
			goto NOTPassed;
	    break;

	    case 2:
	    	if (iMax >= 4)
	    	{
//count type I coils here.
				*iLoopType = 1;
				//MessagePopup ("Type", "I am type I");
	    	}
	    	else 
	    	{
//count type III coils here.
				*iLoopType = 3;
	    		//MessagePopup ("Type", "I am type III");
	    	}
	    	
			goto NOTPassed;
	    	
/*This is remove because no use to handle this situation
//if have been here twice after remove the most branched pixel, consider it is a unhandlable coid and reset the type to type III	    	
            if (iFromCase2 == 1)
            {
//reset the type to type III and the flag
				*iLoopType = 3;
	    		//MessagePopup ("Type", "I am type III");
				iFromCase2 = 0;
				
				goto NOTPassed;
            }
            
//set flag and restart
	    	iFromCase2 = 1;
			resetInfo(&gInfo, 1);	    	
		  	goto restart;
*/
	    break;

	    case 3:
/*I will not handle this
			if (iFromCase4 == 1)
			{
				iFromCase4 = 0;
				goto NOTPassed;
			}
//*/
			
			iThree = 0;
			iFour = 0;

			for (index = 0; index < gInfo.numPsOI; index ++)
			{
	   			if (gInfo.PsOI[index].numNeighs == 3)  iThree ++;
	   			if (gInfo.PsOI[index].numNeighs == 4)  iFour ++;
			}
		
			if ( (iThree <= 3 * (iNumEndingPoint - 2)) && (iFour <= 1 * (iNumEndingPoint - 2)) )
			{
//pruneImage First
				pruneImage (binImg, height, width); 
				//Check case again and decide where to go
				resetInfo (&gInfo, 1);
				findPointsOfInterest(binImg, height, width, &gInfo);
				if ( (gInfo.numEndPoint == 2) &&  (gInfo.iMaxNeighbor < 2) ) 
				{
//count Type I here!
					*iLoopType = 1;
					goto Passed;
				}else
				{
//count Type III here!
					*iLoopType = 3;
					goto NOTPassed;
				}
			} else
			{

//count Type III here!
				*iLoopType = 3;
				//MessagePopup ("Type", "I am type III");
				goto NOTPassed;
	    	}
	    break;

	    case 4:
//count type I here
			*iLoopType = 1;
//I will NOT handle this
		goto NOTPassed;
	    break;

	    case 5:
//Simply try tp seperate type I and type II coils and count them
			iCount = 0;

		    for (index = 0; index < gInfo.numEndPoint; index ++)
	    	{

	    		for (indexCase5 = 1; indexCase5 < NUM_DIRS + 1; indexCase5 ++)
	    		{
	    			if (gInfo.PsOI[gInfo.EndPointIndex[index]].neighborDir[indexCase5] == 1)
	    				iDir = indexCase5;
				}
				
				moveToNextPoI( binImg, &gInfo.PsOI[gInfo.EndPointIndex[index]], iDir, height, width, &outX[iCount], &outY[iCount], &xPrevious, &yPrevious, &dDistance);

				iCount ++; 
	    		
	    	}

			//Goto reset, if something wrong; 
	    	if (iCount > 2 )
	    	{
//Count type III;
				*iLoopType = 3;
	    		//MessagePopup ("Type", "I am type III");
	    		goto reset;
	    	}

	    	dTemp = sqrt( (outX[1] - outX[0]) * (outX[1] - outX[0]) + (outY[1] - outY[0]) * (outY[1] - outY[0]) );
	    		
	    	if (dTemp < 1.5) 
	    	{
//count type I  
				*iLoopType = 1;
	    		//MessagePopup ("Type", "I am type I");
	    	}else
	    	{
//count type II
				*iLoopType = 2;
	    	//MessagePopup ("Type", "I am type II");
	    	}
reset: 				
		  goto NOTPassed;
	    break;
	}
	

NOTPassed:

	resetInfo(&gInfo, 1) ;
	
	return 1;
	
Passed:

 	sampleSkel( binImg, height, width, backboneY, backboneX, numPixToRepBackbone, length); 
//*
/*Set the previous
	for (index = 0; index < numPixToRepBackbone; index++)
	{
		dPreviousY[index] = backboneY[index];
		dPreviousX[index] = backboneX[index];
	}
//*/	
	return 0;
}


// ************************************************************************************************ //
// *************************** extractBackboneFromBinImg HELPER FUNCTIONS ************************* //
// ************************************************************************************************ //


//************************ findPointsOfInterest *********************************
//  This function will find the poi and usefull information regarding a poi
//*********************************************************************************
int findPointsOfInterest( unsigned char ** img, int height, int width, AnalyzedBackboneInfo * Info)
							
{
int rowIndex;
int colIndex;
int index;

int numNeighs;

unsigned char vicinity[NUM_DIRS + 1]; // one for all 8 directions +1 for the middle (index 0)

//JF
int neighborDir[NUM_DIRS + 1]; //all the dir
int iIsPoi = 0; 
int iNumPsOI = 0;
int iNumEndPoint = 0;
int iMax = 0;
int iTotalPixel = 0;


	for (rowIndex = PAD; rowIndex<(height-PAD); rowIndex++)
	{
		for(colIndex = PAD; colIndex<(width-PAD); colIndex++)
		{
			if(img[rowIndex][colIndex]==FOREGROUND)
			{
				iTotalPixel ++;

	   			makeVicinity(img, rowIndex, colIndex, vicinity);
	   			numNeighs = 0;
	   			
	   			iIsPoi = isPoi(vicinity, &numNeighs, neighborDir);
			
	   			if (iIsPoi == 1) // if this is a poi (PsOI have 1, 3, or 4 neighbors)
	   			{
	   				if(iNumPsOI == MAX_NUM_PSOI)
	   				{
	   					return GEN_FAIL;
	   				}
	   				
	   				iNumPsOI = iNumPsOI + 1;
	   				
	   				if ( (numNeighs == 1) || (numNeighs == 3) || (numNeighs == 4) || (numNeighs == 5) )
	   				{
	   					Info->PsOI[iNumPsOI-1].numNeighs = numNeighs;
	   					Info->PsOI[iNumPsOI-1].coord.x = colIndex;
	   					Info->PsOI[iNumPsOI-1].coord.y = rowIndex;
						Info->PsOI[iNumPsOI-1].neighborDir[0] = 0;
						
						if (iMax < numNeighs) iMax = numNeighs;
						
						if (numNeighs == 1) 
						{
							iNumEndPoint ++;
							Info->EndPointIndex[iNumEndPoint - 1] = iNumPsOI - 1;
						}
						
						for(index = 1; index < NUM_DIRS + 1; index ++)
						{
	   						Info->PsOI[iNumPsOI-1].neighborDir[index] = neighborDir[index];
						}
						
	   				}
	   			}
	   			
	   			else if (iIsPoi == 0)
	   			{
	   				img[rowIndex][colIndex] = BACKGROUND;
	   			}
	   				
	   			else if (iIsPoi == 2)
	   			{
	   				return GEN_FAIL;
	   			}
	   			
			}//if (img
		}//columindex
	}//rowindex

//put in the iMax, iNumEndPoint;
	Info->numEndPoint = iNumEndPoint;
	Info->iMaxNeighbor = iMax;
	Info->iTotalPixel = iTotalPixel;
	Info->numPsOI = iNumPsOI;

//If there are two iNumEndPoint set headPOI and tailPOI Index;
	if (iNumEndPoint == 2)
	{
		Info->headPOI = 0;
		Info->tailPOI = 1;
	}
	

	return SUCCESS;
}


//*****************************isPoi************************************************************
// To find if a pixel is a poi (has 1, 3, 4 neighbor.
//  It also tell a pixel has unhandlable neighbor (>=5), is a common one (2 neighbor ) 
//   or a handable mistakes left by thinning (0 neighbor). 
//*****************************************************************************************
int isPoi(unsigned char * vicinity, int  * numNeighsToUpdate, int * neighborDir)
{

int index;
int iTemp = 0;

	for (index = 1; index < NUM_DIRS + 1; index ++)
	{
		if (vicinity[index] == FOREGROUND)
		{
			iTemp = iTemp + 1;
			neighborDir[index] = 1;
		}else neighborDir[index] = 0;
									
	}

	*numNeighsToUpdate = iTemp;

	if (iTemp >= 5) return 2;

	else if (iTemp == 2) return 3 ;
	
	else if (iTemp <= 0) return 0;
	
	else return 1 ;
	
}


// ***************************** MOVE *********************************//
int move( int dirToMove, int * cameFrom, int * y, int * x )
{
	switch(dirToMove)
	{
		case N_DIR:
			*y = *y + (-1);
			*x = *x + ( 0);
			*cameFrom = 5;
			break;
		case NE_DIR:
			*y = *y + (-1);
			*x = *x + ( 1);
			*cameFrom = 6;
			break;
		case E_DIR:  
			*y = *y + ( 0);
			*x = *x + ( 1);
			*cameFrom = 7;
			break;
		case SE_DIR: 
			*y = *y + ( 1);
			*x = *x + ( 1);
			*cameFrom = 8;
			break;
		case S_DIR:  
			*y = *y + ( 1);
			*x = *x + ( 0);
			*cameFrom = 1;
			break;
		case SW_DIR: 
			*y = *y + ( 1);
			*x = *x + (-1);
			*cameFrom = 2;
			break;
		case W_DIR:  
			*y = *y + ( 0);
			*x = *x + (-1);
			*cameFrom = 3;
			break;
		case NW_DIR: 
			*y = *y + (-1);
			*x = *x + (-1);
			*cameFrom = 4;
			break;
		default:
			return GEN_FAIL;
	}
	return SUCCESS;

}



// ***************************** MOVE FORWARD *********************************//
moveForward( double * totalDist, int * cameFrom, int * y, int * x, unsigned char * vicinity )
{

int nVic, neVic, eVic, seVic, sVic, swVic, wVic, nwVic;
nVic =vicinity[1];
neVic=vicinity[2];
eVic =vicinity[3];
seVic=vicinity[4];
sVic =vicinity[5];
swVic=vicinity[6];
wVic =vicinity[7];
nwVic=vicinity[8];

	if (*cameFrom==N_DIR) 
	{
      	if (FOREGROUND==sVic)
            move(S_DIR, cameFrom, y, x);
        else if ( swVic )
            move(SW_DIR, cameFrom, y, x);
        else if ( seVic )
            move(SE_DIR, cameFrom, y, x);
        else
			return GEN_FAIL;
	}
	else if (*cameFrom==E_DIR)      
	{
      	if (FOREGROUND==wVic)
            move(W_DIR, cameFrom, y, x);
        else if ( nwVic )
            move(NW_DIR, cameFrom, y, x);
        else if ( swVic )
            move(SW_DIR, cameFrom, y, x);
        else
			return GEN_FAIL;
	}
	else if (*cameFrom==S_DIR)    
	{
      	if (FOREGROUND==nVic)
            move(N_DIR, cameFrom, y, x);
        else if ( nwVic )
            move(NW_DIR, cameFrom, y, x);
        else if ( neVic )
            move(NE_DIR, cameFrom, y, x);
        else
			return GEN_FAIL;
	}
	else if (*cameFrom==W_DIR)      
	{
      	if (FOREGROUND==eVic)
            move(E_DIR, cameFrom, y, x);
        else if ( neVic )
            move(NE_DIR, cameFrom, y, x);
        else if ( seVic )
            move(SE_DIR, cameFrom, y, x);
        else
			return GEN_FAIL;
	}
	else if (*cameFrom==NE_DIR)
	{
      	if (FOREGROUND==sVic)
            move(S_DIR, cameFrom, y, x);
        else if ( wVic )
            move(W_DIR, cameFrom, y, x);
        else if ( seVic )
            move(SE_DIR, cameFrom, y, x);
        else if ( swVic )
            move(SW_DIR, cameFrom, y, x);
        else if ( nwVic )
            move(NW_DIR, cameFrom, y, x);
        else
			return GEN_FAIL;
	}			
	else if (*cameFrom==SE_DIR)    
	{
    	if (FOREGROUND==nVic)
            move(N_DIR, cameFrom, y, x);
        else if ( wVic )
            move(W_DIR, cameFrom, y, x);
        else if ( nwVic )
            move(NW_DIR, cameFrom, y, x);
        else if ( swVic )
            move(SW_DIR, cameFrom, y, x);
        else if ( neVic )
            move(NE_DIR, cameFrom, y, x);
        else
 			return GEN_FAIL;
	} 			
	else if (*cameFrom==NW_DIR)
	{
     	if (FOREGROUND==sVic)
            move(S_DIR, cameFrom, y, x);
        else if ( eVic )
            move(E_DIR, cameFrom, y, x);
        else if ( seVic )
            move(SE_DIR, cameFrom, y, x);
        else if ( swVic )
            move(SW_DIR, cameFrom, y, x);
        else if ( neVic )
            move(NE_DIR, cameFrom, y, x);
        else
			return GEN_FAIL;
	}
	else if (*cameFrom==SW_DIR)    
	{
      	if (FOREGROUND==nVic)
            move(N_DIR, cameFrom, y, x);
        else if ( eVic )
            move(E_DIR, cameFrom, y, x);
        else if ( neVic )
            move(NE_DIR, cameFrom, y, x);
        else if ( seVic )
            move(SE_DIR, cameFrom, y, x);
        else if ( nwVic )
            move(NW_DIR, cameFrom, y, x);
        else
 			return GEN_FAIL;
	}
	else if (*cameFrom==0)    
	{
      	if (FOREGROUND==nVic)
            move(N_DIR, cameFrom, y, x);
        else if ( eVic )
            move(E_DIR, cameFrom, y, x);
        else if ( sVic )
            move(S_DIR, cameFrom, y, x);
        else if ( wVic )
            move(W_DIR, cameFrom, y, x);
        else if ( neVic )
            move(NE_DIR, cameFrom, y, x);
        else if ( seVic )
            move(SE_DIR, cameFrom, y, x);
        else if ( nwVic )
            move(NW_DIR, cameFrom, y, x);
        else if ( swVic )
            move(SW_DIR, cameFrom, y, x);            
        else
			return GEN_FAIL;
      
	}
	else
		return GEN_FAIL;

return SUCCESS;
}	


// ***************************** HOW FAR *********************************//
double howFar( int dir )
{
	switch(dir)
	{
		case N_DIR:
			return STRAIGHT_DIST;
			break;
		case NE_DIR:
			return DIAG_DIST;
			break;
		case E_DIR:  
			return STRAIGHT_DIST;
			break;
		case SE_DIR: 
			return DIAG_DIST;
			break;
		case S_DIR:  
			return STRAIGHT_DIST;
			break;
		case SW_DIR: 
			return DIAG_DIST;
			break;
		case W_DIR:  
			return STRAIGHT_DIST;
			break;
		case NW_DIR: 
			return DIAG_DIST;
			break;
		default:
			return GEN_FAIL;
	}
	return SUCCESS;
}


// ***************************** MAKE VICINITY *********************************/
int makeVicinity(unsigned char ** img, int row, int col, unsigned char * vicinity)
{
	vicinity[0] = img[row]  [col]  ;
	vicinity[1] = img[row-1][col]  ;
	vicinity[2] = img[row-1][col+1];
	vicinity[3] = img[row]  [col+1];
	vicinity[4] = img[row+1][col+1];
	vicinity[5] = img[row+1][col]  ;
	vicinity[6] = img[row+1][col-1];
	vicinity[7] = img[row]  [col-1];
	vicinity[8] = img[row-1][col-1];
	return SUCCESS;
}



//*************************************** SAMPLE SKELETON *********************************************** 
int sampleSkel( unsigned char ** img, int height, int width, double * backboneY, double * backboneX, int numXY, double *length)
{


//JF
int headX, headY;
int tailX, tailY;
int currX, currY;

double totalDist;
int cameFrom = 0;

int iDir;
int indexDir;
unsigned char vicinity[NUM_DIRS + 1];
int iIndex;

double dDistBtwBkbp;
double dTempDist = 0;

int atEnd = 0;
double dLength;
int iTemp;

	resetInfo(&gInfo, 1);
	findPointsOfInterest(img, height, width, &gInfo);
	
	headX = gInfo.PsOI[gInfo.headPOI].coord.x;
	headY = gInfo.PsOI[gInfo.headPOI].coord.y;
	tailX = gInfo.PsOI[gInfo.tailPOI].coord.x;
	tailY = gInfo.PsOI[gInfo.tailPOI].coord.y;

	currX = headX;
	currY = headY;
	
	for (indexDir = 1; indexDir < NUM_DIRS + 1; indexDir ++)
	{
	    if (gInfo.PsOI[gInfo.EndPointIndex[gInfo.headPOI]].neighborDir[indexDir] == 1)
	    		iDir = indexDir;
	}

 	moveToNextPoI(img, &gInfo.PsOI[gInfo.headPOI], iDir, height, width, &iTemp, &iTemp, &iTemp, &iTemp, &dLength);
	dDistBtwBkbp = dLength / (numXY - 1);
	
	*length = dLength;
	
    iIndex = 1;
    backboneX[0] = headX;
    backboneY[0] = headY;

    totalDist = 0;
	move(iDir, &cameFrom, &currX, &currY );
	totalDist = totalDist + howFar( cameFrom );
	makeVicinity( img, currY, currX, vicinity );
	
	while (atEnd !=1)
	{
		moveForward( &dTempDist, &cameFrom, &currY, &currX, vicinity );
		totalDist = totalDist + howFar( cameFrom );
		if (totalDist >= iIndex * dDistBtwBkbp) 
		{
    		backboneX[iIndex] = currX;
    		backboneY[iIndex] = currY;

			iIndex ++; 
			if (iIndex == (numXY - 1))
			{
				atEnd = 1;
				goto end;
				
			}
		}
		
		makeVicinity( img, currY, currX, vicinity );
		if ( (currX == tailX) && (currY == tailY) )
		{
		   atEnd = 1;
		   goto end;
		}
		
	}

end:
    	backboneX[numXY -1] = tailX;
    	backboneY[numXY -1] = tailY;

	return SUCCESS;
}


//JF new function is added
//********************** removeBranched*************************************/
/*This function will remove the PoI which is most branched.//
int removeBranched   (unsigned char ** img, int height, int width)
{
int iX, iY;
AnalyzedBackboneInfo tempInfo, orgInfo;
unsigned char ** tempImage;
int indexRow, indexCol;
int index;
int iFlag = 0;

int iDebug;

	tempImage = (unsigned char **)malloc ((height * width) * sizeof (unsigned char*));
	
	for (indexRow = 0; indexRow < height; indexRow++)
	{
		tempImage[indexRow] = (unsigned char *) calloc (width, sizeof (unsigned char));
	
	}

	resetInfo(&tempInfo, 0);
	findPointsOfInterest(img, height, width, &orgInfo); 

	for (indexRow = 0; indexRow < height; indexRow++)
	{

		for (indexCol = 0; indexCol < width; indexCol++)
		{
			tempImage[indexRow][indexCol] = img[indexRow][indexCol];
	
		}
	
	}
	
	iDebug = orgInfo.numPsOI;

	for (index = 0; index < orgInfo.numPsOI; index++)
	{
		if (orgInfo.PsOI[index].numNeighs != 1)
		{
			iX = orgInfo.PsOI[index].coord.x;
			iY = orgInfo.PsOI[index].coord.y;
		
			tempImage[iY][iX] = BACKGROUND;
		
			resetInfo(&tempInfo, 0);
			findPointsOfInterest (tempImage, height, width, &tempInfo);

			iDebug = tempInfo.numEndPoint;

//			showImage(tempImage, height, width, 1);
		
			if (tempInfo.numEndPoint == 1 )
			{
				iFlag = 1;
				goto findIt;
			}else
			{
				tempImage[iY][iX] = FOREGROUND;
			}
		}
	}

findIt:
	if (iFlag == 0) goto freeMemory;
	else
	{
		for (indexRow = 0; indexRow < height; indexRow++)
		{

			for (indexCol = 0; indexCol < width; indexCol++)
			{
				img[indexRow][indexCol] = tempImage[indexRow][indexCol];
	
			}
	
		}
	}
	
//	showImage(img, height, width, 1);
	
freeMemory:
	for (indexRow = 0; indexRow < height; indexRow++)
	{

		free (tempImage[indexRow]);
	
	}
	
	free (tempImage);
	
	return iFlag;
}
//*/

//JF new function is added
//********************** removeMaxBranched*************************************/
/*This function will remove the PoI which is most branched.//
int removeMaxBranched (unsigned char ** img, int iMax, int iNumNeibors, int index, AnalyzedBackboneInfo *Info) 
{
int iY, iX;

	if (iMax == iNumNeibors)
	{
		iX = Info->PsOI[index].coord.x;
		iY = Info->PsOI[index].coord.y;
		
		img[iY][iX] = BACKGROUND;
	
		return 1;
	}

	return 0;
}

//*/
//***************************** moveToNextPoI ********************************* //
//This function is to navigate to next PoI from current PoI//
//In the funciton, starPoi is the pointer hold the the current PoI, and the out put including the coordinates of next PoI and the one next the this PoI.
// The lenth of the worm is also recorded. 
//***************************************************************************************************************************************************************
int moveToNextPoI( unsigned char ** img, PointOfInterest * startPoi, int firstMove, int height, int width, int *outX, int *outY, int *xPrevious, int *yPrevious, double *dDistance)
{
unsigned char vicinity[NUM_DIRS+1];
double totalDist = 0;
int cameFrom = 0;
int atEnd = 0;
int neighborDir[NUM_DIRS + 1];

int y;
int x;                
int numNeighs;

int iCount = 0;

	y = startPoi->coord.y;
	x = startPoi->coord.x;
	
	move( firstMove, &cameFrom, &y, &x );
	totalDist = totalDist + howFar( cameFrom );
	
	iCount ++;
	
	makeVicinity( img, y, x, vicinity );

	while (atEnd !=1)
	{
		*yPrevious = y;
		*xPrevious = x;
		
		moveForward( &totalDist, &cameFrom, &y, &x, vicinity );
		totalDist = totalDist + howFar( cameFrom ); 
		makeVicinity( img, y, x, vicinity );
		atEnd = isPoi(vicinity, &numNeighs, neighborDir);
		iCount ++;
	}
	
	*outX = x;
	*outY = y;
	
	*dDistance = totalDist;
	
	return iCount;
}

//******************CountVicinity***********************************************************************************//
//This function, count the neibour of a pixle definced by (xFirst, yFirst), and return the number of its neighbor.  
//The coordinates of the neighbor is written  to iNeighborX and iNeighory array
//****************************************************************************************************************//
int CountVicinity(unsigned char ** img, unsigned char * vicinity, int xFirst, int yFirst, int *iNeighborX, int *iNeighborY)
{
int iCount = 0;
int index;

	for (index = 1; index < 9; index ++)
	{
	   if (vicinity[index] == 1)
	   {
	   		iCount ++;
			
			switch (index)
			{
			
				case 1:
					iNeighborY[iCount - 1] = yFirst - 1;
					iNeighborX[iCount - 1] = xFirst;
				break;

				case 2:
					iNeighborY[iCount - 1] = yFirst - 1;
					iNeighborX[iCount - 1] = xFirst + 1;
				break;

				case 3:
					iNeighborY[iCount - 1] = yFirst;
					iNeighborX[iCount - 1] = xFirst + 1;
				break;

				case 4:
					iNeighborY[iCount - 1] = yFirst + 1;
					iNeighborX[iCount - 1] = xFirst + 1;
				break;

				case 5:
					iNeighborY[iCount - 1] = yFirst + 1;
					iNeighborX[iCount - 1] = xFirst;
				break;

				case 6:
					iNeighborY[iCount - 1] = yFirst + 1;
					iNeighborX[iCount - 1] = xFirst - 1;
				break;
	
				case 7:
					iNeighborY[iCount - 1] = yFirst;
					iNeighborX[iCount - 1] = xFirst - 1;
				break;
	
				case 8:
					iNeighborY[iCount - 1] = yFirst - 1;
					iNeighborX[iCount - 1] = xFirst - 1;
				break;
			}
	   }
	}

	return iCount;
}

//****************resetInfo****************
//to reset or initiate a analysis info
//********************************************
int resetInfo(AnalyzedBackboneInfo * Info, int iFlag)
{	

int index;
int indexDir;

	//
	if ((iFlag ==  0) || Info->numPsOI < 0) goto main;

	
	for(index = 0;index < Info->numPsOI; index ++)
	{
		Info->PsOI[index].numNeighs = - 1; 
		for (indexDir = 1; indexDir < NUM_DIRS + 1; indexDir ++)
		{
			Info->PsOI[index].neighborDir[indexDir] = -1;
		}
	}
	
	for (index = 1; index < NUM_DIRS + 1; index++)
	{
		Info->EndPointIndex [index] = - 1;
	}
	// main
main:
	Info->numPsOI = -1;          
	Info->headPOI=-1;
	Info->tailPOI = -1;
	Info->numEndPoint = - 1;
	Info->iMaxNeighbor = - 1; 
	Info->iTotalPixel = -1;
	
	return SUCCESS;
}



//*****************************pruneImage*********************************************************
//This function perform two jobs: reduce endpoint number to two by delete the shortest branch.
//and remove the redudant pixel left by pruning the image.
//************************************************************************************************
pruneImage (unsigned char **img, int height, int width)
{

int i, j;
int phase = 1;
int iteration = 0;
unsigned char **epImg, **orgImg, **prunedImg, **skelImg;

//index
int index, index1, indexDir; 
int indexRow, indexCol;

//temp holds the infomation
AnalyzedBackboneInfo Info;
int iTemp;
AnalyzedBackboneInfo tempInfo1, tempInfo2;

//flag and directions
int iThisIsIt = 0;
int iDir;
int x, y, iJunk;

//for remove the branch
int iX1, iX2, iY1, iY2;

//
double dDistance;

//* Create square matrix for storing a temporary image  
//* as well as the original image 

	orgImg = (unsigned char **)malloc(height * sizeof(unsigned char *)) ;
	epImg = (unsigned char **)malloc(height * sizeof(unsigned char *)) ;
	prunedImg = (unsigned char **)malloc(height * sizeof(unsigned char *)) ;
	skelImg = (unsigned char **)malloc(height * sizeof(unsigned char *)) ;
	
	if (!orgImg || !epImg || !prunedImg || !skelImg) 
	{
    	return 0;
	}

	for (index = 0; index < height; index++) 
	{
    	orgImg[index] = (unsigned char *) calloc (width, sizeof(unsigned char));
    	epImg[index] = (unsigned char *) calloc (width, sizeof(unsigned char));
    	prunedImg[index] = (unsigned char *) calloc (width, sizeof(unsigned char));
    	skelImg[index] = (unsigned char *) calloc (width, sizeof(unsigned char));

      	if (!orgImg[index] || !epImg[index] || !prunedImg[index] || !skelImg[index]) 
      	{
      		return 0;
      	}
    }

 //* Generate skeleton image     
    for (indexRow = 0; indexRow < height; indexRow++)
    {
    	for (indexCol = 0; indexCol < width; indexCol++)
    	{
    		orgImg[indexRow][indexCol] = img[indexRow][indexCol];
    		skelImg[indexRow][indexCol] = img[indexRow][indexCol];
    	}
    }

	resetInfo(&Info, 0);
	findPointsOfInterest(img, height, width, &Info);
	
  //* If only one endpoint is found (ie where worm's tail loops around) 
   	while (Info.numEndPoint > 2 && phase < 3) 
   	{
    	//* Delete endpoints from original image untile 2 endpoints remain 
    	//while (Info.numEndPoint > 2)
    	while (Info.numEndPoint > 2)
    	{
     		for (index = 0; index < Info.numEndPoint; index++) 
     		{
     			iTemp = Info.EndPointIndex[index];   //Find the index of of endpoint
     			
     			j = Info.PsOI[iTemp].coord.x;		//Get the coordinate of this one
     			i = Info.PsOI[iTemp].coord.y;
     		
        		skelImg[i][j] = 0;					   //Set the endpoint to zero
      		}

			resetInfo(&Info, 1);
			findPointsOfInterest(skelImg, height, width, &Info);
			
      		iteration++;
    	} //* end of while loop (prunning back) 

		resetInfo(&Info, 1);
		findPointsOfInterest(skelImg, height, width, &Info);
		createEpImage (epImg, height, width, &Info); 


    	//* Now, need to grow out the endpoints 
   		//* by X iteration number of times 
    	for (i = 0; i < iteration; i++) 
    	{
      		//* Move the endpoints into the image object 
      		//* and make a copy of the pruned image 
    		for (indexRow = 0; indexRow < height; indexRow++) 
      		{
      			for(indexCol = 0; indexCol < width; indexCol++ ) 
      			{
	        		prunedImg[indexRow][indexCol] = skelImg[indexRow][indexCol];
          			skelImg[indexRow][indexCol]= epImg[indexRow][indexCol];
        		}
      		}
      
			DilateOrErodeImage(skelImg, height, width,1, 1, 0);

      		if (phase == 2) 
      		{
        		//* Disconnct branches with equal length 
				resetInfo(&Info, 1);
				findPointsOfInterest(skelImg, height, width, &Info);
				DisconnectBranch(skelImg, prunedImg, height, width, &Info);         		
			}

      		//* Then take the intersection of the dilated endpts  
      		//* & orig image to grow back out the endpoints 
      		for (indexRow = 0; indexRow < height; indexRow++) 
      		{
        		for(indexCol = 0; indexCol < width; indexCol++ ) 
        		{
          			skelImg[indexRow][indexCol] = ( (skelImg[indexRow][indexCol] && orgImg[indexRow][indexCol]) || prunedImg[indexRow][indexCol] );
					img[indexRow][indexCol]= skelImg[indexRow][indexCol];
        		}
      		}

			resetInfo(&Info, 1);
			findPointsOfInterest(skelImg, height, width, &Info);
			createEpImage (epImg, height, width, &Info); 

    	}  //* end of for loop (growing out endpoints) 

    	phase++;

		resetInfo(&Info, 1);
		findPointsOfInterest(skelImg, height, width, &Info);

	} //* end of while loop (phase check) 


//Get the endpint information
	resetInfo(&tempInfo1, 0);
	findPointsOfInterest(skelImg, height, width, &tempInfo1);

	resetInfo(&tempInfo2, 0);
	findPointsOfInterest(orgImg, height, width, &tempInfo2);

//remove the redundant pixel
	for (index = 0; index < tempInfo2.numEndPoint; index ++)
	{
	    //if a poi in the pruned image is the one poi is original image
		iThisIsIt = 0;

		iX2 = tempInfo2.PsOI[tempInfo2.EndPointIndex[index]].coord.x;
		iY2 = tempInfo2.PsOI[tempInfo2.EndPointIndex[index]].coord.y;
		
		for (index1 = 0; index1 < tempInfo1.numEndPoint; index1 ++)
		{
			iX1 = tempInfo1.PsOI[tempInfo1.EndPointIndex[index1]].coord.x;
			iY1 = tempInfo1.PsOI[tempInfo1.EndPointIndex[index1]].coord.y;

			if ( ( iX2 == iX1)  &&  (iY2 == iY1))
			{
				iThisIsIt ++;
			}
		}
		
		//if this poi has been removed
		if (iThisIsIt == 0)
		{
			//get the direction next poi is.
	    	for (indexDir = 1; indexDir < NUM_DIRS + 1; indexDir ++)
	    	{
	    		if (tempInfo2.PsOI[tempInfo2.EndPointIndex[index]].neighborDir[indexDir] == 1)
	    			iDir = indexDir;
			}
		
			//get the coordinate of the poi
			moveToNextPoI(orgImg, &tempInfo2.PsOI[tempInfo2.EndPointIndex[index]], iDir, height, width, &x, &y, &iJunk, &iJunk, &dDistance);

			//remove it
//			skelImg[y][x] = BACKGROUND;
			img[y][x] = BACKGROUND;
		} 
		
	}

/*
	showImage( img, height, width, 1);
	MessagePopup ("Check!", "This is it!");
	resetInfo(&Info, 1);
	findPointsOfInterest(skelImg, height, width, &Info);

//*/
	for (index = 0; index < height; index++)
	{
		free(epImg[index]);
		free(orgImg[index]);
		free(prunedImg[index]);
		free(skelImg[index]);

	}
  
	free(epImg);
	free(orgImg);
	free(prunedImg);
	free(skelImg);

	return TRUE;
}
//*/

//***********************DisconnectBranch****************************************************
//* This function is to disconnect the branch with less angle with the main trunk.
//*  in case of two branch has the same length 
//*********************************************************
void DisconnectBranch(unsigned char **orgImg, unsigned char **prunedImg, int height, int width, AnalyzedBackboneInfo *Info)
{

int i, j;
int row, col;
int num_branch, diagonal_pos;
unsigned char orig_p[9], prun_p[9], branch_p[9];
int diagonal_pixel_num[10], max_num=0, save_branch;

int iNumEndPoints;
int index;

	iNumEndPoints = Info->numEndPoint;
  
  	for (i = 0; i < iNumEndPoints; i++) 
  	{
		index = Info->EndPointIndex[i];

    	row = Info->PsOI[i].coord.y;
     	col = Info->PsOI[i].coord.y;

    /* Get eight neighbors of the endpoint */
		makeVicinity(orgImg, row, col, orig_p);
		makeVicinity(prunedImg, row, col, prun_p);

    /* Exclusive OR operation in order to find branch pixels */
    	for (j = 1; j < 9; j++) 
    	{
      		if (orig_p[j] == 1 && prun_p[j] == 1)
        	branch_p[j] = 0;
      		else
        	branch_p[j] = orig_p[j];
    	}

    	num_branch = 0;
   		 /* Count the number of branches */
   		for (j = 1; j < 9; j++) 
   		{
      		if (branch_p[j] == 1)
        	num_branch++;
    	}

    /* Decide which branch pixel is deleted or saved */
    	if (num_branch > 1) 
    	{
      		for (j = 1; j < 9; j++) 
      		{
        		if (branch_p[j] == 1) 
        		{
           			diagonal_pos = j + 4;
           			if (diagonal_pos > 9) diagonal_pos -= 8;
           			if (orig_p[diagonal_pos] == 1) diagonal_pixel_num[j] = 3;
           			else diagonal_pixel_num[j] = 2;
        		}
        		else 
        		{
          			diagonal_pixel_num[j] = 1;
        		}
      		}
      		
      		max_num = 0;
     		for (j = 8; j > 0; j--) 
     		{
        		if (diagonal_pixel_num[j] > max_num) 
        		{
          			max_num = diagonal_pixel_num[j];
          			save_branch = j;
        		}
      		}

      		for (j = 1; j < 9; j++) 
      		{
        		if (branch_p[j] == 1 && j != save_branch) 
        		{
        			if (j == 2 && row > 0) orgImg[row-1][col] = 0;
          			else if (j == 3 && row > 0 && col < (height-1)) orgImg[row-1][col+1] = 0;
          			else if (j == 4 && col < (height - 1)) orgImg[row][col+1] = 0;
         		 	else if (j == 5 && row < (height - 1) && col < (width -1)) orgImg[row+1][col+1] = 0;
          			else if (j == 6 && row < (height - 1)) orgImg[row+1][col] = 0;
          			else if (j == 7 && row < (height - 1) && col > 0) orgImg[row+1][col-1] = 0;
          			else if (j == 8 && col > 0) orgImg[row][col-1] = 0;
          			else if (j == 9 && row > 0 && col > 0) orgImg[row-1][col-1] = 0;
        		}
      		}

    	} /* end of if (num_branch > 1) */

  	} /* end of for loop */

}

//***********************createEpImage****************************************************
//* This function is to create image with only end points.
//*********************************************************
int createEpImage (unsigned char ** epImg, int height, int width, AnalyzedBackboneInfo *Info)
{
int indexRow, indexCol;
int i, j;
int iTemp;
int index;


    	for (indexRow = 0; indexRow < height; indexRow++) 
      	{
      		for(indexCol = 0; indexCol < width; indexCol++ ) 
      		{
	        	epImg[indexRow][indexCol] = 0;
	        	
        	}
      	}

     	for (index = 0; index < Info->numEndPoint; index++) 
     	{
     		iTemp = Info->EndPointIndex[index];   //Find the index of of endpoint
     			
     		j = Info->PsOI[iTemp].coord.x;		//Get the coordinate of this one
     		i = Info->PsOI[iTemp].coord.y;
     		
        	epImg[i][j] = 1;					   //Set the endpoint to zero
      	}


		return 1;
}

// ************************************************************************************************ //
// ****************************************** DEBUG FUNCTIONS ************************************* //
// ************************************************************************************************ //
//*Debug
void char2dToChar1d( unsigned char * img1d, unsigned char ** img2d, int height, int width )
{
	int rowIndex;
	int colIndex;
	
	for (rowIndex = 0; rowIndex<height; rowIndex++)
	{
		for (colIndex = 0; colIndex<width; colIndex++)
		{	
			img1d[rowIndex*width+colIndex] = 255*img2d[rowIndex][colIndex];
		}
	}
}

void showImage( unsigned char ** char2d, int height, int width, int windowNumber )
{
int gSuccess;
	int rowIndex;
	unsigned char * char1d;
	Image * iImg;
	int windowHandle;
	int bitmapSmall;

	Image *saveImage;
	
	// mem allocation
	char1d = malloc( width*height*sizeof(unsigned char) );
	
	iImg = imaqCreateImage (IMAQ_IMAGE_U8, 0);

	// show image
																	
	char2dToChar1d(char1d, char2d, height, width);
	imaqArrayToImage (iImg, char1d, width, height);
	imaqScale (iImg, iImg, 3, 3, IMAQ_SCALE_LARGER, IMAQ_NO_RECT);
	
	
	// mem deallocation
	saveImage = imaqCreateImage (IMAQ_IMAGE_U8, 0);
	imaqArrayToImage (saveImage, char1d, width, height);
	imaqWriteBMPFile (saveImage, "Test.bmp", FALSE, NULL);
	imaqDispose (saveImage) ;

	free( char1d );
	
	if (!gWindowExists[windowNumber])
	{
		rowIndex = IMAQ_WIND_RESIZABLE;
		rowIndex = IMAQ_WIND_TOPMOST;		
		rowIndex = IMAQ_WIND_TITLEBAR;
		gSuccess = imaqSetupWindow (windowNumber,IMAQ_WIND_TOPMOST);	
		imaqSetWindowSize (windowNumber, 100, 100);
		gWindowExists[windowNumber] = 1;
	}
	
	

	gSuccess = imaqDisplayImage (iImg, windowNumber, TRUE);
	imaqDispose (iImg);
}  
//*/



