#include "nivision.h"
//**************************************************************************************
//*
//* filename: ImageProcessing.c
//* by: Zhaoyang Feng
//* at: Schafer Lab, UCSD
//*
//* Last modification date: 11/13/2001
//*
//**************************************************************************************

#include <ansi_c.h>
#include <userint.h>
#include <ImageProcessing.h>

//*Trying to move to seperated files.
void DilateOrErodeImage (unsigned char **image_matrix, int H, int W, int Dilate_nErode, int times, int bin_gray)
{
int row = 0;
int col = 0;
int p[10];
int sum_p = 0;
int tmp;
unsigned char **temp_image;
int i = 0,j; 

  	//* Create square matrix for storing temp image 
  	temp_image  = (unsigned char **) malloc (H * sizeof (unsigned char *));

  	if (!temp_image) 
  	{
    	printf("Out of memory\n");
    	exit(1);
  	}

  	for (i = 0; i < H; i++ ) 
  	{
    	temp_image[i] = (unsigned char *) malloc (W * sizeof (unsigned char ));
    	if (!temp_image[i]) 
    	{
      		printf("Out of memory\n");
      		exit(1);
    	}
  	}

  	//* Perform Dilation or Erosion <times> number of times 
  	for (i = 0; i < times; i++) 
  	{
 	   	//* Make a Copy of original image into temp image 
    	for (row = 0; row < H; row++) 
    	{ 
      		for(col = 0; col < W; col++ ) 
      		{  
        		temp_image[row][col]= image_matrix[row][col]; 
      		}
    	} 

    	//* Go through the entire image 
    	if (bin_gray == 0) 
    	{    //* binay image 
      		for (row = 0; row < H; row++) 
      		{
        		for (col = 0; col < W; col++) 
        		{
          		//* Get the pixel's neighbors and sum their values 
          			GetNeighbors (row, col, p, temp_image, H, W, 0);
          			sum_p=p[2]+p[3]+p[4]+p[5]+p[6]+p[7]+p[8]+p[9];

          			if (Dilate_nErode == 1) 
          			{    
          			//* Dilate Image 
 		        		//* If any neighbor is 1, the pixel is set to 1 (for dilation) 
		        		//* otherwise, there's no change in the pixel value  
            			if (sum_p >= 1) 
            			{
              				image_matrix[row][col] = 1;
            			}
            			else 
            			{
              				image_matrix[row][col] = temp_image[row][col];
            			}
          			}
          			else
          			{			
          			//* Erode Image 
       		    		//* If any neighbor is 0, the pixel is set to 0 (for erosion)
            			//* otherwise, there's no change in the pixel value 
            			if (sum_p < 8) 
            			{
              				image_matrix[row][col] = 0;
            			}
           				else 
           				{
              				image_matrix[row][col] = temp_image[row][col];
            			}
          			}
        		}
      		}
    	}
    	else if (bin_gray == 1) 
    	{    //* gray image 
      		for (row = 0; row < H; row++) 
      		{
        		for (col = 0; col < W; col++) 
        		{

          			//* Get the pixel's neighbors and sum their values 
          			GetNeighbors (row, col, p, temp_image, H, W, 255);

          			if (Dilate_nErode == 1) 
          			{    
          			//* Dilate Image 
            			tmp = p[1];
            			for (j = 2; j < 10; j++)
               				tmp = (tmp < p[j]) ? tmp : p[j];
            			image_matrix[row][col] = (unsigned char)tmp;
          			}
          			else
          			{                 
          			//* Erode Image 
            			tmp = p[1];
            			for (j = 2; j < 10; j++)
               				tmp = (tmp > p[j]) ? tmp : p[j];
            				image_matrix[row][col] = (unsigned char)tmp;
          			}
        		}
      		}
    	}
    	else 
    	{
      		printf("Invalid options for binary/gray image in Dilatation\n");
      		exit(1);
    	}

  	} //* end of for X times loop 


  	//* Delete temp images 
  	for (i = 0; i < H; i++ )
  	{
    	free(temp_image[i]);
  	}
  	free(temp_image);
}

//*/

void Smoothing (unsigned char **image_matrix, int H, int W, int times)
{
int row, col;
unsigned char **temp_image;
int i;
int p[10];
int sum_p;

//* Create square matrix for storing temp image 
  	temp_image  = (unsigned char **) malloc (H * sizeof (unsigned char *));

  	if (!temp_image) 
  	{
    	printf("Out of memory\n");
    	exit(1);
  	}

  	for (i = 0; i < H; i++ ) 
  	{
    	temp_image[i]    = (unsigned char *) malloc (W * sizeof (unsigned char ));
    	if (!temp_image[i]) 
    	{
      		printf("Out of memory\n");
      		exit(1);
    	}
  	}

	for (i = 0; i < times; i++)
  	{
    	//* Make a Copy of original image into temp image 
    	for (row = 0; row < H; row++)
      		for(col = 0; col < W; col++ )
        		temp_image[row][col]= image_matrix[row][col];

	    //* Go through the entire image 
    	for (row = 0; row < H; row++) 
    	{
      		for (col = 0; col < W; col++) 
      		{
        		//* Get the pixel's neighbors and sum their values 
        		GetNeighbors (row, col, p, temp_image, H, W, 255);
        		sum_p = p[1]+p[2]+p[3]+p[4]+p[5]+p[6]+p[7]+p[8]+p[9];

        		image_matrix[row][col] = (unsigned char)(sum_p / 9);
      		}
    	}
  	}  //*end of for X times loop 

  	//* Delete temp images 
  	for (i = 0; i < H; i++ )
  	{
    	free(temp_image[i]);
  	}

  	free(temp_image);
}


void ConvertToBinary(unsigned char **image_matrix, int H, int W, int BG_val)
{
int i, j;
  
  	for (i = 0; i < H; i++) 
  	{
    	for (j = 0; j < W; j++) 
    	{ 
      		if(image_matrix[i][j] ==  BG_val)
         		image_matrix[i][j] = 0;
      		else
         		image_matrix[i][j] = 1;
    	}
  	}
}




void GetNeighbors (int row, int col, int *p, unsigned char **image_matrix, int H, int W, int BG_val)
{
  //* Note BG_val is the background value, typically set to 0 for binary images 
  int pix;
  pix = image_matrix[row][col];
  p[1]= pix;

  if (row == 0)
  {
    if (col == 0)			//* Pixel in upper left corner 
    {
      p[2] = BG_val;
      p[3] = BG_val;
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = BG_val; 
      p[8] = BG_val; 
      p[9] = BG_val; 
    }
    else if (col == (W-1))		//* Pixel in upper right corner  
    {
      p[2] = BG_val;
      p[3] = BG_val;
      p[4] = BG_val;
      p[5] = BG_val;
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = BG_val; 
    }
    else				//* Pixel along top edge 
    {
      p[2] = BG_val;
      p[3] = BG_val;
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = BG_val;
    }
  }
  else if (row == (H-1))
  {
    if (col == 0)			//* Pixel in lower left corner 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = BG_val;
      p[6] = BG_val;
      p[7] = BG_val; 
      p[8] = BG_val; 
      p[9] = BG_val; 
    }
    else if (col == (W-1))		//* Pixel in lower right corner 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = BG_val;
      p[4] = BG_val;
      p[5] = BG_val;
      p[6] = BG_val;
      p[7] = BG_val;
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
    else				//* Pixel along bottom edge 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = BG_val;
      p[6] = BG_val;
      p[7] = BG_val;
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
  }
  else
  {
    if (col == 0)			//* Pixel along left edge 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = BG_val; 
      p[8] = BG_val; 
      p[9] = BG_val; 
    }
    else if (col == (W-1))		//* Pixel along right edge 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = BG_val;
      p[4] = BG_val;
      p[5] = BG_val;
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
    else				//* Pixel is inside border 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
  }
}

void GetNeighborsLabel (int row, int col, int *p, int **image_matrix, int H, int W, int BG_val)
{
  //* Note BG_val is the background value, typically set to 0 for binary images 
  int pix;
  pix = image_matrix[row][col];
  p[1]= pix;

  if (row == 0)
  {
    if (col == 0)			//* Pixel in upper left corner 
    {
      p[2] = BG_val;
      p[3] = BG_val;
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = BG_val; 
      p[8] = BG_val; 
      p[9] = BG_val; 
    }
    else if (col == (W-1))		//* Pixel in upper right corner   
    {
      p[2] = BG_val;
      p[3] = BG_val;
      p[4] = BG_val;
      p[5] = BG_val;
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = BG_val; 
    }
    else				//* Pixel along top edge 
    {
      p[2] = BG_val;
      p[3] = BG_val;
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = BG_val;
    }
  }
  else if (row == (H-1))
  {
    if (col == 0)			//* Pixel in lower left corner 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = BG_val;
      p[6] = BG_val;
      p[7] = BG_val; 
      p[8] = BG_val; 
      p[9] = BG_val; 
    }
    else if (col == (W-1))		//* Pixel in lower right corner 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = BG_val;
      p[4] = BG_val;
      p[5] = BG_val;
      p[6] = BG_val;
      p[7] = BG_val;
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
    else				//* Pixel along bottom edge 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = BG_val;
      p[6] = BG_val;
      p[7] = BG_val;
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
  }
  else
  {
    if (col == 0)			//* Pixel along left edge 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = BG_val; 
      p[8] = BG_val; 
      p[9] = BG_val; 
    }
    else if (col == (W-1))		//* Pixel along right edge 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = BG_val;
      p[4] = BG_val;
      p[5] = BG_val;
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
    else				//* Pixel is inside border 
    {
      p[2] = image_matrix[(row-1)][col];
      p[3] = image_matrix[(row-1)][(col+1)];
      p[4] = image_matrix[row][(col+1)];
      p[5] = image_matrix[(row+1)][(col+1)];
      p[6] = image_matrix[(row+1)][col];
      p[7] = image_matrix[(row+1)][(col-1)];
      p[8] = image_matrix[row][(col-1)];
      p[9] = image_matrix[(row-1)][(col-1)];
    }
  }
}


//******************************BreakImage1DArrayTo2DArray***************************************************************
//
//		The function for displaying image by NI needs to breage 1D array to 2D array
//
//****************************************************************************************************************************
void BreakImage1DArrayTo2DArray (unsigned char *image, int imageHeight, int imageWidth, unsigned char **image_matrix)
{

int i, j;

	for (i = 0; i < imageHeight; i++)
	{
		for (j = 0; j < imageWidth; j++)
		{
			image_matrix[i][j] = image[i * imageWidth + j] ;
		}
	}
}


//******************************

//***************************************************************
//
//		The function for displaying image by NI needs to interate 2D to 1D array
//
//****************************************************************************************************************************
void IntegerateImage2DArrayTo1DArray (unsigned char **image_matrix, int imageHeight, int imageWidth, unsigned char *image)
{

int i, j;

	for (i = 0; i < imageHeight; i++)
	{
		for (j = 0; j < imageWidth; j++)
		{
			image[i* imageWidth + j] = image_matrix[i][j] ;
		}
	}
}

//******************************ThresholdingByHistogram***********************************************************************
//
//		This function will threshold a image maxtrix by histogram.  Above = 1, below = 0.
//
//****************************************************************************************************************************
void ThresholdingByHistogram(unsigned char **image_matrix, int H, int W, int BG_val)
{
  int i, j;
  int th_val;
  int histogram[256];
  int first_peak, second_peak;
  long max = 0;
  int avg, sum, num;

//*
  //* Initialize the historgram array 
  for (i = 0; i < 256; i++)
    histogram[i] = 0;

  //* Compute the histogram 
  //* Processing only inside the original image area 
  for (i = 5; i < (H-5); i++)
    for (j = 5; j < (W-5); j++)
       histogram[(int)image_matrix[i][j]]++;

  //* Find the first peak by moving average 
  for (i = 0; i < 256; i++) {
    sum = 0;
    num = 0;
    for (j = -2; j < 2; j++) {
      if ((i+j) >= 0 && (i+j) < 256) {
        sum += histogram[i+j];
        num++; 
      }
    }
    avg = sum / num;

    if (avg > max) {
       first_peak = i;
       max = avg;
     }
  }
  

  //* Assume that second peak is at 0 
  second_peak = 0;
  
  //* Now, compute the threshold value 
  th_val = (first_peak + second_peak) / 2;
  //
  //th_val = 195 - 5;

  if (BG_val == 255) { //* In case that back ground is white 
    for (i = 0; i < H; i++) {
      for (j = 0; j < W; j++) {
        if(image_matrix[i][j] < th_val)
        //if ( (image_matrix[i][j] < th_val) || (image_matrix[i][j] > 195 + 20))
           image_matrix[i][j] = 0;
        else
           image_matrix[i][j] = BG_val;
      }
    }
  }
  else { //* In case that back ground is black 
    for (i = 0; i < H; i++) {
      for (j = 0; j < W; j++) {
        if(image_matrix[i][j] < th_val)
           image_matrix[i][j] = BG_val;
        else
           image_matrix[i][j] = 255;
      }
    }
  }
//*/
/*
    for (i = 0; i < H; i++) 
    {
      for (j = 0; j < W; j++) 
      {
        if ( (image_matrix[i][j] > 190) && (image_matrix[i][j] < 200))
        //if ( (image_matrix[i][j] < 195 - 10) ) 
           image_matrix[i][j] = 255;
        else
           image_matrix[i][j] = 0;

	  }
	}
//*/
}



//******************************RemoveIsolatedObjects*************************************************************************
//
//		This function will remove the smaller particle.
//
//****************************************************************************************************************************
void RemoveIsolatedObjects(unsigned char **image_matrix, int image_H, int image_W, int BG_val)
{
int row = 0;
int col = 0;
int p_label[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
int **labeled_image;
int *label_array;
int i = 0;
int num_objects = 0;
int num_pass = 0;
int previous;
int change_val = TRUE;
int image_HW;
int min_val = 0;
int pix_label;
int label_val = 1;
int max_num_pixels=0, max_label;

	  //* Create square matrix for storing temp image of labels 
	labeled_image  = (int **) malloc (image_H * sizeof (int*));
	if (!labeled_image)
	{
	    MessagePopup ("Error!", "Can not allocate memory.");
	    exit(1);
	}
	  
	for (i = 0; i < image_H; i++ )
  	{
    	labeled_image[i]  = (int *) malloc (image_W * sizeof(int ));
    	if (!labeled_image[i])
    	{
	    	MessagePopup ("Error!", "Can not allocate memory.");
      		exit(1);
    	}

    	//* Initialize the labeled image array 
    	memset(labeled_image[i], 0, image_W);
  	}

  	image_HW = image_H * image_W;
  	label_array  = (int *) malloc ((image_HW+1) * sizeof(int));

  	//* Initialize the label array 
  	for (i = 0; i < (image_HW+1); i++)
    	label_array[i] = 0;

  	//* Initialize labeled_image by labelling all adjacent ON pixels with a unique label
  	//* And "turning ON" the label in the label array 
  	for (row = 0; row < image_H; row++)
  	{
  	    previous = 0;
    	for (col = 0; col < image_W; col++ )
    	{
      		if (image_matrix[row][col] != 0)
      		{
        		labeled_image[row][col] = label_val;
        		label_array[label_val]=1;
        		if (!previous) { label_val++; previous=1; }
      		}
      		else
      		{
        		labeled_image[row][col] = 0;
        		label_array[label_val] = 0;
        		previous = 0;
      		}
    	}
  	}

  	//* Iterate through image to find equivalent labels 
  	num_pass = 0;
  	change_val = TRUE;

  	while (change_val == TRUE)
  	{
    	num_pass++;
    	change_val = FALSE;

    	//* FIRST PASS: Top-down, left-to-right PASS 
    	for (row = 1; row < image_H; row++)
    	{
    		previous = 0;
      		for(col = 1; col < image_W; col++ )
      		{
        		if (labeled_image[row][col] != 0)
        		{
        			if (!previous)
        			{
        				min_val = labeled_image[row][col];
        				if (min_val>labeled_image[row][col-1] && labeled_image[row][col-1]) min_val=labeled_image[row][col-1];
        				if (min_val>labeled_image[row-1][col] && labeled_image[row-1][col]) min_val=labeled_image[row-1][col];
        				if (min_val>labeled_image[row-1][col-1] && labeled_image[row-1][col-1]) min_val=labeled_image[row-1][col-1];
        		    }
        		    else
        		    {
        				if (min_val>labeled_image[row][col]) min_val = labeled_image[row][col];
        				if (min_val>labeled_image[row-1][col] && labeled_image[row-1][col]) min_val=labeled_image[row-1][col];
        		    }
        			
        			if (labeled_image[row][col] > min_val)
        			{
        			  label_array[ labeled_image[row][col] ] = 0;
        			  labeled_image[row][col] = min_val;
        			  change_val = TRUE;
        			}
        			previous=1;
        		}
        		else previous=0;
      		}
    	} //* end of first pass 

    	//* SECOND PASS: Bottom up, right-to-left PASS 
    	for (row = (image_H-2); row >= 0; row--)
    	{
    		previous = 0;
      		for(col = (image_W-2); col >= 0; col-- )
      		{
        		if (labeled_image[row][col] != 0)
        		{
        		    if (!previous)
        		    {
        				min_val = labeled_image[row][col];
        				if (min_val>labeled_image[row][col+1] && labeled_image[row][col+1]) min_val=labeled_image[row][col+1];
        				if (min_val>labeled_image[row+1][col] && labeled_image[row+1][col]) min_val=labeled_image[row+1][col];
        				if (min_val>labeled_image[row+1][col+1] && labeled_image[row+1][col+1]) min_val=labeled_image[row+1][col+1];
        			}
        			else
        			{
        				if (labeled_image[row][col]<min_val) min_val = labeled_image[row][col];
        				if (min_val>labeled_image[row+1][col] && labeled_image[row+1][col]) min_val=labeled_image[row+1][col];
        			}
        			
        			if (labeled_image[row][col] > min_val)
        			{
        			  label_array[ labeled_image[row][col] ] = 0;
        			  labeled_image[row][col] = min_val;
        			  change_val = TRUE;
        			}
        		}
      		}
    	} //* end of 2nd pass 
  	} //* end of while loop 


  	//* Count up the number of labeled objects 
  	num_objects = 0;
  	for (i = 1; i <= label_val; i++)
  	{
    	if (label_array[i] != 0) num_objects++;
  	}
  	
  	if (num_objects > 1) 
  	{

    	//* Initialize the label array for reuse 
    	for (i = 0; i <= label_val; i++)
      		label_array[i] = 0;

    	for(row = 0; row < image_H; row++) 
    	{
      		for (col = 0; col < image_W; col++) label_array[ labeled_image[row][col] ]++;
    	}

    	//* Find the label which has the largest number of pixels 
    	for (i = 1; i <= label_val; i++) 
    	{
      		if (label_array[i] > max_num_pixels) 
      		{
         		max_num_pixels = label_array[i];
         		max_label = i;
      		}
    	}

    	for(row = 0; row < image_H; row++) 
    	{
      		for (col = 0; col < image_W; col++) 
      		{
        		if (labeled_image[row][col] != max_label) 
        		{
           			image_matrix[row][col] = 0;
        		}
      		}
    	}
  	}
  	
          
  	//* Delete labeled image 
  	for (i = 0; i < image_H; i++)
    	free(labeled_image[i]);
  	free(labeled_image);
  	free(label_array);

}


//******************************GenerateSkelPixelList*************************************************************************
//
//		This function will generize the list of the relative cooridate of a binary image where has white dot.
//				The return value is the total number fo the "white."
//
//****************************************************************************************************************************
int GenerateSkelPixelList(int * skelpixList_row, int * skelpixList_col, unsigned char **image_matrix, int imageHeight, int imageWidth)
{
int i,j;
int k=0;

  	for(j = 0; j < imageHeight; j++ )
  	{
  		for (i = 0; i < imageWidth; i++)
    	{
      		if(image_matrix[j][i] == 1 )              //* 1 means pixel is ON (white) 
      		{
        		skelpixList_row[k]=j;
        		skelpixList_col[k]=i;
        		k++;
      		} 
    	}
  	}

  	return k;
}

int RefineSkelPixelList(int *skelpixList_row, int *skelpixList_col, unsigned char **image_matrix, int numInList)
{
  int i,j;
  
  for (i=j=0;i<numInList;i++)
  {
    if (image_matrix[skelpixList_row[i]][skelpixList_col[i]]==1)
    {
      skelpixList_row[j] = skelpixList_row[i];
      skelpixList_col[j] = skelpixList_col[i];
      j++;
    }
  }
  return j;
}


// Can define these any way we want...below, we have an array to map these so that
// 2 = up, 3 = up-left, etc.  Most efficient for us is to have the right edge be
// the upper order stuff so when we move right, we shift right three bits to drop the
// left edge and add in the new right edge.
#define BIT_UL 0x1
#define BIT_UC 0x8
#define BIT_UR 0x40
#define BIT_CL 0x2
#define BIT_CC 0x10
#define BIT_CR 0x80
#define BIT_LL 0x4
#define BIT_LC 0x20
#define BIT_LR 0x100

int GetBitNeighbors (int row, int col, unsigned char **image_matrix, int H, int W)
{
  //* Note BG_val is assumed to be zero 
  int pix = 0;
//  pix = image_matrix[row][col];
//  p[1]= pix;

  if (row == 0)
  {
    if (col == 0)			//* Pixel in upper left corner 
    {
      pix = BIT_CR*image_matrix[row][(col+1)] + BIT_LR*image_matrix[(row+1)][(col+1)]
            + BIT_LC*image_matrix[(row+1)][col];
    }
    else if (col == (W-1))		//* Pixel in upper right corner  
    {
      pix = BIT_LC*image_matrix[(row+1)][col] + BIT_LL*image_matrix[(row+1)][(col-1)]
            + BIT_CL*image_matrix[row][(col-1)];
    }
    else				//* Pixel along top edge 
    {
      pix = BIT_CR*image_matrix[row][(col+1)] + BIT_LR*image_matrix[(row+1)][(col+1)]
            + BIT_LC*image_matrix[(row+1)][col] + BIT_LL*image_matrix[(row+1)][(col-1)]
            + BIT_CL*image_matrix[row][(col-1)];
    }
  }
  else if (row == (H-1))
  {
    if (col == 0)			//* Pixel in lower left corner 
    {
      pix = BIT_UC*image_matrix[(row-1)][col] + BIT_UR*image_matrix[(row-1)][(col+1)]
            + BIT_CR*image_matrix[row][(col+1)];
   }
    else if (col == (W-1))		//* Pixel in lower right corner 
    {
      pix = BIT_UC*image_matrix[(row-1)][col] + BIT_CL*image_matrix[row][(col-1)]
            + BIT_UL*image_matrix[(row-1)][(col-1)];
   }
    else				//* Pixel along bottom edge 
    {
      pix = BIT_UC*image_matrix[(row-1)][col] + BIT_UR*image_matrix[(row-1)][(col+1)]
            + BIT_CR*image_matrix[row][(col+1)] + BIT_CL*image_matrix[row][(col-1)]
            + BIT_UL*image_matrix[(row-1)][(col-1)];
    }
  }
  else
  {
    if (col == 0)			//* Pixel along left edge 
    {
      pix = BIT_UC*image_matrix[(row-1)][col] + BIT_UR*image_matrix[(row-1)][col]
            + BIT_CR*image_matrix[row][(col+1)] + BIT_LR*image_matrix[(row+1)][(col+1)]
            + BIT_LC*image_matrix[(row+1)][col];
    }
    else if (col == (W-1))		//* Pixel along right edge 
    {
      pix = BIT_UC*image_matrix[(row-1)][col] + BIT_LC*image_matrix[(row+1)][col]
            + BIT_LL*image_matrix[(row+1)][(col-1)] + BIT_CL*image_matrix[row][(col-1)]
            + BIT_UL*image_matrix[(row-1)][(col-1)];
    }
    else				//* Pixel is inside border 
    {
      pix = BIT_UC*image_matrix[(row-1)][col] + BIT_UR*image_matrix[(row-1)][(col+1)]
            + BIT_CR*image_matrix[row][(col+1)] + BIT_LR*image_matrix[(row+1)][(col+1)]
            + BIT_LC*image_matrix[(row+1)][col] + BIT_LL*image_matrix[(row+1)][(col-1)]
            + BIT_CL*image_matrix[row][(col-1)] + BIT_UL*image_matrix[(row-1)][(col-1)];
    }
  }
  return pix;
}


// Build on previous results to shift one to the left (col+1)

int GetBitNeighborsNextDoor(int row, int col, unsigned char **image_matrix, int H, int W, int previous)
{
  int pix = (previous >> 3) | BIT_CL;  // Center was guaranteed on before, it becomes center-left now

  if (col==(W-2)) return pix;      // Already at right edge
  else
  {
    if (row==0) return pix + BIT_CR*image_matrix[row][col+2] + BIT_LR*image_matrix[row+1][col+2];
    else if (row==(H-1)) return pix + BIT_CR*image_matrix[row][col+2] + BIT_UR*image_matrix[row-1][col+2];
    else return pix + BIT_UR*image_matrix[row-1][col+2]
                + BIT_CR*image_matrix[row][col+2] + BIT_LR*image_matrix[row+1][col+2];
  }
}


//******************************ThinImage*************************************************************************************
//
//		This function will thin a binary image down to a skeleton and retrun the length of this skeleton.
//
//****************************************************************************************************************************
int ThinImage ( unsigned char ** imageMatrix, int imageHeight, int imageWidth)
{
int row = 0;
int col = 0;
int p_row = 0;
int p_col = 0;
int i,k;
  
int sum_p = 0;
int prev_p = 0;
int transition_01=0;
  
int chk1 = 0;
int chk2 = 0;
int chk3_4 = 0;
  
int p_temp1 = 1;
int p_temp2 = 1;
  
int prev_length = 0;
int temp_length = 0;

int iteration = 0;
int subiteration;
int num_del = 1;
int total_del =0;
int p[10] = {0, 0, BIT_UC, BIT_UR, BIT_CR, BIT_LR, BIT_LC, BIT_LL, BIT_CL, BIT_UL};

int answer_table_one[512];
int answer_table_two[512];
int answer;
int nswaps;

unsigned char **temp_image,**swap_image;
int num_skelpix = 0;

int iLargerOne;
int * skelpixList_row, * skelpixList_col ;

  //* Create square matrix for storing temp image
  	temp_image = (unsigned char **) malloc (imageHeight * sizeof (unsigned char *));
 
  	if (!temp_image)
  	{
	    MessagePopup ("Error!", "Can not allocate memory.");
    	exit(1);
  	}

  	for (i = 0; i < imageHeight; i++ )
  	{
    	temp_image[i] = (unsigned char *) malloc (imageWidth * sizeof (unsigned char ));

    	memset(temp_image[i], 0, imageWidth);

    	if (!temp_image[i])
    	{
		    MessagePopup ("Error!", "Can not allocate memory.");
      		exit(1);
    	}
  	}
  	
  	// Set up tables to look up whether a pixel should be removed or not
  	for (answer = 0; answer<512; answer++)
  	{
  	
  	   sum_p = 0;
  	   for (i=2;i<10;i++) if (answer&p[i]) sum_p++;
  	   chk1 = (sum_p >=2) && (sum_p <= 6);  // Condition #1--two to six neighbors
  	   
  	   prev_p = (answer&p[2]);
  	   transition_01 = 0;
  	   for (i=3;i<10;i++)
  	   {
  	     if (!prev_p && (p[i]&answer)) transition_01++;
  	     prev_p = p[i]&answer;
  	   }
  	   if (!prev_p && (p[2]&answer)) transition_01++;
  	   chk2 = (transition_01==1);   // Condition #2--exactly one off-to-on transition in neighbors
  	   
  	   p_temp1 = (p[2]&answer)*(p[4]&answer)*(p[6]&answer);
  	   p_temp2 = (p[4]&answer)*(p[6]&answer)*(p[8]&answer);
  	   chk3_4 = (!p_temp1 && !p_temp2);    // Condition #3--missing appropriate corner pieces
  	   
  	   if (chk1 && chk2 && chk3_4) answer_table_one[answer] = 0;
  	   else answer_table_one[answer] = 1;
  	   
  	   p_temp1 = (p[2]&answer)*(p[4]&answer)*(p[8]&answer);
  	   p_temp2 = (p[2]&answer)*(p[6]&answer)*(p[8]&answer);
  	   chk3_4 = (!p_temp1 && !p_temp2);    // Condition #3, other direction (alternates)
  	   
  	   if (chk1 && chk2 && chk3_4) answer_table_two[answer] = 0;
  	   else answer_table_two[answer] = 1;
  	}
  	
  	//* Copy image into temp image and force image to be 0 or 1.
  	for (row = 0; row < imageHeight; row++)
  	{ 
    	for(col = 0; col < imageWidth; col++ )
    	{
    	  if (imageMatrix[row][col]!=0) temp_image[row][col] = imageMatrix[row][col] = 1;
    	  else temp_image[row][col] = 0;
    	}
  	} 
  	nswaps = 0;

	iLargerOne = imageHeight * imageWidth ;

	skelpixList_row = (int *) malloc (iLargerOne * sizeof (int));
	skelpixList_col = (int *) malloc (iLargerOne * sizeof (int));

	num_skelpix = GenerateSkelPixelList(skelpixList_row, skelpixList_col, temp_image, imageHeight, imageWidth) ;

  //* Continue to iterate until no more deletes 
  	while (num_del !=0)
  	{
    	prev_length = num_skelpix;
    	temp_length = num_skelpix;
    	iteration += 1;
    	subiteration = iteration % 2;

    	//* Go through the object pixels & find/delete contour  
		for (i=0; i < num_skelpix; i++)
    	{
			row = skelpixList_row[i];
			col = skelpixList_col[i];
			
			if (row==p_row && col==p_col+1)
			  answer = GetBitNeighborsNextDoor(p_row,p_col,imageMatrix,imageHeight,imageWidth,answer);
			else
			  answer = GetBitNeighbors (row, col, imageMatrix, imageHeight, imageWidth);
			  
			p_row=row; p_col=col;
			
			if (subiteration == 1) temp_image[row][col] = answer_table_one[answer];
			else temp_image[row][col] = answer_table_two[answer];
 
     	}

    	//* Switch temp image and original image--go back & forth to avoid extra copying
    	swap_image = temp_image;
    	temp_image = imageMatrix;
    	imageMatrix = swap_image;
    	nswaps++;
    	
    	for (i=0;i<num_skelpix;i++)  // Copy the changes we've made to the new temp_image
    	   temp_image[ skelpixList_row[i] ][ skelpixList_col[i] ] = imageMatrix[ skelpixList_row[i] ][ skelpixList_col[i] ]; 
   	 	
    	//* Generate skeleton pixel list & update skeleton length 
		num_skelpix = RefineSkelPixelList(skelpixList_row, skelpixList_col, imageMatrix, num_skelpix);
		num_del = prev_length - num_skelpix;
    	total_del += num_del;
  	} //* end of while loop
  	
  	if (nswaps&0x1) // Result ended up in the original temp_image, so we need to put it back
  	{
    	swap_image = temp_image;
    	temp_image = imageMatrix;
    	imageMatrix = swap_image;
    	
		for (row = 0; row < imageHeight; row++) 
    	{
			for (col = 0; col < imageWidth; col++) 
			{
        		imageMatrix[row][col] = temp_image[row][col];
      		}
   	 	}
   	}
  	  
  	
  	//* Delete temp images 
  	for (i = 0; i < imageHeight; i++ )
  	{
    	free(temp_image[i]);
  	}

  	free(temp_image);
	free (skelpixList_row);
	free (skelpixList_col);

  	return num_skelpix; 
}


//******************************DelRedundantSkeleton**************************************************************************
//
//		This function further remove the redundent pixtel will thinned binary image skeleton.
//
//****************************************************************************************************************************
int DelRedundantSkeleton (unsigned char ** image_matrix, int imageWidth, int imageHeight)
{

int i, k;
int row, col;
int prev_p, transition_01;
int p[10] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

//JF 
int iLargerOne;
int num_skelpix = 0;
int * skelpixList_row, * skelpixList_col ;

	iLargerOne = imageHeight * imageWidth ;

	skelpixList_row = (int *) malloc (iLargerOne * sizeof (int));
	skelpixList_col = (int *) malloc (iLargerOne * sizeof (int));

	num_skelpix = GenerateSkelPixelList(skelpixList_row, skelpixList_col, image_matrix, imageHeight, imageWidth) ;


  /* Delete redundant pixels */
  	for (i = 0; i < num_skelpix; i++) 
  	{
    	row = skelpixList_row[i];
    	col = skelpixList_col[i];
	
		GetNeighbors (row, col, p, image_matrix, imageHeight, imageWidth, 0);

    	/* Check for 01 transitions of neighbors */
    	prev_p=p[2];
    	transition_01=0;
    	for (k=3; k<=9; k++)
    	{
      		if (prev_p == 0 && p[k] == 1)
          	transition_01 += 1;
      		prev_p=p[k];
    	}
    	
    	if (prev_p == 0 && p[2] == 1)
        transition_01 += 1;

    	if ((transition_01 < 3) && (p[2]*p[4] == 1 || p[4]*p[6] == 1 || p[6]*p[8] == 1 || p[8]*p[2] == 1)) 
    	{
      		image_matrix[row][col] = 0;
    	}
  	}
 
	num_skelpix = GenerateSkelPixelList(skelpixList_row, skelpixList_col, image_matrix, imageHeight, imageWidth) ;
	
	free (skelpixList_row);
	free (skelpixList_col);
	
	return num_skelpix;
}

int binarizationsecond (unsigned char * thisImageChar, unsigned char ** cImageMatrix, int h, int w, double dBackground)
{
int iLclArea = 0;
unsigned char ** cWorkMatrix;
int index, indexH, indexW;
Image *workImage, *tempImage;
unsigned char * tempChar, *workImageChar;
int width, hight;
ThresholdData thresholdData;

/*
ParticleReport *pReport;
int pNum=0;
ParticleFilterCriteria particleFilterArray[] = { IMAQ_AREA, 0, 1200, FALSE } ; 
ParticleReport*partReport;
float bigArea, fMax;
int wormIndex = -1;
//*/
//ParticleReport *pReport;
int pNum=0;
int iCycle = 1;
int iCycle1 = 1;
int iHole = 0;



				cWorkMatrix = (unsigned char **) malloc ( (h + 10) * sizeof (unsigned char *));

  				for (index = 0; index < h + 10; index++ ) 
  				{
    				cWorkMatrix[index] = (unsigned char *) malloc ((w+10) * sizeof (unsigned char ));

    				if (!cWorkMatrix[index]) 
    				{
      					MessagePopup ("Error", "Out of memory!");
      					exit(1);
    				}
    				memset(cWorkMatrix[index], 0, w + 10);
  				}
  				
				
 				workImage = imaqCreateImage (IMAQ_IMAGE_U8, 10) ;
				imaqArrayToImage (workImage, thisImageChar, w, h);

  				
  				//thresholdData.rangeMin = dBackground - 5;
  				thresholdData.rangeMin = dBackground - 50;

  				thresholdData.rangeMax = dBackground + 5;
				thresholdData.useNewValue = TRUE;
				thresholdData.newValue = 1;

				//imaqGrayMorphology (workImage, workImage, IMAQ_POPEN, NULL);
				
				imaqMultithreshold (workImage, workImage, &thresholdData, 1);
  				workImageChar = imaqImageToArray (workImage, IMAQ_NO_RECT, &width, &hight); 
  				

				//pReport = imaqGetParticleInfo (tempImage, TRUE, IMAQ_BASIC_INFO, &pNum);

				//imaqTranspose (workImage, workImage);
				for (index = 0; index < w*h; index++)
				{
					if (workImageChar[index] > 0) workImageChar[index] = 0;
					else workImageChar[index] = 1;
				
				}

				BreakImage1DArrayTo2DArray (workImageChar, h, w, cImageMatrix) ; 


  				for (indexH = 0; indexH < h; indexH ++)
  				{
  					for (indexW = 0; indexW < w; indexW ++)
  					{
  						if (cImageMatrix[indexH][indexW] != 0)
  						cWorkMatrix[indexH+5][indexW + 5] = cImageMatrix[indexH][indexW];
  					}
  				}
  				
				tempChar = (unsigned char *) malloc (((w+10) * (h + 10)) * sizeof (unsigned char));

				IntegerateImage2DArrayTo1DArray (cWorkMatrix, h + 10, w + 10, tempChar) ;
				
				tempImage = imaqCreateImage (IMAQ_IMAGE_U8, 10);
				
				imaqArrayToImage (tempImage, tempChar, w + 10, h + 10);	

//Choice should me here:
				imaqSizeFilter (tempImage, tempImage, FALSE, 10, IMAQ_KEEP_LARGE, NULL);

repeat:			imaqGetParticleInfo (tempImage, TRUE, IMAQ_BASIC_INFO, &pNum);
				if (pNum < 1)
				{
				
					imaqArrayToImage (tempImage, tempChar, w + 10, h + 10);	
					imaqSizeFilter (tempImage, tempImage, FALSE, 10 - iCycle, IMAQ_KEEP_LARGE, NULL);
					iCycle ++;
					goto repeat;
				
				}

//*
				if (pNum > 1)
				{
				
					imaqArrayToImage (tempImage, tempChar, w + 10, h + 10);	
					imaqSizeFilter (tempImage, tempImage, FALSE, 10 + iCycle1, IMAQ_KEEP_LARGE, NULL);
					iCycle1 ++;
					if (iCycle1 < 5)
					goto repeat;
				
				}

//*/

  				free(tempChar) ;

				//imaqLowPass (tempImage, tempImage, 3, 3, 40.0, NULL);
				
				//imaqMorphology (tempImage, tempImage, IMAQ_AUTOM, NULL);

				imaqMorphology (tempImage, tempImage, IMAQ_DILATE, NULL);
				imaqMorphology (tempImage, tempImage, IMAQ_DILATE, NULL);
				imaqMorphology (tempImage, tempImage, IMAQ_DILATE, NULL);
				imaqMorphology (tempImage, tempImage, IMAQ_DILATE, NULL);
				imaqMorphology (tempImage, tempImage, IMAQ_ERODE, NULL);
				imaqMorphology (tempImage, tempImage, IMAQ_ERODE, NULL);
				imaqMorphology (tempImage, tempImage, IMAQ_ERODE, NULL);
				imaqMorphology (tempImage, tempImage, IMAQ_ERODE, NULL);

				//pReport = imaqGetParticleInfo (tempImage, TRUE, IMAQ_ALL_INFO, &pNum);
				//imaqCalcCoeff (tempImage, tempImage, IMAQ_NUM_HOLES, &fNumWhole);
				//imaqFillHoles (tempImage, tempImage, TRUE);


				tempChar = imaqImageToArray (tempImage, IMAQ_NO_RECT, &hight, &width);
				
				
				BreakImage1DArrayTo2DArray (tempChar, h + 10, w + 10, cWorkMatrix) ;  

				//RemoveIsolatedObjects(cWorkMatrix, h + 10, w + 10, 0); 
				
  				for (indexH = 0; indexH < h; indexH ++)
  				{
  					for (indexW = 0; indexW < w; indexW ++)
  					{
  						cImageMatrix[indexH][indexW] = cWorkMatrix[indexH + 5][indexW + 5];
  						if (cImageMatrix[indexH][indexW] == 1) iLclArea ++;
  					}
  				}
  				
  				imaqDispose (tempChar) ;
  				imaqDispose (workImageChar);
  				imaqDispose (workImage);
  				imaqDispose (tempImage);
  				//imaqDispose (binImage);
  				//imaqDispose (pReport);
  				//imaqDispose (particleFilterArray);
  				//imaqDispose (&thresholdData);

				for (index = 0; index < h + 10; index++ ) 
  				{
    				free (cWorkMatrix[index]);
  				}  	
  				free(cWorkMatrix);
  				
				
		return iLclArea;
		
}


